/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VolumeDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CreateVolume
extends BaseCmd {
    private static final String AVAILABILITY_ZONE_DESC = "The zone in which the volume should be created.";
    private static final String SNAPSHOT_DESC = "The snapshot on which the volume should be based.";
    private static final String VOLUME_SIZE_DESC = "The size of the volume, in GiB (2^30 octets), to be created.";
    private static final String VOLUME_TYPE_DESC = "The type of volume to be used. Valid values are gp2, io1 and standard. Defaults to standard.";
    private static final String IOPS_DESC = "The requested number of I/O operations per second that the volume can support.";
    private static final String ENCRYPTED_DESC = "Indicates that the volume should be encrypted.";
    private static final String KMS_KEY_ID_DESC = "The full ARN of the AWS Key Management Service (KMS) Customer Master Key (CMK) to use when creating the encrypted volume. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default CMK is used. The ARN contains the arn:aws:kms namespace, followed by the region of the CMK, the AWS account ID of the CMK owner, the key namespace, and then the CMK ID. For example, arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef.";
    private static final String AVAILABILITY_ZONE_ARG = "ZONE";
    private static final String SNAPSHOT_ARG = "SNAPSHOT";
    private static final String VOLUME_SIZE_ARG = "SIZE";
    private static final String VOLUME_TYPE_ARG = "TYPE";
    private static final String IOPS_ARG = "IOPS";

    public CreateVolume(String[] args) {
        super("ec2addvol", "ec2-create-volume");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(CreateVolume.createOptionWithArgs("s", "size", VOLUME_SIZE_DESC, VOLUME_SIZE_ARG));
        result.addOption(CreateVolume.createOptionWithArgs(null, "snapshot", SNAPSHOT_DESC, SNAPSHOT_ARG));
        result.addOption(CreateVolume.createOptionWithArgs("z", "availability-zone", AVAILABILITY_ZONE_DESC, AVAILABILITY_ZONE_ARG));
        result.addOption(CreateVolume.createOptionWithArgs("t", "type", VOLUME_TYPE_DESC, VOLUME_TYPE_ARG));
        result.addOption(CreateVolume.createOptionWithArgs("i", "iops", IOPS_DESC, IOPS_ARG));
        result.addOption(CreateVolume.createOption(null, "encrypted", ENCRYPTED_DESC));
        result.addOption(CreateVolume.createOptionWithArgs("k", "kms-key-id", KMS_KEY_ID_DESC, "KMS_KEY_ID"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "(-s SIZE | --snapshot SNAPSHOT [-s SIZE]) [-t TYPE [-i IOPS]] [--encrypted [-k KMS_KEY_ID]] -z ZONE";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a new volume.");
        System.out.println("     Create a volume, possibly based on a snapshot, of the indicated size in the specified zone.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("size");
        this.printOption("snapshot");
        this.printOption("availability-zone");
        this.printOption("type");
        this.printOption("iops");
        this.printOption("encrypted");
        this.printOption("kms-key-id");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        if (!this.isOptionSet("size") && !this.isOptionSet("snapshot")) {
            throw new MissingAtLeastOneArgument(new String[]{"size", "snapshot"});
        }
        this.assertOptionSet("availability-zone");
        String size = this.isOptionSet("size") ? this.getOptionValue("size") : null;
        String snapshotId = this.isOptionSet("snapshot") ? this.getOptionValue("snapshot") : null;
        String zone = this.getOptionValue("availability-zone");
        String type = this.isOptionSet("type") ? this.getOptionValue("type") : null;
        Integer iops = this.isOptionSet("iops") ? Integer.valueOf(Integer.parseInt(this.getOptionValue("iops"))) : null;
        Boolean encrypted = this.isOptionSet("encrypted");
        String kmsKeyId = this.getOptionValue("kms-key-id");
        RequestResultPair rsp = jec2.createVolume(size, snapshotId, zone, type, iops, encrypted, kmsKeyId);
        if (rsp.getResponse() != null) {
            out.output(System.out, (VolumeDescription)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CreateVolume(args).invoke();
    }
}

