/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.JakartaWebServlet;
import org.h2.server.web.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public class ConsoleServlet
extends JakartaWebServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleServlet.class);
    private final Config config;

    public ConsoleServlet(Config config) {
        this.config = config;
    }

    public void init() {
        super.init();
        try {
            Field field = JakartaWebServlet.class.getDeclaredField("server");
            field.setAccessible(true);
            WebServer server = (WebServer)field.get((Object)this);
            ConnectionInfo connectionInfo = new ConnectionInfo("Traccar|" + this.config.getString(Keys.DATABASE_DRIVER) + "|" + this.config.getString(Keys.DATABASE_URL) + "|" + this.config.getString(Keys.DATABASE_USER));
            Method method = WebServer.class.getDeclaredMethod("updateSetting", ConnectionInfo.class);
            method.setAccessible(true);
            method.invoke((Object)server, connectionInfo);
            method = WebServer.class.getDeclaredMethod("setAllowOthers", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)server, true);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Console reflection error", (Throwable)e);
        }
    }
}

