/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util.prefs;

import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.prefs.Preferences;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicToolBarUI;

public class ToolBarPrefsHandler
implements ComponentListener,
AncestorListener {
    private JToolBar toolbar;
    private String prefsPrefix;
    private Preferences prefs;
    private boolean firstTimeShown;

    public ToolBarPrefsHandler(JToolBar jToolBar, String string, Preferences preferences) {
        this.toolbar = jToolBar;
        this.prefsPrefix = string;
        this.prefs = preferences;
        String string2 = preferences.get(string + ".constraint", "North");
        int n = string2.equals("North") || string2.equals("South") ? 0 : 1;
        jToolBar.setOrientation(n);
        jToolBar.getParent().add(string2, jToolBar);
        jToolBar.setVisible(preferences.getBoolean(string + ".visible", true));
        jToolBar.addComponentListener(this);
        jToolBar.addAncestorListener(this);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.prefs.putBoolean(this.prefsPrefix + ".visible", false);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.locationChanged();
    }

    private void locationChanged() {
        if (this.toolbar.getUI() instanceof BasicToolBarUI) {
            BasicToolBarUI basicToolBarUI = (BasicToolBarUI)this.toolbar.getUI();
            boolean bl = basicToolBarUI.isFloating();
            this.prefs.putBoolean(this.prefsPrefix + ".isFloating", bl);
            if (bl) {
                Window window = SwingUtilities.getWindowAncestor(this.toolbar);
                this.prefs.putInt(this.prefsPrefix + ".floatingX", window.getX());
                this.prefs.putInt(this.prefsPrefix + ".floatingY", window.getY());
            } else if (this.toolbar.getParent() != null) {
                int n = this.toolbar.getX();
                int n2 = this.toolbar.getY();
                Insets insets = this.toolbar.getParent().getInsets();
                String string = n == insets.left && n2 == insets.top ? (this.toolbar.getOrientation() == 0 ? "North" : "West") : (this.toolbar.getOrientation() == 0 ? "South" : "East");
                this.prefs.put(this.prefsPrefix + ".constraint", string);
            }
        } else if (this.toolbar.getParent() != null) {
            int n = this.toolbar.getX();
            int n3 = this.toolbar.getY();
            Insets insets = this.toolbar.getParent().getInsets();
            String string = n == insets.left && n3 == insets.top ? (this.toolbar.getOrientation() == 0 ? "North" : "West") : (this.toolbar.getOrientation() == 0 ? "South" : "East");
            this.prefs.put(this.prefsPrefix + ".constraint", string);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.locationChanged();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.prefs.putBoolean(this.prefsPrefix + ".visible", true);
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.locationChanged();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
        if (this.toolbar.getUI() instanceof BasicToolBarUI && ((BasicToolBarUI)this.toolbar.getUI()).isFloating()) {
            this.locationChanged();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        if (this.toolbar.getUI() instanceof BasicToolBarUI && ((BasicToolBarUI)this.toolbar.getUI()).isFloating()) {
            this.locationChanged();
        }
    }
}

