/* $OpenBSD: ec_curve.c,v 1.41 2023/05/02 13:01:57 tb Exp $ */
/*
 * Written by Nils Larsch for the OpenSSL project.
 */
/* ====================================================================
 * Copyright (c) 1998-2010 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@openssl.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */
/* ====================================================================
 * Copyright 2002 Sun Microsystems, Inc. ALL RIGHTS RESERVED.
 *
 * Portions of the attached software ("Contribution") are developed by
 * SUN MICROSYSTEMS, INC., and are contributed to the OpenSSL project.
 *
 * The Contribution is licensed pursuant to the OpenSSL open source
 * license provided above.
 *
 * The elliptic curve binary polynomial software is originally written by
 * Sheueling Chang Shantz and Douglas Stebila of Sun Microsystems Laboratories.
 *
 */

#include <string.h>

#include <openssl/opensslconf.h>

#include <openssl/err.h>
#include <openssl/objects.h>

#include "ec_local.h"

/* the nist prime curves */
static const struct {
	uint8_t seed[20];
	uint8_t p[24];
	uint8_t a[24];
	uint8_t b[24];
	uint8_t x[24];
	uint8_t y[24];
	uint8_t order[24];
} _EC_NIST_PRIME_192 = {
	.seed = {
		0x30, 0x45, 0xae, 0x6f, 0xc8, 0x42, 0x2f, 0x64, 0xed, 0x57,
		0x95, 0x28, 0xd3, 0x81, 0x20, 0xea, 0xe1, 0x21, 0x96, 0xd5,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0x64, 0x21, 0x05, 0x19, 0xe5, 0x9c, 0x80, 0xe7, 0x0f, 0xa7,
		0xe9, 0xab, 0x72, 0x24, 0x30, 0x49, 0xfe, 0xb8, 0xde, 0xec,
		0xc1, 0x46, 0xb9, 0xb1,
	},
	.x = {
		0x18, 0x8d, 0xa8, 0x0e, 0xb0, 0x30, 0x90, 0xf6, 0x7c, 0xbf,
		0x20, 0xeb, 0x43, 0xa1, 0x88, 0x00, 0xf4, 0xff, 0x0a, 0xfd,
		0x82, 0xff, 0x10, 0x12,
	},
	.y = {
		0x07, 0x19, 0x2b, 0x95, 0xff, 0xc8, 0xda, 0x78, 0x63, 0x10,
		0x11, 0xed, 0x6b, 0x24, 0xcd, 0xd5, 0x73, 0xf9, 0x77, 0xa1,
		0x1e, 0x79, 0x48, 0x11,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x99, 0xde, 0xf8, 0x36, 0x14, 0x6b, 0xc9, 0xb1,
		0xb4, 0xd2, 0x28, 0x31,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[28];
	uint8_t a[28];
	uint8_t b[28];
	uint8_t x[28];
	uint8_t y[28];
	uint8_t order[28];
} _EC_NIST_PRIME_224 = {
	.seed = {
		0xbd, 0x71, 0x34, 0x47, 0x99, 0xd5, 0xc7, 0xfc, 0xdc, 0x45,
		0xb5, 0x9f, 0xa3, 0xb9, 0xab, 0x8f, 0x6a, 0x94, 0x8b, 0xc5,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
	},
	.b = {
		0xb4, 0x05, 0x0a, 0x85, 0x0c, 0x04, 0xb3, 0xab, 0xf5, 0x41,
		0x32, 0x56, 0x50, 0x44, 0xb0, 0xb7, 0xd7, 0xbf, 0xd8, 0xba,
		0x27, 0x0b, 0x39, 0x43, 0x23, 0x55, 0xff, 0xb4,
	},
	.x = {
		0xb7, 0x0e, 0x0c, 0xbd, 0x6b, 0xb4, 0xbf, 0x7f, 0x32, 0x13,
		0x90, 0xb9, 0x4a, 0x03, 0xc1, 0xd3, 0x56, 0xc2, 0x11, 0x22,
		0x34, 0x32, 0x80, 0xd6, 0x11, 0x5c, 0x1d, 0x21,
	},
	.y = {
		0xbd, 0x37, 0x63, 0x88, 0xb5, 0xf7, 0x23, 0xfb, 0x4c, 0x22,
		0xdf, 0xe6, 0xcd, 0x43, 0x75, 0xa0, 0x5a, 0x07, 0x47, 0x64,
		0x44, 0xd5, 0x81, 0x99, 0x85, 0x00, 0x7e, 0x34,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0x16, 0xa2, 0xe0, 0xb8, 0xf0, 0x3e,
		0x13, 0xdd, 0x29, 0x45, 0x5c, 0x5c, 0x2a, 0x3d,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[48];
	uint8_t a[48];
	uint8_t b[48];
	uint8_t x[48];
	uint8_t y[48];
	uint8_t order[48];
} _EC_NIST_PRIME_384 = {
	.seed = {
		0xa3, 0x35, 0x92, 0x6a, 0xa3, 0x19, 0xa2, 0x7a, 0x1d, 0x00,
		0x89, 0x6a, 0x67, 0x73, 0xa4, 0x82, 0x7a, 0xcd, 0xac, 0x73,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0xb3, 0x31, 0x2f, 0xa7, 0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e,
		0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19, 0x18, 0x1d, 0x9c, 0x6e,
		0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f, 0x50, 0x13,
		0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
		0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef,
	},
	.x = {
		0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1,
		0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62,
		0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54,
		0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c,
		0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7,
	},
	.y = {
		0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e,
		0x98, 0xbf, 0x92, 0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd,
		0x28, 0x9a, 0x14, 0x7c, 0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0,
		0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d, 0x7e, 0x81, 0x9d,
		0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37,
		0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
		0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[66];
	uint8_t a[66];
	uint8_t b[66];
	uint8_t x[66];
	uint8_t y[66];
	uint8_t order[66];
} _EC_NIST_PRIME_521 = {
	.seed = {
		0xd0, 0x9e, 0x88, 0x00, 0x29, 0x1c, 0xb8, 0x53, 0x96, 0xcc,
		0x67, 0x17, 0x39, 0x32, 0x84, 0xaa, 0xa0, 0xda, 0x64, 0xba,
	},
	.p = {
		0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0x00, 0x51, 0x95, 0x3e, 0xb9, 0x61, 0x8e, 0x1c, 0x9a, 0x1f,
		0x92, 0x9a, 0x21, 0xa0, 0xb6, 0x85, 0x40, 0xee, 0xa2, 0xda,
		0x72, 0x5b, 0x99, 0xb3, 0x15, 0xf3, 0xb8, 0xb4, 0x89, 0x91,
		0x8e, 0xf1, 0x09, 0xe1, 0x56, 0x19, 0x39, 0x51, 0xec, 0x7e,
		0x93, 0x7b, 0x16, 0x52, 0xc0, 0xbd, 0x3b, 0xb1, 0xbf, 0x07,
		0x35, 0x73, 0xdf, 0x88, 0x3d, 0x2c, 0x34, 0xf1, 0xef, 0x45,
		0x1f, 0xd4, 0x6b, 0x50, 0x3f, 0x00,
	},
	.x = {
		0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9, 0xcd,
		0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c, 0x64,
		0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60,
		0x6b, 0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7,
		0x59, 0x28, 0xfe, 0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde,
		0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42, 0x9b, 0xf9, 0x7e,
		0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66,
	},
	.y = {
		0x01, 0x18, 0x39, 0x29, 0x6a, 0x78, 0x9a, 0x3b, 0xc0, 0x04,
		0x5c, 0x8a, 0x5f, 0xb4, 0x2c, 0x7d, 0x1b, 0xd9, 0x98, 0xf5,
		0x44, 0x49, 0x57, 0x9b, 0x44, 0x68, 0x17, 0xaf, 0xbd, 0x17,
		0x27, 0x3e, 0x66, 0x2c, 0x97, 0xee, 0x72, 0x99, 0x5e, 0xf4,
		0x26, 0x40, 0xc5, 0x50, 0xb9, 0x01, 0x3f, 0xad, 0x07, 0x61,
		0x35, 0x3c, 0x70, 0x86, 0xa2, 0x72, 0xc2, 0x40, 0x88, 0xbe,
		0x94, 0x76, 0x9f, 0xd1, 0x66, 0x50,
	},
	.order = {
		0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
		0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0,
		0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f,
		0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09,
	},
};

/* the x9.62 prime curves (minus the nist prime curves) */
static const struct {
	uint8_t seed[20];
	uint8_t p[24];
	uint8_t a[24];
	uint8_t b[24];
	uint8_t x[24];
	uint8_t y[24];
	uint8_t order[24];
} _EC_X9_62_PRIME_192V2 = {
	.seed = {
		0x31, 0xa9, 0x2e, 0xe2, 0x02, 0x9f, 0xd1, 0x0d, 0x90, 0x1b,
		0x11, 0x3e, 0x99, 0x07, 0x10, 0xf0, 0xd2, 0x1a, 0xc6, 0xb6,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0xcc, 0x22, 0xd6, 0xdf, 0xb9, 0x5c, 0x6b, 0x25, 0xe4, 0x9c,
		0x0d, 0x63, 0x64, 0xa4, 0xe5, 0x98, 0x0c, 0x39, 0x3a, 0xa2,
		0x16, 0x68, 0xd9, 0x53,
	},
	.x = {
		0xee, 0xa2, 0xba, 0xe7, 0xe1, 0x49, 0x78, 0x42, 0xf2, 0xde,
		0x77, 0x69, 0xcf, 0xe9, 0xc9, 0x89, 0xc0, 0x72, 0xad, 0x69,
		0x6f, 0x48, 0x03, 0x4a,
	},
	.y = {
		0x65, 0x74, 0xd1, 0x1d, 0x69, 0xb6, 0xec, 0x7a, 0x67, 0x2b,
		0xb8, 0x2a, 0x08, 0x3d, 0xf2, 0xf2, 0xb0, 0x84, 0x7d, 0xe9,
		0x70, 0xb2, 0xde, 0x15,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfe, 0x5f, 0xb1, 0xa7, 0x24, 0xdc, 0x80, 0x41, 0x86,
		0x48, 0xd8, 0xdd, 0x31,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[24];
	uint8_t a[24];
	uint8_t b[24];
	uint8_t x[24];
	uint8_t y[24];
	uint8_t order[24];
} _EC_X9_62_PRIME_192V3 = {
	.seed = {
		0xc4, 0x69, 0x68, 0x44, 0x35, 0xde, 0xb3, 0x78, 0xc4, 0xb6,
		0x5c, 0xa9, 0x59, 0x1e, 0x2a, 0x57, 0x63, 0x05, 0x9a, 0x2e,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0x22, 0x12, 0x3d, 0xc2, 0x39, 0x5a, 0x05, 0xca, 0xa7, 0x42,
		0x3d, 0xae, 0xcc, 0xc9, 0x47, 0x60, 0xa7, 0xd4, 0x62, 0x25,
		0x6b, 0xd5, 0x69, 0x16,
	},
	.x = {
		0x7d, 0x29, 0x77, 0x81, 0x00, 0xc6, 0x5a, 0x1d, 0xa1, 0x78,
		0x37, 0x16, 0x58, 0x8d, 0xce, 0x2b, 0x8b, 0x4a, 0xee, 0x8e,
		0x22, 0x8f, 0x18, 0x96,
	},
	.y = {
		0x38, 0xa9, 0x0f, 0x22, 0x63, 0x73, 0x37, 0x33, 0x4b, 0x49,
		0xdc, 0xb6, 0x6a, 0x6d, 0xc8, 0xf9, 0x97, 0x8a, 0xca, 0x76,
		0x48, 0xa9, 0x43, 0xb0,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7a, 0x62, 0xd0, 0x31, 0xc8, 0x3f, 0x42, 0x94,
		0xf6, 0x40, 0xec, 0x13,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[30];
	uint8_t a[30];
	uint8_t b[30];
	uint8_t x[30];
	uint8_t y[30];
	uint8_t order[30];
} _EC_X9_62_PRIME_239V1 = {
	.seed = {
		0xe4, 0x3b, 0xb4, 0x60, 0xf0, 0xb8, 0x0c, 0xc0, 0xc0, 0xb0,
		0x75, 0x79, 0x8e, 0x94, 0x80, 0x60, 0xf8, 0x32, 0x1b, 0x7d,
	},
	.p = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0x6b, 0x01, 0x6c, 0x3b, 0xdc, 0xf1, 0x89, 0x41, 0xd0, 0xd6,
		0x54, 0x92, 0x14, 0x75, 0xca, 0x71, 0xa9, 0xdb, 0x2f, 0xb2,
		0x7d, 0x1d, 0x37, 0x79, 0x61, 0x85, 0xc2, 0x94, 0x2c, 0x0a,
	},
	.x = {
		0x0f, 0xfa, 0x96, 0x3c, 0xdc, 0xa8, 0x81, 0x6c, 0xcc, 0x33,
		0xb8, 0x64, 0x2b, 0xed, 0xf9, 0x05, 0xc3, 0xd3, 0x58, 0x57,
		0x3d, 0x3f, 0x27, 0xfb, 0xbd, 0x3b, 0x3c, 0xb9, 0xaa, 0xaf,
	},
	.y = {
		0x7d, 0xeb, 0xe8, 0xe4, 0xe9, 0x0a, 0x5d, 0xae, 0x6e, 0x40,
		0x54, 0xca, 0x53, 0x0b, 0xa0, 0x46, 0x54, 0xb3, 0x68, 0x18,
		0xce, 0x22, 0x6b, 0x39, 0xfc, 0xcb, 0x7b, 0x02, 0xf1, 0xae,
	},
	.order = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0x9e, 0x5e, 0x9a, 0x9f, 0x5d,
		0x90, 0x71, 0xfb, 0xd1, 0x52, 0x26, 0x88, 0x90, 0x9d, 0x0b,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[30];
	uint8_t a[30];
	uint8_t b[30];
	uint8_t x[30];
	uint8_t y[30];
	uint8_t order[30];
} _EC_X9_62_PRIME_239V2 = {
	.seed = {
		0xe8, 0xb4, 0x01, 0x16, 0x04, 0x09, 0x53, 0x03, 0xca, 0x3b,
		0x80, 0x99, 0x98, 0x2b, 0xe0, 0x9f, 0xcb, 0x9a, 0xe6, 0x16,
	},
	.p = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0x61, 0x7f, 0xab, 0x68, 0x32, 0x57, 0x6c, 0xbb, 0xfe, 0xd5,
		0x0d, 0x99, 0xf0, 0x24, 0x9c, 0x3f, 0xee, 0x58, 0xb9, 0x4b,
		0xa0, 0x03, 0x8c, 0x7a, 0xe8, 0x4c, 0x8c, 0x83, 0x2f, 0x2c,
	},
	.x = {
		0x38, 0xaf, 0x09, 0xd9, 0x87, 0x27, 0x70, 0x51, 0x20, 0xc9,
		0x21, 0xbb, 0x5e, 0x9e, 0x26, 0x29, 0x6a, 0x3c, 0xdc, 0xf2,
		0xf3, 0x57, 0x57, 0xa0, 0xea, 0xfd, 0x87, 0xb8, 0x30, 0xe7,
	},
	.y = {
		0x5b, 0x01, 0x25, 0xe4, 0xdb, 0xea, 0x0e, 0xc7, 0x20, 0x6d,
		0xa0, 0xfc, 0x01, 0xd9, 0xb0, 0x81, 0x32, 0x9f, 0xb5, 0x55,
		0xde, 0x6e, 0xf4, 0x60, 0x23, 0x7d, 0xff, 0x8b, 0xe4, 0xba,
	},
	.order = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x80, 0x00, 0x00, 0xcf, 0xa7, 0xe8, 0x59, 0x43,
		0x77, 0xd4, 0x14, 0xc0, 0x38, 0x21, 0xbc, 0x58, 0x20, 0x63,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[30];
	uint8_t a[30];
	uint8_t b[30];
	uint8_t x[30];
	uint8_t y[30];
	uint8_t order[30];
} _EC_X9_62_PRIME_239V3 = {
	.seed = {
		0x7d, 0x73, 0x74, 0x16, 0x8f, 0xfe, 0x34, 0x71, 0xb6, 0x0a,
		0x85, 0x76, 0x86, 0xa1, 0x94, 0x75, 0xd3, 0xbf, 0xa2, 0xff,
	},
	.p = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0x25, 0x57, 0x05, 0xfa, 0x2a, 0x30, 0x66, 0x54, 0xb1, 0xf4,
		0xcb, 0x03, 0xd6, 0xa7, 0x50, 0xa3, 0x0c, 0x25, 0x01, 0x02,
		0xd4, 0x98, 0x87, 0x17, 0xd9, 0xba, 0x15, 0xab, 0x6d, 0x3e,
	},
	.x = {
		0x67, 0x68, 0xae, 0x8e, 0x18, 0xbb, 0x92, 0xcf, 0xcf, 0x00,
		0x5c, 0x94, 0x9a, 0xa2, 0xc6, 0xd9, 0x48, 0x53, 0xd0, 0xe6,
		0x60, 0xbb, 0xf8, 0x54, 0xb1, 0xc9, 0x50, 0x5f, 0xe9, 0x5a,
	},
	.y = {
		0x16, 0x07, 0xe6, 0x89, 0x8f, 0x39, 0x0c, 0x06, 0xbc, 0x1d,
		0x55, 0x2b, 0xad, 0x22, 0x6f, 0x3b, 0x6f, 0xcf, 0xe4, 0x8b,
		0x6e, 0x81, 0x84, 0x99, 0xaf, 0x18, 0xe3, 0xed, 0x6c, 0xf3,
	},
	.order = {
		0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x7f, 0xff, 0xff, 0x97, 0x5d, 0xeb, 0x41, 0xb3,
		0xa6, 0x05, 0x7c, 0x3c, 0x43, 0x21, 0x46, 0x52, 0x65, 0x51,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_X9_62_PRIME_256V1 = {
	.seed = {
		0xc4, 0x9d, 0x36, 0x08, 0x86, 0xe7, 0x04, 0x93, 0x6a, 0x66,
		0x78, 0xe1, 0x13, 0x9d, 0x26, 0xb7, 0x81, 0x9f, 0x7e, 0x90,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfc,
	},
	.b = {
		0x5a, 0xc6, 0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb,
		0xbd, 0x55, 0x76, 0x98, 0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0,
		0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce, 0x3c, 0x3e, 0x27, 0xd2,
		0x60, 0x4b,
	},
	.x = {
		0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc,
		0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
		0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98,
		0xc2, 0x96,
	},
	.y = {
		0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b, 0x8e, 0xe7,
		0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33, 0x57,
		0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf,
		0x51, 0xf5,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
		0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63,
		0x25, 0x51,
	},
};

/* the secg prime curves (minus the nist and x9.62 prime curves) */
static const struct {
	uint8_t seed[20];
	uint8_t p[14];
	uint8_t a[14];
	uint8_t b[14];
	uint8_t x[14];
	uint8_t y[14];
	uint8_t order[14];
} _EC_SECG_PRIME_112R1 = {
	.seed = {
		0x00, 0xf5, 0x0b, 0x02, 0x8e, 0x4d, 0x69, 0x6e, 0x67, 0x68,
		0x75, 0x61, 0x51, 0x75, 0x29, 0x04, 0x72, 0x78, 0x3f, 0xb1,
	},
	.p = {
		0xdb, 0x7c, 0x2a, 0xbf, 0x62, 0xe3, 0x5e, 0x66, 0x80, 0x76,
		0xbe, 0xad, 0x20, 0x8b,
	},
	.a = {
		0xdb, 0x7c, 0x2a, 0xbf, 0x62, 0xe3, 0x5e, 0x66, 0x80, 0x76,
		0xbe, 0xad, 0x20, 0x88,
	},
	.b = {
		0x65, 0x9e, 0xf8, 0xba, 0x04, 0x39, 0x16, 0xee, 0xde, 0x89,
		0x11, 0x70, 0x2b, 0x22,
	},
	.x = {
		0x09, 0x48, 0x72, 0x39, 0x99, 0x5a, 0x5e, 0xe7, 0x6b, 0x55,
		0xf9, 0xc2, 0xf0, 0x98,
	},
	.y = {
		0xa8, 0x9c, 0xe5, 0xaf, 0x87, 0x24, 0xc0, 0xa2, 0x3e, 0x0e,
		0x0f, 0xf7, 0x75, 0x00,
	},
	.order = {
		0xdb, 0x7c, 0x2a, 0xbf, 0x62, 0xe3, 0x5e, 0x76, 0x28, 0xdf,
		0xac, 0x65, 0x61, 0xc5,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[14];
	uint8_t a[14];
	uint8_t b[14];
	uint8_t x[14];
	uint8_t y[14];
	uint8_t order[14];
} _EC_SECG_PRIME_112R2 = {
	.seed = {
		0x00, 0x27, 0x57, 0xa1, 0x11, 0x4d, 0x69, 0x6e, 0x67, 0x68,
		0x75, 0x61, 0x51, 0x75, 0x53, 0x16, 0xc0, 0x5e, 0x0b, 0xd4,
	},
	.p = {
		0xdb, 0x7c, 0x2a, 0xbf, 0x62, 0xe3, 0x5e, 0x66, 0x80, 0x76,
		0xbe, 0xad, 0x20, 0x8b,
	},
	.a = {
		0x61, 0x27, 0xc2, 0x4c, 0x05, 0xf3, 0x8a, 0x0a, 0xaa, 0xf6,
		0x5c, 0x0e, 0xf0, 0x2c,
	},
	.b = {
		0x51, 0xde, 0xf1, 0x81, 0x5d, 0xb5, 0xed, 0x74, 0xfc, 0xc3,
		0x4c, 0x85, 0xd7, 0x09,
	},
	.x = {
		0x4b, 0xa3, 0x0a, 0xb5, 0xe8, 0x92, 0xb4, 0xe1, 0x64, 0x9d,
		0xd0, 0x92, 0x86, 0x43,
	},
	.y = {
		0xad, 0xcd, 0x46, 0xf5, 0x88, 0x2e, 0x37, 0x47, 0xde, 0xf3,
		0x6e, 0x95, 0x6e, 0x97,
	},
	.order = {
		0x36, 0xdf, 0x0a, 0xaf, 0xd8, 0xb8, 0xd7, 0x59, 0x7c, 0xa1,
		0x05, 0x20, 0xd0, 0x4b,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[16];
	uint8_t a[16];
	uint8_t b[16];
	uint8_t x[16];
	uint8_t y[16];
	uint8_t order[16];
} _EC_SECG_PRIME_128R1 = {
	.seed = {
		0x00, 0x0e, 0x0d, 0x4d, 0x69, 0x6e, 0x67, 0x68, 0x75, 0x61,
		0x51, 0x75, 0x0c, 0xc0, 0x3a, 0x44, 0x73, 0xd0, 0x36, 0x79,
	},
	.p = {
		0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0xe8, 0x75, 0x79, 0xc1, 0x10, 0x79, 0xf4, 0x3d, 0xd8, 0x24,
		0x99, 0x3c, 0x2c, 0xee, 0x5e, 0xd3,
	},
	.x = {
		0x16, 0x1f, 0xf7, 0x52, 0x8b, 0x89, 0x9b, 0x2d, 0x0c, 0x28,
		0x60, 0x7c, 0xa5, 0x2c, 0x5b, 0x86,
	},
	.y = {
		0xcf, 0x5a, 0xc8, 0x39, 0x5b, 0xaf, 0xeb, 0x13, 0xc0, 0x2d,
		0xa2, 0x92, 0xdd, 0xed, 0x7a, 0x83,
	},
	.order = {
		0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x75, 0xa3,
		0x0d, 0x1b, 0x90, 0x38, 0xa1, 0x15,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[16];
	uint8_t a[16];
	uint8_t b[16];
	uint8_t x[16];
	uint8_t y[16];
	uint8_t order[16];
} _EC_SECG_PRIME_128R2 = {
	.seed = {
		0x00, 0x4d, 0x69, 0x6e, 0x67, 0x68, 0x75, 0x61, 0x51, 0x75,
		0x12, 0xd8, 0xf0, 0x34, 0x31, 0xfc, 0xe6, 0x3b, 0x88, 0xf4,
	},
	.p = {
		0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0xd6, 0x03, 0x19, 0x98, 0xd1, 0xb3, 0xbb, 0xfe, 0xbf, 0x59,
		0xcc, 0x9b, 0xbf, 0xf9, 0xae, 0xe1,
	},
	.b = {
		0x5e, 0xee, 0xfc, 0xa3, 0x80, 0xd0, 0x29, 0x19, 0xdc, 0x2c,
		0x65, 0x58, 0xbb, 0x6d, 0x8a, 0x5d,
	},
	.x = {
		0x7b, 0x6a, 0xa5, 0xd8, 0x5e, 0x57, 0x29, 0x83, 0xe6, 0xfb,
		0x32, 0xa7, 0xcd, 0xeb, 0xc1, 0x40,
	},
	.y = {
		0x27, 0xb6, 0x91, 0x6a, 0x89, 0x4d, 0x3a, 0xee, 0x71, 0x06,
		0xfe, 0x80, 0x5f, 0xc3, 0x4b, 0x44,
	},
	.order = {
		0x3f, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xbe, 0x00,
		0x24, 0x72, 0x06, 0x13, 0xb5, 0xa3,
	},
};

static const struct {
	uint8_t p[21];
	uint8_t a[21];
	uint8_t b[21];
	uint8_t x[21];
	uint8_t y[21];
	uint8_t order[21];
} _EC_SECG_PRIME_160K1 = {
	.p = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xac,
		0x73,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00,
	},
	.b  = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x07,
	},
	.x = {
		0x00, 0x3b, 0x4c, 0x38, 0x2c, 0xe3, 0x7a, 0xa1, 0x92, 0xa4,
		0x01, 0x9e, 0x76, 0x30, 0x36, 0xf4, 0xf5, 0xdd, 0x4d, 0x7e,
		0xbb,
	},
	.y = {
		0x00, 0x93, 0x8c, 0xf9, 0x35, 0x31, 0x8f, 0xdc, 0xed, 0x6b,
		0xc2, 0x82, 0x86, 0x53, 0x17, 0x33, 0xc3, 0xf0, 0x3c, 0x4f,
		0xee,
	},
	.order = {
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x01, 0xb8, 0xfa, 0x16, 0xdf, 0xab, 0x9a, 0xca, 0x16, 0xb6,
		0xb3,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[21];
	uint8_t a[21];
	uint8_t b[21];
	uint8_t x[21];
	uint8_t y[21];
	uint8_t order[21];
} _EC_SECG_PRIME_160R1 = {
	.seed = {
		0x10, 0x53, 0xcd, 0xe4, 0x2c, 0x14, 0xd6, 0x96, 0xe6, 0x76,
		0x87, 0x56, 0x15, 0x17, 0x53, 0x3b, 0xf3, 0xf8, 0x33, 0x45,
	},
	.p = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
		0xff,
	},
	.a = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff,
		0xfc,
	},
	.b = {
		0x00, 0x1c, 0x97, 0xbe, 0xfc, 0x54, 0xbd, 0x7a, 0x8b, 0x65,
		0xac, 0xf8, 0x9f, 0x81, 0xd4, 0xd4, 0xad, 0xc5, 0x65, 0xfa,
		0x45,
	},
	.x = {
		0x00, 0x4a, 0x96, 0xb5, 0x68, 0x8e, 0xf5, 0x73, 0x28, 0x46,
		0x64, 0x69, 0x89, 0x68, 0xc3, 0x8b, 0xb9, 0x13, 0xcb, 0xfc,
		0x82,
	},
	.y = {
		0x00, 0x23, 0xa6, 0x28, 0x55, 0x31, 0x68, 0x94, 0x7d, 0x59,
		0xdc, 0xc9, 0x12, 0x04, 0x23, 0x51, 0x37, 0x7a, 0xc5, 0xfb,
		0x32,
	},
	.order = {
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x01, 0xf4, 0xc8, 0xf9, 0x27, 0xae, 0xd3, 0xca, 0x75, 0x22,
		0x57,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[21];
	uint8_t a[21];
	uint8_t b[21];
	uint8_t x[21];
	uint8_t y[21];
	uint8_t order[21];
} _EC_SECG_PRIME_160R2 = {
	.seed = {
		0xb9, 0x9b, 0x99, 0xb0, 0x99, 0xb3, 0x23, 0xe0, 0x27, 0x09,
		0xa4, 0xd6, 0x96, 0xe6, 0x76, 0x87, 0x56, 0x15, 0x17, 0x51,
	},
	.p = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xac,
		0x73,
	},
	.a = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xac,
		0x70,
	},
	.b = {
		0x00, 0xb4, 0xe1, 0x34, 0xd3, 0xfb, 0x59, 0xeb, 0x8b, 0xab,
		0x57, 0x27, 0x49, 0x04, 0x66, 0x4d, 0x5a, 0xf5, 0x03, 0x88,
		0xba,
	},
	.x = {
		0x00, 0x52, 0xdc, 0xb0, 0x34, 0x29, 0x3a, 0x11, 0x7e, 0x1f,
		0x4f, 0xf1, 0x1b, 0x30, 0xf7, 0x19, 0x9d, 0x31, 0x44, 0xce,
		0x6d,
	},
	.y = {
		0x00, 0xfe, 0xaf, 0xfe, 0xf2, 0xe3, 0x31, 0xf2, 0x96, 0xe0,
		0x71, 0xfa, 0x0d, 0xf9, 0x98, 0x2c, 0xfe, 0xa7, 0xd4, 0x3f,
		0x2e,
	},
	.order = {
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x35, 0x1e, 0xe7, 0x86, 0xa8, 0x18, 0xf3, 0xa1, 0xa1,
		0x6b,
	},
};

static const struct {
	uint8_t p[24];
	uint8_t a[24];
	uint8_t b[24];
	uint8_t x[24];
	uint8_t y[24];
	uint8_t order[24];
} _EC_SECG_PRIME_192K1 = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
		0xff, 0xff, 0xee, 0x37,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x03,
	},
	.x = {
		0xdb, 0x4f, 0xf1, 0x0e, 0xc0, 0x57, 0xe9, 0xae, 0x26, 0xb0,
		0x7d, 0x02, 0x80, 0xb7, 0xf4, 0x34, 0x1d, 0xa5, 0xd1, 0xb1,
		0xea, 0xe0, 0x6c, 0x7d,
	},
	.y = {
		0x9b, 0x2f, 0x2f, 0x6d, 0x9c, 0x56, 0x28, 0xa7, 0x84, 0x41,
		0x63, 0xd0, 0x15, 0xbe, 0x86, 0x34, 0x40, 0x82, 0xaa, 0x88,
		0xd9, 0x5e, 0x2f, 0x9d,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfe, 0x26, 0xf2, 0xfc, 0x17, 0x0f, 0x69, 0x46, 0x6a,
		0x74, 0xde, 0xfd, 0x8d,
	},
};

static const struct {
	uint8_t p[29];
	uint8_t a[29];
	uint8_t b[29];
	uint8_t x[29];
	uint8_t y[29];
	uint8_t order[29];
} _EC_SECG_PRIME_224K1 = {
	.p = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xe5, 0x6d,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	},
	.x = {
		0x00, 0xa1, 0x45, 0x5b, 0x33, 0x4d, 0xf0, 0x99, 0xdf, 0x30,
		0xfc, 0x28, 0xa1, 0x69, 0xa4, 0x67, 0xe9, 0xe4, 0x70, 0x75,
		0xa9, 0x0f, 0x7e, 0x65, 0x0e, 0xb6, 0xb7, 0xa4, 0x5c,
	},
	.y = {
		0x00, 0x7e, 0x08, 0x9f, 0xed, 0x7f, 0xba, 0x34, 0x42, 0x82,
		0xca, 0xfb, 0xd6, 0xf7, 0xe3, 0x19, 0xf7, 0xc0, 0xb0, 0xbd,
		0x59, 0xe2, 0xca, 0x4b, 0xdb, 0x55, 0x6d, 0x61, 0xa5,
	},
	.order = {
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x01, 0xdc, 0xe8, 0xd2, 0xec, 0x61,
		0x84, 0xca, 0xf0, 0xa9, 0x71, 0x76, 0x9f, 0xb1, 0xf7,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_SECG_PRIME_256K1 = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
		0xfc, 0x2f,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x07,
	},
	.x = {
		0x79, 0xbe, 0x66, 0x7e, 0xf9, 0xdc, 0xbb, 0xac, 0x55, 0xa0,
		0x62, 0x95, 0xce, 0x87, 0x0b, 0x07, 0x02, 0x9b, 0xfc, 0xdb,
		0x2d, 0xce, 0x28, 0xd9, 0x59, 0xf2, 0x81, 0x5b, 0x16, 0xf8,
		0x17, 0x98,
	},
	.y = {
		0x48, 0x3a, 0xda, 0x77, 0x26, 0xa3, 0xc4, 0x65, 0x5d, 0xa4,
		0xfb, 0xfc, 0x0e, 0x11, 0x08, 0xa8, 0xfd, 0x17, 0xb4, 0x48,
		0xa6, 0x85, 0x54, 0x19, 0x9c, 0x47, 0xd0, 0x8f, 0xfb, 0x10,
		0xd4, 0xb8,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xba, 0xae, 0xdc, 0xe6,
		0xaf, 0x48, 0xa0, 0x3b, 0xbf, 0xd2, 0x5e, 0x8c, 0xd0, 0x36,
		0x41, 0x41,
	},
};

/* some wap/wtls curves */
static const struct {
	uint8_t p[15];
	uint8_t a[15];
	uint8_t b[15];
	uint8_t x[15];
	uint8_t y[15];
	uint8_t order[15];
} _EC_WTLS_8 = {
	.p = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xfd, 0xe7,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x03,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x01,
	},
	.y = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x02,
	},
	.order = {
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xec, 0xea,
		0x55, 0x1a, 0xd8, 0x37, 0xe9,
	},
};

static const struct {
	uint8_t p[21];
	uint8_t a[21];
	uint8_t b[21];
	uint8_t x[21];
	uint8_t y[21];
	uint8_t order[21];
} _EC_WTLS_9 = {
	.p = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x80,
		0x8f,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x03,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x01,
	},
	.y = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x02,
	},
	.order = {
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x01, 0xcd, 0xc9, 0x8a, 0xe0, 0xe2, 0xde, 0x57, 0x4a, 0xbf,
		0x33,
	},
};

static const struct {
	uint8_t p[28];
	uint8_t a[28];
	uint8_t b[28];
	uint8_t x[28];
	uint8_t y[28];
	uint8_t order[28];
} _EC_WTLS_12 = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
	},
	.b = {
		0xb4, 0x05, 0x0a, 0x85, 0x0c, 0x04, 0xb3, 0xab, 0xf5, 0x41,
		0x32, 0x56, 0x50, 0x44, 0xb0, 0xb7, 0xd7, 0xbf, 0xd8, 0xba,
		0x27, 0x0b, 0x39, 0x43, 0x23, 0x55, 0xff, 0xb4,
	},
	.x = {
		0xb7, 0x0e, 0x0c, 0xbd, 0x6b, 0xb4, 0xbf, 0x7f, 0x32, 0x13,
		0x90, 0xb9, 0x4a, 0x03, 0xc1, 0xd3, 0x56, 0xc2, 0x11, 0x22,
		0x34, 0x32, 0x80, 0xd6, 0x11, 0x5c, 0x1d, 0x21,
	},
	.y = {
		0xbd, 0x37, 0x63, 0x88, 0xb5, 0xf7, 0x23, 0xfb, 0x4c, 0x22,
		0xdf, 0xe6, 0xcd, 0x43, 0x75, 0xa0, 0x5a, 0x07, 0x47, 0x64,
		0x44, 0xd5, 0x81, 0x99, 0x85, 0x00, 0x7e, 0x34,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0x16, 0xa2, 0xe0, 0xb8, 0xf0, 0x3e,
		0x13, 0xdd, 0x29, 0x45, 0x5c, 0x5c, 0x2a, 0x3d,
	},
};

static const struct {
	uint8_t p[20];
	uint8_t a[20];
	uint8_t b[20];
	uint8_t x[20];
	uint8_t y[20];
	uint8_t order[20];
} _EC_brainpoolP160r1 = {
	.p = {
		0xe9, 0x5e, 0x4a, 0x5f, 0x73, 0x70, 0x59, 0xdc, 0x60, 0xdf,
		0xc7, 0xad, 0x95, 0xb3, 0xd8, 0x13, 0x95, 0x15, 0x62, 0x0f,
	},
	.a = {
		0x34, 0x0e, 0x7b, 0xe2, 0xa2, 0x80, 0xeb, 0x74, 0xe2, 0xbe,
		0x61, 0xba, 0xda, 0x74, 0x5d, 0x97, 0xe8, 0xf7, 0xc3, 0x00,
	},
	.b = {
		0x1e, 0x58, 0x9a, 0x85, 0x95, 0x42, 0x34, 0x12, 0x13, 0x4f,
		0xaa, 0x2d, 0xbd, 0xec, 0x95, 0xc8, 0xd8, 0x67, 0x5e, 0x58,
	},
	.x = {
		0xbe, 0xd5, 0xaf, 0x16, 0xea, 0x3f, 0x6a, 0x4f, 0x62, 0x93,
		0x8c, 0x46, 0x31, 0xeb, 0x5a, 0xf7, 0xbd, 0xbc, 0xdb, 0xc3,
	},
	.y = {
		0x16, 0x67, 0xcb, 0x47, 0x7a, 0x1a, 0x8e, 0xc3, 0x38, 0xf9,
		0x47, 0x41, 0x66, 0x9c, 0x97, 0x63, 0x16, 0xda, 0x63, 0x21,
	},
	.order = {
		0xe9, 0x5e, 0x4a, 0x5f, 0x73, 0x70, 0x59, 0xdc, 0x60, 0xdf,
		0x59, 0x91, 0xd4, 0x50, 0x29, 0x40, 0x9e, 0x60, 0xfc, 0x09,
	},
};

static const struct {
	uint8_t p[20];
	uint8_t a[20];
	uint8_t b[20];
	uint8_t x[20];
	uint8_t y[20];
	uint8_t order[20];
} _EC_brainpoolP160t1 = {
	.p = {
		0xe9, 0x5e, 0x4a, 0x5f, 0x73, 0x70, 0x59, 0xdc, 0x60, 0xdf,
		0xc7, 0xad, 0x95, 0xb3, 0xd8, 0x13, 0x95, 0x15, 0x62, 0x0f,
	},
	.a = {
		0xe9, 0x5e, 0x4a, 0x5f, 0x73, 0x70, 0x59, 0xdc, 0x60, 0xdf,
		0xc7, 0xad, 0x95, 0xb3, 0xd8, 0x13, 0x95, 0x15, 0x62, 0x0c,
	},
	.b = {
		0x7a, 0x55, 0x6b, 0x6d, 0xae, 0x53, 0x5b, 0x7b, 0x51, 0xed,
		0x2c, 0x4d, 0x7d, 0xaa, 0x7a, 0x0b, 0x5c, 0x55, 0xf3, 0x80,
	},
	.x = {
		0xb1, 0x99, 0xb1, 0x3b, 0x9b, 0x34, 0xef, 0xc1, 0x39, 0x7e,
		0x64, 0xba, 0xeb, 0x05, 0xac, 0xc2, 0x65, 0xff, 0x23, 0x78,
	},
	.y = {
		0xad, 0xd6, 0x71, 0x8b, 0x7c, 0x7c, 0x19, 0x61, 0xf0, 0x99,
		0x1b, 0x84, 0x24, 0x43, 0x77, 0x21, 0x52, 0xc9, 0xe0, 0xad,
	},
	.order = {
		0xe9, 0x5e, 0x4a, 0x5f, 0x73, 0x70, 0x59, 0xdc, 0x60, 0xdf,
		0x59, 0x91, 0xd4, 0x50, 0x29, 0x40, 0x9e, 0x60, 0xfc, 0x09,
	},
};

static const struct {
	uint8_t p[24];
	uint8_t a[24];
	uint8_t b[24];
	uint8_t x[24];
	uint8_t y[24];
	uint8_t order[24];
} _EC_brainpoolP192r1 = {
	.p = {
		0xc3, 0x02, 0xf4, 0x1d, 0x93, 0x2a, 0x36, 0xcd, 0xa7, 0xa3,
		0x46, 0x30, 0x93, 0xd1, 0x8d, 0xb7, 0x8f, 0xce, 0x47, 0x6d,
		0xe1, 0xa8, 0x62, 0x97,
	},
	.a = {
		0x6a, 0x91, 0x17, 0x40, 0x76, 0xb1, 0xe0, 0xe1, 0x9c, 0x39,
		0xc0, 0x31, 0xfe, 0x86, 0x85, 0xc1, 0xca, 0xe0, 0x40, 0xe5,
		0xc6, 0x9a, 0x28, 0xef,
	},
	.b = {
		0x46, 0x9a, 0x28, 0xef, 0x7c, 0x28, 0xcc, 0xa3, 0xdc, 0x72,
		0x1d, 0x04, 0x4f, 0x44, 0x96, 0xbc, 0xca, 0x7e, 0xf4, 0x14,
		0x6f, 0xbf, 0x25, 0xc9,
	},
	.x = {
		0xc0, 0xa0, 0x64, 0x7e, 0xaa, 0xb6, 0xa4, 0x87, 0x53, 0xb0,
		0x33, 0xc5, 0x6c, 0xb0, 0xf0, 0x90, 0x0a, 0x2f, 0x5c, 0x48,
		0x53, 0x37, 0x5f, 0xd6,
	},
	.y = {
		0x14, 0xb6, 0x90, 0x86, 0x6a, 0xbd, 0x5b, 0xb8, 0x8b, 0x5f,
		0x48, 0x28, 0xc1, 0x49, 0x00, 0x02, 0xe6, 0x77, 0x3f, 0xa2,
		0xfa, 0x29, 0x9b, 0x8f,
	},
	.order = {
		0xc3, 0x02, 0xf4, 0x1d, 0x93, 0x2a, 0x36, 0xcd, 0xa7, 0xa3,
		0x46, 0x2f, 0x9e, 0x9e, 0x91, 0x6b, 0x5b, 0xe8, 0xf1, 0x02,
		0x9a, 0xc4, 0xac, 0xc1,
	},
};

static const struct {
	uint8_t p[24];
	uint8_t a[24];
	uint8_t b[24];
	uint8_t x[24];
	uint8_t y[24];
	uint8_t order[24];
} _EC_brainpoolP192t1 = {
	.p = {
		0xc3, 0x02, 0xf4, 0x1d, 0x93, 0x2a, 0x36, 0xcd, 0xa7, 0xa3,
		0x46, 0x30, 0x93, 0xd1, 0x8d, 0xb7, 0x8f, 0xce, 0x47, 0x6d,
		0xe1, 0xa8, 0x62, 0x97,
	},
	.a = {
		0xc3, 0x02, 0xf4, 0x1d, 0x93, 0x2a, 0x36, 0xcd, 0xa7, 0xa3,
		0x46, 0x30, 0x93, 0xd1, 0x8d, 0xb7, 0x8f, 0xce, 0x47, 0x6d,
		0xe1, 0xa8, 0x62, 0x94,
	},
	.b = {
		0x13, 0xd5, 0x6f, 0xfa, 0xec, 0x78, 0x68, 0x1e, 0x68, 0xf9,
		0xde, 0xb4, 0x3b, 0x35, 0xbe, 0xc2, 0xfb, 0x68, 0x54, 0x2e,
		0x27, 0x89, 0x7b, 0x79,
	},
	.x = {
		0x3a, 0xe9, 0xe5, 0x8c, 0x82, 0xf6, 0x3c, 0x30, 0x28, 0x2e,
		0x1f, 0xe7, 0xbb, 0xf4, 0x3f, 0xa7, 0x2c, 0x44, 0x6a, 0xf6,
		0xf4, 0x61, 0x81, 0x29,
	},
	.y = {
		0x09, 0x7e, 0x2c, 0x56, 0x67, 0xc2, 0x22, 0x3a, 0x90, 0x2a,
		0xb5, 0xca, 0x44, 0x9d, 0x00, 0x84, 0xb7, 0xe5, 0xb3, 0xde,
		0x7c, 0xcc, 0x01, 0xc9,
	},
	.order = {
		0xc3, 0x02, 0xf4, 0x1d, 0x93, 0x2a, 0x36, 0xcd, 0xa7, 0xa3,
		0x46, 0x2f, 0x9e, 0x9e, 0x91, 0x6b, 0x5b, 0xe8, 0xf1, 0x02,
		0x9a, 0xc4, 0xac, 0xc1,
	},
};

static const struct {
	uint8_t p[28];
	uint8_t a[28];
	uint8_t b[28];
	uint8_t x[28];
	uint8_t y[28];
	uint8_t order[28];
} _EC_brainpoolP224r1 = {
	.p = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57,
		0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff,
	},
	.a = {
		0x68, 0xa5, 0xe6, 0x2c, 0xa9, 0xce, 0x6c, 0x1c, 0x29, 0x98,
		0x03, 0xa6, 0xc1, 0x53, 0x0b, 0x51, 0x4e, 0x18, 0x2a, 0xd8,
		0xb0, 0x04, 0x2a, 0x59, 0xca, 0xd2, 0x9f, 0x43,
	},
	.b = {
		0x25, 0x80, 0xf6, 0x3c, 0xcf, 0xe4, 0x41, 0x38, 0x87, 0x07,
		0x13, 0xb1, 0xa9, 0x23, 0x69, 0xe3, 0x3e, 0x21, 0x35, 0xd2,
		0x66, 0xdb, 0xb3, 0x72, 0x38, 0x6c, 0x40, 0x0b,
	},
	.x = {
		0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08,
		0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17,
		0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d,
	},
	.y = {
		0x58, 0xaa, 0x56, 0xf7, 0x72, 0xc0, 0x72, 0x6f, 0x24, 0xc6,
		0xb8, 0x9e, 0x4e, 0xcd, 0xac, 0x24, 0x35, 0x4b, 0x9e, 0x99,
		0xca, 0xa3, 0xf6, 0xd3, 0x76, 0x14, 0x02, 0xcd,
	},
	.order = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b,
		0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f,
	},
};

static const struct {
	uint8_t p[28];
	uint8_t a[28];
	uint8_t b[28];
	uint8_t x[28];
	uint8_t y[28];
	uint8_t order[28];
} _EC_brainpoolP224t1 = {
	.p = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57,
		0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff,
	},
	.a = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57,
		0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xfc,
	},
	.b = {
		0x4b, 0x33, 0x7d, 0x93, 0x41, 0x04, 0xcd, 0x7b, 0xef, 0x27,
		0x1b, 0xf6, 0x0c, 0xed, 0x1e, 0xd2, 0x0d, 0xa1, 0x4c, 0x08,
		0xb3, 0xbb, 0x64, 0xf1, 0x8a, 0x60, 0x88, 0x8d,
	},
	.x = {
		0x6a, 0xb1, 0xe3, 0x44, 0xce, 0x25, 0xff, 0x38, 0x96, 0x42,
		0x4e, 0x7f, 0xfe, 0x14, 0x76, 0x2e, 0xcb, 0x49, 0xf8, 0x92,
		0x8a, 0xc0, 0xc7, 0x60, 0x29, 0xb4, 0xd5, 0x80,
	},
	.y = {
		0x03, 0x74, 0xe9, 0xf5, 0x14, 0x3e, 0x56, 0x8c, 0xd2, 0x3f,
		0x3f, 0x4d, 0x7c, 0x0d, 0x4b, 0x1e, 0x41, 0xc8, 0xcc, 0x0d,
		0x1c, 0x6a, 0xbd, 0x5f, 0x1a, 0x46, 0xdb, 0x4c,
	},
	.order = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b,
		0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_brainpoolP256r1 = {
	.p = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23,
		0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e,
		0x53, 0x77,
	},
	.a = {
		0x7d, 0x5a, 0x09, 0x75, 0xfc, 0x2c, 0x30, 0x57, 0xee, 0xf6,
		0x75, 0x30, 0x41, 0x7a, 0xff, 0xe7, 0xfb, 0x80, 0x55, 0xc1,
		0x26, 0xdc, 0x5c, 0x6c, 0xe9, 0x4a, 0x4b, 0x44, 0xf3, 0x30,
		0xb5, 0xd9,
	},
	.b = {
		0x26, 0xdc, 0x5c, 0x6c, 0xe9, 0x4a, 0x4b, 0x44, 0xf3, 0x30,
		0xb5, 0xd9, 0xbb, 0xd7, 0x7c, 0xbf, 0x95, 0x84, 0x16, 0x29,
		0x5c, 0xf7, 0xe1, 0xce, 0x6b, 0xcc, 0xdc, 0x18, 0xff, 0x8c,
		0x07, 0xb6,
	},
	.x = {
		0x8b, 0xd2, 0xae, 0xb9, 0xcb, 0x7e, 0x57, 0xcb, 0x2c, 0x4b,
		0x48, 0x2f, 0xfc, 0x81, 0xb7, 0xaf, 0xb9, 0xde, 0x27, 0xe1,
		0xe3, 0xbd, 0x23, 0xc2, 0x3a, 0x44, 0x53, 0xbd, 0x9a, 0xce,
		0x32, 0x62,
	},
	.y = {
		0x54, 0x7e, 0xf8, 0x35, 0xc3, 0xda, 0xc4, 0xfd, 0x97, 0xf8,
		0x46, 0x1a, 0x14, 0x61, 0x1d, 0xc9, 0xc2, 0x77, 0x45, 0x13,
		0x2d, 0xed, 0x8e, 0x54, 0x5c, 0x1d, 0x54, 0xc7, 0x2f, 0x04,
		0x69, 0x97,
	},
	.order = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3,
		0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48,
		0x56, 0xa7,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_brainpoolP256t1 = {
	.p = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23,
		0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e,
		0x53, 0x77,
	},
	.a = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23,
		0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e,
		0x53, 0x74,
	},
	.b = {
		0x66, 0x2c, 0x61, 0xc4, 0x30, 0xd8, 0x4e, 0xa4, 0xfe, 0x66,
		0xa7, 0x73, 0x3d, 0x0b, 0x76, 0xb7, 0xbf, 0x93, 0xeb, 0xc4,
		0xaf, 0x2f, 0x49, 0x25, 0x6a, 0xe5, 0x81, 0x01, 0xfe, 0xe9,
		0x2b, 0x04,
	},
	.x = {
		0xa3, 0xe8, 0xeb, 0x3c, 0xc1, 0xcf, 0xe7, 0xb7, 0x73, 0x22,
		0x13, 0xb2, 0x3a, 0x65, 0x61, 0x49, 0xaf, 0xa1, 0x42, 0xc4,
		0x7a, 0xaf, 0xbc, 0x2b, 0x79, 0xa1, 0x91, 0x56, 0x2e, 0x13,
		0x05, 0xf4,
	},
	.y = {
		0x2d, 0x99, 0x6c, 0x82, 0x34, 0x39, 0xc5, 0x6d, 0x7f, 0x7b,
		0x22, 0xe1, 0x46, 0x44, 0x41, 0x7e, 0x69, 0xbc, 0xb6, 0xde,
		0x39, 0xd0, 0x27, 0x00, 0x1d, 0xab, 0xe8, 0xf3, 0x5b, 0x25,
		0xc9, 0xbe,
	},
	.order = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3,
		0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48,
		0x56, 0xa7,
	},
};

static const struct {
	uint8_t p[40];
	uint8_t a[40];
	uint8_t b[40];
	uint8_t x[40];
	uint8_t y[40];
	uint8_t order[40];
} _EC_brainpoolP320r1 = {
	.p = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa6,
		0xf6, 0xf4, 0x0d, 0xef, 0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93,
		0xec, 0x28, 0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
	},
	.a = {
		0x3e, 0xe3, 0x0b, 0x56, 0x8f, 0xba, 0xb0, 0xf8, 0x83, 0xcc,
		0xeb, 0xd4, 0x6d, 0x3f, 0x3b, 0xb8, 0xa2, 0xa7, 0x35, 0x13,
		0xf5, 0xeb, 0x79, 0xda, 0x66, 0x19, 0x0e, 0xb0, 0x85, 0xff,
		0xa9, 0xf4, 0x92, 0xf3, 0x75, 0xa9, 0x7d, 0x86, 0x0e, 0xb4,
	},
	.b = {
		0x52, 0x08, 0x83, 0x94, 0x9d, 0xfd, 0xbc, 0x42, 0xd3, 0xad,
		0x19, 0x86, 0x40, 0x68, 0x8a, 0x6f, 0xe1, 0x3f, 0x41, 0x34,
		0x95, 0x54, 0xb4, 0x9a, 0xcc, 0x31, 0xdc, 0xcd, 0x88, 0x45,
		0x39, 0x81, 0x6f, 0x5e, 0xb4, 0xac, 0x8f, 0xb1, 0xf1, 0xa6,
	},
	.x = {
		0x43, 0xbd, 0x7e, 0x9a, 0xfb, 0x53, 0xd8, 0xb8, 0x52, 0x89,
		0xbc, 0xc4, 0x8e, 0xe5, 0xbf, 0xe6, 0xf2, 0x01, 0x37, 0xd1,
		0x0a, 0x08, 0x7e, 0xb6, 0xe7, 0x87, 0x1e, 0x2a, 0x10, 0xa5,
		0x99, 0xc7, 0x10, 0xaf, 0x8d, 0x0d, 0x39, 0xe2, 0x06, 0x11,
	},
	.y = {
		0x14, 0xfd, 0xd0, 0x55, 0x45, 0xec, 0x1c, 0xc8, 0xab, 0x40,
		0x93, 0x24, 0x7f, 0x77, 0x27, 0x5e, 0x07, 0x43, 0xff, 0xed,
		0x11, 0x71, 0x82, 0xea, 0xa9, 0xc7, 0x78, 0x77, 0xaa, 0xac,
		0x6a, 0xc7, 0xd3, 0x52, 0x45, 0xd1, 0x69, 0x2e, 0x8e, 0xe1,
	},
	.order = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa5,
		0xb6, 0x8f, 0x12, 0xa3, 0x2d, 0x48, 0x2e, 0xc7, 0xee, 0x86,
		0x58, 0xe9, 0x86, 0x91, 0x55, 0x5b, 0x44, 0xc5, 0x93, 0x11,
	},
};

static const struct {
	uint8_t p[40];
	uint8_t a[40];
	uint8_t b[40];
	uint8_t x[40];
	uint8_t y[40];
	uint8_t order[40];
} _EC_brainpoolP320t1 = {
	.p = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa6,
		0xf6, 0xf4, 0x0d, 0xef, 0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93,
		0xec, 0x28, 0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
	},
	.a = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa6,
		0xf6, 0xf4, 0x0d, 0xef, 0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93,
		0xec, 0x28, 0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x24,
	},
	.b = {
		0xa7, 0xf5, 0x61, 0xe0, 0x38, 0xeb, 0x1e, 0xd5, 0x60, 0xb3,
		0xd1, 0x47, 0xdb, 0x78, 0x20, 0x13, 0x06, 0x4c, 0x19, 0xf2,
		0x7e, 0xd2, 0x7c, 0x67, 0x80, 0xaa, 0xf7, 0x7f, 0xb8, 0xa5,
		0x47, 0xce, 0xb5, 0xb4, 0xfe, 0xf4, 0x22, 0x34, 0x03, 0x53,
	},
	.x = {
		0x92, 0x5b, 0xe9, 0xfb, 0x01, 0xaf, 0xc6, 0xfb, 0x4d, 0x3e,
		0x7d, 0x49, 0x90, 0x01, 0x0f, 0x81, 0x34, 0x08, 0xab, 0x10,
		0x6c, 0x4f, 0x09, 0xcb, 0x7e, 0xe0, 0x78, 0x68, 0xcc, 0x13,
		0x6f, 0xff, 0x33, 0x57, 0xf6, 0x24, 0xa2, 0x1b, 0xed, 0x52,
	},
	.y = {
		0x63, 0xba, 0x3a, 0x7a, 0x27, 0x48, 0x3e, 0xbf, 0x66, 0x71,
		0xdb, 0xef, 0x7a, 0xbb, 0x30, 0xeb, 0xee, 0x08, 0x4e, 0x58,
		0xa0, 0xb0, 0x77, 0xad, 0x42, 0xa5, 0xa0, 0x98, 0x9d, 0x1e,
		0xe7, 0x1b, 0x1b, 0x9b, 0xc0, 0x45, 0x5f, 0xb0, 0xd2, 0xc3,
	},
	.order = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa5,
		0xb6, 0x8f, 0x12, 0xa3, 0x2d, 0x48, 0x2e, 0xc7, 0xee, 0x86,
		0x58, 0xe9, 0x86, 0x91, 0x55, 0x5b, 0x44, 0xc5, 0x93, 0x11,
	},
};

static const struct {
	uint8_t p[48];
	uint8_t a[48];
	uint8_t b[48];
	uint8_t x[48];
	uint8_t y[48];
	uint8_t order[48];
} _EC_brainpoolP384r1 = {
	.p = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb4, 0x12, 0xb1, 0xda, 0x19, 0x7f, 0xb7,
		0x11, 0x23, 0xac, 0xd3, 0xa7, 0x29, 0x90, 0x1d, 0x1a, 0x71,
		0x87, 0x47, 0x00, 0x13, 0x31, 0x07, 0xec, 0x53,
	},
	.a = {
		0x7b, 0xc3, 0x82, 0xc6, 0x3d, 0x8c, 0x15, 0x0c, 0x3c, 0x72,
		0x08, 0x0a, 0xce, 0x05, 0xaf, 0xa0, 0xc2, 0xbe, 0xa2, 0x8e,
		0x4f, 0xb2, 0x27, 0x87, 0x13, 0x91, 0x65, 0xef, 0xba, 0x91,
		0xf9, 0x0f, 0x8a, 0xa5, 0x81, 0x4a, 0x50, 0x3a, 0xd4, 0xeb,
		0x04, 0xa8, 0xc7, 0xdd, 0x22, 0xce, 0x28, 0x26,
	},
	.b = {
		0x04, 0xa8, 0xc7, 0xdd, 0x22, 0xce, 0x28, 0x26, 0x8b, 0x39,
		0xb5, 0x54, 0x16, 0xf0, 0x44, 0x7c, 0x2f, 0xb7, 0x7d, 0xe1,
		0x07, 0xdc, 0xd2, 0xa6, 0x2e, 0x88, 0x0e, 0xa5, 0x3e, 0xeb,
		0x62, 0xd5, 0x7c, 0xb4, 0x39, 0x02, 0x95, 0xdb, 0xc9, 0x94,
		0x3a, 0xb7, 0x86, 0x96, 0xfa, 0x50, 0x4c, 0x11,
	},
	.x = {
		0x1d, 0x1c, 0x64, 0xf0, 0x68, 0xcf, 0x45, 0xff, 0xa2, 0xa6,
		0x3a, 0x81, 0xb7, 0xc1, 0x3f, 0x6b, 0x88, 0x47, 0xa3, 0xe7,
		0x7e, 0xf1, 0x4f, 0xe3, 0xdb, 0x7f, 0xca, 0xfe, 0x0c, 0xbd,
		0x10, 0xe8, 0xe8, 0x26, 0xe0, 0x34, 0x36, 0xd6, 0x46, 0xaa,
		0xef, 0x87, 0xb2, 0xe2, 0x47, 0xd4, 0xaf, 0x1e,
	},
	.y = {
		0x8a, 0xbe, 0x1d, 0x75, 0x20, 0xf9, 0xc2, 0xa4, 0x5c, 0xb1,
		0xeb, 0x8e, 0x95, 0xcf, 0xd5, 0x52, 0x62, 0xb7, 0x0b, 0x29,
		0xfe, 0xec, 0x58, 0x64, 0xe1, 0x9c, 0x05, 0x4f, 0xf9, 0x91,
		0x29, 0x28, 0x0e, 0x46, 0x46, 0x21, 0x77, 0x91, 0x81, 0x11,
		0x42, 0x82, 0x03, 0x41, 0x26, 0x3c, 0x53, 0x15,
	},
	.order = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb3, 0x1f, 0x16, 0x6e, 0x6c, 0xac, 0x04,
		0x25, 0xa7, 0xcf, 0x3a, 0xb6, 0xaf, 0x6b, 0x7f, 0xc3, 0x10,
		0x3b, 0x88, 0x32, 0x02, 0xe9, 0x04, 0x65, 0x65,
	},
};

static const struct {
	uint8_t p[48];
	uint8_t a[48];
	uint8_t b[48];
	uint8_t x[48];
	uint8_t y[48];
	uint8_t order[48];
} _EC_brainpoolP384t1 = {
	.p = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb4, 0x12, 0xb1, 0xda, 0x19, 0x7f, 0xb7,
		0x11, 0x23, 0xac, 0xd3, 0xa7, 0x29, 0x90, 0x1d, 0x1a, 0x71,
		0x87, 0x47, 0x00, 0x13, 0x31, 0x07, 0xec, 0x53,
	},
	.a = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb4, 0x12, 0xb1, 0xda, 0x19, 0x7f, 0xb7,
		0x11, 0x23, 0xac, 0xd3, 0xa7, 0x29, 0x90, 0x1d, 0x1a, 0x71,
		0x87, 0x47, 0x00, 0x13, 0x31, 0x07, 0xec, 0x50,
	},
	.b = {
		0x7f, 0x51, 0x9e, 0xad, 0xa7, 0xbd, 0xa8, 0x1b, 0xd8, 0x26,
		0xdb, 0xa6, 0x47, 0x91, 0x0f, 0x8c, 0x4b, 0x93, 0x46, 0xed,
		0x8c, 0xcd, 0xc6, 0x4e, 0x4b, 0x1a, 0xbd, 0x11, 0x75, 0x6d,
		0xce, 0x1d, 0x20, 0x74, 0xaa, 0x26, 0x3b, 0x88, 0x80, 0x5c,
		0xed, 0x70, 0x35, 0x5a, 0x33, 0xb4, 0x71, 0xee,
	},
	.x = {
		0x18, 0xde, 0x98, 0xb0, 0x2d, 0xb9, 0xa3, 0x06, 0xf2, 0xaf,
		0xcd, 0x72, 0x35, 0xf7, 0x2a, 0x81, 0x9b, 0x80, 0xab, 0x12,
		0xeb, 0xd6, 0x53, 0x17, 0x24, 0x76, 0xfe, 0xcd, 0x46, 0x2a,
		0xab, 0xff, 0xc4, 0xff, 0x19, 0x1b, 0x94, 0x6a, 0x5f, 0x54,
		0xd8, 0xd0, 0xaa, 0x2f, 0x41, 0x88, 0x08, 0xcc,
	},
	.y = {
		0x25, 0xab, 0x05, 0x69, 0x62, 0xd3, 0x06, 0x51, 0xa1, 0x14,
		0xaf, 0xd2, 0x75, 0x5a, 0xd3, 0x36, 0x74, 0x7f, 0x93, 0x47,
		0x5b, 0x7a, 0x1f, 0xca, 0x3b, 0x88, 0xf2, 0xb6, 0xa2, 0x08,
		0xcc, 0xfe, 0x46, 0x94, 0x08, 0x58, 0x4d, 0xc2, 0xb2, 0x91,
		0x26, 0x75, 0xbf, 0x5b, 0x9e, 0x58, 0x29, 0x28,
	},
	.order = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb3, 0x1f, 0x16, 0x6e, 0x6c, 0xac, 0x04,
		0x25, 0xa7, 0xcf, 0x3a, 0xb6, 0xaf, 0x6b, 0x7f, 0xc3, 0x10,
		0x3b, 0x88, 0x32, 0x02, 0xe9, 0x04, 0x65, 0x65,
	},
};

static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_brainpoolP512r1 = {
	.p = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x71, 0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
		0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6, 0x28, 0x81,
		0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85, 0x28, 0xaa, 0x60, 0x56,
		0x58, 0x3a, 0x48, 0xf3,
	},
	.a = {
		0x78, 0x30, 0xa3, 0x31, 0x8b, 0x60, 0x3b, 0x89, 0xe2, 0x32,
		0x71, 0x45, 0xac, 0x23, 0x4c, 0xc5, 0x94, 0xcb, 0xdd, 0x8d,
		0x3d, 0xf9, 0x16, 0x10, 0xa8, 0x34, 0x41, 0xca, 0xea, 0x98,
		0x63, 0xbc, 0x2d, 0xed, 0x5d, 0x5a, 0xa8, 0x25, 0x3a, 0xa1,
		0x0a, 0x2e, 0xf1, 0xc9, 0x8b, 0x9a, 0xc8, 0xb5, 0x7f, 0x11,
		0x17, 0xa7, 0x2b, 0xf2, 0xc7, 0xb9, 0xe7, 0xc1, 0xac, 0x4d,
		0x77, 0xfc, 0x94, 0xca,
	},
	.b = {
		0x3d, 0xf9, 0x16, 0x10, 0xa8, 0x34, 0x41, 0xca, 0xea, 0x98,
		0x63, 0xbc, 0x2d, 0xed, 0x5d, 0x5a, 0xa8, 0x25, 0x3a, 0xa1,
		0x0a, 0x2e, 0xf1, 0xc9, 0x8b, 0x9a, 0xc8, 0xb5, 0x7f, 0x11,
		0x17, 0xa7, 0x2b, 0xf2, 0xc7, 0xb9, 0xe7, 0xc1, 0xac, 0x4d,
		0x77, 0xfc, 0x94, 0xca, 0xdc, 0x08, 0x3e, 0x67, 0x98, 0x40,
		0x50, 0xb7, 0x5e, 0xba, 0xe5, 0xdd, 0x28, 0x09, 0xbd, 0x63,
		0x80, 0x16, 0xf7, 0x23,
	},
	.x = {
		0x81, 0xae, 0xe4, 0xbd, 0xd8, 0x2e, 0xd9, 0x64, 0x5a, 0x21,
		0x32, 0x2e, 0x9c, 0x4c, 0x6a, 0x93, 0x85, 0xed, 0x9f, 0x70,
		0xb5, 0xd9, 0x16, 0xc1, 0xb4, 0x3b, 0x62, 0xee, 0xf4, 0xd0,
		0x09, 0x8e, 0xff, 0x3b, 0x1f, 0x78, 0xe2, 0xd0, 0xd4, 0x8d,
		0x50, 0xd1, 0x68, 0x7b, 0x93, 0xb9, 0x7d, 0x5f, 0x7c, 0x6d,
		0x50, 0x47, 0x40, 0x6a, 0x5e, 0x68, 0x8b, 0x35, 0x22, 0x09,
		0xbc, 0xb9, 0xf8, 0x22,
	},
	.y = {
		0x7d, 0xde, 0x38, 0x5d, 0x56, 0x63, 0x32, 0xec, 0xc0, 0xea,
		0xbf, 0xa9, 0xcf, 0x78, 0x22, 0xfd, 0xf2, 0x09, 0xf7, 0x00,
		0x24, 0xa5, 0x7b, 0x1a, 0xa0, 0x00, 0xc5, 0x5b, 0x88, 0x1f,
		0x81, 0x11, 0xb2, 0xdc, 0xde, 0x49, 0x4a, 0x5f, 0x48, 0x5e,
		0x5b, 0xca, 0x4b, 0xd8, 0x8a, 0x27, 0x63, 0xae, 0xd1, 0xca,
		0x2b, 0x2f, 0xa8, 0xf0, 0x54, 0x06, 0x78, 0xcd, 0x1e, 0x0f,
		0x3a, 0xd8, 0x08, 0x92,
	},
	.order = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x70, 0x55, 0x3e, 0x5c, 0x41, 0x4c, 0xa9, 0x26, 0x19,
		0x41, 0x86, 0x61, 0x19, 0x7f, 0xac, 0x10, 0x47, 0x1d, 0xb1,
		0xd3, 0x81, 0x08, 0x5d, 0xda, 0xdd, 0xb5, 0x87, 0x96, 0x82,
		0x9c, 0xa9, 0x00, 0x69,
	},
};

static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_brainpoolP512t1 = {
	.p = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x71, 0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
		0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6, 0x28, 0x81,
		0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85, 0x28, 0xaa, 0x60, 0x56,
		0x58, 0x3a, 0x48, 0xf3,
	},
	.a = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x71, 0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
		0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6, 0x28, 0x81,
		0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85, 0x28, 0xaa, 0x60, 0x56,
		0x58, 0x3a, 0x48, 0xf0,
	},
	.b = {
		0x7c, 0xbb, 0xbc, 0xf9, 0x44, 0x1c, 0xfa, 0xb7, 0x6e, 0x18,
		0x90, 0xe4, 0x68, 0x84, 0xea, 0xe3, 0x21, 0xf7, 0x0c, 0x0b,
		0xcb, 0x49, 0x81, 0x52, 0x78, 0x97, 0x50, 0x4b, 0xec, 0x3e,
		0x36, 0xa6, 0x2b, 0xcd, 0xfa, 0x23, 0x04, 0x97, 0x65, 0x40,
		0xf6, 0x45, 0x00, 0x85, 0xf2, 0xda, 0xe1, 0x45, 0xc2, 0x25,
		0x53, 0xb4, 0x65, 0x76, 0x36, 0x89, 0x18, 0x0e, 0xa2, 0x57,
		0x18, 0x67, 0x42, 0x3e,
	},
	.x = {
		0x64, 0x0e, 0xce, 0x5c, 0x12, 0x78, 0x87, 0x17, 0xb9, 0xc1,
		0xba, 0x06, 0xcb, 0xc2, 0xa6, 0xfe, 0xba, 0x85, 0x84, 0x24,
		0x58, 0xc5, 0x6d, 0xde, 0x9d, 0xb1, 0x75, 0x8d, 0x39, 0xc0,
		0x31, 0x3d, 0x82, 0xba, 0x51, 0x73, 0x5c, 0xdb, 0x3e, 0xa4,
		0x99, 0xaa, 0x77, 0xa7, 0xd6, 0x94, 0x3a, 0x64, 0xf7, 0xa3,
		0xf2, 0x5f, 0xe2, 0x6f, 0x06, 0xb5, 0x1b, 0xaa, 0x26, 0x96,
		0xfa, 0x90, 0x35, 0xda,
	},
	.y = {
		0x5b, 0x53, 0x4b, 0xd5, 0x95, 0xf5, 0xaf, 0x0f, 0xa2, 0xc8,
		0x92, 0x37, 0x6c, 0x84, 0xac, 0xe1, 0xbb, 0x4e, 0x30, 0x19,
		0xb7, 0x16, 0x34, 0xc0, 0x11, 0x31, 0x15, 0x9c, 0xae, 0x03,
		0xce, 0xe9, 0xd9, 0x93, 0x21, 0x84, 0xbe, 0xef, 0x21, 0x6b,
		0xd7, 0x1d, 0xf2, 0xda, 0xdf, 0x86, 0xa6, 0x27, 0x30, 0x6e,
		0xcf, 0xf9, 0x6d, 0xbb, 0x8b, 0xac, 0xe1, 0x98, 0xb6, 0x1e,
		0x00, 0xf8, 0xb3, 0x32,
	},
	.order = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x70, 0x55, 0x3e, 0x5c, 0x41, 0x4c, 0xa9, 0x26, 0x19,
		0x41, 0x86, 0x61, 0x19, 0x7f, 0xac, 0x10, 0x47, 0x1d, 0xb1,
		0xd3, 0x81, 0x08, 0x5d, 0xda, 0xdd, 0xb5, 0x87, 0x96, 0x82,
		0x9c, 0xa9, 0x00, 0x69,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_FRP256v1 = {
	.p = {
		0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f, 0x10, 0x12,
		0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b, 0x39, 0x61, 0xad, 0xbc,
		0xab, 0xc8, 0xca, 0x6d, 0xe8, 0xfc, 0xf3, 0x53, 0xd8, 0x6e,
		0x9c, 0x03,
	},
	.a = {
		0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f, 0x10, 0x12,
		0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b, 0x39, 0x61, 0xad, 0xbc,
		0xab, 0xc8, 0xca, 0x6d, 0xe8, 0xfc, 0xf3, 0x53, 0xd8, 0x6e,
		0x9c, 0x00,
	},
	.b = {
		0xee, 0x35, 0x3f, 0xca, 0x54, 0x28, 0xa9, 0x30, 0x0d, 0x4a,
		0xba, 0x75, 0x4a, 0x44, 0xc0, 0x0f, 0xdf, 0xec, 0x0c, 0x9a,
		0xe4, 0xb1, 0xa1, 0x80, 0x30, 0x75, 0xed, 0x96, 0x7b, 0x7b,
		0xb7, 0x3f,
	},
	.x = {
		0xb6, 0xb3, 0xd4, 0xc3, 0x56, 0xc1, 0x39, 0xeb, 0x31, 0x18,
		0x3d, 0x47, 0x49, 0xd4, 0x23, 0x95, 0x8c, 0x27, 0xd2, 0xdc,
		0xaf, 0x98, 0xb7, 0x01, 0x64, 0xc9, 0x7a, 0x2d, 0xd9, 0x8f,
		0x5c, 0xff,
	},
	.y = {
		0x61, 0x42, 0xe0, 0xf7, 0xc8, 0xb2, 0x04, 0x91, 0x1f, 0x92,
		0x71, 0xf0, 0xf3, 0xec, 0xef, 0x8c, 0x27, 0x01, 0xc3, 0x07,
		0xe8, 0xe4, 0xc9, 0xe1, 0x83, 0x11, 0x5a, 0x15, 0x54, 0x06,
		0x2c, 0xfb,
	},
	.order = {
		0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f, 0x10, 0x12,
		0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b, 0x53, 0xdc, 0x67, 0xe1,
		0x40, 0xd2, 0xbf, 0x94, 0x1f, 0xfd, 0xd4, 0x59, 0xc6, 0xd6,
		0x55, 0xe1,
	},
};

#ifndef OPENSSL_NO_GOST
static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_GOST_2001_Test = {
	.p = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x04, 0x31,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x07,
	},
	.b = {
		0x5f, 0xbf, 0xf4, 0x98, 0xaa, 0x93, 0x8c, 0xe7, 0x39, 0xb8,
		0xe0, 0x22, 0xfb, 0xaf, 0xef, 0x40, 0x56, 0x3f, 0x6e, 0x6a,
		0x34, 0x72, 0xfc, 0x2a, 0x51, 0x4c, 0x0c, 0xe9, 0xda, 0xe2,
		0x3b, 0x7e,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x02,
	},
	.y = {
		0x08, 0xe2, 0xa8, 0xa0, 0xe6, 0x51, 0x47, 0xd4, 0xbd, 0x63,
		0x16, 0x03, 0x0e, 0x16, 0xd1, 0x9c, 0x85, 0xc9, 0x7f, 0x0a,
		0x9c, 0xa2, 0x67, 0x12, 0x2b, 0x96, 0xab, 0xbc, 0xea, 0x7e,
		0x8f, 0xc8,
	},
	.order = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x50, 0xfe, 0x8a, 0x18,
		0x92, 0x97, 0x61, 0x54, 0xc5, 0x9c, 0xfc, 0x19, 0x3a, 0xcc,
		0xf5, 0xb3,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_GOST_2001_CryptoPro_A = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xfd, 0x97,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xfd, 0x94,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0xa6,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x01,
	},
	.y = {
		0x8d, 0x91, 0xe4, 0x71, 0xe0, 0x98, 0x9c, 0xda, 0x27, 0xdf,
		0x50, 0x5a, 0x45, 0x3f, 0x2b, 0x76, 0x35, 0x29, 0x4f, 0x2d,
		0xdf, 0x23, 0xe3, 0xb1, 0x22, 0xac, 0xc9, 0x9c, 0x9e, 0x9f,
		0x1e, 0x14,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6c, 0x61, 0x10, 0x70,
		0x99, 0x5a, 0xd1, 0x00, 0x45, 0x84, 0x1b, 0x09, 0xb7, 0x61,
		0xb8, 0x93,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_GOST_2001_CryptoPro_B = {
	.p = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x0c, 0x99,
	},
	.a = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x0c, 0x96,
	},
	.b = {
		0x3e, 0x1a, 0xf4, 0x19, 0xa2, 0x69, 0xa5, 0xf8, 0x66, 0xa7,
		0xd3, 0xc2, 0x5c, 0x3d, 0xf8, 0x0a, 0xe9, 0x79, 0x25, 0x93,
		0x73, 0xff, 0x2b, 0x18, 0x2f, 0x49, 0xd4, 0xce, 0x7e, 0x1b,
		0xbc, 0x8b,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x01,
	},
	.y = {
		0x3f, 0xa8, 0x12, 0x43, 0x59, 0xf9, 0x66, 0x80, 0xb8, 0x3d,
		0x1c, 0x3e, 0xb2, 0xc0, 0x70, 0xe5, 0xc5, 0x45, 0xc9, 0x85,
		0x8d, 0x03, 0xec, 0xfb, 0x74, 0x4b, 0xf8, 0xd7, 0x17, 0x71,
		0x7e, 0xfc,
	},
	.order = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5f, 0x70, 0x0c, 0xff,
		0xf1, 0xa6, 0x24, 0xe5, 0xe4, 0x97, 0x16, 0x1b, 0xcc, 0x8a,
		0x19, 0x8f,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_GOST_2001_CryptoPro_C = {
	.p = {
		0x9b, 0x9f, 0x60, 0x5f, 0x5a, 0x85, 0x81, 0x07, 0xab, 0x1e,
		0xc8, 0x5e, 0x6b, 0x41, 0xc8, 0xaa, 0xcf, 0x84, 0x6e, 0x86,
		0x78, 0x90, 0x51, 0xd3, 0x79, 0x98, 0xf7, 0xb9, 0x02, 0x2d,
		0x75, 0x9b,
	},
	.a = {
		0x9b, 0x9f, 0x60, 0x5f, 0x5a, 0x85, 0x81, 0x07, 0xab, 0x1e,
		0xc8, 0x5e, 0x6b, 0x41, 0xc8, 0xaa, 0xcf, 0x84, 0x6e, 0x86,
		0x78, 0x90, 0x51, 0xd3, 0x79, 0x98, 0xf7, 0xb9, 0x02, 0x2d,
		0x75, 0x98,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x80, 0x5a,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00,
	},
	.y = {
		0x41, 0xec, 0xe5, 0x57, 0x43, 0x71, 0x1a, 0x8c, 0x3c, 0xbf,
		0x37, 0x83, 0xcd, 0x08, 0xc0, 0xee, 0x4d, 0x4d, 0xc4, 0x40,
		0xd4, 0x64, 0x1a, 0x8f, 0x36, 0x6e, 0x55, 0x0d, 0xfd, 0xb3,
		0xbb, 0x67,
	},
	.order = {
		0x9b, 0x9f, 0x60, 0x5f, 0x5a, 0x85, 0x81, 0x07, 0xab, 0x1e,
		0xc8, 0x5e, 0x6b, 0x41, 0xc8, 0xaa, 0x58, 0x2c, 0xa3, 0x51,
		0x1e, 0xdd, 0xfb, 0x74, 0xf0, 0x2f, 0x3a, 0x65, 0x98, 0x98,
		0x0b, 0xb9,
	},
};

/*
 * This curve is defined in two birationally equal forms: canonical and Twisted
 * Edwards. We do calculations in canonical (Weierstrass) form.
 */
static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_GOST_2012_256_TC26_A = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xfd, 0x97,
	},
	.a = {
		0xc2, 0x17, 0x3f, 0x15, 0x13, 0x98, 0x16, 0x73, 0xaf, 0x48,
		0x92, 0xc2, 0x30, 0x35, 0xa2, 0x7c, 0xe2, 0x5e, 0x20, 0x13,
		0xbf, 0x95, 0xaa, 0x33, 0xb2, 0x2c, 0x65, 0x6f, 0x27, 0x7e,
		0x73, 0x35,
	},
	.b = {
		0x29, 0x5f, 0x9b, 0xae, 0x74, 0x28, 0xed, 0x9c, 0xcc, 0x20,
		0xe7, 0xc3, 0x59, 0xa9, 0xd4, 0x1a, 0x22, 0xfc, 0xcd, 0x91,
		0x08, 0xe1, 0x7b, 0xf7, 0xba, 0x93, 0x37, 0xa6, 0xf8, 0xae,
		0x95, 0x13,
	},
	.x = {
		0x91, 0xe3, 0x84, 0x43, 0xa5, 0xe8, 0x2c, 0x0d, 0x88, 0x09,
		0x23, 0x42, 0x57, 0x12, 0xb2, 0xbb, 0x65, 0x8b, 0x91, 0x96,
		0x93, 0x2e, 0x02, 0xc7, 0x8b, 0x25, 0x82, 0xfe, 0x74, 0x2d,
		0xaa, 0x28,
	},
	.y = {
		0x32, 0x87, 0x94, 0x23, 0xab, 0x1a, 0x03, 0x75, 0x89, 0x57,
		0x86, 0xc4, 0xbb, 0x46, 0xe9, 0x56, 0x5f, 0xde, 0x0b, 0x53,
		0x44, 0x76, 0x67, 0x40, 0xaf, 0x26, 0x8a, 0xdb, 0x32, 0x32,
		0x2e, 0x5c,
	},
	.order = {
		0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xd8, 0xcd, 0xdf,
		0xc8, 0x7b, 0x66, 0x35, 0xc1, 0x15, 0xaf, 0x55, 0x6c, 0x36,
		0x0c, 0x67,
	},
};

static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_GOST_2012_512_Test = {
	.p = {
		0x45, 0x31, 0xac, 0xd1, 0xfe, 0x00, 0x23, 0xc7, 0x55, 0x0d,
		0x26, 0x7b, 0x6b, 0x2f, 0xee, 0x80, 0x92, 0x2b, 0x14, 0xb2,
		0xff, 0xb9, 0x0f, 0x04, 0xd4, 0xeb, 0x7c, 0x09, 0xb5, 0xd2,
		0xd1, 0x5d, 0xf1, 0xd8, 0x52, 0x74, 0x1a, 0xf4, 0x70, 0x4a,
		0x04, 0x58, 0x04, 0x7e, 0x80, 0xe4, 0x54, 0x6d, 0x35, 0xb8,
		0x33, 0x6f, 0xac, 0x22, 0x4d, 0xd8, 0x16, 0x64, 0xbb, 0xf5,
		0x28, 0xbe, 0x63, 0x73,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x07,
	},
	.b = {
		0x1c, 0xff, 0x08, 0x06, 0xa3, 0x11, 0x16, 0xda, 0x29, 0xd8,
		0xcf, 0xa5, 0x4e, 0x57, 0xeb, 0x74, 0x8b, 0xc5, 0xf3, 0x77,
		0xe4, 0x94, 0x00, 0xfd, 0xd7, 0x88, 0xb6, 0x49, 0xec, 0xa1,
		0xac, 0x43, 0x61, 0x83, 0x40, 0x13, 0xb2, 0xad, 0x73, 0x22,
		0x48, 0x0a, 0x89, 0xca, 0x58, 0xe0, 0xcf, 0x74, 0xbc, 0x9e,
		0x54, 0x0c, 0x2a, 0xdd, 0x68, 0x97, 0xfa, 0xd0, 0xa3, 0x08,
		0x4f, 0x30, 0x2a, 0xdc,
	},
	.x = {
		0x24, 0xd1, 0x9c, 0xc6, 0x45, 0x72, 0xee, 0x30, 0xf3, 0x96,
		0xbf, 0x6e, 0xbb, 0xfd, 0x7a, 0x6c, 0x52, 0x13, 0xb3, 0xb3,
		0xd7, 0x05, 0x7c, 0xc8, 0x25, 0xf9, 0x10, 0x93, 0xa6, 0x8c,
		0xd7, 0x62, 0xfd, 0x60, 0x61, 0x12, 0x62, 0xcd, 0x83, 0x8d,
		0xc6, 0xb6, 0x0a, 0xa7, 0xee, 0xe8, 0x04, 0xe2, 0x8b, 0xc8,
		0x49, 0x97, 0x7f, 0xac, 0x33, 0xb4, 0xb5, 0x30, 0xf1, 0xb1,
		0x20, 0x24, 0x8a, 0x9a,
	},
	.y = {
		0x2b, 0xb3, 0x12, 0xa4, 0x3b, 0xd2, 0xce, 0x6e, 0x0d, 0x02,
		0x06, 0x13, 0xc8, 0x57, 0xac, 0xdd, 0xcf, 0xbf, 0x06, 0x1e,
		0x91, 0xe5, 0xf2, 0xc3, 0xf3, 0x24, 0x47, 0xc2, 0x59, 0xf3,
		0x9b, 0x2c, 0x83, 0xab, 0x15, 0x6d, 0x77, 0xf1, 0x49, 0x6b,
		0xf7, 0xeb, 0x33, 0x51, 0xe1, 0xee, 0x4e, 0x43, 0xdc, 0x1a,
		0x18, 0xb9, 0x1b, 0x24, 0x64, 0x0b, 0x6d, 0xbb, 0x92, 0xcb,
		0x1a, 0xdd, 0x37, 0x1e,
	},
	.order = {
		0x45, 0x31, 0xac, 0xd1, 0xfe, 0x00, 0x23, 0xc7, 0x55, 0x0d,
		0x26, 0x7b, 0x6b, 0x2f, 0xee, 0x80, 0x92, 0x2b, 0x14, 0xb2,
		0xff, 0xb9, 0x0f, 0x04, 0xd4, 0xeb, 0x7c, 0x09, 0xb5, 0xd2,
		0xd1, 0x5d, 0xa8, 0x2f, 0x2d, 0x7e, 0xcb, 0x1d, 0xba, 0xc7,
		0x19, 0x90, 0x5c, 0x5e, 0xec, 0xc4, 0x23, 0xf1, 0xd8, 0x6e,
		0x25, 0xed, 0xbe, 0x23, 0xc5, 0x95, 0xd6, 0x44, 0xaa, 0xf1,
		0x87, 0xe6, 0xe6, 0xdf,
	},
};

static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_GOST_2012_512_TC26_A = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xfd, 0xc7,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xfd, 0xc4,
	},
	.b = {
		0xe8, 0xc2, 0x50, 0x5d, 0xed, 0xfc, 0x86, 0xdd, 0xc1, 0xbd,
		0x0b, 0x2b, 0x66, 0x67, 0xf1, 0xda, 0x34, 0xb8, 0x25, 0x74,
		0x76, 0x1c, 0xb0, 0xe8, 0x79, 0xbd, 0x08, 0x1c, 0xfd, 0x0b,
		0x62, 0x65, 0xee, 0x3c, 0xb0, 0x90, 0xf3, 0x0d, 0x27, 0x61,
		0x4c, 0xb4, 0x57, 0x40, 0x10, 0xda, 0x90, 0xdd, 0x86, 0x2e,
		0xf9, 0xd4, 0xeb, 0xee, 0x47, 0x61, 0x50, 0x31, 0x90, 0x78,
		0x5a, 0x71, 0xc7, 0x60,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x03,
	},
	.y = {
		0x75, 0x03, 0xcf, 0xe8, 0x7a, 0x83, 0x6a, 0xe3, 0xa6, 0x1b,
		0x88, 0x16, 0xe2, 0x54, 0x50, 0xe6, 0xce, 0x5e, 0x1c, 0x93,
		0xac, 0xf1, 0xab, 0xc1, 0x77, 0x80, 0x64, 0xfd, 0xcb, 0xef,
		0xa9, 0x21, 0xdf, 0x16, 0x26, 0xbe, 0x4f, 0xd0, 0x36, 0xe9,
		0x3d, 0x75, 0xe6, 0xa5, 0x0e, 0x3a, 0x41, 0xe9, 0x80, 0x28,
		0xfe, 0x5f, 0xc2, 0x35, 0xf5, 0xb8, 0x89, 0xa5, 0x89, 0xcb,
		0x52, 0x15, 0xf2, 0xa4,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0x27, 0xe6, 0x95, 0x32, 0xf4, 0x8d, 0x89, 0x11,
		0x6f, 0xf2, 0x2b, 0x8d, 0x4e, 0x05, 0x60, 0x60, 0x9b, 0x4b,
		0x38, 0xab, 0xfa, 0xd2, 0xb8, 0x5d, 0xca, 0xcd, 0xb1, 0x41,
		0x1f, 0x10, 0xb2, 0x75,
	},
};

static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_GOST_2012_512_TC26_B = {
	.p = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x6f,
	},
	.a = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x6c,
	},
	.b = {
		0x68, 0x7d, 0x1b, 0x45, 0x9d, 0xc8, 0x41, 0x45, 0x7e, 0x3e,
		0x06, 0xcf, 0x6f, 0x5e, 0x25, 0x17, 0xb9, 0x7c, 0x7d, 0x61,
		0x4a, 0xf1, 0x38, 0xbc, 0xbf, 0x85, 0xdc, 0x80, 0x6c, 0x4b,
		0x28, 0x9f, 0x3e, 0x96, 0x5d, 0x2d, 0xb1, 0x41, 0x6d, 0x21,
		0x7f, 0x8b, 0x27, 0x6f, 0xad, 0x1a, 0xb6, 0x9c, 0x50, 0xf7,
		0x8b, 0xee, 0x1f, 0xa3, 0x10, 0x6e, 0xfb, 0x8c, 0xcb, 0xc7,
		0xc5, 0x14, 0x01, 0x16,
	},
	.x = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x02,
	},
	.y = {
		0x1a, 0x8f, 0x7e, 0xda, 0x38, 0x9b, 0x09, 0x4c, 0x2c, 0x07,
		0x1e, 0x36, 0x47, 0xa8, 0x94, 0x0f, 0x3c, 0x12, 0x3b, 0x69,
		0x75, 0x78, 0xc2, 0x13, 0xbe, 0x6d, 0xd9, 0xe6, 0xc8, 0xec,
		0x73, 0x35, 0xdc, 0xb2, 0x28, 0xfd, 0x1e, 0xdf, 0x4a, 0x39,
		0x15, 0x2c, 0xbc, 0xaa, 0xf8, 0xc0, 0x39, 0x88, 0x28, 0x04,
		0x10, 0x55, 0xf9, 0x4c, 0xee, 0xec, 0x7e, 0x21, 0x34, 0x07,
		0x80, 0xfe, 0x41, 0xbd,
	},
	.order = {
		0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x01, 0x49, 0xa1, 0xec, 0x14, 0x25, 0x65, 0xa5, 0x45,
		0xac, 0xfd, 0xb7, 0x7b, 0xd9, 0xd4, 0x0c, 0xfa, 0x8b, 0x99,
		0x67, 0x12, 0x10, 0x1b, 0xea, 0x0e, 0xc6, 0x34, 0x6c, 0x54,
		0x37, 0x4f, 0x25, 0xbd,
	},
};

/*
 * This curve is defined in two birationally equal forms: canonical and Twisted
 * Edwards. We do calculations in canonical (Weierstrass) form.
 */
static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_GOST_2012_512_TC26_C = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xfd, 0xc7,
	},
	.a = {
		0xdc, 0x92, 0x03, 0xe5, 0x14, 0xa7, 0x21, 0x87, 0x54, 0x85,
		0xa5, 0x29, 0xd2, 0xc7, 0x22, 0xfb, 0x18, 0x7b, 0xc8, 0x98,
		0x0e, 0xb8, 0x66, 0x64, 0x4d, 0xe4, 0x1c, 0x68, 0xe1, 0x43,
		0x06, 0x45, 0x46, 0xe8, 0x61, 0xc0, 0xe2, 0xc9, 0xed, 0xd9,
		0x2a, 0xde, 0x71, 0xf4, 0x6f, 0xcf, 0x50, 0xff, 0x2a, 0xd9,
		0x7f, 0x95, 0x1f, 0xda, 0x9f, 0x2a, 0x2e, 0xb6, 0x54, 0x6f,
		0x39, 0x68, 0x9b, 0xd3,
	},
	.b = {
		0xb4, 0xc4, 0xee, 0x28, 0xce, 0xbc, 0x6c, 0x2c, 0x8a, 0xc1,
		0x29, 0x52, 0xcf, 0x37, 0xf1, 0x6a, 0xc7, 0xef, 0xb6, 0xa9,
		0xf6, 0x9f, 0x4b, 0x57, 0xff, 0xda, 0x2e, 0x4f, 0x0d, 0xe5,
		0xad, 0xe0, 0x38, 0xcb, 0xc2, 0xff, 0xf7, 0x19, 0xd2, 0xc1,
		0x8d, 0xe0, 0x28, 0x4b, 0x8b, 0xfe, 0xf3, 0xb5, 0x2b, 0x8c,
		0xc7, 0xa5, 0xf5, 0xbf, 0x0a, 0x3c, 0x8d, 0x23, 0x19, 0xa5,
		0x31, 0x25, 0x57, 0xe1,
	},
	.x = {
		0xe2, 0xe3, 0x1e, 0xdf, 0xc2, 0x3d, 0xe7, 0xbd, 0xeb, 0xe2,
		0x41, 0xce, 0x59, 0x3e, 0xf5, 0xde, 0x22, 0x95, 0xb7, 0xa9,
		0xcb, 0xae, 0xf0, 0x21, 0xd3, 0x85, 0xf7, 0x07, 0x4c, 0xea,
		0x04, 0x3a, 0xa2, 0x72, 0x72, 0xa7, 0xae, 0x60, 0x2b, 0xf2,
		0xa7, 0xb9, 0x03, 0x3d, 0xb9, 0xed, 0x36, 0x10, 0xc6, 0xfb,
		0x85, 0x48, 0x7e, 0xae, 0x97, 0xaa, 0xc5, 0xbc, 0x79, 0x28,
		0xc1, 0x95, 0x01, 0x48,
	},
	.y = {
		0xf5, 0xce, 0x40, 0xd9, 0x5b, 0x5e, 0xb8, 0x99, 0xab, 0xbc,
		0xcf, 0xf5, 0x91, 0x1c, 0xb8, 0x57, 0x79, 0x39, 0x80, 0x4d,
		0x65, 0x27, 0x37, 0x8b, 0x8c, 0x10, 0x8c, 0x3d, 0x20, 0x90,
		0xff, 0x9b, 0xe1, 0x8e, 0x2d, 0x33, 0xe3, 0x02, 0x1e, 0xd2,
		0xef, 0x32, 0xd8, 0x58, 0x22, 0x42, 0x3b, 0x63, 0x04, 0xf7,
		0x26, 0xaa, 0x85, 0x4b, 0xae, 0x07, 0xd0, 0x39, 0x6e, 0x9a,
		0x9a, 0xdd, 0xc4, 0x0f,
	},
	.order = {
		0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xc9, 0x8c, 0xdb, 0xa4, 0x65, 0x06, 0xab, 0x00,
		0x4c, 0x33, 0xa9, 0xff, 0x51, 0x47, 0x50, 0x2c, 0xc8, 0xed,
		0xa9, 0xe7, 0xa7, 0x69, 0xa1, 0x26, 0x94, 0x62, 0x3c, 0xef,
		0x47, 0xf0, 0x23, 0xed,
	},
};
#endif

static const struct ec_list_element {
	const char *comment;
	int nid;
	int seed_len;
	int param_len;
	unsigned int cofactor;
	const uint8_t *seed;
	const uint8_t *p;
	const uint8_t *a;
	const uint8_t *b;
	const uint8_t *x;
	const uint8_t *y;
	const uint8_t *order;
} curve_list[] = {
	/* secg curves */
	{
		.comment = "SECG/WTLS curve over a 112 bit prime field",
		.nid = NID_secp112r1,
		.seed_len = sizeof(_EC_SECG_PRIME_112R1.seed),
		.param_len = sizeof(_EC_SECG_PRIME_112R1.p),
		.seed = _EC_SECG_PRIME_112R1.seed,
		.p = _EC_SECG_PRIME_112R1.p,
		.a = _EC_SECG_PRIME_112R1.a,
		.b = _EC_SECG_PRIME_112R1.b,
		.x = _EC_SECG_PRIME_112R1.x,
		.y = _EC_SECG_PRIME_112R1.y,
		.order = _EC_SECG_PRIME_112R1.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG curve over a 112 bit prime field",
		.nid = NID_secp112r2,
		.seed_len = sizeof(_EC_SECG_PRIME_112R2.seed),
		.param_len = sizeof(_EC_SECG_PRIME_112R2.p),
		.seed = _EC_SECG_PRIME_112R2.seed,
		.p = _EC_SECG_PRIME_112R2.p,
		.a = _EC_SECG_PRIME_112R2.a,
		.b = _EC_SECG_PRIME_112R2.b,
		.x = _EC_SECG_PRIME_112R2.x,
		.y = _EC_SECG_PRIME_112R2.y,
		.order = _EC_SECG_PRIME_112R2.order,
		.cofactor = 4,
	},
	{
		.comment = "SECG curve over a 128 bit prime field",
		.nid = NID_secp128r1,
		.seed_len = sizeof(_EC_SECG_PRIME_128R1.seed),
		.param_len = sizeof(_EC_SECG_PRIME_128R1.p),
		.seed = _EC_SECG_PRIME_128R1.seed,
		.p = _EC_SECG_PRIME_128R1.p,
		.a = _EC_SECG_PRIME_128R1.a,
		.b = _EC_SECG_PRIME_128R1.b,
		.x = _EC_SECG_PRIME_128R1.x,
		.y = _EC_SECG_PRIME_128R1.y,
		.order = _EC_SECG_PRIME_128R1.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG curve over a 128 bit prime field",
		.nid = NID_secp128r2,
		.seed_len = sizeof(_EC_SECG_PRIME_128R2.seed),
		.param_len = sizeof(_EC_SECG_PRIME_128R2.p),
		.seed = _EC_SECG_PRIME_128R2.seed,
		.p = _EC_SECG_PRIME_128R2.p,
		.a = _EC_SECG_PRIME_128R2.a,
		.b = _EC_SECG_PRIME_128R2.b,
		.x = _EC_SECG_PRIME_128R2.x,
		.y = _EC_SECG_PRIME_128R2.y,
		.order = _EC_SECG_PRIME_128R2.order,
		.cofactor = 4,
	},
	{
		.comment = "SECG curve over a 160 bit prime field",
		.nid = NID_secp160k1,
		.param_len = sizeof(_EC_SECG_PRIME_160K1.p),
		.p = _EC_SECG_PRIME_160K1.p,
		.a = _EC_SECG_PRIME_160K1.a,
		.b = _EC_SECG_PRIME_160K1.b,
		.x = _EC_SECG_PRIME_160K1.x,
		.y = _EC_SECG_PRIME_160K1.y,
		.order = _EC_SECG_PRIME_160K1.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG curve over a 160 bit prime field",
		.nid = NID_secp160r1,
		.seed_len = sizeof(_EC_SECG_PRIME_160R1.seed),
		.param_len = sizeof(_EC_SECG_PRIME_160R1.p),
		.seed = _EC_SECG_PRIME_160R1.seed,
		.p = _EC_SECG_PRIME_160R1.p,
		.a = _EC_SECG_PRIME_160R1.a,
		.b = _EC_SECG_PRIME_160R1.b,
		.x = _EC_SECG_PRIME_160R1.x,
		.y = _EC_SECG_PRIME_160R1.y,
		.order = _EC_SECG_PRIME_160R1.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG/WTLS curve over a 160 bit prime field",
		.nid = NID_secp160r2,
		.seed_len = sizeof(_EC_SECG_PRIME_160R2.seed),
		.param_len = sizeof(_EC_SECG_PRIME_160R2.p),
		.seed = _EC_SECG_PRIME_160R2.seed,
		.p = _EC_SECG_PRIME_160R2.p,
		.a = _EC_SECG_PRIME_160R2.a,
		.b = _EC_SECG_PRIME_160R2.b,
		.x = _EC_SECG_PRIME_160R2.x,
		.y = _EC_SECG_PRIME_160R2.y,
		.order = _EC_SECG_PRIME_160R2.order,
		.cofactor = 1,
	},
	/* SECG secp192r1 is the same as X9.62 prime192v1 and hence omitted */
	{
		.comment = "SECG curve over a 192 bit prime field",
		.nid = NID_secp192k1,
		.param_len = sizeof(_EC_SECG_PRIME_192K1.p),
		.p = _EC_SECG_PRIME_192K1.p,
		.a = _EC_SECG_PRIME_192K1.a,
		.b = _EC_SECG_PRIME_192K1.b,
		.x = _EC_SECG_PRIME_192K1.x,
		.y = _EC_SECG_PRIME_192K1.y,
		.order = _EC_SECG_PRIME_192K1.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG curve over a 224 bit prime field",
		.nid = NID_secp224k1,
		.param_len = sizeof(_EC_SECG_PRIME_224K1.p),
		.p = _EC_SECG_PRIME_224K1.p,
		.a = _EC_SECG_PRIME_224K1.a,
		.b = _EC_SECG_PRIME_224K1.b,
		.x = _EC_SECG_PRIME_224K1.x,
		.y = _EC_SECG_PRIME_224K1.y,
		.order = _EC_SECG_PRIME_224K1.order,
		.cofactor = 1,
	},
	{
		.comment = "NIST/SECG curve over a 224 bit prime field",
		.nid = NID_secp224r1,
		.seed_len = sizeof(_EC_NIST_PRIME_224.seed),
		.param_len = sizeof(_EC_NIST_PRIME_224.p),
		.seed = _EC_NIST_PRIME_224.seed,
		.p = _EC_NIST_PRIME_224.p,
		.a = _EC_NIST_PRIME_224.a,
		.b = _EC_NIST_PRIME_224.b,
		.x = _EC_NIST_PRIME_224.x,
		.y = _EC_NIST_PRIME_224.y,
		.order = _EC_NIST_PRIME_224.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG curve over a 256 bit prime field",
		.nid = NID_secp256k1,
		.param_len = sizeof(_EC_SECG_PRIME_256K1.p),
		.p = _EC_SECG_PRIME_256K1.p,
		.a = _EC_SECG_PRIME_256K1.a,
		.b = _EC_SECG_PRIME_256K1.b,
		.x = _EC_SECG_PRIME_256K1.x,
		.y = _EC_SECG_PRIME_256K1.y,
		.order = _EC_SECG_PRIME_256K1.order,
		.cofactor = 1,
	},
	/* SECG secp256r1 is the same as X9.62 prime256v1 and hence omitted */
	{
		.comment = "NIST/SECG curve over a 384 bit prime field",
		.nid = NID_secp384r1,
		.seed_len = sizeof(_EC_NIST_PRIME_384.seed),
		.param_len = sizeof(_EC_NIST_PRIME_384.p),
		.seed = _EC_NIST_PRIME_384.seed,
		.p = _EC_NIST_PRIME_384.p,
		.a = _EC_NIST_PRIME_384.a,
		.b = _EC_NIST_PRIME_384.b,
		.x = _EC_NIST_PRIME_384.x,
		.y = _EC_NIST_PRIME_384.y,
		.order = _EC_NIST_PRIME_384.order,
		.cofactor = 1,
	},
	{
		.comment = "NIST/SECG curve over a 521 bit prime field",
		.nid = NID_secp521r1,
		.seed_len = sizeof(_EC_NIST_PRIME_521.seed),
		.param_len = sizeof(_EC_NIST_PRIME_521.p),
		.seed = _EC_NIST_PRIME_521.seed,
		.p = _EC_NIST_PRIME_521.p,
		.a = _EC_NIST_PRIME_521.a,
		.b = _EC_NIST_PRIME_521.b,
		.x = _EC_NIST_PRIME_521.x,
		.y = _EC_NIST_PRIME_521.y,
		.order = _EC_NIST_PRIME_521.order,
		.cofactor = 1,
	},
	/* X9.62 curves */
	{
		.comment = "NIST/X9.62/SECG curve over a 192 bit prime field",
		.nid = NID_X9_62_prime192v1,
		.seed_len = sizeof(_EC_NIST_PRIME_192.seed),
		.param_len = sizeof(_EC_NIST_PRIME_192.p),
		.seed = _EC_NIST_PRIME_192.seed,
		.p = _EC_NIST_PRIME_192.p,
		.a = _EC_NIST_PRIME_192.a,
		.b = _EC_NIST_PRIME_192.b,
		.x = _EC_NIST_PRIME_192.x,
		.y = _EC_NIST_PRIME_192.y,
		.order = _EC_NIST_PRIME_192.order,
		.cofactor = 1,
	},
	{
		.comment = "X9.62 curve over a 192 bit prime field",
		.nid = NID_X9_62_prime192v2,
		.seed_len = sizeof(_EC_X9_62_PRIME_192V2.seed),
		.param_len = sizeof(_EC_X9_62_PRIME_192V2.p),
		.seed = _EC_X9_62_PRIME_192V2.seed,
		.p = _EC_X9_62_PRIME_192V2.p,
		.a = _EC_X9_62_PRIME_192V2.a,
		.b = _EC_X9_62_PRIME_192V2.b,
		.x = _EC_X9_62_PRIME_192V2.x,
		.y = _EC_X9_62_PRIME_192V2.y,
		.order = _EC_X9_62_PRIME_192V2.order,
		.cofactor = 1,
	},
	{
		.comment = "X9.62 curve over a 192 bit prime field",
		.nid = NID_X9_62_prime192v3,
		.seed_len = sizeof(_EC_X9_62_PRIME_192V3.seed),
		.param_len = sizeof(_EC_X9_62_PRIME_192V3.p),
		.seed = _EC_X9_62_PRIME_192V3.seed,
		.p = _EC_X9_62_PRIME_192V3.p,
		.a = _EC_X9_62_PRIME_192V3.a,
		.b = _EC_X9_62_PRIME_192V3.b,
		.x = _EC_X9_62_PRIME_192V3.x,
		.y = _EC_X9_62_PRIME_192V3.y,
		.order = _EC_X9_62_PRIME_192V3.order,
		.cofactor = 1,
	},
	{
		.comment = "X9.62 curve over a 239 bit prime field",
		.nid = NID_X9_62_prime239v1,
		.seed_len = sizeof(_EC_X9_62_PRIME_239V1.seed),
		.param_len = sizeof(_EC_X9_62_PRIME_239V1.p),
		.seed = _EC_X9_62_PRIME_239V1.seed,
		.p = _EC_X9_62_PRIME_239V1.p,
		.a = _EC_X9_62_PRIME_239V1.a,
		.b = _EC_X9_62_PRIME_239V1.b,
		.x = _EC_X9_62_PRIME_239V1.x,
		.y = _EC_X9_62_PRIME_239V1.y,
		.order = _EC_X9_62_PRIME_239V1.order,
		.cofactor = 1,
	},
	{
		.comment = "X9.62 curve over a 239 bit prime field",
		.nid = NID_X9_62_prime239v2,
		.seed_len = sizeof(_EC_X9_62_PRIME_239V2.seed),
		.param_len = sizeof(_EC_X9_62_PRIME_239V2.p),
		.seed = _EC_X9_62_PRIME_239V2.seed,
		.p = _EC_X9_62_PRIME_239V2.p,
		.a = _EC_X9_62_PRIME_239V2.a,
		.b = _EC_X9_62_PRIME_239V2.b,
		.x = _EC_X9_62_PRIME_239V2.x,
		.y = _EC_X9_62_PRIME_239V2.y,
		.order = _EC_X9_62_PRIME_239V2.order,
		.cofactor = 1,
	},
	{
		.comment = "X9.62 curve over a 239 bit prime field",
		.nid = NID_X9_62_prime239v3,
		.seed_len = sizeof(_EC_X9_62_PRIME_239V3.seed),
		.param_len = sizeof(_EC_X9_62_PRIME_239V3.p),
		.seed = _EC_X9_62_PRIME_239V3.seed,
		.p = _EC_X9_62_PRIME_239V3.p,
		.a = _EC_X9_62_PRIME_239V3.a,
		.b = _EC_X9_62_PRIME_239V3.b,
		.x = _EC_X9_62_PRIME_239V3.x,
		.y = _EC_X9_62_PRIME_239V3.y,
		.order = _EC_X9_62_PRIME_239V3.order,
		.cofactor = 1,
	},
	{
		.comment = "X9.62/SECG curve over a 256 bit prime field",
		.nid = NID_X9_62_prime256v1,
		.seed_len = sizeof(_EC_X9_62_PRIME_256V1.seed),
		.param_len = sizeof(_EC_X9_62_PRIME_256V1.p),
		.seed = _EC_X9_62_PRIME_256V1.seed,
		.p = _EC_X9_62_PRIME_256V1.p,
		.a = _EC_X9_62_PRIME_256V1.a,
		.b = _EC_X9_62_PRIME_256V1.b,
		.x = _EC_X9_62_PRIME_256V1.x,
		.y = _EC_X9_62_PRIME_256V1.y,
		.order = _EC_X9_62_PRIME_256V1.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG/WTLS curve over a 112 bit prime field",
		.nid = NID_wap_wsg_idm_ecid_wtls6,
		.seed_len = sizeof(_EC_SECG_PRIME_112R1.seed),
		.param_len = sizeof(_EC_SECG_PRIME_112R1.p),
		.seed = _EC_SECG_PRIME_112R1.seed,
		.p = _EC_SECG_PRIME_112R1.p,
		.a = _EC_SECG_PRIME_112R1.a,
		.b = _EC_SECG_PRIME_112R1.b,
		.x = _EC_SECG_PRIME_112R1.x,
		.y = _EC_SECG_PRIME_112R1.y,
		.order = _EC_SECG_PRIME_112R1.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG/WTLS curve over a 160 bit prime field",
		.nid = NID_wap_wsg_idm_ecid_wtls7,
		.seed_len = sizeof(_EC_SECG_PRIME_160R2.seed),
		.param_len = sizeof(_EC_SECG_PRIME_160R2.p),
		.seed = _EC_SECG_PRIME_160R2.seed,
		.p = _EC_SECG_PRIME_160R2.p,
		.a = _EC_SECG_PRIME_160R2.a,
		.b = _EC_SECG_PRIME_160R2.b,
		.x = _EC_SECG_PRIME_160R2.x,
		.y = _EC_SECG_PRIME_160R2.y,
		.order = _EC_SECG_PRIME_160R2.order,
		.cofactor = 1,
	},
	{
		.comment = "WTLS curve over a 112 bit prime field",
		.nid = NID_wap_wsg_idm_ecid_wtls8,
		.param_len = sizeof(_EC_WTLS_8.p),
		.p = _EC_WTLS_8.p,
		.a = _EC_WTLS_8.a,
		.b = _EC_WTLS_8.b,
		.x = _EC_WTLS_8.x,
		.y = _EC_WTLS_8.y,
		.order = _EC_WTLS_8.order,
		.cofactor = 1,
	},
	{
		.comment = "WTLS curve over a 160 bit prime field",
		.nid = NID_wap_wsg_idm_ecid_wtls9,
		.param_len = sizeof(_EC_WTLS_9.p),
		.p = _EC_WTLS_9.p,
		.a = _EC_WTLS_9.a,
		.b = _EC_WTLS_9.b,
		.x = _EC_WTLS_9.x,
		.y = _EC_WTLS_9.y,
		.order = _EC_WTLS_9.order,
		.cofactor = 1,
	},
	{
		.comment = "WTLS curve over a 224 bit prime field",
		.nid = NID_wap_wsg_idm_ecid_wtls12,
		.param_len = sizeof(_EC_WTLS_12.p),
		.p = _EC_WTLS_12.p,
		.a = _EC_WTLS_12.a,
		.b = _EC_WTLS_12.b,
		.x = _EC_WTLS_12.x,
		.y = _EC_WTLS_12.y,
		.order = _EC_WTLS_12.order,
		.cofactor = 1,
	},
	/* RFC 5639 curves */
	{
		.comment = "RFC 5639 curve over a 160 bit prime field",
		.nid = NID_brainpoolP160r1,
		.param_len = sizeof(_EC_brainpoolP160r1.p),
		.p = _EC_brainpoolP160r1.p,
		.a = _EC_brainpoolP160r1.a,
		.b = _EC_brainpoolP160r1.b,
		.x = _EC_brainpoolP160r1.x,
		.y = _EC_brainpoolP160r1.y,
		.order = _EC_brainpoolP160r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 160 bit prime field",
		.nid = NID_brainpoolP160t1,
		.param_len = sizeof(_EC_brainpoolP160t1.p),
		.p = _EC_brainpoolP160t1.p,
		.a = _EC_brainpoolP160t1.a,
		.b = _EC_brainpoolP160t1.b,
		.x = _EC_brainpoolP160t1.x,
		.y = _EC_brainpoolP160t1.y,
		.order = _EC_brainpoolP160t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 192 bit prime field",
		.nid = NID_brainpoolP192r1,
		.param_len = sizeof(_EC_brainpoolP192r1.p),
		.p = _EC_brainpoolP192r1.p,
		.a = _EC_brainpoolP192r1.a,
		.b = _EC_brainpoolP192r1.b,
		.x = _EC_brainpoolP192r1.x,
		.y = _EC_brainpoolP192r1.y,
		.order = _EC_brainpoolP192r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 192 bit prime field",
		.nid = NID_brainpoolP192t1,
		.param_len = sizeof(_EC_brainpoolP192t1.p),
		.p = _EC_brainpoolP192t1.p,
		.a = _EC_brainpoolP192t1.a,
		.b = _EC_brainpoolP192t1.b,
		.x = _EC_brainpoolP192t1.x,
		.y = _EC_brainpoolP192t1.y,
		.order = _EC_brainpoolP192t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 224 bit prime field",
		.nid = NID_brainpoolP224r1,
		.param_len = sizeof(_EC_brainpoolP224r1.p),
		.p = _EC_brainpoolP224r1.p,
		.a = _EC_brainpoolP224r1.a,
		.b = _EC_brainpoolP224r1.b,
		.x = _EC_brainpoolP224r1.x,
		.y = _EC_brainpoolP224r1.y,
		.order = _EC_brainpoolP224r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 224 bit prime field",
		.nid = NID_brainpoolP224t1,
		.param_len = sizeof(_EC_brainpoolP224t1.p),
		.p = _EC_brainpoolP224t1.p,
		.a = _EC_brainpoolP224t1.a,
		.b = _EC_brainpoolP224t1.b,
		.x = _EC_brainpoolP224t1.x,
		.y = _EC_brainpoolP224t1.y,
		.order = _EC_brainpoolP224t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 256 bit prime field",
		.nid = NID_brainpoolP256r1,
		.param_len = sizeof(_EC_brainpoolP256r1.p),
		.p = _EC_brainpoolP256r1.p,
		.a = _EC_brainpoolP256r1.a,
		.b = _EC_brainpoolP256r1.b,
		.x = _EC_brainpoolP256r1.x,
		.y = _EC_brainpoolP256r1.y,
		.order = _EC_brainpoolP256r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 256 bit prime field",
		.nid = NID_brainpoolP256t1,
		.param_len = sizeof(_EC_brainpoolP256t1.p),
		.p = _EC_brainpoolP256t1.p,
		.a = _EC_brainpoolP256t1.a,
		.b = _EC_brainpoolP256t1.b,
		.x = _EC_brainpoolP256t1.x,
		.y = _EC_brainpoolP256t1.y,
		.order = _EC_brainpoolP256t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 320 bit prime field",
		.nid = NID_brainpoolP320r1,
		.param_len = sizeof(_EC_brainpoolP320r1.p),
		.p = _EC_brainpoolP320r1.p,
		.a = _EC_brainpoolP320r1.a,
		.b = _EC_brainpoolP320r1.b,
		.x = _EC_brainpoolP320r1.x,
		.y = _EC_brainpoolP320r1.y,
		.order = _EC_brainpoolP320r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 320 bit prime field",
		.nid = NID_brainpoolP320t1,
		.param_len = sizeof(_EC_brainpoolP320t1.p),
		.p = _EC_brainpoolP320t1.p,
		.a = _EC_brainpoolP320t1.a,
		.b = _EC_brainpoolP320t1.b,
		.x = _EC_brainpoolP320t1.x,
		.y = _EC_brainpoolP320t1.y,
		.order = _EC_brainpoolP320t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 384 bit prime field",
		.nid = NID_brainpoolP384r1,
		.param_len = sizeof(_EC_brainpoolP384r1.p),
		.p = _EC_brainpoolP384r1.p,
		.a = _EC_brainpoolP384r1.a,
		.b = _EC_brainpoolP384r1.b,
		.x = _EC_brainpoolP384r1.x,
		.y = _EC_brainpoolP384r1.y,
		.order = _EC_brainpoolP384r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 384 bit prime field",
		.nid = NID_brainpoolP384t1,
		.param_len = sizeof(_EC_brainpoolP384t1.p),
		.p = _EC_brainpoolP384t1.p,
		.a = _EC_brainpoolP384t1.a,
		.b = _EC_brainpoolP384t1.b,
		.x = _EC_brainpoolP384t1.x,
		.y = _EC_brainpoolP384t1.y,
		.order = _EC_brainpoolP384t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 512 bit prime field",
		.nid = NID_brainpoolP512r1,
		.param_len = sizeof(_EC_brainpoolP512r1.p),
		.p = _EC_brainpoolP512r1.p,
		.a = _EC_brainpoolP512r1.a,
		.b = _EC_brainpoolP512r1.b,
		.x = _EC_brainpoolP512r1.x,
		.y = _EC_brainpoolP512r1.y,
		.order = _EC_brainpoolP512r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve over a 512 bit prime field",
		.nid = NID_brainpoolP512t1,
		.param_len = sizeof(_EC_brainpoolP512t1.p),
		.p = _EC_brainpoolP512t1.p,
		.a = _EC_brainpoolP512t1.a,
		.b = _EC_brainpoolP512t1.b,
		.x = _EC_brainpoolP512t1.x,
		.y = _EC_brainpoolP512t1.y,
		.order = _EC_brainpoolP512t1.order,
		.cofactor = 1,
	},
	/* ANSSI */
	{
		.comment = "FRP256v1",
		.nid = NID_FRP256v1,
		.param_len = sizeof(_EC_FRP256v1.p),
		.p = _EC_FRP256v1.p,
		.a = _EC_FRP256v1.a,
		.b = _EC_FRP256v1.b,
		.x = _EC_FRP256v1.x,
		.y = _EC_FRP256v1.y,
		.order = _EC_FRP256v1.order,
		.cofactor = 1,
	},
#ifndef OPENSSL_NO_GOST
	/* GOST R 34.10-2001 */
	{
		.comment = "GOST R 34.10-2001 Test Curve",
		.nid = NID_id_GostR3410_2001_TestParamSet,
		.param_len = sizeof(_EC_GOST_2001_Test.p),
		.p = _EC_GOST_2001_Test.p,
		.a = _EC_GOST_2001_Test.a,
		.b = _EC_GOST_2001_Test.b,
		.x = _EC_GOST_2001_Test.x,
		.y = _EC_GOST_2001_Test.y,
		.order = _EC_GOST_2001_Test.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2001 CryptoPro-A",
		.nid = NID_id_GostR3410_2001_CryptoPro_A_ParamSet,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_A.p),
		.p = _EC_GOST_2001_CryptoPro_A.p,
		.a = _EC_GOST_2001_CryptoPro_A.a,
		.b = _EC_GOST_2001_CryptoPro_A.b,
		.x = _EC_GOST_2001_CryptoPro_A.x,
		.y = _EC_GOST_2001_CryptoPro_A.y,
		.order = _EC_GOST_2001_CryptoPro_A.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2001 CryptoPro-B",
		.nid = NID_id_GostR3410_2001_CryptoPro_B_ParamSet,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_B.p),
		.p = _EC_GOST_2001_CryptoPro_B.p,
		.a = _EC_GOST_2001_CryptoPro_B.a,
		.b = _EC_GOST_2001_CryptoPro_B.b,
		.x = _EC_GOST_2001_CryptoPro_B.x,
		.y = _EC_GOST_2001_CryptoPro_B.y,
		.order = _EC_GOST_2001_CryptoPro_B.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2001 CryptoPro-C",
		.nid = NID_id_GostR3410_2001_CryptoPro_C_ParamSet,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_C.p),
		.p = _EC_GOST_2001_CryptoPro_C.p,
		.a = _EC_GOST_2001_CryptoPro_C.a,
		.b = _EC_GOST_2001_CryptoPro_C.b,
		.x = _EC_GOST_2001_CryptoPro_C.x,
		.y = _EC_GOST_2001_CryptoPro_C.y,
		.order = _EC_GOST_2001_CryptoPro_C.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2001 CryptoPro-XchA",
		.nid = NID_id_GostR3410_2001_CryptoPro_XchA_ParamSet,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_A.p),
		.p = _EC_GOST_2001_CryptoPro_A.p,
		.a = _EC_GOST_2001_CryptoPro_A.a,
		.b = _EC_GOST_2001_CryptoPro_A.b,
		.x = _EC_GOST_2001_CryptoPro_A.x,
		.y = _EC_GOST_2001_CryptoPro_A.y,
		.order = _EC_GOST_2001_CryptoPro_A.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2001 CryptoPro-XchB",
		.nid = NID_id_GostR3410_2001_CryptoPro_XchB_ParamSet,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_C.p),
		.p = _EC_GOST_2001_CryptoPro_C.p,
		.a = _EC_GOST_2001_CryptoPro_C.a,
		.b = _EC_GOST_2001_CryptoPro_C.b,
		.x = _EC_GOST_2001_CryptoPro_C.x,
		.y = _EC_GOST_2001_CryptoPro_C.y,
		.order = _EC_GOST_2001_CryptoPro_C.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2012 256 TC26-A",
		.nid = NID_id_tc26_gost_3410_12_256_paramSetA,
		.param_len = sizeof(_EC_GOST_2012_256_TC26_A.p),
		.p = _EC_GOST_2012_256_TC26_A.p,
		.a = _EC_GOST_2012_256_TC26_A.a,
		.b = _EC_GOST_2012_256_TC26_A.b,
		.x = _EC_GOST_2012_256_TC26_A.x,
		.y = _EC_GOST_2012_256_TC26_A.y,
		.order = _EC_GOST_2012_256_TC26_A.order,
		.cofactor = 4,
	},
	{
		.comment = "GOST R 34.10-2012 256 TC26-B",
		.nid = NID_id_tc26_gost_3410_12_256_paramSetB,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_A.p),
		.p = _EC_GOST_2001_CryptoPro_A.p,
		.a = _EC_GOST_2001_CryptoPro_A.a,
		.b = _EC_GOST_2001_CryptoPro_A.b,
		.x = _EC_GOST_2001_CryptoPro_A.x,
		.y = _EC_GOST_2001_CryptoPro_A.y,
		.order = _EC_GOST_2001_CryptoPro_A.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2012 256 TC26-C",
		.nid = NID_id_tc26_gost_3410_12_256_paramSetC,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_B.p),
		.p = _EC_GOST_2001_CryptoPro_B.p,
		.a = _EC_GOST_2001_CryptoPro_B.a,
		.b = _EC_GOST_2001_CryptoPro_B.b,
		.x = _EC_GOST_2001_CryptoPro_B.x,
		.y = _EC_GOST_2001_CryptoPro_B.y,
		.order = _EC_GOST_2001_CryptoPro_B.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2012 256 TC26-D",
		.nid = NID_id_tc26_gost_3410_12_256_paramSetD,
		.param_len = sizeof(_EC_GOST_2001_CryptoPro_C.p),
		.p = _EC_GOST_2001_CryptoPro_C.p,
		.a = _EC_GOST_2001_CryptoPro_C.a,
		.b = _EC_GOST_2001_CryptoPro_C.b,
		.x = _EC_GOST_2001_CryptoPro_C.x,
		.y = _EC_GOST_2001_CryptoPro_C.y,
		.order = _EC_GOST_2001_CryptoPro_C.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2012 512 Test Curve",
		.nid = NID_id_tc26_gost_3410_12_512_paramSetTest,
		.param_len = sizeof(_EC_GOST_2012_512_Test.p),
		.p = _EC_GOST_2012_512_Test.p,
		.a = _EC_GOST_2012_512_Test.a,
		.b = _EC_GOST_2012_512_Test.b,
		.x = _EC_GOST_2012_512_Test.x,
		.y = _EC_GOST_2012_512_Test.y,
		.order = _EC_GOST_2012_512_Test.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2012 512 TC26-A",
		.nid = NID_id_tc26_gost_3410_12_512_paramSetA,
		.param_len = sizeof(_EC_GOST_2012_512_TC26_A.p),
		.p = _EC_GOST_2012_512_TC26_A.p,
		.a = _EC_GOST_2012_512_TC26_A.a,
		.b = _EC_GOST_2012_512_TC26_A.b,
		.x = _EC_GOST_2012_512_TC26_A.x,
		.y = _EC_GOST_2012_512_TC26_A.y,
		.order = _EC_GOST_2012_512_TC26_A.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2012 512 TC26-B",
		.nid = NID_id_tc26_gost_3410_12_512_paramSetB,
		.param_len = sizeof(_EC_GOST_2012_512_TC26_B.p),
		.p = _EC_GOST_2012_512_TC26_B.p,
		.a = _EC_GOST_2012_512_TC26_B.a,
		.b = _EC_GOST_2012_512_TC26_B.b,
		.x = _EC_GOST_2012_512_TC26_B.x,
		.y = _EC_GOST_2012_512_TC26_B.y,
		.order = _EC_GOST_2012_512_TC26_B.order,
		.cofactor = 1,
	},
	{
		.comment = "GOST R 34.10-2012 512 TC26-C",
		.nid = NID_id_tc26_gost_3410_12_512_paramSetC,
		.param_len = sizeof(_EC_GOST_2012_512_TC26_C.p),
		.p = _EC_GOST_2012_512_TC26_C.p,
		.a = _EC_GOST_2012_512_TC26_C.a,
		.b = _EC_GOST_2012_512_TC26_C.b,
		.x = _EC_GOST_2012_512_TC26_C.x,
		.y = _EC_GOST_2012_512_TC26_C.y,
		.order = _EC_GOST_2012_512_TC26_C.order,
		.cofactor = 4,
	},
#endif
};

#define CURVE_LIST_LENGTH (sizeof(curve_list) / sizeof(curve_list[0]))

static EC_GROUP *
ec_group_new_from_data(const struct ec_list_element *curve)
{
	EC_GROUP *group = NULL, *ret = NULL;
	EC_POINT *generator = NULL;
	BN_CTX *ctx = NULL;
	BIGNUM *p, *a, *b, *x, *y, *order, *cofactor;

	if ((ctx = BN_CTX_new()) == NULL) {
		ECerror(ERR_R_MALLOC_FAILURE);
		goto err;
	}
	BN_CTX_start(ctx);

	if ((p = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((a = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((b = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((x = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((y = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((order = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((cofactor = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}

	if (BN_bin2bn(curve->p, curve->param_len, p) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->a, curve->param_len, a) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->b, curve->param_len, b) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((group = EC_GROUP_new_curve_GFp(p, a, b, ctx)) == NULL) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	EC_GROUP_set_curve_name(group, curve->nid);

	if ((generator = EC_POINT_new(group)) == NULL) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->x, curve->param_len, x) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->y, curve->param_len, y) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (!EC_POINT_set_affine_coordinates(group, generator, x, y, ctx)) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->order, curve->param_len, order) == NULL) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	if (!BN_set_word(cofactor, curve->cofactor)) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (!EC_GROUP_set_generator(group, generator, order, cofactor)) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}

	if (curve->seed != NULL) {
		if (!EC_GROUP_set_seed(group, curve->seed, curve->seed_len)) {
			ECerror(ERR_R_EC_LIB);
			goto err;
		}
	}

	ret = group;
	group = NULL;

 err:
	EC_GROUP_free(group);
	EC_POINT_free(generator);
	BN_CTX_end(ctx);
	BN_CTX_free(ctx);

	return ret;
}

EC_GROUP *
EC_GROUP_new_by_curve_name(int nid)
{
	size_t i;

	if (nid <= 0)
		return NULL;

	for (i = 0; i < CURVE_LIST_LENGTH; i++) {
		if (curve_list[i].nid == nid)
			return ec_group_new_from_data(&curve_list[i]);
	}

	ECerror(EC_R_UNKNOWN_GROUP);
	return NULL;
}

size_t
EC_get_builtin_curves(EC_builtin_curve *r, size_t nitems)
{
	size_t i, min;

	if (r == NULL || nitems == 0)
		return CURVE_LIST_LENGTH;

	min = nitems < CURVE_LIST_LENGTH ? nitems : CURVE_LIST_LENGTH;

	for (i = 0; i < min; i++) {
		r[i].nid = curve_list[i].nid;
		r[i].comment = curve_list[i].comment;
	}

	return CURVE_LIST_LENGTH;
}

static const struct {
	const char *name;
	int nid;
} nist_curves[] = {
	{ "B-163", NID_sect163r2 },
	{ "B-233", NID_sect233r1 },
	{ "B-283", NID_sect283r1 },
	{ "B-409", NID_sect409r1 },
	{ "B-571", NID_sect571r1 },
	{ "K-163", NID_sect163k1 },
	{ "K-233", NID_sect233k1 },
	{ "K-283", NID_sect283k1 },
	{ "K-409", NID_sect409k1 },
	{ "K-571", NID_sect571k1 },
	{ "P-192", NID_X9_62_prime192v1 },
	{ "P-224", NID_secp224r1 },
	{ "P-256", NID_X9_62_prime256v1 },
	{ "P-384", NID_secp384r1 },
	{ "P-521", NID_secp521r1 }
};

const char *
EC_curve_nid2nist(int nid)
{
	size_t i;

	for (i = 0; i < sizeof(nist_curves) / sizeof(nist_curves[0]); i++) {
		if (nist_curves[i].nid == nid)
			return nist_curves[i].name;
	}

	return NULL;
}

int
EC_curve_nist2nid(const char *name)
{
	size_t i;

	for (i = 0; i < sizeof(nist_curves) / sizeof(nist_curves[0]); i++) {
		if (strcmp(nist_curves[i].name, name) == 0)
			return nist_curves[i].nid;
	}

	return NID_undef;
}
