untrusted comment: signature from openbsd 5.8 base secret key
RWQNNZXtC/MqPx4eagMCvwUyXexY09svciUK0zNpr+MCYm2MEgkeI43mIxquBtLMiTuxKiCTdADul+5ZClyLQHfivK+YPQVA6g0=

OpenBSD 5.8 errata 22, Jul 14, 2016:

Invalid file descriptor use with kevent(2) could lead to a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-58-base.pub -x 022_kevent.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/kern_event.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_event.c,v
retrieving revision 1.61.6.1
diff -u -p -r1.61.6.1 kern_event.c
--- sys/kern/kern_event.c	14 Oct 2015 18:10:27 -0000	1.61.6.1
+++ sys/kern/kern_event.c	14 Jul 2016 02:40:13 -0000
@@ -573,6 +573,8 @@ kqueue_register(struct kqueue *kq, struc
 
 	if (fops->f_isfd) {
 		/* validate descriptor */
+		if (kev->ident > INT_MAX)
+			return (EBADF);
 		if ((fp = fd_getfile(fdp, kev->ident)) == NULL)
 			return (EBADF);
 		FREF(fp);
