untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ49mnoTnUSoWs+JmfWHKitfNSmv+uEexV+JSQJ/WXjy4S7rchLQvjSdyeFk2AL7OMPfpHdbCC7n9p3AVH/o5yQE=

OpenBSD 6.0 errata 039, August 3, 2017:

An out of bounds read could occur during processing of EAPOL frames in
the wireless stack. Information from kernel memory could be leaked to
root in userland via an ieee80211(9) ioctl.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 039_ieee80211.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/net80211/ieee80211_ioctl.c
===================================================================
RCS file: /cvs/src/sys/net80211/ieee80211_ioctl.c,v
--- sys/net80211/ieee80211_ioctl.c	23 Mar 2017 04:10:10 -0000	1.52
+++ sys/net80211/ieee80211_ioctl.c	1 Aug 2017 23:07:01 -0000	1.52.4.1
@@ -60,6 +60,10 @@ ieee80211_node2req(struct ieee80211com *
 ieee80211_node2req(struct ieee80211com *ic, const struct ieee80211_node *ni,
     struct ieee80211_nodereq *nr)
 {
+	memset(nr, 0, sizeof(*nr));
+
+	strlcpy(nr->nr_ifname, ic->ic_if.if_xname, sizeof(nr->nr_ifname));
+
 	/* Node address and name information */
 	IEEE80211_ADDR_COPY(nr->nr_macaddr, ni->ni_macaddr);
	IEEE80211_ADDR_COPY(nr->nr_bssid, ni->ni_bssid);
Index: sys/net80211/ieee80211_pae_input.c
===================================================================
RCS file: /cvs/src/sys/net80211/ieee80211_pae_input.c,v
--- sys/net80211/ieee80211_pae_input.c	1 Mar 2017 20:57:51 -0000	1.25.6.1
+++ sys/net80211/ieee80211_pae_input.c	2 Aug 2017 16:42:31 -0000
@@ -78,7 +78,7 @@ ieee80211_eapol_key_input(struct ieee802
 	struct ether_header *eh;
 	struct ieee80211_eapol_key *key;
 	u_int16_t info, desc;
-	int totlen;
+	int totlen, bodylen, paylen;
 
 	ifp->if_ibytes += m->m_pkthdr.len;
 
@@ -109,12 +109,14 @@ ieee80211_eapol_key_input(struct ieee802
 		goto done;
 
 	/* check packet body length */
-	if (m->m_pkthdr.len < 4 + BE_READ_2(key->len))
+	bodylen = BE_READ_2(key->len);
+	totlen = 4 + bodylen;
+	if (m->m_pkthdr.len < totlen || totlen > MCLBYTES)
 		goto done;
 
 	/* check key data length */
-	totlen = sizeof(*key) + BE_READ_2(key->paylen);
-	if (m->m_pkthdr.len < totlen || totlen > MCLBYTES)
+	paylen = BE_READ_2(key->paylen);
+	if (paylen > totlen - sizeof(*key))
 		goto done;
 
 	info = BE_READ_2(key->info);
