untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76Zdykk05F9XAvQDDifhs31AOryYnOroPnh/IGhcH3Q7spTl9myqJZfFu7MpeUacjBxGjUZMOXn8Fajpn1ZI5/6AM=

OpenBSD 6.3 errata 016, August 4, 2018:

Incorrect initialization of the FPU caused floating point exceptions
when running on Xen.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 016_fpuinit.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/cpu.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/cpu.c,v
retrieving revision 1.113.2.1
diff -u -p -r1.113.2.1 cpu.c
--- sys/arch/amd64/amd64/cpu.c	16 Jun 2018 20:37:22 -0000	1.113.2.1
+++ sys/arch/amd64/amd64/cpu.c	2 Aug 2018 23:15:03 -0000
@@ -571,6 +571,9 @@ cpu_init(struct cpu_info *ci)
 	/* Give proc0 a clean FPU save area */
 	sfp = &proc0.p_addr->u_pcb.pcb_savefpu;
 	memset(sfp, 0, fpu_save_len);
+	sfp->fp_fxsave.fx_fcw = __INITIAL_NPXCW__;
+	sfp->fp_fxsave.fx_mxcsr = __INITIAL_MXCSR__;
+	fpureset();
 	if (xsave_mask) {
 		/* must not use xsaveopt here */
 		xsave(sfp, xsave_mask);
