untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24BxL/rULMtlwYo/S2mti/yXFLUOwz7gSIB5N31gYI4ogepusDg+y2HWH/Eb2PUzCz6HeJMmvqhBEblveFXobSAU=

OpenBSD 6.6 errata 002, October 28, 2019:

Various third party applications may crash due to symbol collision.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 002_ber.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libutil:
    cd /usr/src/lib/libutil
    make obj
    make includes
    make
    make install
    makewhatis
then rebuild and install ldap, ldapctl, ldapd, snmp, snmpd, and ypldap:
    for d in usr.bin/{ldap,snmp} usr.sbin/{ldapctl,ldapd,snmpd,ypldap}; do
        cd /usr/src/$d
        make obj
        make
        make install
    done

Index: lib/libutil/Symbols.map
===================================================================
RCS file: /cvs/src/lib/libutil/Symbols.map,v
retrieving revision 1.2
diff -u -p -r1.2 Symbols.map
--- lib/libutil/Symbols.map	11 May 2019 17:46:02 -0000	1.2
+++ lib/libutil/Symbols.map	24 Oct 2019 13:58:18 -0000
@@ -9,51 +9,6 @@
 {
 	global:
 		bcrypt_pbkdf;
-		ber_add_bitstring;
-		ber_add_boolean;
-		ber_add_enumerated;
-		ber_add_eoc;
-		ber_add_integer;
-		ber_add_noid;
-		ber_add_nstring;
-		ber_add_null;
-		ber_add_oid;
-		ber_add_oidstring;
-		ber_add_ostring;
-		ber_add_sequence;
-		ber_add_set;
-		ber_add_string;
-		ber_calc_len;
-		ber_free;
-		ber_free_element;
-		ber_free_elements;
-		ber_get_bitstring;
-		ber_get_boolean;
-		ber_get_element;
-		ber_get_enumerated;
-		ber_get_eoc;
-		ber_get_integer;
-		ber_get_nstring;
-		ber_get_null;
-		ber_get_oid;
-		ber_get_ostring;
-		ber_get_string;
-		ber_get_writebuf;
-		ber_getpos;
-		ber_link_elements;
-		ber_oid2ber;
-		ber_oid_cmp;
-		ber_printf_elements;
-		ber_read_elements;
-		ber_replace_elements;
-		ber_scanf_elements;
-		ber_set_application;
-		ber_set_header;
-		ber_set_readbuf;
-		ber_set_writecallback;
-		ber_string2oid;
-		ber_unlink_elements;
-		ber_write_elements;
 		fdforkpty;
 		fdopenpty;
 		fmt_scaled;
@@ -95,6 +50,51 @@
 		msgbuf_drain;
 		msgbuf_init;
 		msgbuf_write;
+		ober_add_bitstring;
+		ober_add_boolean;
+		ober_add_enumerated;
+		ober_add_eoc;
+		ober_add_integer;
+		ober_add_noid;
+		ober_add_nstring;
+		ober_add_null;
+		ober_add_oid;
+		ober_add_oidstring;
+		ober_add_ostring;
+		ober_add_sequence;
+		ober_add_set;
+		ober_add_string;
+		ober_calc_len;
+		ober_free;
+		ober_free_element;
+		ober_free_elements;
+		ober_get_bitstring;
+		ober_get_boolean;
+		ober_get_element;
+		ober_get_enumerated;
+		ober_get_eoc;
+		ober_get_integer;
+		ober_get_nstring;
+		ober_get_null;
+		ober_get_oid;
+		ober_get_ostring;
+		ober_get_string;
+		ober_get_writebuf;
+		ober_getpos;
+		ober_link_elements;
+		ober_oid2ber;
+		ober_oid_cmp;
+		ober_printf_elements;
+		ober_read_elements;
+		ober_replace_elements;
+		ober_scanf_elements;
+		ober_set_application;
+		ober_set_header;
+		ober_set_readbuf;
+		ober_set_writecallback;
+		ober_string2oid;
+		ober_unlink_elements;
+		ober_write_elements;
 		ohash_create_entry;
 		ohash_delete;
 		ohash_entries;
Index: lib/libutil/ber.c
===================================================================
RCS file: /cvs/src/lib/libutil/ber.c,v
retrieving revision 1.14
diff -u -p -r1.14 ber.c
--- lib/libutil/ber.c	15 Aug 2019 06:11:18 -0000	1.14
+++ lib/libutil/ber.c	24 Oct 2019 13:58:18 -0000
@@ -38,16 +38,16 @@
 #define BER_TAG_TYPE_MASK	0x7f
 #define BER_CLASS_SHIFT		6
 
-static int	ber_dump_element(struct ber *ber, struct ber_element *root);
-static void	ber_dump_header(struct ber *ber, struct ber_element *root);
-static void	ber_putc(struct ber *ber, u_char c);
-static void	ber_write(struct ber *ber, void *buf, size_t len);
+static int	ober_dump_element(struct ber *ber, struct ber_element *root);
+static void	ober_dump_header(struct ber *ber, struct ber_element *root);
+static void	ober_putc(struct ber *ber, u_char c);
+static void	ober_write(struct ber *ber, void *buf, size_t len);
 static ssize_t	get_id(struct ber *b, unsigned int *tag, int *class,
     int *cstruct);
 static ssize_t	get_len(struct ber *b, ssize_t *len);
-static ssize_t	ber_read_element(struct ber *ber, struct ber_element *elm);
-static ssize_t	ber_getc(struct ber *b, u_char *c);
-static ssize_t	ber_read(struct ber *ber, void *buf, size_t len);
+static ssize_t	ober_read_element(struct ber *ber, struct ber_element *elm);
+static ssize_t	ober_getc(struct ber *b, u_char *c);
+static ssize_t	ober_read(struct ber *ber, void *buf, size_t len);
 
 #ifdef DEBUG
 #define DPRINTF(...)	printf(__VA_ARGS__)
@@ -56,7 +56,7 @@ static ssize_t	ber_read(struct ber *ber,
 #endif
 
 struct ber_element *
-ber_get_element(unsigned int encoding)
+ober_get_element(unsigned int encoding)
 {
 	struct ber_element *elm;
 
@@ -64,13 +64,13 @@ ber_get_element(unsigned int encoding)
 		return NULL;
 
 	elm->be_encoding = encoding;
-	ber_set_header(elm, BER_CLASS_UNIVERSAL, BER_TYPE_DEFAULT);
+	ober_set_header(elm, BER_CLASS_UNIVERSAL, BER_TYPE_DEFAULT);
 
 	return elm;
 }
 
 void
-ber_set_header(struct ber_element *elm, int class, unsigned int type)
+ober_set_header(struct ber_element *elm, int class, unsigned int type)
 {
 	elm->be_class = class & BER_CLASS_MASK;
 	if (type == BER_TYPE_DEFAULT)
@@ -79,7 +79,7 @@ ber_set_header(struct ber_element *elm, 
 }
 
 void
-ber_link_elements(struct ber_element *prev, struct ber_element *elm)
+ober_link_elements(struct ber_element *prev, struct ber_element *elm)
 {
 	if (prev != NULL) {
 		if ((prev->be_encoding == BER_TYPE_SEQUENCE ||
@@ -92,7 +92,7 @@ ber_link_elements(struct ber_element *pr
 }
 
 struct ber_element *
-ber_unlink_elements(struct ber_element *prev)
+ober_unlink_elements(struct ber_element *prev)
 {
 	struct ber_element *elm;
 
@@ -110,53 +110,53 @@ ber_unlink_elements(struct ber_element *
 }
 
 void
-ber_replace_elements(struct ber_element *prev, struct ber_element *new)
+ober_replace_elements(struct ber_element *prev, struct ber_element *new)
 {
 	struct ber_element *ber, *next;
 
-	ber = ber_unlink_elements(prev);
-	next = ber_unlink_elements(ber);
-	ber_link_elements(new, next);
-	ber_link_elements(prev, new);
+	ber = ober_unlink_elements(prev);
+	next = ober_unlink_elements(ber);
+	ober_link_elements(new, next);
+	ober_link_elements(prev, new);
 
 	/* cleanup old element */
-	ber_free_elements(ber);
+	ober_free_elements(ber);
 }
 
 struct ber_element *
-ber_add_sequence(struct ber_element *prev)
+ober_add_sequence(struct ber_element *prev)
 {
 	struct ber_element *elm;
 
-	if ((elm = ber_get_element(BER_TYPE_SEQUENCE)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_SEQUENCE)) == NULL)
 		return NULL;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 struct ber_element *
-ber_add_set(struct ber_element *prev)
+ober_add_set(struct ber_element *prev)
 {
 	struct ber_element *elm;
 
-	if ((elm = ber_get_element(BER_TYPE_SET)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_SET)) == NULL)
 		return NULL;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 struct ber_element *
-ber_add_enumerated(struct ber_element *prev, long long val)
+ober_add_enumerated(struct ber_element *prev, long long val)
 {
 	struct ber_element *elm;
 	u_int i, len = 0;
 	u_char cur, last = 0;
 
-	if ((elm = ber_get_element(BER_TYPE_ENUMERATED)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_ENUMERATED)) == NULL)
 		return NULL;
 
 	elm->be_numeric = val;
@@ -173,19 +173,19 @@ ber_add_enumerated(struct ber_element *p
 	}
 	elm->be_len = len + 1;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 struct ber_element *
-ber_add_integer(struct ber_element *prev, long long val)
+ober_add_integer(struct ber_element *prev, long long val)
 {
 	struct ber_element *elm;
 	u_int i, len = 0;
 	u_char cur, last = 0;
 
-	if ((elm = ber_get_element(BER_TYPE_INTEGER)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_INTEGER)) == NULL)
 		return NULL;
 
 	elm->be_numeric = val;
@@ -202,13 +202,13 @@ ber_add_integer(struct ber_element *prev
 	}
 	elm->be_len = len + 1;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 int
-ber_get_integer(struct ber_element *elm, long long *n)
+ober_get_integer(struct ber_element *elm, long long *n)
 {
 	if (elm->be_encoding != BER_TYPE_INTEGER)
 		return -1;
@@ -218,7 +218,7 @@ ber_get_integer(struct ber_element *elm,
 }
 
 int
-ber_get_enumerated(struct ber_element *elm, long long *n)
+ober_get_enumerated(struct ber_element *elm, long long *n)
 {
 	if (elm->be_encoding != BER_TYPE_ENUMERATED)
 		return -1;
@@ -228,23 +228,23 @@ ber_get_enumerated(struct ber_element *e
 }
 
 struct ber_element *
-ber_add_boolean(struct ber_element *prev, int bool)
+ober_add_boolean(struct ber_element *prev, int bool)
 {
 	struct ber_element *elm;
 
-	if ((elm = ber_get_element(BER_TYPE_BOOLEAN)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_BOOLEAN)) == NULL)
 		return NULL;
 
 	elm->be_numeric = bool ? 0xff : 0;
 	elm->be_len = 1;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 int
-ber_get_boolean(struct ber_element *elm, int *b)
+ober_get_boolean(struct ber_element *elm, int *b)
 {
 	if (elm->be_encoding != BER_TYPE_BOOLEAN)
 		return -1;
@@ -254,20 +254,20 @@ ber_get_boolean(struct ber_element *elm,
 }
 
 struct ber_element *
-ber_add_string(struct ber_element *prev, const char *string)
+ober_add_string(struct ber_element *prev, const char *string)
 {
-	return ber_add_nstring(prev, string, strlen(string));
+	return ober_add_nstring(prev, string, strlen(string));
 }
 
 struct ber_element *
-ber_add_nstring(struct ber_element *prev, const char *string0, size_t len)
+ober_add_nstring(struct ber_element *prev, const char *string0, size_t len)
 {
 	struct ber_element *elm;
 	char *string;
 
 	if ((string = calloc(1, len + 1)) == NULL)
 		return NULL;
-	if ((elm = ber_get_element(BER_TYPE_OCTETSTRING)) == NULL) {
+	if ((elm = ober_get_element(BER_TYPE_OCTETSTRING)) == NULL) {
 		free(string);
 		return NULL;
 	}
@@ -277,19 +277,19 @@ ber_add_nstring(struct ber_element *prev
 	elm->be_len = len;
 	elm->be_free = 1;		/* free string on cleanup */
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 struct ber_element *
-ber_add_ostring(struct ber_element *prev, struct ber_octetstring *s)
+ober_add_ostring(struct ber_element *prev, struct ber_octetstring *s)
 {
-	return ber_add_nstring(prev, s->ostr_val, s->ostr_len);
+	return ober_add_nstring(prev, s->ostr_val, s->ostr_len);
 }
 
 int
-ber_get_string(struct ber_element *elm, char **s)
+ober_get_string(struct ber_element *elm, char **s)
 {
 	if (elm->be_encoding != BER_TYPE_OCTETSTRING)
 		return -1;
@@ -304,7 +304,7 @@ ber_get_string(struct ber_element *elm, 
 }
 
 int
-ber_get_nstring(struct ber_element *elm, void **p, size_t *len)
+ober_get_nstring(struct ber_element *elm, void **p, size_t *len)
 {
 	if (elm->be_encoding != BER_TYPE_OCTETSTRING)
 		return -1;
@@ -315,7 +315,7 @@ ber_get_nstring(struct ber_element *elm,
 }
 
 int
-ber_get_ostring(struct ber_element *elm, struct ber_octetstring *s)
+ober_get_ostring(struct ber_element *elm, struct ber_octetstring *s)
 {
 	if (elm->be_encoding != BER_TYPE_OCTETSTRING)
 		return -1;
@@ -326,14 +326,14 @@ ber_get_ostring(struct ber_element *elm,
 }
 
 struct ber_element *
-ber_add_bitstring(struct ber_element *prev, const void *v0, size_t len)
+ober_add_bitstring(struct ber_element *prev, const void *v0, size_t len)
 {
 	struct ber_element *elm;
 	void *v;
 
 	if ((v = calloc(1, len)) == NULL)
 		return NULL;
-	if ((elm = ber_get_element(BER_TYPE_BITSTRING)) == NULL) {
+	if ((elm = ober_get_element(BER_TYPE_BITSTRING)) == NULL) {
 		free(v);
 		return NULL;
 	}
@@ -343,13 +343,13 @@ ber_add_bitstring(struct ber_element *pr
 	elm->be_len = len;
 	elm->be_free = 1;		/* free string on cleanup */
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 int
-ber_get_bitstring(struct ber_element *elm, void **v, size_t *len)
+ober_get_bitstring(struct ber_element *elm, void **v, size_t *len)
 {
 	if (elm->be_encoding != BER_TYPE_BITSTRING)
 		return -1;
@@ -360,20 +360,20 @@ ber_get_bitstring(struct ber_element *el
 }
 
 struct ber_element *
-ber_add_null(struct ber_element *prev)
+ober_add_null(struct ber_element *prev)
 {
 	struct ber_element *elm;
 
-	if ((elm = ber_get_element(BER_TYPE_NULL)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_NULL)) == NULL)
 		return NULL;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 int
-ber_get_null(struct ber_element *elm)
+ober_get_null(struct ber_element *elm)
 {
 	if (elm->be_encoding != BER_TYPE_NULL)
 		return -1;
@@ -382,20 +382,20 @@ ber_get_null(struct ber_element *elm)
 }
 
 struct ber_element *
-ber_add_eoc(struct ber_element *prev)
+ober_add_eoc(struct ber_element *prev)
 {
 	struct ber_element *elm;
 
-	if ((elm = ber_get_element(BER_TYPE_EOC)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_EOC)) == NULL)
 		return NULL;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return elm;
 }
 
 int
-ber_get_eoc(struct ber_element *elm)
+ober_get_eoc(struct ber_element *elm)
 {
 	if (elm->be_encoding != BER_TYPE_EOC)
 		return -1;
@@ -404,7 +404,7 @@ ber_get_eoc(struct ber_element *elm)
 }
 
 size_t
-ber_oid2ber(struct ber_oid *o, u_int8_t *buf, size_t len)
+ober_oid2ber(struct ber_oid *o, u_int8_t *buf, size_t len)
 {
 	u_int32_t	 v;
 	u_int		 i, j = 0, k;
@@ -431,7 +431,7 @@ ber_oid2ber(struct ber_oid *o, u_int8_t 
 }
 
 int
-ber_string2oid(const char *oidstr, struct ber_oid *o)
+ober_string2oid(const char *oidstr, struct ber_oid *o)
 {
 	char			*sp, *p, str[BUFSIZ];
 	const char		*errstr;
@@ -453,7 +453,7 @@ ber_string2oid(const char *oidstr, struc
 }
 
 int
-ber_oid_cmp(struct ber_oid *a, struct ber_oid *b)
+ober_oid_cmp(struct ber_oid *a, struct ber_oid *b)
 {
 	size_t	 i;
 	for (i = 0; i < a->bo_n && i < b->bo_n; i++) {
@@ -479,16 +479,16 @@ ber_oid_cmp(struct ber_oid *a, struct be
 }
 
 struct ber_element *
-ber_add_oid(struct ber_element *prev, struct ber_oid *o)
+ober_add_oid(struct ber_element *prev, struct ber_oid *o)
 {
 	struct ber_element	*elm;
 	u_int8_t		*buf;
 	size_t			 len;
 
-	if ((elm = ber_get_element(BER_TYPE_OBJECT)) == NULL)
+	if ((elm = ober_get_element(BER_TYPE_OBJECT)) == NULL)
 		return (NULL);
 
-	if ((len = ber_oid2ber(o, NULL, 0)) == 0)
+	if ((len = ober_oid2ber(o, NULL, 0)) == 0)
 		goto fail;
 
 	if ((buf = calloc(1, len)) == NULL)
@@ -498,20 +498,20 @@ ber_add_oid(struct ber_element *prev, st
 	elm->be_len = len;
 	elm->be_free = 1;
 
-	if (ber_oid2ber(o, buf, len) != len)
+	if (ober_oid2ber(o, buf, len) != len)
 		goto fail;
 
-	ber_link_elements(prev, elm);
+	ober_link_elements(prev, elm);
 
 	return (elm);
 
  fail:
-	ber_free_elements(elm);
+	ober_free_elements(elm);
 	return (NULL);
 }
 
 struct ber_element *
-ber_add_noid(struct ber_element *prev, struct ber_oid *o, int n)
+ober_add_noid(struct ber_element *prev, struct ber_oid *o, int n)
 {
 	struct ber_oid		 no;
 
@@ -520,22 +520,22 @@ ber_add_noid(struct ber_element *prev, s
 	no.bo_n = n;
 	bcopy(&o->bo_id, &no.bo_id, sizeof(no.bo_id));
 
-	return (ber_add_oid(prev, &no));
+	return (ober_add_oid(prev, &no));
 }
 
 struct ber_element *
-ber_add_oidstring(struct ber_element *prev, const char *oidstr)
+ober_add_oidstring(struct ber_element *prev, const char *oidstr)
 {
 	struct ber_oid		 o;
 
-	if (ber_string2oid(oidstr, &o) == -1)
+	if (ober_string2oid(oidstr, &o) == -1)
 		return (NULL);
 
-	return (ber_add_oid(prev, &o));
+	return (ober_add_oid(prev, &o));
 }
 
 int
-ber_get_oid(struct ber_element *elm, struct ber_oid *o)
+ober_get_oid(struct ber_element *elm, struct ber_oid *o)
 {
 	u_int8_t	*buf;
 	size_t		 len, i = 0, j = 0;
@@ -561,7 +561,7 @@ ber_get_oid(struct ber_element *elm, str
 }
 
 struct ber_element *
-ber_printf_elements(struct ber_element *ber, char *fmt, ...)
+ober_printf_elements(struct ber_element *ber, char *fmt, ...)
 {
 	va_list			 ap;
 	int			 d, class;
@@ -579,69 +579,69 @@ ber_printf_elements(struct ber_element *
 		case 'B':
 			p = va_arg(ap, void *);
 			len = va_arg(ap, size_t);
-			if ((ber = ber_add_bitstring(ber, p, len)) == NULL)
+			if ((ber = ober_add_bitstring(ber, p, len)) == NULL)
 				goto fail;
 			break;
 		case 'b':
 			d = va_arg(ap, int);
-			if ((ber = ber_add_boolean(ber, d)) == NULL)
+			if ((ber = ober_add_boolean(ber, d)) == NULL)
 				goto fail;
 			break;
 		case 'd':
 			d = va_arg(ap, int);
-			if ((ber = ber_add_integer(ber, d)) == NULL)
+			if ((ber = ober_add_integer(ber, d)) == NULL)
 				goto fail;
 			break;
 		case 'e':
 			e = va_arg(ap, struct ber_element *);
-			ber_link_elements(ber, e);
+			ober_link_elements(ber, e);
 			break;
 		case 'E':
 			i = va_arg(ap, long long);
-			if ((ber = ber_add_enumerated(ber, i)) == NULL)
+			if ((ber = ober_add_enumerated(ber, i)) == NULL)
 				goto fail;
 			break;
 		case 'i':
 			i = va_arg(ap, long long);
-			if ((ber = ber_add_integer(ber, i)) == NULL)
+			if ((ber = ober_add_integer(ber, i)) == NULL)
 				goto fail;
 			break;
 		case 'O':
 			o = va_arg(ap, struct ber_oid *);
-			if ((ber = ber_add_oid(ber, o)) == NULL)
+			if ((ber = ober_add_oid(ber, o)) == NULL)
 				goto fail;
 			break;
 		case 'o':
 			s = va_arg(ap, char *);
-			if ((ber = ber_add_oidstring(ber, s)) == NULL)
+			if ((ber = ober_add_oidstring(ber, s)) == NULL)
 				goto fail;
 			break;
 		case 's':
 			s = va_arg(ap, char *);
-			if ((ber = ber_add_string(ber, s)) == NULL)
+			if ((ber = ober_add_string(ber, s)) == NULL)
 				goto fail;
 			break;
 		case 't':
 			class = va_arg(ap, int);
 			type = va_arg(ap, unsigned int);
-			ber_set_header(ber, class, type);
+			ober_set_header(ber, class, type);
 			break;
 		case 'x':
 			s = va_arg(ap, char *);
 			len = va_arg(ap, size_t);
-			if ((ber = ber_add_nstring(ber, s, len)) == NULL)
+			if ((ber = ober_add_nstring(ber, s, len)) == NULL)
 				goto fail;
 			break;
 		case '0':
-			if ((ber = ber_add_null(ber)) == NULL)
+			if ((ber = ober_add_null(ber)) == NULL)
 				goto fail;
 			break;
 		case '{':
-			if ((ber = sub = ber_add_sequence(ber)) == NULL)
+			if ((ber = sub = ober_add_sequence(ber)) == NULL)
 				goto fail;
 			break;
 		case '(':
-			if ((ber = sub = ber_add_set(ber)) == NULL)
+			if ((ber = sub = ober_add_set(ber)) == NULL)
 				goto fail;
 			break;
 		case '}':
@@ -649,7 +649,7 @@ ber_printf_elements(struct ber_element *
 			ber = sub;
 			break;
 		case '.':
-			if ((e = ber_add_eoc(ber)) == NULL)
+			if ((e = ober_add_eoc(ber)) == NULL)
 				goto fail;
 			ber = e;
 			break;
@@ -661,12 +661,12 @@ ber_printf_elements(struct ber_element *
 
 	return (ber);
  fail:
-	ber_free_elements(ber);
+	ober_free_elements(ber);
 	return (NULL);
 }
 
 int
-ber_scanf_elements(struct ber_element *ber, char *fmt, ...)
+ober_scanf_elements(struct ber_element *ber, char *fmt, ...)
 {
 #define _MAX_SEQ		 128
 	va_list			 ap;
@@ -690,19 +690,19 @@ ber_scanf_elements(struct ber_element *b
 		case 'B':
 			ptr = va_arg(ap, void **);
 			len = va_arg(ap, size_t *);
-			if (ber_get_bitstring(ber, ptr, len) == -1)
+			if (ober_get_bitstring(ber, ptr, len) == -1)
 				goto fail;
 			ret++;
 			break;
 		case 'b':
 			d = va_arg(ap, int *);
-			if (ber_get_boolean(ber, d) == -1)
+			if (ober_get_boolean(ber, d) == -1)
 				goto fail;
 			ret++;
 			break;
 		case 'd':
 			d = va_arg(ap, int *);
-			if (ber_get_integer(ber, &l) == -1)
+			if (ober_get_integer(ber, &l) == -1)
 				goto fail;
 			*d = l;
 			ret++;
@@ -714,19 +714,19 @@ ber_scanf_elements(struct ber_element *b
 			continue;
 		case 'E':
 			i = va_arg(ap, long long *);
-			if (ber_get_enumerated(ber, i) == -1)
+			if (ober_get_enumerated(ber, i) == -1)
 				goto fail;
 			ret++;
 			break;
 		case 'i':
 			i = va_arg(ap, long long *);
-			if (ber_get_integer(ber, i) == -1)
+			if (ober_get_integer(ber, i) == -1)
 				goto fail;
 			ret++;
 			break;
 		case 'o':
 			o = va_arg(ap, struct ber_oid *);
-			if (ber_get_oid(ber, o) == -1)
+			if (ober_get_oid(ber, o) == -1)
 				goto fail;
 			ret++;
 			break;
@@ -735,7 +735,7 @@ ber_scanf_elements(struct ber_element *b
 			break;
 		case 's':
 			s = va_arg(ap, char **);
-			if (ber_get_string(ber, s) == -1)
+			if (ober_get_string(ber, s) == -1)
 				goto fail;
 			ret++;
 			break;
@@ -749,7 +749,7 @@ ber_scanf_elements(struct ber_element *b
 		case 'x':
 			ptr = va_arg(ap, void **);
 			len = va_arg(ap, size_t *);
-			if (ber_get_nstring(ber, ptr, len) == -1)
+			if (ober_get_nstring(ber, ptr, len) == -1)
 				goto fail;
 			ret++;
 			break;
@@ -765,7 +765,7 @@ ber_scanf_elements(struct ber_element *b
 			break;
 		case 'p':
 			pos = va_arg(ap, off_t *);
-			*pos = ber_getpos(ber);
+			*pos = ober_getpos(ber);
 			ret++;
 			continue;
 		case '{':
@@ -802,7 +802,7 @@ ber_scanf_elements(struct ber_element *b
 }
 
 ssize_t
-ber_get_writebuf(struct ber *b, void **buf)
+ober_get_writebuf(struct ber *b, void **buf)
 {
 	if (b->br_wbuf == NULL)
 		return -1;
@@ -822,12 +822,12 @@ ber_get_writebuf(struct ber *b, void **b
  *	-1	on failure and sets errno
  */
 ssize_t
-ber_write_elements(struct ber *ber, struct ber_element *root)
+ober_write_elements(struct ber *ber, struct ber_element *root)
 {
 	size_t len;
 
 	/* calculate length because only the definite form is required */
-	len = ber_calc_len(root);
+	len = ober_calc_len(root);
 	DPRINTF("write ber element of %zd bytes length\n", len);
 
 	if (ber->br_wbuf != NULL && ber->br_wbuf + len > ber->br_wend) {
@@ -843,14 +843,14 @@ ber_write_elements(struct ber *ber, stru
 	/* reset write pointer */
 	ber->br_wptr = ber->br_wbuf;
 
-	if (ber_dump_element(ber, root) == -1)
+	if (ober_dump_element(ber, root) == -1)
 		return -1;
 
 	return (len);
 }
 
 void
-ber_set_readbuf(struct ber *b, void *buf, size_t len)
+ober_set_readbuf(struct ber *b, void *buf, size_t len)
 {
 	b->br_rbuf = b->br_rptr = buf;
 	b->br_rend = (u_int8_t *)buf + len;
@@ -870,21 +870,21 @@ ber_set_readbuf(struct ber *b, void *buf
  *	NULL, type mismatch or read error
  */
 struct ber_element *
-ber_read_elements(struct ber *ber, struct ber_element *elm)
+ober_read_elements(struct ber *ber, struct ber_element *elm)
 {
 	struct ber_element *root = elm;
 
 	if (root == NULL) {
-		if ((root = ber_get_element(0)) == NULL)
+		if ((root = ober_get_element(0)) == NULL)
 			return NULL;
 	}
 
 	DPRINTF("read ber elements, root %p\n", root);
 
-	if (ber_read_element(ber, root) == -1) {
+	if (ober_read_element(ber, root) == -1) {
 		/* Cleanup if root was allocated by us */
 		if (elm == NULL)
-			ber_free_elements(root);
+			ober_free_elements(root);
 		return NULL;
 	}
 
@@ -892,17 +892,17 @@ ber_read_elements(struct ber *ber, struc
 }
 
 off_t
-ber_getpos(struct ber_element *elm)
+ober_getpos(struct ber_element *elm)
 {
 	return elm->be_offs;
 }
 
 void
-ber_free_element(struct ber_element *root)
+ober_free_element(struct ber_element *root)
 {
 	if (root->be_sub && (root->be_encoding == BER_TYPE_SEQUENCE ||
 	    root->be_encoding == BER_TYPE_SET))
-		ber_free_elements(root->be_sub);
+		ober_free_elements(root->be_sub);
 	if (root->be_free && (root->be_encoding == BER_TYPE_OCTETSTRING ||
 	    root->be_encoding == BER_TYPE_BITSTRING ||
 	    root->be_encoding == BER_TYPE_OBJECT))
@@ -911,15 +911,15 @@ ber_free_element(struct ber_element *roo
 }
 
 void
-ber_free_elements(struct ber_element *root)
+ober_free_elements(struct ber_element *root)
 {
 	if (root == NULL)
 		return;
 	if (root->be_sub && (root->be_encoding == BER_TYPE_SEQUENCE ||
 	    root->be_encoding == BER_TYPE_SET))
-		ber_free_elements(root->be_sub);
+		ober_free_elements(root->be_sub);
 	if (root->be_next)
-		ber_free_elements(root->be_next);
+		ober_free_elements(root->be_next);
 	if (root->be_free && (root->be_encoding == BER_TYPE_OCTETSTRING ||
 	    root->be_encoding == BER_TYPE_BITSTRING ||
 	    root->be_encoding == BER_TYPE_OBJECT))
@@ -928,7 +928,7 @@ ber_free_elements(struct ber_element *ro
 }
 
 size_t
-ber_calc_len(struct ber_element *root)
+ober_calc_len(struct ber_element *root)
 {
 	unsigned int t;
 	size_t s;
@@ -937,7 +937,7 @@ ber_calc_len(struct ber_element *root)
 	/* calculate the real length of a sequence or set */
 	if (root->be_sub && (root->be_encoding == BER_TYPE_SEQUENCE ||
 	    root->be_encoding == BER_TYPE_SET))
-		root->be_len = ber_calc_len(root->be_sub);
+		root->be_len = ober_calc_len(root->be_sub);
 
 	/* fix header length for extended types */
 	if (root->be_type > BER_TYPE_SINGLE_MAX)
@@ -949,7 +949,7 @@ ber_calc_len(struct ber_element *root)
 
 	/* calculate the length of the following elements */
 	if (root->be_next)
-		size += ber_calc_len(root->be_next);
+		size += ober_calc_len(root->be_next);
 
 	/* This is an empty element, do not use a minimal size */
 	if (root->be_class == BER_CLASS_UNIVERSAL &&
@@ -960,13 +960,13 @@ ber_calc_len(struct ber_element *root)
 }
 
 void
-ber_set_application(struct ber *b, unsigned int (*cb)(struct ber_element *))
+ober_set_application(struct ber *b, unsigned int (*cb)(struct ber_element *))
 {
 	b->br_application = cb;
 }
 
 void
-ber_set_writecallback(struct ber_element *elm, void (*cb)(void *, size_t),
+ober_set_writecallback(struct ber_element *elm, void (*cb)(void *, size_t),
     void *arg)
 {
 	elm->be_cb = cb;
@@ -974,7 +974,7 @@ ber_set_writecallback(struct ber_element
 }
 
 void
-ber_free(struct ber *b)
+ober_free(struct ber *b)
 {
 	free(b->br_wbuf);
 }
@@ -984,13 +984,13 @@ ber_free(struct ber *b)
  */
 
 static int
-ber_dump_element(struct ber *ber, struct ber_element *root)
+ober_dump_element(struct ber *ber, struct ber_element *root)
 {
 	unsigned long long l;
 	int i;
 	uint8_t u;
 
-	ber_dump_header(ber, root);
+	ober_dump_header(ber, root);
 	if (root->be_cb)
 		root->be_cb(root->be_cbarg, ber->br_wptr - ber->br_wbuf);
 
@@ -1001,31 +1001,31 @@ ber_dump_element(struct ber *ber, struct
 		l = (unsigned long long)root->be_numeric;
 		for (i = root->be_len; i > 0; i--) {
 			u = (l >> ((i - 1) * 8)) & 0xff;
-			ber_putc(ber, u);
+			ober_putc(ber, u);
 		}
 		break;
 	case BER_TYPE_BITSTRING:
 	case BER_TYPE_OCTETSTRING:
 	case BER_TYPE_OBJECT:
-		ber_write(ber, root->be_val, root->be_len);
+		ober_write(ber, root->be_val, root->be_len);
 		break;
 	case BER_TYPE_NULL:	/* no payload */
 	case BER_TYPE_EOC:
 		break;
 	case BER_TYPE_SEQUENCE:
 	case BER_TYPE_SET:
-		if (root->be_sub && ber_dump_element(ber, root->be_sub) == -1)
+		if (root->be_sub && ober_dump_element(ber, root->be_sub) == -1)
 			return -1;
 		break;
 	}
 
 	if (root->be_next == NULL)
 		return 0;
-	return ber_dump_element(ber, root->be_next);
+	return ober_dump_element(ber, root->be_next);
 }
 
 static void
-ber_dump_header(struct ber *ber, struct ber_element *root)
+ober_dump_header(struct ber *ber, struct ber_element *root)
 {
 	u_char	id = 0, t, buf[5];
 	unsigned int type;
@@ -1039,14 +1039,14 @@ ber_dump_header(struct ber *ber, struct 
 		    root->be_encoding == BER_TYPE_SET)
 			id |= BER_TYPE_CONSTRUCTED;
 
-		ber_putc(ber, id);
+		ober_putc(ber, id);
 	} else {
 		id = BER_TAG_MASK | (root->be_class << BER_CLASS_SHIFT);
 		if (root->be_encoding == BER_TYPE_SEQUENCE ||
 		    root->be_encoding == BER_TYPE_SET)
 			id |= BER_TYPE_CONSTRUCTED;
 
-		ber_putc(ber, id);
+		ober_putc(ber, id);
 
 		for (t = 0, type = root->be_type; type > 0; type >>= 7)
 			buf[t++] = type & ~BER_TAG_MORE;
@@ -1054,26 +1054,26 @@ ber_dump_header(struct ber *ber, struct 
 		while (t-- > 0) {
 			if (t > 0)
 				buf[t] |= BER_TAG_MORE;
-			ber_putc(ber, buf[t]);
+			ober_putc(ber, buf[t]);
 		}
 	}
 
 	if (root->be_len < BER_TAG_MORE) {
 		/* short form */
-		ber_putc(ber, root->be_len);
+		ober_putc(ber, root->be_len);
 	} else {
 		for (t = 0, size = root->be_len; size > 0; size >>= 8)
 			buf[t++] = size & 0xff;
 
-		ber_putc(ber, t | BER_TAG_MORE);
+		ober_putc(ber, t | BER_TAG_MORE);
 
 		while (t > 0)
-			ber_putc(ber, buf[--t]);
+			ober_putc(ber, buf[--t]);
 	}
 }
 
 static void
-ber_putc(struct ber *ber, u_char c)
+ober_putc(struct ber *ber, u_char c)
 {
 	if (ber->br_wptr + 1 <= ber->br_wend)
 		*ber->br_wptr = c;
@@ -1081,7 +1081,7 @@ ber_putc(struct ber *ber, u_char c)
 }
 
 static void
-ber_write(struct ber *ber, void *buf, size_t len)
+ober_write(struct ber *ber, void *buf, size_t len)
 {
 	if (ber->br_wptr + len <= ber->br_wend)
 		bcopy(buf, ber->br_wptr, len);
@@ -1098,7 +1098,7 @@ get_id(struct ber *b, unsigned int *tag,
 	size_t i = 0;
 	unsigned int t = 0;
 
-	if (ber_getc(b, &u) == -1)
+	if (ober_getc(b, &u) == -1)
 		return -1;
 
 	*class = (u >> BER_CLASS_SHIFT) & BER_CLASS_MASK;
@@ -1110,7 +1110,7 @@ get_id(struct ber *b, unsigned int *tag,
 	}
 
 	do {
-		if (ber_getc(b, &u) == -1)
+		if (ober_getc(b, &u) == -1)
 			return -1;
 
 		/* enforce minimal number of octets for tag > 30 */
@@ -1140,7 +1140,7 @@ get_len(struct ber *b, ssize_t *len)
 	u_char	u, n;
 	ssize_t	s, r;
 
-	if (ber_getc(b, &u) == -1)
+	if (ober_getc(b, &u) == -1)
 		return -1;
 	if ((u & BER_TAG_MORE) == 0) {
 		/* short form */
@@ -1171,7 +1171,7 @@ get_len(struct ber *b, ssize_t *len)
 	r = n + 1;
 
 	for (s = 0; n > 0; n--) {
-		if (ber_getc(b, &u) == -1)
+		if (ober_getc(b, &u) == -1)
 			return -1;
 		s = (s << 8) | u;
 	}
@@ -1187,7 +1187,7 @@ get_len(struct ber *b, ssize_t *len)
 }
 
 static ssize_t
-ber_read_element(struct ber *ber, struct ber_element *elm)
+ober_read_element(struct ber *ber, struct ber_element *elm)
 {
 	long long val = 0;
 	struct ber_element *next;
@@ -1261,7 +1261,7 @@ ber_read_element(struct ber *ber, struct
 		if (len > (ssize_t)sizeof(long long))
 			return -1;
 		for (i = 0; i < len; i++) {
-			if (ber_getc(ber, &c) != 1)
+			if (ober_getc(ber, &c) != 1)
 				return -1;
 
 			/* smallest number of contents octets only */
@@ -1286,7 +1286,7 @@ ber_read_element(struct ber *ber, struct
 			return -1;
 		elm->be_free = 1;
 		elm->be_len = len;
-		ber_read(ber, elm->be_val, len);
+		ober_read(ber, elm->be_val, len);
 		break;
 	case BER_TYPE_OCTETSTRING:
 	case BER_TYPE_OBJECT:
@@ -1295,7 +1295,7 @@ ber_read_element(struct ber *ber, struct
 			return -1;
 		elm->be_free = 1;
 		elm->be_len = len;
-		ber_read(ber, elm->be_val, len);
+		ober_read(ber, elm->be_val, len);
 		((u_char *)elm->be_val)[len] = '\0';
 		break;
 	case BER_TYPE_NULL:	/* no payload */
@@ -1305,26 +1305,26 @@ ber_read_element(struct ber *ber, struct
 	case BER_TYPE_SEQUENCE:
 	case BER_TYPE_SET:
 		if (elm->be_sub == NULL) {
-			if ((elm->be_sub = ber_get_element(0)) == NULL)
+			if ((elm->be_sub = ober_get_element(0)) == NULL)
 				return -1;
 		}
 		next = elm->be_sub;
 		while (len > 0) {
 			/*
 			 * Prevent stack overflow from excessive recursion
-			 * depth in ber_free_elements().
+			 * depth in ober_free_elements().
 			 */
 			if (elements >= BER_MAX_SEQ_ELEMENTS) {
 				errno = ERANGE;
 				return -1;
 			}
-			r = ber_read_element(ber, next);
+			r = ober_read_element(ber, next);
 			if (r == -1)
 				return -1;
 			elements++;
 			len -= r;
 			if (len > 0 && next->be_next == NULL) {
-				if ((next->be_next = ber_get_element(0)) ==
+				if ((next->be_next = ober_get_element(0)) ==
 				    NULL)
 					return -1;
 			}
@@ -1336,13 +1336,13 @@ ber_read_element(struct ber *ber, struct
 }
 
 static ssize_t
-ber_getc(struct ber *b, u_char *c)
+ober_getc(struct ber *b, u_char *c)
 {
-	return ber_read(b, c, 1);
+	return ober_read(b, c, 1);
 }
 
 static ssize_t
-ber_read(struct ber *ber, void *buf, size_t len)
+ober_read(struct ber *ber, void *buf, size_t len)
 {
 	size_t	sz;
 
Index: lib/libutil/ber.h
===================================================================
RCS file: /cvs/src/lib/libutil/ber.h,v
retrieving revision 1.1
diff -u -p -r1.1 ber.h
--- lib/libutil/ber.h	11 May 2019 17:46:02 -0000	1.1
+++ lib/libutil/ber.h	24 Oct 2019 13:58:18 -0000
@@ -90,62 +90,62 @@ struct ber_oid {
 };
 
 __BEGIN_DECLS
-struct ber_element	*ber_get_element(unsigned int);
-void			 ber_set_header(struct ber_element *, int,
+struct ber_element	*ober_get_element(unsigned int);
+void			 ober_set_header(struct ber_element *, int,
 			    unsigned int);
-void			 ber_link_elements(struct ber_element *,
+void			 ober_link_elements(struct ber_element *,
 			    struct ber_element *);
-struct ber_element	*ber_unlink_elements(struct ber_element *);
-void			 ber_replace_elements(struct ber_element *,
+struct ber_element	*ober_unlink_elements(struct ber_element *);
+void			 ober_replace_elements(struct ber_element *,
 			    struct ber_element *);
-struct ber_element	*ber_add_sequence(struct ber_element *);
-struct ber_element	*ber_add_set(struct ber_element *);
-struct ber_element	*ber_add_integer(struct ber_element *, long long);
-int			 ber_get_integer(struct ber_element *, long long *);
-struct ber_element	*ber_add_enumerated(struct ber_element *, long long);
-int			 ber_get_enumerated(struct ber_element *, long long *);
-struct ber_element	*ber_add_boolean(struct ber_element *, int);
-int			 ber_get_boolean(struct ber_element *, int *);
-struct ber_element	*ber_add_string(struct ber_element *, const char *);
-struct ber_element	*ber_add_nstring(struct ber_element *, const char *,
+struct ber_element	*ober_add_sequence(struct ber_element *);
+struct ber_element	*ober_add_set(struct ber_element *);
+struct ber_element	*ober_add_integer(struct ber_element *, long long);
+int			 ober_get_integer(struct ber_element *, long long *);
+struct ber_element	*ober_add_enumerated(struct ber_element *, long long);
+int			 ober_get_enumerated(struct ber_element *, long long *);
+struct ber_element	*ober_add_boolean(struct ber_element *, int);
+int			 ober_get_boolean(struct ber_element *, int *);
+struct ber_element	*ober_add_string(struct ber_element *, const char *);
+struct ber_element	*ober_add_nstring(struct ber_element *, const char *,
 			    size_t);
-struct ber_element	*ber_add_ostring(struct ber_element *,
+struct ber_element	*ober_add_ostring(struct ber_element *,
 			    struct ber_octetstring *);
-int			 ber_get_string(struct ber_element *, char **);
-int			 ber_get_nstring(struct ber_element *, void **,
+int			 ober_get_string(struct ber_element *, char **);
+int			 ober_get_nstring(struct ber_element *, void **,
 			    size_t *);
-int			 ber_get_ostring(struct ber_element *,
+int			 ober_get_ostring(struct ber_element *,
 			    struct ber_octetstring *);
-struct ber_element	*ber_add_bitstring(struct ber_element *, const void *,
+struct ber_element	*ober_add_bitstring(struct ber_element *, const void *,
 			    size_t);
-int			 ber_get_bitstring(struct ber_element *, void **,
+int			 ober_get_bitstring(struct ber_element *, void **,
 			    size_t *);
-struct ber_element	*ber_add_null(struct ber_element *);
-int			 ber_get_null(struct ber_element *);
-struct ber_element	*ber_add_eoc(struct ber_element *);
-int			 ber_get_eoc(struct ber_element *);
-struct ber_element	*ber_add_oid(struct ber_element *, struct ber_oid *);
-struct ber_element	*ber_add_noid(struct ber_element *, struct ber_oid *, int);
-struct ber_element	*ber_add_oidstring(struct ber_element *, const char *);
-int			 ber_get_oid(struct ber_element *, struct ber_oid *);
-size_t			 ber_oid2ber(struct ber_oid *, u_int8_t *, size_t);
-int			 ber_string2oid(const char *, struct ber_oid *);
-struct ber_element	*ber_printf_elements(struct ber_element *, char *, ...);
-int			 ber_scanf_elements(struct ber_element *, char *, ...);
-ssize_t			 ber_get_writebuf(struct ber *, void **);
-ssize_t			 ber_write_elements(struct ber *, struct ber_element *);
-void			 ber_set_readbuf(struct ber *, void *, size_t);
-struct ber_element	*ber_read_elements(struct ber *, struct ber_element *);
-off_t			 ber_getpos(struct ber_element *);
-void			 ber_free_element(struct ber_element *);
-void			 ber_free_elements(struct ber_element *);
-size_t			 ber_calc_len(struct ber_element *);
-void			 ber_set_application(struct ber *,
+struct ber_element	*ober_add_null(struct ber_element *);
+int			 ober_get_null(struct ber_element *);
+struct ber_element	*ober_add_eoc(struct ber_element *);
+int			 ober_get_eoc(struct ber_element *);
+struct ber_element	*ober_add_oid(struct ber_element *, struct ber_oid *);
+struct ber_element	*ober_add_noid(struct ber_element *, struct ber_oid *, int);
+struct ber_element	*ober_add_oidstring(struct ber_element *, const char *);
+int			 ober_get_oid(struct ber_element *, struct ber_oid *);
+size_t			 ober_oid2ber(struct ber_oid *, u_int8_t *, size_t);
+int			 ober_string2oid(const char *, struct ber_oid *);
+struct ber_element	*ober_printf_elements(struct ber_element *, char *, ...);
+int			 ober_scanf_elements(struct ber_element *, char *, ...);
+ssize_t			 ober_get_writebuf(struct ber *, void **);
+ssize_t			 ober_write_elements(struct ber *, struct ber_element *);
+void			 ober_set_readbuf(struct ber *, void *, size_t);
+struct ber_element	*ober_read_elements(struct ber *, struct ber_element *);
+off_t			 ober_getpos(struct ber_element *);
+void			 ober_free_element(struct ber_element *);
+void			 ober_free_elements(struct ber_element *);
+size_t			 ober_calc_len(struct ber_element *);
+void			 ober_set_application(struct ber *,
 			    unsigned int (*)(struct ber_element *));
-void			 ber_set_writecallback(struct ber_element *,
+void			 ober_set_writecallback(struct ber_element *,
 			    void (*)(void *, size_t), void *);
-void			 ber_free(struct ber *);
-int			 ber_oid_cmp(struct ber_oid *, struct ber_oid *);
+void			 ober_free(struct ber *);
+int			 ober_oid_cmp(struct ber_oid *, struct ber_oid *);
 
 __END_DECLS
 
Index: lib/libutil/ber_add_string.3
===================================================================
RCS file: /cvs/src/lib/libutil/Attic/ber_add_string.3,v
retrieving revision 1.3
diff -u -p -r1.3 ber_add_string.3
--- lib/libutil/ber_add_string.3	21 May 2019 12:30:07 -0000	1.3
+++ lib/libutil/ber_add_string.3	24 Oct 2019 14:06:20 -0000
@@ -15,68 +15,68 @@
 .\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 .\"
 .Dd $Mdocdate: May 21 2019 $
-.Dt BER_ADD_STRING 3
+.Dt OBER_ADD_STRING 3
 .Os
 .Sh NAME
-.Nm ber_get_element ,
-.Nm ber_add_sequence ,
-.Nm ber_add_set ,
-.Nm ber_add_null ,
-.Nm ber_add_eoc ,
-.Nm ber_add_integer ,
-.Nm ber_add_enumerated ,
-.Nm ber_add_boolean ,
-.Nm ber_add_string ,
-.Nm ber_add_nstring ,
-.Nm ber_add_ostring ,
-.Nm ber_add_bitstring ,
-.Nm ber_add_oid ,
-.Nm ber_add_noid ,
-.Nm ber_add_oidstring ,
-.Nm ber_printf_elements
+.Nm ober_get_element ,
+.Nm ober_add_sequence ,
+.Nm ober_add_set ,
+.Nm ober_add_null ,
+.Nm ober_add_eoc ,
+.Nm ober_add_integer ,
+.Nm ober_add_enumerated ,
+.Nm ober_add_boolean ,
+.Nm ober_add_string ,
+.Nm ober_add_nstring ,
+.Nm ober_add_ostring ,
+.Nm ober_add_bitstring ,
+.Nm ober_add_oid ,
+.Nm ober_add_noid ,
+.Nm ober_add_oidstring ,
+.Nm ober_printf_elements
 .Nd create ASN.1 objects for BER encoding
 .Sh SYNOPSIS
 .In sys/types.h
 .In ber.h
 .Ft "struct ber_element *"
-.Fn "ber_get_element" "unsigned int encoding"
+.Fn "ober_get_element" "unsigned int encoding"
 .Ft "struct ber_element *"
-.Fn "ber_add_sequence" "struct ber_element *prev"
+.Fn "ober_add_sequence" "struct ber_element *prev"
 .Ft "struct ber_element *"
-.Fn "ber_add_set" "struct ber_element *prev"
+.Fn "ober_add_set" "struct ber_element *prev"
 .Ft "struct ber_element *"
-.Fn "ber_add_null" "struct ber_element *prev"
+.Fn "ober_add_null" "struct ber_element *prev"
 .Ft "struct ber_element *"
-.Fn "ber_add_eoc" "struct ber_element *prev"
+.Fn "ober_add_eoc" "struct ber_element *prev"
 .Ft "struct ber_element *"
-.Fn "ber_add_integer" "struct ber_element *prev" "long long val"
+.Fn "ober_add_integer" "struct ber_element *prev" "long long val"
 .Ft "struct ber_element *"
-.Fn "ber_add_enumerated" "struct ber_element *prev" "long long val"
+.Fn "ober_add_enumerated" "struct ber_element *prev" "long long val"
 .Ft "struct ber_element *"
-.Fn "ber_add_boolean" "struct ber_element *prev" "int bool"
+.Fn "ober_add_boolean" "struct ber_element *prev" "int bool"
 .Ft "struct ber_element *"
-.Fn "ber_add_string" "struct ber_element *prev" "const char *string"
+.Fn "ober_add_string" "struct ber_element *prev" "const char *string"
 .Ft "struct ber_element *"
-.Fn "ber_add_nstring" "struct ber_element *prev" "const char *string" "size_t size"
+.Fn "ober_add_nstring" "struct ber_element *prev" "const char *string" "size_t size"
 .Ft "struct ber_element *"
-.Fo "ber_add_ostring"
+.Fo "ober_add_ostring"
 .Fa "struct ber_element *prev"
 .Fa "struct ber_octetstring *ostring"
 .Fc
 .Ft "struct ber_element *"
-.Fo "ber_add_bitstring"
+.Fo "ober_add_bitstring"
 .Fa "struct ber_element *prev"
 .Fa "const void *buf"
 .Fa "size_t size"
 .Fc
 .Ft "struct ber_element *"
-.Fn "ber_add_oid" "struct ber_element *prev" "struct ber_oid *oid"
+.Fn "ober_add_oid" "struct ber_element *prev" "struct ber_oid *oid"
 .Ft "struct ber_element *"
-.Fn "ber_add_noid" "struct ber_element *prev" "struct ber_oid *oid" "int n"
+.Fn "ober_add_noid" "struct ber_element *prev" "struct ber_oid *oid" "int n"
 .Ft "struct ber_element *"
-.Fn "ber_add_oidstring" "struct ber_element *prev" "const char *string"
+.Fn "ober_add_oidstring" "struct ber_element *prev" "const char *string"
 .Ft "struct ber_element *"
-.Fn "ber_printf_elements" "struct ber_element *prev" "char *format" "..."
+.Fn "ober_printf_elements" "struct ber_element *prev" "char *format" "..."
 .Sh DESCRIPTION
 Intermediary storage of BER elements during encoding and decoding uses the
 following structure:
@@ -102,7 +102,7 @@ struct ber_element {
 };
 .Ed
 .Pp
-.Fn ber_get_element
+.Fn ober_get_element
 creates a new
 .Vt ber_element
 with default values, dynamically allocates required storage, and sets
@@ -111,7 +111,7 @@ to
 .Fa encoding .
 .Pp
 The
-.Fn ber_add_*
+.Fn ober_add_*
 functions allocate a new
 .Vt ber_element
 of the respective type.
@@ -128,7 +128,7 @@ they put it behind
 Those functions taking a second argument initialize the content
 of the new element from the second argument.
 .Pp
-.Fn ber_printf_elements
+.Fn ober_printf_elements
 creates zero or more
 .Vt ber_element
 structures.
@@ -139,25 +139,25 @@ and passed to the listed function, creat
 .Vt ber_element
 per byte.
 The following bytes are valid:
-.Bl -column -offset indent byte ber_add_enumerated "struct ber_element *"
+.Bl -column -offset indent byte ober_add_enumerated "struct ber_element *"
 .It Sy byte Ta Sy function Ta Sy arguments
-.It B   Ta Fn ber_add_bitstring  Ta 2: Vt void * , size_t
-.It b   Ta Fn ber_add_boolean    Ta 1: Vt int
-.It d   Ta Fn ber_add_integer    Ta 1: Vt int
-.It E   Ta Fn ber_add_enumerated Ta 1: Vt long long
-.It e   Ta see below             Ta 1: Vt struct ber_element *
-.It i   Ta Fn ber_add_integer    Ta 1: Vt long long
-.It O   Ta Fn ber_add_oid        Ta 1: Vt struct ber_oid *
-.It o   Ta Fn ber_add_oidstring  Ta 1: Vt char *
-.It s   Ta Fn ber_add_string     Ta 1: Vt char *
-.It t   Ta Xr ber_set_header 3   Ta 2: Vt int , unsigned int
-.It x   Ta Fn ber_add_nstring    Ta 2: Vt char * , size_t
-.It \&( Ta Fn ber_add_set        Ta 0
-.It \&) Ta see below             Ta 0
-.It \&. Ta Fn ber_add_eoc        Ta 0
-.It 0   Ta Fn ber_add_null       Ta 0
-.It {   Ta Fn ber_add_sequence   Ta 0
-.It }   Ta see below             Ta 0
+.It B   Ta Fn ober_add_bitstring  Ta 2: Vt void * , size_t
+.It b   Ta Fn ober_add_boolean    Ta 1: Vt int
+.It d   Ta Fn ober_add_integer    Ta 1: Vt int
+.It E   Ta Fn ober_add_enumerated Ta 1: Vt long long
+.It e   Ta see below              Ta 1: Vt struct ber_element *
+.It i   Ta Fn ober_add_integer    Ta 1: Vt long long
+.It O   Ta Fn ober_add_oid        Ta 1: Vt struct ber_oid *
+.It o   Ta Fn ober_add_oidstring  Ta 1: Vt char *
+.It s   Ta Fn ober_add_string     Ta 1: Vt char *
+.It t   Ta Xr ober_set_header 3   Ta 2: Vt int , unsigned int
+.It x   Ta Fn ober_add_nstring    Ta 2: Vt char * , size_t
+.It \&( Ta Fn ober_add_set        Ta 0
+.It \&) Ta see below              Ta 0
+.It \&. Ta Fn ober_add_eoc        Ta 0
+.It 0   Ta Fn ober_add_null       Ta 0
+.It {   Ta Fn ober_add_sequence   Ta 0
+.It }   Ta see below              Ta 0
 .El
 .Pp
 The
@@ -175,7 +175,7 @@ if the
 is the first byte in
 .Fa fmt ,
 just like the
-.Fn ber_add_*
+.Fn ober_add_*
 functions would add a new element.
 The
 .Sq t
@@ -202,7 +202,7 @@ is returned and the global variable
 .Va errno
 is set to indicate the error.
 .Pp
-.Fn ber_printf_elements
+.Fn ober_printf_elements
 returns
 .Dv NULL
 without setting
@@ -214,10 +214,10 @@ is an empty string and
 is
 .Dv NULL .
 .Sh SEE ALSO
-.Xr ber_get_string 3 ,
-.Xr ber_oid_cmp 3 ,
-.Xr ber_read_elements 3 ,
-.Xr ber_set_header 3
+.Xr ober_get_string 3 ,
+.Xr ober_oid_cmp 3 ,
+.Xr ober_read_elements 3 ,
+.Xr ober_set_header 3
 .Sh STANDARDS
 ITU-T Recommendation X.690, also known as ISO/IEC 8825-1:
 Information technology - ASN.1 encoding rules.
Index: lib/libutil/ber_get_string.3
===================================================================
RCS file: /cvs/src/lib/libutil/Attic/ber_get_string.3,v
retrieving revision 1.7
diff -u -p -r1.7 ber_get_string.3
--- lib/libutil/ber_get_string.3	14 Aug 2019 17:36:04 -0000	1.7
+++ lib/libutil/ber_get_string.3	24 Oct 2019 14:06:20 -0000
@@ -15,61 +15,61 @@
 .\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 .\"
 .Dd $Mdocdate: August 14 2019 $
-.Dt BER_GET_STRING 3
+.Dt OBER_GET_STRING 3
 .Os
 .Sh NAME
-.Nm ber_get_null ,
-.Nm ber_get_eoc ,
-.Nm ber_get_integer ,
-.Nm ber_get_enumerated ,
-.Nm ber_get_boolean ,
-.Nm ber_get_string ,
-.Nm ber_get_nstring ,
-.Nm ber_get_ostring ,
-.Nm ber_get_bitstring ,
-.Nm ber_get_oid ,
-.Nm ber_getpos ,
-.Nm ber_scanf_elements
+.Nm ober_get_null ,
+.Nm ober_get_eoc ,
+.Nm ober_get_integer ,
+.Nm ober_get_enumerated ,
+.Nm ober_get_boolean ,
+.Nm ober_get_string ,
+.Nm ober_get_nstring ,
+.Nm ober_get_ostring ,
+.Nm ober_get_bitstring ,
+.Nm ober_get_oid ,
+.Nm ober_getpos ,
+.Nm ober_scanf_elements
 .Nd access properties of ASN.1 objects decoded from BER
 .Sh SYNOPSIS
 .In sys/types.h
 .In ber.h
 .Ft "int"
-.Fn "ber_get_null" "struct ber_element *root"
+.Fn "ober_get_null" "struct ber_element *root"
 .Ft "int"
-.Fn "ber_get_eoc" "struct ber_element *root"
+.Fn "ober_get_eoc" "struct ber_element *root"
 .Ft "int"
-.Fn "ber_get_integer" "struct ber_element *root" "long long *val"
+.Fn "ober_get_integer" "struct ber_element *root" "long long *val"
 .Ft "int"
-.Fn "ber_get_enumerated" "struct ber_element *root" "long long *val"
+.Fn "ober_get_enumerated" "struct ber_element *root" "long long *val"
 .Ft "int"
-.Fn "ber_get_boolean" "struct ber_element *root" "int *bool"
+.Fn "ober_get_boolean" "struct ber_element *root" "int *bool"
 .Ft "int"
-.Fn "ber_get_string" "struct ber_element *root" "char **charbuf"
+.Fn "ober_get_string" "struct ber_element *root" "char **charbuf"
 .Ft "int"
-.Fn "ber_get_nstring" "struct ber_element *root" "void **buf" "size_t *size"
+.Fn "ober_get_nstring" "struct ber_element *root" "void **buf" "size_t *size"
 .Ft "int"
-.Fn "ber_get_ostring" "struct ber_element *root" "struct ber_octetstring *ostring"
+.Fn "ober_get_ostring" "struct ber_element *root" "struct ber_octetstring *ostring"
 .Ft "int"
-.Fn "ber_get_bitstring" "struct ber_element *root" "void **buf" "size_t *size"
+.Fn "ober_get_bitstring" "struct ber_element *root" "void **buf" "size_t *size"
 .Ft "int"
-.Fn "ber_get_oid" "struct ber_element *root" "struct ber_oid *oid"
+.Fn "ober_get_oid" "struct ber_element *root" "struct ber_oid *oid"
 .Ft off_t
-.Fn "ber_getpos" "struct ber_element *elm"
+.Fn "ober_getpos" "struct ber_element *elm"
 .Ft "int"
-.Fn "ber_scanf_elements" "struct ber_element *root" "char *format" "..."
+.Fn "ober_scanf_elements" "struct ber_element *root" "char *format" "..."
 .Sh DESCRIPTION
 Functions which take two arguments save the value contained in the
 .Fa root
 element into the storage location pointed to by the second argument.
 Additionally,
-.Fn ber_get_nstring
+.Fn ober_get_nstring
 and
-.Fn ber_get_bitstring
+.Fn ober_get_bitstring
 save the number of bytes contained in the string into
 .Pf * Fa size .
 .Pp
-.Fn ber_scanf_elements
+.Fn ober_scanf_elements
 retrieves the values from zero or more elements starting at
 .Fa root .
 For each byte in
@@ -79,24 +79,24 @@ and passed to the function listed, proce
 .Vt ber_element
 per byte.
 The following bytes are valid:
-.Bl -column -offset indent bytes ber_get_enumerated() "1: struct ber_element **"
+.Bl -column -offset indent bytes ober_get_enumerated() "1: struct ber_element **"
 .It Sy byte Ta Sy function Ta Sy arguments
-.It B Ta Fn ber_get_bitstring  Ta 2: Vt void ** , size_t *
-.It b Ta Fn ber_get_boolean    Ta 1: Vt int *
-.It d Ta Fn ber_get_integer    Ta 1: Vt int *
-.It E Ta Fn ber_get_enumerated Ta 1: Vt long long *
+.It B Ta Fn ober_get_bitstring  Ta 2: Vt void ** , size_t *
+.It b Ta Fn ober_get_boolean    Ta 1: Vt int *
+.It d Ta Fn ober_get_integer    Ta 1: Vt int *
+.It E Ta Fn ober_get_enumerated Ta 1: Vt long long *
 .It e Ta see below             Ta 1: Vt struct ber_element **
-.It i Ta Fn ber_get_integer    Ta 1: Vt long long *
-.It o Ta Fn ber_get_oid        Ta 1: Vt struct ber_oid *
-.It p Ta Fn ber_getpos         Ta 1: Vt off_t *
+.It i Ta Fn ober_get_integer    Ta 1: Vt long long *
+.It o Ta Fn ober_get_oid        Ta 1: Vt struct ber_oid *
+.It p Ta Fn ober_getpos         Ta 1: Vt off_t *
 .It S Ta see below             Ta 0
-.It s Ta Fn ber_get_string     Ta 1: Vt char **
+.It s Ta Fn ober_get_string     Ta 1: Vt char **
 .It t Ta see below             Ta 2: Vt int * , unsigned int *
-.It x Ta Fn ber_get_nstring    Ta 2: Vt void **, size_t *
+.It x Ta Fn ober_get_nstring    Ta 2: Vt void **, size_t *
 .It \&( or { Ta see below      Ta 0
 .It \&) or } Ta see below      Ta 0
-.It \&. Ta Fn ber_get_eoc      Ta 0
-.It 0 Ta Fn ber_get_null       Ta 0
+.It \&. Ta Fn ober_get_eoc      Ta 0
+.It 0 Ta Fn ober_get_null       Ta 0
 .El
 .Pp
 For
@@ -128,11 +128,11 @@ For a closing parenthesis or brace, pars
 or set is ended and parsing continues with the element following
 the sequence or set.
 .Sh RETURN VALUES
-.Fn ber_getpos
+.Fn ober_getpos
 returns the value of
 .Vt be_offs .
 .Pp
-.Fn ber_scanf_elements
+.Fn ober_scanf_elements
 returns 0 for success or \-1 when encountering elements that do not
 agree with the expectations of
 .Fa fmt
@@ -140,17 +140,17 @@ or when
 .Fa fmt
 is syntactically invalid.
 Even when
-.Fn ber_scanf_elements
+.Fn ober_scanf_elements
 fails, some of the arguments may already have been filled in.
 .Pp
 The other functions return 0 if
 .Va root
 is of the requested type or \-1 otherwise.
 .Sh SEE ALSO
-.Xr ber_add_string 3 ,
-.Xr ber_oid_cmp 3 ,
-.Xr ber_read_elements 3 ,
-.Xr ber_set_header 3
+.Xr ober_add_string 3 ,
+.Xr ober_oid_cmp 3 ,
+.Xr ober_read_elements 3 ,
+.Xr ober_set_header 3
 .Sh STANDARDS
 ITU-T Recommendation X.690, also known as ISO/IEC 8825-1:
 Information technology - ASN.1 encoding rules.
Index: lib/libutil/ber_oid_cmp.3
===================================================================
RCS file: /cvs/src/lib/libutil/Attic/ber_oid_cmp.3,v
retrieving revision 1.2
diff -u -p -r1.2 ber_oid_cmp.3
--- lib/libutil/ber_oid_cmp.3	21 May 2019 12:30:07 -0000	1.2
+++ lib/libutil/ber_oid_cmp.3	24 Oct 2019 14:06:20 -0000
@@ -15,22 +15,22 @@
 .\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 .\"
 .Dd $Mdocdate: May 21 2019 $
-.Dt BER_OID_CMP 3
+.Dt OBER_OID_CMP 3
 .Os
 .Sh NAME
-.Nm ber_oid_cmp ,
-.Nm ber_oid2ber ,
-.Nm ber_string2oid
+.Nm ober_oid_cmp ,
+.Nm ober_oid2ber ,
+.Nm ober_string2oid
 .Nd OID helper functions for the BER library
 .Sh SYNOPSIS
 .In sys/types.h
 .In ber.h
 .Ft "int"
-.Fn "ber_oid_cmp" "struct ber_oid *a" "struct ber_oid *b"
+.Fn "ober_oid_cmp" "struct ber_oid *a" "struct ber_oid *b"
 .Ft "size_t"
-.Fn "ber_oid2ber" "struct ber_oid *oid" "u_int8_t *buf" "size_t size"
+.Fn "ober_oid2ber" "struct ber_oid *oid" "u_int8_t *buf" "size_t size"
 .Ft "int"
-.Fn "ber_string2oid" "const char *string" "struct ber_oid *oid"
+.Fn "ober_string2oid" "const char *string" "struct ber_oid *oid"
 .Sh DESCRIPTION
 Object Identifiers are commonly used in ASN.1-based protocols.
 These functions provide an interface to parse OIDs.
@@ -48,24 +48,24 @@ struct ber_oid {
 .Ed
 .Pp
 The
-.Fn ber_oid2ber
+.Fn ober_oid2ber
 and
-.Fn ber_string2oid
+.Fn ober_string2oid
 functions may be used to convert from and to
 .Vt struct ber_oid .
 .Pp
-.Fn ber_oid_cmp
+.Fn ober_oid_cmp
 may be used to compare two
 .Vt ber_oid
 structures.
 .Sh RETURN VALUES
-.Fn ber_oid2ber
+.Fn ober_oid2ber
 returns the number of bytes written or 0 on faliure.
 .Pp
-.Fn ber_string2oid
+.Fn ober_string2oid
 returns 0 on success or -1 on failure.
 .Pp
-.Fn ber_oid_cmp
+.Fn ober_oid_cmp
 returns 0 when oids
 .Fa a
 and
@@ -87,10 +87,10 @@ is larger, but a child of
 .Fa a ,
 2 is returned.
 .Sh SEE ALSO
-.Xr ber_add_string 3 ,
-.Xr ber_get_string 3 ,
-.Xr ber_read_elements 3 ,
-.Xr ber_set_header 3
+.Xr ober_add_string 3 ,
+.Xr ober_get_string 3 ,
+.Xr ober_read_elements 3 ,
+.Xr ober_set_header 3
 .Sh HISTORY
 These functions first appeared as internal functions in
 .Xr snmpd 8
Index: lib/libutil/ber_read_elements.3
===================================================================
RCS file: /cvs/src/lib/libutil/Attic/ber_read_elements.3,v
retrieving revision 1.5
diff -u -p -r1.5 ber_read_elements.3
--- lib/libutil/ber_read_elements.3	21 May 2019 12:30:07 -0000	1.5
+++ lib/libutil/ber_read_elements.3	24 Oct 2019 14:06:20 -0000
@@ -15,34 +15,34 @@
 .\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 .\"
 .Dd $Mdocdate: May 21 2019 $
-.Dt BER_READ_ELEMENTS 3
+.Dt OBER_READ_ELEMENTS 3
 .Os
 .Sh NAME
-.Nm ber_set_readbuf ,
-.Nm ber_set_application ,
-.Nm ber_read_elements ,
-.Nm ber_get_writebuf ,
-.Nm ber_write_elements ,
-.Nm ber_free
+.Nm ober_set_readbuf ,
+.Nm ober_set_application ,
+.Nm ober_read_elements ,
+.Nm ober_get_writebuf ,
+.Nm ober_write_elements ,
+.Nm ober_free
 .Nd encode and decode ASN.1 with Basic Encoding Rules
 .Sh SYNOPSIS
 .In sys/types.h
 .In ber.h
 .Ft "void"
-.Fn "ber_set_readbuf" "struct ber *ber" "void *buf" "size_t len"
+.Fn "ober_set_readbuf" "struct ber *ber" "void *buf" "size_t len"
 .Ft "void"
-.Fo "ber_set_application"
+.Fo "ober_set_application"
 .Fa "struct ber *ber"
 .Fa "unsigned int (*cb)(struct ber_element *)"
 .Fc
 .Ft "struct ber_element *"
-.Fn "ber_read_elements" "struct ber *ber" "struct ber_element *root"
+.Fn "ober_read_elements" "struct ber *ber" "struct ber_element *root"
 .Ft "ssize_t"
-.Fn "ber_get_writebuf" "struct ber *ber" "void **buf"
+.Fn "ober_get_writebuf" "struct ber *ber" "void **buf"
 .Ft "ssize_t"
-.Fn "ber_write_elements" "struct ber *ber" "struct ber_element *root"
+.Fn "ober_write_elements" "struct ber *ber" "struct ber_element *root"
 .Ft "void"
-.Fn "ber_free" "struct ber *ber"
+.Fn "ober_free" "struct ber *ber"
 .Sh DESCRIPTION
 The BER API provides a mechanism to read and write ASN.1 using the
 Basic Encoding Rules.
@@ -95,7 +95,7 @@ struct ber_element {
 };
 .Ed
 .Pp
-.Fn ber_set_readbuf
+.Fn ober_set_readbuf
 sets
 .Fa br_rbuf
 to point an input buffer of BER encoded bytes in preparation for decoding.
@@ -108,7 +108,7 @@ application, commonly obtained by
 or
 .Xr tls_read 3 .
 .Pp
-.Fn ber_read_elements
+.Fn ober_read_elements
 may then be called to parse, validate, and store the
 .Fa ber
 data stream into its
@@ -118,12 +118,12 @@ parts for subsequent processing.
 The calling application must have explicit knowledge of the expected data
 types in order for correct decoding.
 .Pp
-.Fn ber_get_writebuf
+.Fn ober_get_writebuf
 sets
 .Fa br_wbuf
 to point to an output buffer for writing a BER byte stream.
 .Pp
-.Fn ber_write_elements
+.Fn ober_write_elements
 encodes
 .Fa root
 into a compliant BER byte stream which is written to
@@ -135,23 +135,23 @@ functions such as
 or
 .Xr tls_write 3 .
 .Pp
-.Fn ber_free
+.Fn ober_free
 frees any dynamically allocated storage associated with
 .Fa ber .
 .Sh RETURN VALUES
-.Fn ber_read_elements
+.Fn ober_read_elements
 returns a pointer to a fully populated list of one or more
 .Vt ber_element
 structures or
 .Dv NULL
 on a type mismatch or read error.
 .Pp
-.Fn ber_get_writebuf
+.Fn ober_get_writebuf
 returns the number of bytes contained within the buffer
 .Fa buf
 or \-1 on failure.
 .Pp
-.Fn ber_write_elements
+.Fn ober_write_elements
 returns the number of bytes written.
 Otherwise \-1 is returned and the global variable
 .Va errno
@@ -161,10 +161,10 @@ is set to indicate the error.
 .Xr recv 2 ,
 .Xr send 2 ,
 .Xr write 2 ,
-.Xr ber_add_string 3 ,
-.Xr ber_get_string 3 ,
-.Xr ber_oid_cmp 3 ,
-.Xr ber_set_header 3 ,
+.Xr ober_add_string 3 ,
+.Xr ober_get_string 3 ,
+.Xr ober_oid_cmp 3 ,
+.Xr ober_set_header 3 ,
 .Xr tls_read 3
 .Sh STANDARDS
 ITU-T Recommendation X.690, also known as ISO/IEC 8825-1:
Index: lib/libutil/ber_set_header.3
===================================================================
RCS file: /cvs/src/lib/libutil/Attic/ber_set_header.3,v
retrieving revision 1.3
diff -u -p -r1.3 ber_set_header.3
--- lib/libutil/ber_set_header.3	14 Aug 2019 19:08:03 -0000	1.3
+++ lib/libutil/ber_set_header.3	24 Oct 2019 14:06:20 -0000
@@ -15,41 +15,41 @@
 .\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 .\"
 .Dd $Mdocdate: August 14 2019 $
-.Dt BER_SET_HEADER 3
+.Dt OBER_SET_HEADER 3
 .Os
 .Sh NAME
-.Nm ber_set_header ,
-.Nm ber_calc_len ,
-.Nm ber_set_writecallback ,
-.Nm ber_link_elements ,
-.Nm ber_replace_elements ,
-.Nm ber_unlink_elements ,
-.Nm ber_free_element ,
-.Nm ber_free_elements
+.Nm ober_set_header ,
+.Nm ober_calc_len ,
+.Nm ober_set_writecallback ,
+.Nm ober_link_elements ,
+.Nm ober_replace_elements ,
+.Nm ober_unlink_elements ,
+.Nm ober_free_element ,
+.Nm ober_free_elements
 .Nd change and destroy ASN.1 objects for BER encoding
 .Sh SYNOPSIS
 .In sys/types.h
 .In ber.h
 .Ft "void"
-.Fn "ber_set_header" "struct ber_element *elm" "int class" "unsigned int type"
+.Fn "ober_set_header" "struct ber_element *elm" "int class" "unsigned int type"
 .Ft "size_t"
-.Fn "ber_calc_len" "struct ber_element *root"
+.Fn "ober_calc_len" "struct ber_element *root"
 .Ft "void"
-.Fo "ber_set_writecallback"
+.Fo "ober_set_writecallback"
 .Fa "struct ber_element *elm"
 .Fa "void (*cb)(void *arg, size_t offs)"
 .Fa "void *arg"
 .Fc
 .Ft "void"
-.Fn "ber_link_elements" "struct ber_element *prev" "struct ber_element *elm"
+.Fn "ober_link_elements" "struct ber_element *prev" "struct ber_element *elm"
 .Ft "void"
-.Fn "ber_replace_elements" "struct ber_element *prev" "struct ber_element *elm"
+.Fn "ober_replace_elements" "struct ber_element *prev" "struct ber_element *elm"
 .Ft "struct ber_element *"
-.Fn "ber_unlink_elements" "struct ber_element *prev"
+.Fn "ober_unlink_elements" "struct ber_element *prev"
 .Ft "void"
-.Fn "ber_free_element" "struct ber_element *root"
+.Fn "ober_free_element" "struct ber_element *root"
 .Ft "void"
-.Fn "ber_free_elements" "struct ber_element *root"
+.Fn "ober_free_elements" "struct ber_element *root"
 .Pp
 .Fd #define BER_TYPE_BOOLEAN			1
 .Fd #define BER_TYPE_INTEGER			2
@@ -70,7 +70,7 @@
 .Fd #define BER_CLASS_CONTEXT		0x2
 .Fd #define BER_CLASS_PRIVATE		0x3
 .Sh DESCRIPTION
-.Fn ber_set_header
+.Fn ober_set_header
 sets the
 .Fa class
 and
@@ -78,22 +78,22 @@ and
 of
 .Fa elm .
 .Pp
-.Fn ber_calc_len
+.Fn ober_calc_len
 determines the total length of
 .Fa root .
 .Pp
-.Fn ber_set_writecallback
+.Fn ober_set_writecallback
 registers the
 .Vt br_cb
 callback function.
 .Pp
-.Fn ber_link_elements
+.Fn ober_link_elements
 links
 .Fa prev
 and
 .Fa elm .
 .Pp
-.Fn ber_replace_elements
+.Fn ober_replace_elements
 replaces
 .Fa prev
 with
@@ -101,30 +101,30 @@ with
 and frees any dynamically allocated storage assocated with
 .Fa prev .
 .Pp
-.Fn ber_unlink_elements
+.Fn ober_unlink_elements
 unlinks
 .Fa prev .
 .Pp
-.Fn ber_free_element
+.Fn ober_free_element
 and
-.Fn ber_free_elements
+.Fn ober_free_elements
 free any dynamically allocated storage associated with
 .Fa root .
 .Sh RETURN VALUES
-.Fn ber_calc_len
+.Fn ober_calc_len
 returns the total length of a fully populated
 .Fa root
 containing one or more
 .Vt ber_element .
 .Pp
-.Fn ber_unlink_elements
+.Fn ober_unlink_elements
 returns a pointer to
 .Vt ber_element .
 .Sh SEE ALSO
-.Xr ber_add_string 3 ,
-.Xr ber_get_string 3 ,
-.Xr ber_oid_cmp 3 ,
-.Xr ber_read_elements 3
+.Xr ober_add_string 3 ,
+.Xr ober_get_string 3 ,
+.Xr ober_oid_cmp 3 ,
+.Xr ober_read_elements 3
 .Sh STANDARDS
 ITU-T Recommendation X.690, also known as ISO/IEC 8825-1:
 Information technology - ASN.1 encoding rules.
Index: regress/lib/libutil/ber/ber_test.c
===================================================================
RCS file: /cvs/src/regress/lib/libutil/ber/ber_test.c,v
retrieving revision 1.19
diff -u -p -r1.19 ber_test.c
--- regress/lib/libutil/ber/ber_test.c	18 Sep 2019 11:00:46 -0000	1.19
+++ regress/lib/libutil/ber/ber_test.c	24 Oct 2019 13:58:18 -0000
@@ -332,18 +332,18 @@ test(int i)
 	struct ber_octetstring	 ostring;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_readbuf(&ber, test_vectors[i].input, test_vectors[i].length);
-	ber_set_application(&ber, ldap_application);
+	ober_set_readbuf(&ber, test_vectors[i].input, test_vectors[i].length);
+	ober_set_application(&ber, ldap_application);
 
-	elm = ber_read_elements(&ber, elm);
+	elm = ober_read_elements(&ber, elm);
 	if (elm == NULL && test_vectors[i].fail &&
 	    (errno == EINVAL || errno == ERANGE || errno == ECANCELED))
 		return 0;
 	else if (elm != NULL && test_vectors[i].fail) {
-		printf("expected failure of ber_read_elements did not occur\n");
+		printf("expected failure of ober_read_elements did not occur\n");
 		return 1;
 	} else if (elm == NULL) {
-		printf("unexpectedly failed ber_read_elements\n");
+		printf("unexpectedly failed ober_read_elements\n");
 		return 1;
 	}
 
@@ -351,7 +351,7 @@ test(int i)
 	 * short form tagged elements start at the 3rd octet (i.e. position 2).
 	 */
 	if (test_vectors[i].memcheck) {
-		pos = ber_getpos(elm);
+		pos = ober_getpos(elm);
 		if (pos != 2) {
 			printf("unexpected element position within "
 			    "byte stream\n");
@@ -361,82 +361,82 @@ test(int i)
 
 	switch (elm->be_encoding) {
 	case BER_TYPE_EOC:
-		if (ber_get_eoc(elm) == -1) {
+		if (ober_get_eoc(elm) == -1) {
 			printf("failed (eoc) encoding check\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, ".", &val) == -1) {
-			printf("failed (eoc) ber_scanf_elements\n");
+		if (ober_scanf_elements(elm, ".", &val) == -1) {
+			printf("failed (eoc) ober_scanf_elements\n");
 			return 1;
 		}
 		break;
 	case BER_TYPE_BOOLEAN:
-		if (ber_get_boolean(elm, &b) == -1) {
+		if (ober_get_boolean(elm, &b) == -1) {
 			printf("failed (boolean) encoding check\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "b", &b) == -1) {
-			printf("failed (boolean) ber_scanf_elements\n");
+		if (ober_scanf_elements(elm, "b", &b) == -1) {
+			printf("failed (boolean) ober_scanf_elements\n");
 			return 1;
 		}
 		break;
 	case BER_TYPE_INTEGER:
-		if (ber_get_integer(elm, &val) == -1) {
+		if (ober_get_integer(elm, &val) == -1) {
 			printf("failed (int) encoding check\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "i", &val) == -1) {
-			printf("failed (int) ber_scanf_elements (i)\n");
+		if (ober_scanf_elements(elm, "i", &val) == -1) {
+			printf("failed (int) ober_scanf_elements (i)\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "d", &val) == -1) {
-			printf("failed (int) ber_scanf_elements (d)\n");
+		if (ober_scanf_elements(elm, "d", &val) == -1) {
+			printf("failed (int) ober_scanf_elements (d)\n");
 			return 1;
 		}
 		break;
 	case BER_TYPE_ENUMERATED:
-		if (ber_get_enumerated(elm, &val) == -1) {
+		if (ober_get_enumerated(elm, &val) == -1) {
 			printf("failed (enum) encoding check\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "E", &val) == -1) {
-			printf("failed (enum) ber_scanf_elements (E)\n");
+		if (ober_scanf_elements(elm, "E", &val) == -1) {
+			printf("failed (enum) ober_scanf_elements (E)\n");
 			return 1;
 		}
 		break;
 	case BER_TYPE_BITSTRING:
-		if (ber_get_bitstring(elm, &bstring, &len) == -1) {
+		if (ober_get_bitstring(elm, &bstring, &len) == -1) {
 			printf("failed (bit string) encoding check\n");
 			return 1;
 		}
 		break;
 	case BER_TYPE_OCTETSTRING:
-		if (ber_get_ostring(elm, &ostring) == -1) {
+		if (ober_get_ostring(elm, &ostring) == -1) {
 			printf("failed (octet string) encoding check\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "s", &string) == -1) {
-			printf("failed (octet string) ber_scanf_elements\n");
+		if (ober_scanf_elements(elm, "s", &string) == -1) {
+			printf("failed (octet string) ober_scanf_elements\n");
 			return 1;
 		}
 		break;
 	case BER_TYPE_NULL:
-		if (ber_get_null(elm) == -1) {
+		if (ober_get_null(elm) == -1) {
 			printf("failed (null) encoding check\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "0", &val) == -1) {
-			printf("failed (null) ber_scanf_elements\n");
+		if (ober_scanf_elements(elm, "0", &val) == -1) {
+			printf("failed (null) ober_scanf_elements\n");
 			return 1;
 		}
 		break;
 	case BER_TYPE_OBJECT:	/* OID */
-		if (ber_get_oid(elm, &oid) == -1) {
+		if (ober_get_oid(elm, &oid) == -1) {
 			printf("failed (oid) encoding check\n");
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "o", &oid) == -1) {
-			printf("failed (oid) ber_scanf_elements\n");
+		if (ober_scanf_elements(elm, "o", &oid) == -1) {
+			printf("failed (oid) ober_scanf_elements\n");
 			return 1;
 		}
 		break;
@@ -444,7 +444,7 @@ test(int i)
 	case BER_TYPE_SEQUENCE:
 		if (elm->be_sub != NULL) {
 			ptr = elm->be_sub;
-			if (ber_getpos(ptr) <= pos) {
+			if (ober_getpos(ptr) <= pos) {
 				printf("unexpected element position within "
 				    "byte stream\n");
 				return 1;
@@ -464,14 +464,14 @@ test(int i)
 	 * additional testing on short form encoding
 	 */
 	if (test_vectors[i].memcheck) {
-		len = ber_calc_len(elm);
+		len = ober_calc_len(elm);
 		if (len != test_vectors[i].length) {
 			printf("failed to calculate length\n");
 			return 1;
 		}
 
 		ber.br_wbuf = NULL;
-		len = ber_write_elements(&ber, elm);
+		len = ober_write_elements(&ber, elm);
 		if (len != test_vectors[i].length) {
 			printf("failed length check (was %zd want "
 			    "%zd)\n", len, test_vectors[i].length);
@@ -487,10 +487,10 @@ test(int i)
 			hexdump(test_vectors[i].input, test_vectors[i].length);
 			return 1;
 		}
-		ber_free(&ber);
+		ober_free(&ber);
 
 	}
-	ber_free_elements(elm);
+	ober_free_elements(elm);
 
 	return 0;
 }
@@ -503,15 +503,15 @@ test_ber_printf_elements_integer(void) {
 
 	unsigned char		 exp[3] = { 0x02, 0x01, 0x01 };
 
-	elm = ber_printf_elements(elm, "d", val);
+	elm = ober_printf_elements(elm, "d", val);
 	if (elm == NULL) {
-		printf("failed ber_printf_elements\n");
+		printf("failed ober_printf_elements\n");
 		return 1;
 	}
 
 	bzero(&ber, sizeof(ber));
 	ber.br_wbuf = NULL;
-	len = ber_write_elements(&ber, elm);
+	len = ober_write_elements(&ber, elm);
 	if (len != sizeof(exp)) {
 		printf("failed length check (was %d want %zd)\n", len,
 		    sizeof(exp));
@@ -523,8 +523,8 @@ test_ber_printf_elements_integer(void) {
 		return 1;
 	}
 
-	ber_free_elements(elm);
-	ber_free(&ber);
+	ober_free_elements(elm);
+	ober_free(&ber);
 	return 0;
 }
 
@@ -550,24 +550,24 @@ test_ber_printf_elements_ldap_bind(void)
 		0x80, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64
 	};
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		return 1;
 
-	elm = ber_printf_elements(root, "d{tdsst", msgid,
+	elm = ober_printf_elements(root, "d{tdsst", msgid,
 	    BER_CLASS_APP, LDAP_REQ_BIND,
 	    VERSION,
 	    binddn, bindcred,
 	    BER_CLASS_CONTEXT, LDAP_AUTH_SIMPLE);
 
 	if (elm == NULL) {
-		printf("failed ber_printf_elements\n");
+		printf("failed ober_printf_elements\n");
 		return 1;
 	}
 
 	bzero(&ber, sizeof(ber));
 	ber.br_wbuf = NULL;
-	ber_set_application(&ber, ldap_application);
-	len = ber_write_elements(&ber, root);
+	ober_set_application(&ber, ldap_application);
+	len = ober_write_elements(&ber, root);
 	if (len != sizeof(exp)) {
 		printf("failed length check (was %d want %zd)\n", len,
 		    sizeof(exp));
@@ -580,8 +580,8 @@ test_ber_printf_elements_ldap_bind(void)
 		return 1;
 	}
 
-	ber_free_elements(elm);
-	ber_free(&ber);
+	ober_free_elements(elm);
+	ober_free(&ber);
 	return 0;
 }
 
@@ -604,21 +604,21 @@ test_ber_printf_elements_ldap_search(voi
 		0x00, 0x04, 0x02, 0x63, 0x6e
 	};
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		return 1;
 
-	elm = ber_printf_elements(root, "d{tsEEddbs",
+	elm = ober_printf_elements(root, "d{tsEEddbs",
 	    msgid, BER_CLASS_APP, LDAP_REQ_SEARCH,
 	    basedn, scope, deref, sizelimit, timelimit, typesonly, filter);
 	if (elm == NULL) {
-		printf("failed ber_printf_elements\n");
+		printf("failed ober_printf_elements\n");
 		return 1;
 	}
 
 	bzero(&ber, sizeof(ber));
 	ber.br_wbuf = NULL;
-	ber_set_application(&ber, ldap_application);
-	len = ber_write_elements(&ber, root);
+	ober_set_application(&ber, ldap_application);
+	len = ober_write_elements(&ber, root);
 	if (len != sizeof(exp)) {
 		printf("failed length check (was %d want %zd)\n", len,
 		    sizeof(exp));
@@ -631,8 +631,8 @@ test_ber_printf_elements_ldap_search(voi
 		return 1;
 	}
 
-	ber_free_elements(elm);
-	ber_free(&ber);
+	ober_free_elements(elm);
+	ober_free(&ber);
 	return 0;
 }
 
@@ -650,16 +650,16 @@ test_ber_printf_elements_snmp_v3_encode(
 		0x00, 0x04, 0x01, 0x01, 0x02, 0x01, 0x03
 	};
 
-	elm = ber_printf_elements(elm, "{iixi}", msgid, max_msg_size,
+	elm = ober_printf_elements(elm, "{iixi}", msgid, max_msg_size,
 	    &f, sizeof(f), secmodel);
 	if (elm == NULL) {
-		printf("failed ber_printf_elements\n");
+		printf("failed ober_printf_elements\n");
 		return 1;
 	}
 
 	bzero(&ber, sizeof(ber));
 	ber.br_wbuf = NULL;
-	len = ber_write_elements(&ber, elm);
+	len = ober_write_elements(&ber, elm);
 	if (len != sizeof(exp)) {
 		printf("failed length check (was %d want %zd)\n", len,
 		    sizeof(exp));
@@ -672,8 +672,8 @@ test_ber_printf_elements_snmp_v3_encode(
 		return 1;
 	}
 
-	ber_free_elements(elm);
-	ber_free(&ber);
+	ober_free_elements(elm);
+	ober_free(&ber);
 	return 0;
 }
 
@@ -684,37 +684,37 @@ test_ber_null(void)
 	struct ber_element	*elm = NULL;
 
 	/* scanning into a null ber_element should fail */
-	if (ber_scanf_elements(elm, "0", &val) != -1) {
-		printf("failed (null ber_element) ber_scanf_elements empty\n");
+	if (ober_scanf_elements(elm, "0", &val) != -1) {
+		printf("failed (null ber_element) ober_scanf_elements empty\n");
 		goto fail;
 	}
 
-	if ((elm = ber_printf_elements(elm, "{d}", 1)) == NULL) {
-		printf("failed (null ber_element) ber_printf_elements\n");
+	if ((elm = ober_printf_elements(elm, "{d}", 1)) == NULL) {
+		printf("failed (null ber_element) ober_printf_elements\n");
 	}
 
 	/*
 	 * Scanning after the last valid element should be able to descend back
 	 * into the parent level.
 	 */
-	if (ber_scanf_elements(elm, "{i}", &val) != 0) {
-		printf("failed (null ber_element) ber_scanf_elements valid\n");
+	if (ober_scanf_elements(elm, "{i}", &val) != 0) {
+		printf("failed (null ber_element) ober_scanf_elements valid\n");
 		goto fail;
 	}
 	/*
 	 * Scanning for a non-existent element should fail, even if it's just a
 	 * skip.
 	 */
-	if (ber_scanf_elements(elm, "{lS}", &val) != -1) {
-		printf("failed (null ber_element) ber_scanf_elements invalid\n");
+	if (ober_scanf_elements(elm, "{lS}", &val) != -1) {
+		printf("failed (null ber_element) ober_scanf_elements invalid\n");
 		goto fail;
 	}
 
-	ber_free_elements(elm);
+	ober_free_elements(elm);
 	return 0;
 
 fail:
-	ber_free_elements(elm);
+	ober_free_elements(elm);
 	return 1;
 }
 
Index: regress/lib/libutil/ber/ber_test_int_i.c
===================================================================
RCS file: /cvs/src/regress/lib/libutil/ber/ber_test_int_i.c,v
retrieving revision 1.5
diff -u -p -r1.5 ber_test_int_i.c
--- regress/lib/libutil/ber/ber_test_int_i.c	27 Apr 2019 23:43:51 -0000	1.5
+++ regress/lib/libutil/ber/ber_test_int_i.c	24 Oct 2019 13:58:18 -0000
@@ -530,20 +530,20 @@ test_read_elements(int i)
 	struct ber_octetstring	 ostring;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_readbuf(&ber, test_vectors[i].input,
+	ober_set_readbuf(&ber, test_vectors[i].input,
 	    test_vectors[i].input_length);
 
-	elm = ber_read_elements(&ber, elm);
+	elm = ober_read_elements(&ber, elm);
 	if (elm != NULL && test_vectors[i].fail == FAIL) {
-		printf("unexpectedly passed ber_read_elements\n");
+		printf("unexpectedly passed ober_read_elements\n");
 		return 1;
 	} else if (elm == NULL && test_vectors[i].fail != FAIL) {
-		printf("unexpectedly failed ber_read_elements\n");
+		printf("unexpectedly failed ober_read_elements\n");
 		return 1;
 	} else if (elm == NULL && test_vectors[i].fail == FAIL)
 		return 0;
 
-	pos = ber_getpos(elm);
+	pos = ober_getpos(elm);
 	if (pos != 2) {
 		printf("unexpected element position within "
 		    "byte stream (%d)\n", pos);
@@ -552,18 +552,18 @@ test_read_elements(int i)
 
 	switch (elm->be_encoding) {
 	case BER_TYPE_INTEGER:
-		if (ber_get_integer(elm, &val) == -1) {
+		if (ober_get_integer(elm, &val) == -1) {
 			printf("failed (int) encoding check\n");
 			return 1;
 		}
 		if (val != test_vectors[i].value) {
-			printf("(ber_get_integer) got %lld, expected %lld\n",
+			printf("(ober_get_integer) got %lld, expected %lld\n",
 			    val, test_vectors[i].value);
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "i", &val) == -1) {
-			printf("(ber_scanf_elements) failed (int)"
-			    " ber_scanf_elements (i)\n");
+		if (ober_scanf_elements(elm, "i", &val) == -1) {
+			printf("(ober_scanf_elements) failed (int)"
+			    " ober_scanf_elements (i)\n");
 			return 1;
 		}
 		if (val != test_vectors[i].value) {
@@ -578,7 +578,7 @@ test_read_elements(int i)
 		return 1;
 	}
 
-	len = ber_calc_len(elm);
+	len = ober_calc_len(elm);
 	if (len != test_vectors[i].expect_length) {
 		printf("failed to calculate length\n");
 		printf("was %zd want %zu\n", len,
@@ -587,7 +587,7 @@ test_read_elements(int i)
 	}
 
 	ber.br_wbuf = NULL;
-	len = ber_write_elements(&ber, elm);
+	len = ober_write_elements(&ber, elm);
 	if (len != test_vectors[i].expect_length) {
 		printf("failed length check (was %zd want "
 		    "%zd)\n", len, test_vectors[i].expect_length);
@@ -603,9 +603,9 @@ test_read_elements(int i)
 		hexdump(test_vectors[i].expect, test_vectors[i].expect_length);
 		return 1;
 	}
-	ber_free(&ber);
+	ober_free(&ber);
 
-	ber_free_elements(elm);
+	ober_free_elements(elm);
 
 	return 0;
 }
@@ -625,29 +625,29 @@ test_printf_elements(int i)
 	struct ber_octetstring	 ostring;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_readbuf(&ber, test_vectors[i].input,
+	ober_set_readbuf(&ber, test_vectors[i].input,
 	    test_vectors[i].input_length);
 
-	elm = ber_printf_elements(elm, "i", test_vectors[i].value);
+	elm = ober_printf_elements(elm, "i", test_vectors[i].value);
 	if (elm == NULL) {
-		printf("unexpectedly failed ber_printf_elements\n");
+		printf("unexpectedly failed ober_printf_elements\n");
 		return 1;
 	}
 
 	switch (elm->be_encoding) {
 	case BER_TYPE_INTEGER:
-		if (ber_get_integer(elm, &val) == -1) {
+		if (ober_get_integer(elm, &val) == -1) {
 			printf("failed (int) encoding check\n");
 			return 1;
 		}
 		if (val != test_vectors[i].value) {
-			printf("(ber_get_integer) got %lld, expected %lld\n",
+			printf("(ober_get_integer) got %lld, expected %lld\n",
 			    val, test_vectors[i].value);
 			return 1;
 		}
-		if (ber_scanf_elements(elm, "i", &val) == -1) {
-			printf("(ber_scanf_elements) failed (int)"
-			    " ber_scanf_elements (i)\n");
+		if (ober_scanf_elements(elm, "i", &val) == -1) {
+			printf("(ober_scanf_elements) failed (int)"
+			    " ober_scanf_elements (i)\n");
 			return 1;
 		}
 		if (val != test_vectors[i].value) {
@@ -662,7 +662,7 @@ test_printf_elements(int i)
 		return 1;
 	}
 
-	len = ber_calc_len(elm);
+	len = ober_calc_len(elm);
 	if (len != test_vectors[i].expect_length) {
 		printf("failed to calculate length\n");
 		printf("was %zd want %zu\n", len,
@@ -671,7 +671,7 @@ test_printf_elements(int i)
 	}
 
 	ber.br_wbuf = NULL;
-	len = ber_write_elements(&ber, elm);
+	len = ober_write_elements(&ber, elm);
 	if (len != test_vectors[i].expect_length) {
 		printf("failed length check (was %zd want "
 		    "%zd)\n", len, test_vectors[i].expect_length);
@@ -687,9 +687,9 @@ test_printf_elements(int i)
 		hexdump(test_vectors[i].expect, test_vectors[i].expect_length);
 		return 1;
 	}
-	ber_free(&ber);
+	ober_free(&ber);
 
-	ber_free_elements(elm);
+	ober_free_elements(elm);
 
 	return 0;
 }
@@ -717,8 +717,8 @@ main(void)
 	printf("= = = = = test_printf_elements\n");
 	for (i = 0; i < sizeof(test_vectors) / sizeof(test_vectors[0]); i++) {
 		/*
-		 * skip test cases known to fail under ber_read_elements as
-		 * they are not applicable to ber_printf_elements
+		 * skip test cases known to fail under ober_read_elements as
+		 * they are not applicable to ober_printf_elements
 		 */
 		if (test_vectors[i].fail)
 			continue;
Index: usr.bin/ldap/aldap.c
===================================================================
RCS file: /cvs/src/usr.bin/ldap/aldap.c,v
retrieving revision 1.8
diff -u -p -r1.8 aldap.c
--- usr.bin/ldap/aldap.c	10 Sep 2019 14:35:32 -0000	1.8
+++ usr.bin/ldap/aldap.c	24 Oct 2019 13:58:18 -0000
@@ -74,7 +74,7 @@ aldap_close(struct aldap *al)
 		tls_free(al->tls);
 	}
 	close(al->fd);
-	ber_free(&al->ber);
+	ober_free(&al->ber);
 	evbuffer_free(al->buf);
 	free(al);
 
@@ -90,7 +90,7 @@ aldap_init(int fd)
 		return NULL;
 	a->buf = evbuffer_new();
 	a->fd = fd;
-	ber_set_application(&a->ber, aldap_application);
+	ober_set_application(&a->ber, aldap_application);
 
 	return a;
 }
@@ -130,13 +130,13 @@ aldap_send(struct aldap *ldap, struct be
 	size_t len, done;
 	ssize_t error, wrote;
 
-	len = ber_calc_len(root);
-	error = ber_write_elements(&ldap->ber, root);
-	ber_free_elements(root);
+	len = ober_calc_len(root);
+	error = ober_write_elements(&ldap->ber, root);
+	ober_free_elements(root);
 	if (error == -1)
 		return -1;
 
-	ber_get_writebuf(&ldap->ber, &ptr);
+	ober_get_writebuf(&ldap->ber, &ptr);
 	done = 0;
 	data = ptr;
 	while (len > 0) {
@@ -163,10 +163,10 @@ aldap_req_starttls(struct aldap *ldap)
 {
 	struct ber_element *root = NULL, *ber;
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	ber = ber_printf_elements(root, "d{tst", ++ldap->msgid, BER_CLASS_APP,
+	ber = ober_printf_elements(root, "d{tst", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_EXTENDED, LDAP_STARTTLS_OID, BER_CLASS_CONTEXT, 0);
 	if (ber == NULL) {
 		ldap->err = ALDAP_ERR_OPERATION_FAILED;
@@ -179,7 +179,7 @@ aldap_req_starttls(struct aldap *ldap)
 	return (ldap->msgid);
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	ldap->err = ALDAP_ERR_OPERATION_FAILED;
 	return (-1);
@@ -195,10 +195,10 @@ aldap_bind(struct aldap *ldap, char *bin
 	if (bindcred == NULL)
 		bindcred = "";
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	elm = ber_printf_elements(root, "d{tdsst", ++ldap->msgid, BER_CLASS_APP,
+	elm = ober_printf_elements(root, "d{tdsst", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_BIND, VERSION, binddn, bindcred, BER_CLASS_CONTEXT,
 	    LDAP_AUTH_SIMPLE);
 	if (elm == NULL)
@@ -213,7 +213,7 @@ aldap_bind(struct aldap *ldap, char *bin
 	return (ldap->msgid);
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	ldap->err = ALDAP_ERR_OPERATION_FAILED;
 	return (-1);
@@ -224,9 +224,9 @@ aldap_unbind(struct aldap *ldap)
 {
 	struct ber_element *root = NULL, *elm;
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
-	elm = ber_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
+	elm = ober_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_UNBIND_30);
 	if (elm == NULL)
 		goto fail;
@@ -240,7 +240,7 @@ aldap_unbind(struct aldap *ldap)
 	return (ldap->msgid);
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	ldap->err = ALDAP_ERR_OPERATION_FAILED;
 
@@ -255,10 +255,10 @@ aldap_search(struct aldap *ldap, char *b
 	struct ber_element *root = NULL, *ber, *c;
 	int i;
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	ber = ber_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
+	ber = ober_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_SEARCH);
 	if (ber == NULL) {
 		ldap->err = ALDAP_ERR_OPERATION_FAILED;
@@ -266,7 +266,7 @@ aldap_search(struct aldap *ldap, char *b
 	}
 
 	c = ber;	
-	ber = ber_printf_elements(ber, "sEEddb", basedn, (long long)scope,
+	ber = ober_printf_elements(ber, "sEEddb", basedn, (long long)scope,
 	                         (long long)LDAP_DEREF_NEVER, sizelimit, 
 				 timelimit, typesonly);
 	if (ber == NULL) {
@@ -279,11 +279,11 @@ aldap_search(struct aldap *ldap, char *b
 		goto fail;
 	}
 
-	if ((ber = ber_add_sequence(ber)) == NULL)
+	if ((ber = ober_add_sequence(ber)) == NULL)
 		goto fail;
 	if (attrs != NULL)
 		for (i = 0; attrs[i] != NULL; i++) {
-			if ((ber = ber_add_string(ber, attrs[i])) == NULL)
+			if ((ber = ober_add_string(ber, attrs[i])) == NULL)
 				goto fail;
 		}
 
@@ -301,7 +301,7 @@ aldap_search(struct aldap *ldap, char *b
 
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	return (-1);
 }
@@ -316,30 +316,30 @@ aldap_create_page_control(struct ber_ele
 
 	c.br_wbuf = NULL;
 
-	ber = ber_add_sequence(NULL);
+	ber = ober_add_sequence(NULL);
 
 	if (page == NULL) {
-		if (ber_printf_elements(ber, "ds", 50, "") == NULL)
+		if (ober_printf_elements(ber, "ds", 50, "") == NULL)
 			goto fail;
 	} else {
-		if (ber_printf_elements(ber, "dx", 50, page->cookie,
+		if (ober_printf_elements(ber, "dx", 50, page->cookie,
 			    page->cookie_len) == NULL)
 			goto fail;
 	}
 
-	if ((len = ber_write_elements(&c, ber)) < 1)
+	if ((len = ober_write_elements(&c, ber)) < 1)
 		goto fail;
-	if (ber_printf_elements(elm, "{t{sx", 2, 0, LDAP_PAGED_OID,
+	if (ober_printf_elements(elm, "{t{sx", 2, 0, LDAP_PAGED_OID,
 		                c.br_wbuf, (size_t)len) == NULL)
 		goto fail;
 
-	ber_free_elements(ber);
-	ber_free(&c);
+	ober_free_elements(ber);
+	ober_free(&c);
 	return len;
 fail:
 	if (ber != NULL)
-		ber_free_elements(ber);
-	ber_free(&c);	
+		ober_free_elements(ber);
+	ober_free(&c);	
 
 	return (-1);
 }
@@ -377,10 +377,10 @@ aldap_parse(struct aldap *ldap)
 		}
 
 		if (EVBUFFER_LENGTH(ldap->buf) > 0) {
-			ber_set_readbuf(&ldap->ber, EVBUFFER_DATA(ldap->buf),
+			ober_set_readbuf(&ldap->ber, EVBUFFER_DATA(ldap->buf),
 			    EVBUFFER_LENGTH(ldap->buf));
 			errno = 0;
-			m->msg = ber_read_elements(&ldap->ber, NULL);
+			m->msg = ober_read_elements(&ldap->ber, NULL);
 			if (errno != 0 && errno != ECANCELED) {
 				goto parsefail;
 			}
@@ -393,7 +393,7 @@ aldap_parse(struct aldap *ldap)
 
 	LDAP_DEBUG("message", m->msg);
 
-	if (ber_scanf_elements(m->msg, "{ite", &msgid, &class, &type, &a) != 0)
+	if (ober_scanf_elements(m->msg, "{ite", &msgid, &class, &type, &a) != 0)
 		goto parsefail;
 	m->msgid = msgid;
 	m->message_type = type;
@@ -407,17 +407,17 @@ aldap_parse(struct aldap *ldap)
 	case LDAP_RES_MODRDN:
 	case LDAP_RES_COMPARE:
 	case LDAP_RES_SEARCH_RESULT:
-		if (ber_scanf_elements(m->protocol_op, "{EeSe",
+		if (ober_scanf_elements(m->protocol_op, "{EeSe",
 		    &m->body.res.rescode, &m->dn, &m->body.res.diagmsg) != 0)
 			goto parsefail;
 		if (m->body.res.rescode == LDAP_REFERRAL) {
 			a = m->body.res.diagmsg->be_next;
-			if (ber_scanf_elements(a, "{e", &m->references) != 0)
+			if (ober_scanf_elements(a, "{e", &m->references) != 0)
 				goto parsefail;
 		}
 		if (m->msg->be_sub) {
 			for (ep = m->msg->be_sub; ep != NULL; ep = ep->be_next) {
-				ber_scanf_elements(ep, "t", &class, &type);
+				ober_scanf_elements(ep, "t", &class, &type);
 				if (class == 2 && type == 0)
 					m->page = aldap_parse_page_control(ep->be_sub->be_sub,
 					    ep->be_sub->be_sub->be_len);
@@ -426,16 +426,16 @@ aldap_parse(struct aldap *ldap)
 			m->page = NULL;
 		break;
 	case LDAP_RES_SEARCH_ENTRY:
-		if (ber_scanf_elements(m->protocol_op, "{eS{e", &m->dn,
+		if (ober_scanf_elements(m->protocol_op, "{eS{e", &m->dn,
 		    &m->body.search.attrs) != 0)
 			goto parsefail;
 		break;
 	case LDAP_RES_SEARCH_REFERENCE:
-		if (ber_scanf_elements(m->protocol_op, "{e", &m->references) != 0)
+		if (ober_scanf_elements(m->protocol_op, "{e", &m->references) != 0)
 			goto parsefail;
 		break;
 	case LDAP_RES_EXTENDED:
-		if (ber_scanf_elements(m->protocol_op, "{E",
+		if (ober_scanf_elements(m->protocol_op, "{E",
 		    &m->body.res.rescode) != 0) {
 			goto parsefail;
 		}
@@ -460,31 +460,31 @@ aldap_parse_page_control(struct ber_elem
 	struct aldap_page_control *page;
 
 	b.br_wbuf = NULL;
-	ber_scanf_elements(control, "ss", &oid, &encoded);
-	ber_set_readbuf(&b, encoded, control->be_next->be_len);
-	elm = ber_read_elements(&b, NULL);
+	ober_scanf_elements(control, "ss", &oid, &encoded);
+	ober_set_readbuf(&b, encoded, control->be_next->be_len);
+	elm = ober_read_elements(&b, NULL);
 
 	if ((page = malloc(sizeof(struct aldap_page_control))) == NULL) {
 		if (elm != NULL)
-			ber_free_elements(elm);
-		ber_free(&b);
+			ober_free_elements(elm);
+		ober_free(&b);
 		return NULL;
 	}
 
-	ber_scanf_elements(elm->be_sub, "is", &page->size, &s);
+	ober_scanf_elements(elm->be_sub, "is", &page->size, &s);
 	page->cookie_len = elm->be_sub->be_next->be_len;
 
 	if ((page->cookie = malloc(page->cookie_len)) == NULL) {
 		if (elm != NULL)
-			ber_free_elements(elm);
-		ber_free(&b);
+			ober_free_elements(elm);
+		ober_free(&b);
 		free(page);
 		return NULL;
 	}
 	memcpy(page->cookie, s, page->cookie_len);
 
-	ber_free_elements(elm);
-	ber_free(&b);
+	ober_free_elements(elm);
+	ober_free(&b);
 	return page;
 }
 
@@ -499,7 +499,7 @@ void
 aldap_freemsg(struct aldap_message *msg)
 {
 	if (msg->msg)
-		ber_free_elements(msg->msg);
+		ober_free_elements(msg->msg);
 	free(msg);
 }
 
@@ -517,7 +517,7 @@ aldap_get_dn(struct aldap_message *msg)
 	if (msg->dn == NULL)
 		return NULL;
 
-	if (ber_get_string(msg->dn, &dn) == -1)
+	if (ober_get_string(msg->dn, &dn) == -1)
 		return NULL;
 
 	return utoa(dn);
@@ -553,7 +553,7 @@ aldap_get_diagmsg(struct aldap_message *
 	if (msg->body.res.diagmsg == NULL)
 		return NULL;
 
-	if (ber_get_string(msg->body.res.diagmsg, &s) == -1)
+	if (ober_get_string(msg->body.res.diagmsg, &s) == -1)
 		return NULL;
 
 	return utoa(s);
@@ -569,7 +569,7 @@ aldap_count_attrs(struct aldap_message *
 		return (-1);
 
 	for (i = 0, a = msg->body.search.attrs;
-	    a != NULL && ber_get_eoc(a) != 0;
+	    a != NULL && ober_get_eoc(a) != 0;
 	    i++, a = a->be_next)
 		;
 
@@ -587,7 +587,7 @@ aldap_first_attr(struct aldap_message *m
 	if (msg->body.search.attrs == NULL)
 		goto fail;
 
-	if (ber_scanf_elements(msg->body.search.attrs, "{s(e)}e",
+	if (ober_scanf_elements(msg->body.search.attrs, "{s(e)}e",
 	    &key, &b, &c) != 0)
 		goto fail;
 
@@ -619,10 +619,10 @@ aldap_next_attr(struct aldap_message *ms
 
 	LDAP_DEBUG("attr", msg->body.search.iter);
 
-	if (ber_get_eoc(msg->body.search.iter) == 0)
+	if (ober_get_eoc(msg->body.search.iter) == 0)
 		goto notfound;
 
-	if (ber_scanf_elements(msg->body.search.iter, "{s(e)}e", &key, &a, &b)
+	if (ober_scanf_elements(msg->body.search.iter, "{s(e)}e", &key, &a, &b)
 	    != 0)
 		goto fail;
 
@@ -658,9 +658,9 @@ aldap_match_attr(struct aldap_message *m
 	for (a = msg->body.search.attrs;;) {
 		if (a == NULL)
 			goto notfound;
-		if (ber_get_eoc(a) == 0)
+		if (ober_get_eoc(a) == 0)
 			goto notfound;
-		if (ber_scanf_elements(a, "{s(e", &descr, &b) != 0)
+		if (ober_scanf_elements(a, "{s(e", &descr, &b) != 0)
 			goto fail;
 		if (strcasecmp(descr, inkey) == 0)
 			goto attrfound;
@@ -864,7 +864,7 @@ aldap_get_stringset(struct ber_element *
 
 	for (a = elm, i = 0; a != NULL && a->be_type == BER_TYPE_OCTETSTRING;
 	    a = a->be_next, i++)
-		(void) ber_get_ostring(a, &(ret->str[i]));
+		(void) ober_get_ostring(a, &(ret->str[i]));
 
 	return ret;
 }
@@ -893,8 +893,8 @@ ldap_parse_search_filter(struct ber_elem
 		return (NULL);
 
 	if (*cp != '\0') {
-		ber_free_elements(elm);
-		ber_link_elements(ber, NULL);
+		ober_free_elements(elm);
+		ober_link_elements(ber, NULL);
 		errno = EINVAL;
 		return (NULL);
 	}
@@ -941,10 +941,10 @@ ldap_do_parse_search_filter(struct ber_e
 		else
 			type = LDAP_FILT_OR;
 
-		if ((elm = ber_add_set(prev)) == NULL)
+		if ((elm = ober_add_set(prev)) == NULL)
 			goto callfail;
 		root = elm;
-		ber_set_header(elm, BER_CLASS_CONTEXT, type);
+		ober_set_header(elm, BER_CLASS_CONTEXT, type);
 
 		if (*++cp != '(')		/* opening `(` of filter */
 			goto syntaxfail;
@@ -960,9 +960,9 @@ ldap_do_parse_search_filter(struct ber_e
 		break;
 
 	case '!':		/* NOT */
-		if ((root = ber_add_sequence(prev)) == NULL)
+		if ((root = ober_add_sequence(prev)) == NULL)
 			goto callfail;
-		ber_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_NOT);
+		ober_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_NOT);
 
 		cp++;				/* now points to sub-filter */
 		if ((elm = ldap_do_parse_search_filter(root, &cp)) == NULL)
@@ -1004,18 +1004,18 @@ ldap_do_parse_search_filter(struct ber_e
 		if (strncmp(attr_val, "*)", 2) == 0) {
 			cp++;			/* point to trailing `)` */
 			if ((root =
-			    ber_add_nstring(prev, attr_desc, len)) == NULL)
+			    ober_add_nstring(prev, attr_desc, len)) == NULL)
 				goto bad;
 
-			ber_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_PRES);
+			ober_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_PRES);
 			break;
 		}
 
-		if ((root = ber_add_sequence(prev)) == NULL)
+		if ((root = ober_add_sequence(prev)) == NULL)
 			goto callfail;
-		ber_set_header(root, BER_CLASS_CONTEXT, type);
+		ober_set_header(root, BER_CLASS_CONTEXT, type);
 
-		if ((elm = ber_add_nstring(root, attr_desc, len)) == NULL)
+		if ((elm = ober_add_nstring(root, attr_desc, len)) == NULL)
 			goto callfail;
 
 		len = strcspn(attr_val, "*)");
@@ -1030,9 +1030,9 @@ ldap_do_parse_search_filter(struct ber_e
 
 			cp = attr_val;
 
-			ber_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_SUBS);
+			ober_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_SUBS);
 
-			if ((elm = ber_add_sequence(elm)) == NULL)
+			if ((elm = ober_add_sequence(elm)) == NULL)
 				goto callfail;
 
 			for (initial = 1;; cp++, initial = 0) {
@@ -1059,12 +1059,12 @@ ldap_do_parse_search_filter(struct ber_e
 				if ((parsed_val = parseval(attr_val, len)) ==
 				    NULL)
 					goto callfail;
-				elm = ber_add_nstring(elm, parsed_val,
+				elm = ober_add_nstring(elm, parsed_val,
 				    strlen(parsed_val));
 				free(parsed_val);
 				if (elm == NULL)
 					goto callfail;
-				ber_set_header(elm, BER_CLASS_CONTEXT, type);
+				ober_set_header(elm, BER_CLASS_CONTEXT, type);
 				if (type == LDAP_FILT_SUBS_FIN)
 					break;
 			}
@@ -1073,7 +1073,7 @@ ldap_do_parse_search_filter(struct ber_e
 
 		if ((parsed_val = parseval(attr_val, len)) == NULL)
 			goto callfail;
-		elm = ber_add_nstring(elm, parsed_val, strlen(parsed_val));
+		elm = ober_add_nstring(elm, parsed_val, strlen(parsed_val));
 		free(parsed_val);
 		if (elm == NULL)
 			goto callfail;
@@ -1089,8 +1089,8 @@ syntaxfail:		/* XXX -- error reporting *
 callfail:
 bad:
 	if (root != NULL)
-		ber_free_elements(root);
-	ber_link_elements(prev, NULL);
+		ober_free_elements(root);
+	ober_link_elements(prev, NULL);
 	return (NULL);
 }
 
@@ -1112,7 +1112,7 @@ ldap_debug_elements(struct ber_element *
 	struct ber_oid	 o;
 
 	/* calculate lengths */
-	ber_calc_len(root);
+	ober_calc_len(root);
 
 	switch (root->be_encoding) {
 	case BER_TYPE_SEQUENCE:
@@ -1242,28 +1242,28 @@ ldap_debug_elements(struct ber_element *
 
 	switch (root->be_encoding) {
 	case BER_TYPE_BOOLEAN:
-		if (ber_get_boolean(root, &d) == -1) {
+		if (ober_get_boolean(root, &d) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "%s(%d)\n", d ? "true" : "false", d);
 		break;
 	case BER_TYPE_INTEGER:
-		if (ber_get_integer(root, &v) == -1) {
+		if (ober_get_integer(root, &v) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "value %lld\n", v);
 		break;
 	case BER_TYPE_ENUMERATED:
-		if (ber_get_enumerated(root, &v) == -1) {
+		if (ober_get_enumerated(root, &v) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "value %lld\n", v);
 		break;
 	case BER_TYPE_BITSTRING:
-		if (ber_get_bitstring(root, (void *)&buf, &len) == -1) {
+		if (ober_get_bitstring(root, (void *)&buf, &len) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
@@ -1273,14 +1273,14 @@ ldap_debug_elements(struct ber_element *
 		fprintf(stderr, "\n");
 		break;
 	case BER_TYPE_OBJECT:
-		if (ber_get_oid(root, &o) == -1) {
+		if (ober_get_oid(root, &o) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "\n");
 		break;
 	case BER_TYPE_OCTETSTRING:
-		if (ber_get_nstring(root, (void *)&buf, &len) == -1) {
+		if (ober_get_nstring(root, (void *)&buf, &len) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
Index: usr.bin/snmp/smi.c
===================================================================
RCS file: /cvs/src/usr.bin/snmp/smi.c,v
retrieving revision 1.5
diff -u -p -r1.5 smi.c
--- usr.bin/snmp/smi.c	11 Oct 2019 14:48:30 -0000	1.5
+++ usr.bin/snmp/smi.c	24 Oct 2019 13:58:18 -0000
@@ -65,7 +65,7 @@ smi_debug_elements(struct ber_element *r
 	int		 constructed;
 
 	/* calculate lengths */
-	ber_calc_len(root);
+	ober_calc_len(root);
 
 	switch (root->be_encoding) {
 	case BER_TYPE_SEQUENCE:
@@ -251,7 +251,7 @@ smi_print_element(struct ber_element *ro
 
 	switch (root->be_encoding) {
 	case BER_TYPE_BOOLEAN:
-		if (ber_get_boolean(root, &d) == -1)
+		if (ober_get_boolean(root, &d) == -1)
 			goto fail;
 		if (print_hint) {
 			if (asprintf(&str, "INTEGER: %s(%d)",
@@ -263,7 +263,7 @@ smi_print_element(struct ber_element *ro
 		break;
 	case BER_TYPE_INTEGER:
 	case BER_TYPE_ENUMERATED:
-		if (ber_get_integer(root, &v) == -1)
+		if (ober_get_integer(root, &v) == -1)
 			goto fail;
 		if (root->be_class == BER_CLASS_APPLICATION &&
 		    root->be_type == SNMP_T_TIMETICKS) {
@@ -333,7 +333,7 @@ smi_print_element(struct ber_element *ro
 			goto fail;
 		break;
 	case BER_TYPE_BITSTRING:
-		if (ber_get_bitstring(root, (void *)&buf, &len) == -1)
+		if (ober_get_bitstring(root, (void *)&buf, &len) == -1)
 			goto fail;
 		slen = len * 2 + 1 + sizeof("BITS: ");
 		if ((str = calloc(1, slen)) == NULL)
@@ -349,7 +349,7 @@ smi_print_element(struct ber_element *ro
 		}
 		break;
 	case BER_TYPE_OBJECT:
-		if (ber_get_oid(root, &o) == -1)
+		if (ober_get_oid(root, &o) == -1)
 			goto fail;
 		if (asprintf(&str, "%s%s",
 		    print_hint ? "OID: " : "",
@@ -357,7 +357,7 @@ smi_print_element(struct ber_element *ro
 			goto fail;
 		break;
 	case BER_TYPE_OCTETSTRING:
-		if (ber_get_string(root, &buf) == -1)
+		if (ober_get_string(root, &buf) == -1)
 			goto fail;
 		if (root->be_class == BER_CLASS_APPLICATION &&
 		    root->be_type == SNMP_T_IPADDR) {
@@ -471,7 +471,7 @@ smi_string2oid(const char *oidstr, struc
 
 	/*
 	 * Parse OID strings in the common form n.n.n or n-n-n.
-	 * Based on ber_string2oid with additional support for symbolic names.
+	 * Based on ober_string2oid with additional support for symbolic names.
 	 */
 	p = sp = str[0] == '.' ? str + 1 : str;
 	for (; p != NULL; sp = p) {
@@ -479,7 +479,7 @@ smi_string2oid(const char *oidstr, struc
 			*p++ = '\0';
 		if ((oid = smi_findkey(sp)) != NULL) {
 			bcopy(&oid->o_id, &ko, sizeof(ko));
-			if (o->bo_n && ber_oid_cmp(o, &ko) != 2)
+			if (o->bo_n && ober_oid_cmp(o, &ko) != 2)
 				return (-1);
 			bcopy(&ko, o, sizeof(*o));
 			errstr = NULL;
Index: usr.bin/snmp/snmp.c
===================================================================
RCS file: /cvs/src/usr.bin/snmp/snmp.c,v
retrieving revision 1.8
diff -u -p -r1.8 snmp.c
--- usr.bin/snmp/snmp.c	8 Oct 2019 10:00:42 -0000	1.8
+++ usr.bin/snmp/snmp.c	24 Oct 2019 13:58:18 -0000
@@ -152,19 +152,19 @@ snmp_get(struct snmp_agent *agent, struc
 	struct ber_element *pdu, *varbind;
 	size_t i;
 
-	if ((pdu = ber_add_sequence(NULL)) == NULL)
+	if ((pdu = ober_add_sequence(NULL)) == NULL)
 		return NULL;
-	if ((varbind = ber_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
+	if ((varbind = ober_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
 	    SNMP_C_GETREQ, arc4random() & 0x7fffffff, 0, 0)) == NULL)
 		goto fail;
 	for (i = 0; i < len; i++)
-		varbind = ber_printf_elements(varbind, "{O0}", &oid[i]);
+		varbind = ober_printf_elements(varbind, "{O0}", &oid[i]);
 		if (varbind == NULL)
 			goto fail;
 
 	return snmp_resolve(agent, pdu, 1);
 fail:
-	ber_free_elements(pdu);
+	ober_free_elements(pdu);
 	return NULL;
 }
 
@@ -174,19 +174,19 @@ snmp_getnext(struct snmp_agent *agent, s
 	struct ber_element *pdu, *varbind;
 	size_t i;
 
-	if ((pdu = ber_add_sequence(NULL)) == NULL)
+	if ((pdu = ober_add_sequence(NULL)) == NULL)
 		return NULL;
-	if ((varbind = ber_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
+	if ((varbind = ober_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
 	    SNMP_C_GETNEXTREQ, arc4random() & 0x7fffffff, 0, 0)) == NULL)
 		goto fail;
 	for (i = 0; i < len; i++)
-		varbind = ber_printf_elements(varbind, "{O0}", &oid[i]);
+		varbind = ober_printf_elements(varbind, "{O0}", &oid[i]);
 		if (varbind == NULL)
 			goto fail;
 
 	return snmp_resolve(agent, pdu, 1);
 fail:
-	ber_free_elements(pdu);
+	ober_free_elements(pdu);
 	return NULL;
 }
 
@@ -198,9 +198,9 @@ snmp_trap(struct snmp_agent *agent, stru
 	struct ber_oid sysuptime, trap;
 	long long ticks;
 
-	if ((pdu = ber_add_sequence(NULL)) == NULL)
+	if ((pdu = ober_add_sequence(NULL)) == NULL)
 		return -1;
-	if ((varbind = ber_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
+	if ((varbind = ober_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
 	    SNMP_C_TRAPV2, arc4random() & 0x7fffffff, 0, 0)) == NULL)
 		goto fail;
 
@@ -208,20 +208,20 @@ snmp_trap(struct snmp_agent *agent, stru
 	ticks += uptime->tv_nsec / 10000000;
 	if (smi_string2oid("sysUpTime.0", &sysuptime) == -1)
 		goto fail;
-	if ((varbind = ber_printf_elements(varbind, "{Oit}", &sysuptime, ticks,
+	if ((varbind = ober_printf_elements(varbind, "{Oit}", &sysuptime, ticks,
 	    BER_CLASS_APPLICATION, SNMP_T_TIMETICKS)) == NULL)
 		goto fail;
 	if (smi_string2oid("snmpTrapOID.0", &trap) == -1)
 		goto fail;
-	if ((varbind = ber_printf_elements(varbind, "{OO}", &trap, oid)) == NULL)
+	if ((varbind = ober_printf_elements(varbind, "{OO}", &trap, oid)) == NULL)
 		goto fail;
 	if (custvarbind != NULL)
-		ber_link_elements(varbind, custvarbind);
+		ober_link_elements(varbind, custvarbind);
 
 	snmp_resolve(agent, pdu, 0);
 	return 0;
 fail:
-	ber_free_elements(pdu);
+	ober_free_elements(pdu);
 	return -1;
 }
 
@@ -232,20 +232,20 @@ snmp_getbulk(struct snmp_agent *agent, s
 	struct ber_element *pdu, *varbind;
 	size_t i;
 
-	if ((pdu = ber_add_sequence(NULL)) == NULL)
+	if ((pdu = ober_add_sequence(NULL)) == NULL)
 		return NULL;
-	if ((varbind = ber_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
+	if ((varbind = ober_printf_elements(pdu, "tddd{", BER_CLASS_CONTEXT,
 	    SNMP_C_GETBULKREQ, arc4random() & 0x7fffffff, non_repeaters,
 	    max_repetitions)) == NULL)
 		goto fail;
 	for (i = 0; i < len; i++)
-		varbind = ber_printf_elements(varbind, "{O0}", &oid[i]);
+		varbind = ober_printf_elements(varbind, "{O0}", &oid[i]);
 		if (varbind == NULL)
 			goto fail;
 
 	return snmp_resolve(agent, pdu, 1);
 fail:
-	ber_free_elements(pdu);
+	ober_free_elements(pdu);
 	return NULL;
 }
 
@@ -254,12 +254,12 @@ snmp_set(struct snmp_agent *agent, struc
 {
 	struct ber_element *pdu;
 
-	if ((pdu = ber_add_sequence(NULL)) == NULL)
+	if ((pdu = ober_add_sequence(NULL)) == NULL)
 		return NULL;
-	if (ber_printf_elements(pdu, "tddd{e", BER_CLASS_CONTEXT,
+	if (ober_printf_elements(pdu, "tddd{e", BER_CLASS_CONTEXT,
 	    SNMP_C_SETREQ, arc4random() & 0x7fffffff, 0, 0, vblist) == NULL) {
-		ber_free_elements(pdu);
-		ber_free_elements(vblist);
+		ober_free_elements(pdu);
+		ober_free_elements(vblist);
 		return NULL;
 	}
 
@@ -281,9 +281,9 @@ snmp_resolve(struct snmp_agent *agent, s
 	int tries;
 	char buf[READ_BUF_SIZE];
 
-	if (ber_scanf_elements(pdu, "{i", &reqid) != 0) {
+	if (ober_scanf_elements(pdu, "{i", &reqid) != 0) {
 		errno = EINVAL;
-		ber_free_elements(pdu);
+		ober_free_elements(pdu);
 		return NULL;
 	}
 
@@ -340,7 +340,7 @@ snmp_resolve(struct snmp_agent *agent, s
 			continue;
 		}
 		/* Validate pdu format and check request id */
-		if (ber_scanf_elements(pdu, "{iSSe", &rreqid, &varbind) != 0 ||
+		if (ober_scanf_elements(pdu, "{iSSe", &rreqid, &varbind) != 0 ||
 		    varbind->be_encoding != BER_TYPE_SEQUENCE) {
 			errno = EPROTO;
 			direction = POLLOUT;
@@ -355,7 +355,7 @@ snmp_resolve(struct snmp_agent *agent, s
 		}
 		for (varbind = varbind->be_sub; varbind != NULL;
 		    varbind = varbind->be_next) {
-			if (ber_scanf_elements(varbind, "{oS}", &oid) != 0) {
+			if (ober_scanf_elements(varbind, "{oS}", &oid) != 0) {
 				errno = EPROTO;
 				direction = POLLOUT;
 				tries--;
@@ -384,68 +384,68 @@ snmp_package(struct snmp_agent *agent, s
 	void *cookie = NULL;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_application(&ber, smi_application);
+	ober_set_application(&ber, smi_application);
 
-	if ((message = ber_add_sequence(NULL)) == NULL) {
-		ber_free_elements(pdu);
+	if ((message = ober_add_sequence(NULL)) == NULL) {
+		ober_free_elements(pdu);
 		goto fail;
 	}
 
 	switch (agent->version) {
 	case SNMP_V1:
 	case SNMP_V2C:
-		if (ber_printf_elements(message, "dse", agent->version,
+		if (ober_printf_elements(message, "dse", agent->version,
 		    agent->community, pdu) == NULL) {
-			ber_free_elements(pdu);
+			ober_free_elements(pdu);
 			goto fail;
 		}
 		break;
 	case SNMP_V3:
 		msgid = arc4random_uniform(2147483647);
-		if ((scopedpdu = ber_add_sequence(NULL)) == NULL) {
-			ber_free_elements(pdu);
+		if ((scopedpdu = ober_add_sequence(NULL)) == NULL) {
+			ober_free_elements(pdu);
 			goto fail;
 		}
-		if (ber_printf_elements(scopedpdu, "xxe",
+		if (ober_printf_elements(scopedpdu, "xxe",
 		    agent->v3->engineid, agent->v3->engineidlen,
 		    agent->v3->ctxname, agent->v3->ctxnamelen, pdu) == NULL) {
-			ber_free_elements(pdu);
-			ber_free_elements(scopedpdu);
+			ober_free_elements(pdu);
+			ober_free_elements(scopedpdu);
 			goto fail;
 		}
 		pdu = NULL;
 		if ((securityparams = agent->v3->sec->genparams(agent,
 		    &securitysize, &cookie)) == NULL) {
-			ber_free_elements(scopedpdu);
+			ober_free_elements(scopedpdu);
 			goto fail;
 		}
 		if (agent->v3->level & SNMP_MSGFLAG_PRIV) {
 			if ((encpdu = agent->v3->sec->encpdu(agent, scopedpdu,
 			    cookie)) == NULL)
 				goto fail;
-			ber_free_elements(scopedpdu);
+			ober_free_elements(scopedpdu);
 			scopedpdu = encpdu;
 		}
-		if (ber_printf_elements(message, "d{idxd}xe",
+		if (ober_printf_elements(message, "d{idxd}xe",
 		    agent->version, msgid, UDP_MAXPACKET, &(agent->v3->level),
 		    (size_t) 1, agent->v3->sec->model, securityparams,
 		    securitysize, scopedpdu) == NULL) {
-			ber_free_elements(scopedpdu);
+			ober_free_elements(scopedpdu);
 			goto fail;
 		}
-		if (ber_scanf_elements(message, "{SSe", &secparams) == -1)
+		if (ober_scanf_elements(message, "{SSe", &secparams) == -1)
 			goto fail;
-		ber_set_writecallback(secparams, snmp_v3_secparamsoffset,
+		ober_set_writecallback(secparams, snmp_v3_secparamsoffset,
 		    &secparamsoffset);
 		break;
 	}
 
-	if (ber_write_elements(&ber, message) == -1)
+	if (ober_write_elements(&ber, message) == -1)
 		goto fail;
 	ret = ber_copy_writebuf(&ber, (void **)&packet);
 
 	*len = (size_t) ret;
-	ber_free(&ber);
+	ober_free(&ber);
 
 	if (agent->version == SNMP_V3 && packet != NULL) {
 		if (agent->v3->sec->finalparams(agent, packet,
@@ -458,7 +458,7 @@ snmp_package(struct snmp_agent *agent, s
 fail:
 	if (agent->version == SNMP_V3)
 		agent->v3->sec->freecookie(cookie);
-	ber_free_elements(message);
+	ober_free_elements(message);
 	free(securityparams);
 	return packet;
 }
@@ -481,14 +481,14 @@ snmp_unpackage(struct snmp_agent *agent,
 	void *cookie = NULL;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_application(&ber, smi_application);
+	ober_set_application(&ber, smi_application);
 
-	ber_set_readbuf(&ber, buf, buflen);
-	if ((message = ber_read_elements(&ber, NULL)) == NULL)
+	ober_set_readbuf(&ber, buf, buflen);
+	if ((message = ober_read_elements(&ber, NULL)) == NULL)
 		return NULL;
-	ber_free(&ber);
+	ober_free(&ber);
 
-	if (ber_scanf_elements(message, "{de", &version, &payload) != 0)
+	if (ober_scanf_elements(message, "{de", &version, &payload) != 0)
 		goto fail;
 
 	if (version != agent->version)
@@ -497,15 +497,15 @@ snmp_unpackage(struct snmp_agent *agent,
 	switch (version) {
 	case SNMP_V1:
 	case SNMP_V2C:
-		if (ber_scanf_elements(payload, "se", &community, &pdu) == -1)
+		if (ober_scanf_elements(payload, "se", &community, &pdu) == -1)
 			goto fail;
 		if (strcmp(community, agent->community) != 0)
 			goto fail;
-		ber_unlink_elements(payload);
-		ber_free_elements(message);
+		ober_unlink_elements(payload);
+		ober_free_elements(message);
 		return pdu;
 	case SNMP_V3:
-		if (ber_scanf_elements(payload, "{idxi}pxe", &msgid, &msgsz,
+		if (ober_scanf_elements(payload, "{idxi}pxe", &msgid, &msgsz,
 		    &msgflags, &msgflagslen, &model, &secparamsoffset,
 		    &secparams, &secparamslen, &scopedpdu) == -1)
 			goto fail;
@@ -518,14 +518,14 @@ snmp_unpackage(struct snmp_agent *agent,
 			goto fail;
 		}
 		if (msgflags[0] & SNMP_MSGFLAG_PRIV) {
-			if (ber_scanf_elements(scopedpdu, "x", &encpdu,
+			if (ober_scanf_elements(scopedpdu, "x", &encpdu,
 			    &encpdulen) == -1)
 				goto fail;
 			if ((scopedpdu = agent->v3->sec->decpdu(agent, encpdu,
 			    encpdulen, cookie)) == NULL)
 				goto fail;
 		}
-		if (ber_scanf_elements(scopedpdu, "{xeS{", &engineid,
+		if (ober_scanf_elements(scopedpdu, "{xeS{", &engineid,
 		    &engineidlen, &ctxname) == -1)
 			goto fail;
 		if (!agent->v3->engineidset) {
@@ -533,7 +533,7 @@ snmp_unpackage(struct snmp_agent *agent,
 			    engineidlen) == -1)
 				goto fail;
 		}
-		pdu = ber_unlink_elements(ctxname);
+		pdu = ober_unlink_elements(ctxname);
 		/* Accept reports, so we can continue if possible */
 		if (pdu->be_type != SNMP_C_REPORT) {
 			if ((msgflags[0] & SNMP_MSGFLAG_SECMASK) !=
@@ -541,7 +541,7 @@ snmp_unpackage(struct snmp_agent *agent,
 				goto fail;
 		}
 
-		ber_free_elements(message);
+		ober_free_elements(message);
 		agent->v3->sec->freecookie(cookie);
 		return pdu;
 	}
@@ -550,7 +550,7 @@ snmp_unpackage(struct snmp_agent *agent,
 fail:
 	if (version == SNMP_V3)
 		agent->v3->sec->freecookie(cookie);
-	ber_free_elements(message);
+	ober_free_elements(message);
 	return NULL;
 }
 
@@ -569,7 +569,7 @@ ber_copy_writebuf(struct ber *ber, void 
 	ssize_t ret;
 
 	*buf = NULL;
-	if ((ret = ber_get_writebuf(ber, (void **)&bbuf)) == -1)
+	if ((ret = ober_get_writebuf(ber, (void **)&bbuf)) == -1)
 		return -1;
 	if ((*buf = malloc(ret)) == NULL)
 		return -1;
Index: usr.bin/snmp/snmpc.c
===================================================================
RCS file: /cvs/src/usr.bin/snmp/snmpc.c,v
retrieving revision 1.15
diff -u -p -r1.15 snmpc.c
--- usr.bin/snmp/snmpc.c	8 Oct 2019 08:41:31 -0000	1.15
+++ usr.bin/snmp/snmpc.c	24 Oct 2019 13:58:18 -0000
@@ -520,7 +520,7 @@ snmpc_get(int argc, char *argv[])
 			err(1, "get");
 	}
 
-	(void) ber_scanf_elements(pdu, "t{Sdd{e", &class, &type, &errorstatus,
+	(void) ober_scanf_elements(pdu, "t{Sdd{e", &class, &type, &errorstatus,
 	    &errorindex, &varbind);
 	if (errorstatus != 0) {
 		if (errorindex >= 1 && errorindex <= argc)
@@ -535,7 +535,7 @@ snmpc_get(int argc, char *argv[])
 		if (!snmpc_print(varbind))
 			err(1, "Can't print response");
 	}
-	ber_free_elements(pdu);
+	ober_free_elements(pdu);
 	snmp_free_agent(agent);
 	return 0;
 }
@@ -576,7 +576,7 @@ snmpc_walk(int argc, char *argv[])
 		if ((pdu = snmp_get(agent, &oid, 1)) == NULL)
 			err(1, "%s", snmp_app->name);
 
-		(void) ber_scanf_elements(pdu, "t{Sdd{e", &class, &type,
+		(void) ober_scanf_elements(pdu, "t{Sdd{e", &class, &type,
 		    &errorstatus, &errorindex, &varbind);
 		if (errorstatus != 0)
 			snmpc_printerror((enum snmp_error) errorstatus, varbind,
@@ -586,7 +586,7 @@ snmpc_walk(int argc, char *argv[])
 			printf("Received report:\n");
 		if (!snmpc_print(varbind))
 			err(1, "Can't print response");
-		ber_free_element(pdu);
+		ober_free_element(pdu);
 		if (class == BER_CLASS_CONTEXT && type == SNMP_C_REPORT)
 			return 1;
 		n++;
@@ -602,7 +602,7 @@ snmpc_walk(int argc, char *argv[])
 				err(1, "walk");
 		}
 
-		(void) ber_scanf_elements(pdu, "t{Sdd{e", &class, &type,
+		(void) ober_scanf_elements(pdu, "t{Sdd{e", &class, &type,
 		    &errorstatus, &errorindex, &varbind);
 		if (errorstatus != 0) {
 			snmpc_printerror((enum snmp_error) errorstatus, varbind,
@@ -612,25 +612,25 @@ snmpc_walk(int argc, char *argv[])
 		if (class == BER_CLASS_CONTEXT && type == SNMP_C_REPORT)
 			printf("Received report:\n");
 		for (; varbind != NULL; varbind = varbind->be_next) {
-			(void) ber_scanf_elements(varbind, "{oe}", &noid,
+			(void) ober_scanf_elements(varbind, "{oe}", &noid,
 			    &value);
 			if (value->be_class == BER_CLASS_CONTEXT &&
 			    value->be_type == BER_TYPE_EOC)
 				break;
-			prev_cmp = ber_oid_cmp(&loid, &noid);
+			prev_cmp = ober_oid_cmp(&loid, &noid);
 			if (walk_check_increase && prev_cmp == -1)
 				errx(1, "OID not increasing");
-			if (prev_cmp == 0 || ber_oid_cmp(&oid, &noid) != 2)
+			if (prev_cmp == 0 || ober_oid_cmp(&oid, &noid) != 2)
 				break;
 			if (walk_end.bo_n != 0 &&
-			    ber_oid_cmp(&walk_end, &noid) != -1)
+			    ober_oid_cmp(&walk_end, &noid) != -1)
 				break;
 
 			if (!snmpc_print(varbind))
 				err(1, "Can't print response");
 			n++;
 		}
-		ber_free_elements(pdu);
+		ober_free_elements(pdu);
 		if (class == BER_CLASS_CONTEXT && type == SNMP_C_REPORT)
 			return 1;
 		if (varbind != NULL)
@@ -640,7 +640,7 @@ snmpc_walk(int argc, char *argv[])
 		if ((pdu = snmp_get(agent, &oid, 1)) == NULL)
 			err(1, "%s", snmp_app->name);
 
-		(void) ber_scanf_elements(pdu, "t{Sdd{e", &class, &type,
+		(void) ober_scanf_elements(pdu, "t{Sdd{e", &class, &type,
 		    &errorstatus, &errorindex, &varbind);
 		if (errorstatus != 0)
 			snmpc_printerror((enum snmp_error) errorstatus, varbind,
@@ -650,7 +650,7 @@ snmpc_walk(int argc, char *argv[])
 			printf("Received report:\n");
 		if (!snmpc_print(varbind))
 			err(1, "Can't print response");
-		ber_free_element(pdu);
+		ober_free_element(pdu);
 		if (class == BER_CLASS_CONTEXT && type == SNMP_C_REPORT)
 			return 1;
 		n++;
@@ -695,7 +695,7 @@ snmpc_set(int argc, char *argv[])
 	if ((pdu = snmp_set(agent, snmpc_varbindparse(argc, argv))) == NULL)
 		err(1, "set");
 
-	(void) ber_scanf_elements(pdu, "t{Sdd{e", &class, &type, &errorstatus,
+	(void) ober_scanf_elements(pdu, "t{Sdd{e", &class, &type, &errorstatus,
 	    &errorindex, &varbind);
 	if (errorstatus != 0) {
 		if (errorindex >= 1 && errorindex <= argc / 3)
@@ -710,7 +710,7 @@ snmpc_set(int argc, char *argv[])
 		if (!snmpc_print(varbind))
 			err(1, "Can't print response");
 	}
-	ber_free_elements(pdu);
+	ober_free_elements(pdu);
 	snmp_free_agent(agent);
 	return 0;
 }
@@ -789,7 +789,7 @@ snmpc_print(struct ber_element *elm)
 	char *value;
 
 	elm = elm->be_sub;
-	if (ber_get_oid(elm, &oid) != 0) {
+	if (ober_get_oid(elm, &oid) != 0) {
 		errno = EINVAL;
 		return 0;
 	}
@@ -828,11 +828,11 @@ snmpc_printerror(enum snmp_error error, 
 		    varbind = varbind->be_next)
 			i++;
 		if (varbind != NULL &&
-		    ber_get_oid(varbind->be_sub, &vboid) == 0) {
+		    ober_get_oid(varbind->be_sub, &vboid) == 0) {
 			/* If user and reply conform print user input */
 			if (hint != NULL &&
 			    smi_string2oid(hint, &hoid) == 0 &&
-			    ber_oid_cmp(&hoid, &vboid) == 0)
+			    ober_oid_cmp(&hoid, &vboid) == 0)
 				oid = hint;
 			else
 				oid = smi_oid2string(&vboid, oids,
@@ -1056,10 +1056,10 @@ snmpc_varbindparse(int argc, char *argv[
 			if (ret == 0)
 				errx(1, "%s: Bad value notation (%s)", argv[i],
 				    argv[i + 2]);
-			if ((varbind = ber_printf_elements(varbind, "{Oxt}",
+			if ((varbind = ober_printf_elements(varbind, "{Oxt}",
 			    &oid, addr, sizeof(addr4), BER_CLASS_APPLICATION,
 			    SNMP_T_IPADDR)) == NULL)
-				err(1, "ber_printf_elements");
+				err(1, "ober_printf_elements");
 			break;
 		case 'b':
 			tmpstr = argv[i + 2];
@@ -1098,10 +1098,10 @@ snmpc_varbindparse(int argc, char *argv[
 			if (errstr != NULL)
 				errx(1, "%s: Bad value notation (%s)", argv[i],
 				    argv[i + 2]);
-			if ((varbind = ber_printf_elements(varbind, "{Oit}",
+			if ((varbind = ober_printf_elements(varbind, "{Oit}",
 			    &oid, lval, BER_CLASS_APPLICATION,
 			    SNMP_T_COUNTER32)) == NULL)
-				err(1, "ber_printf_elements");
+				err(1, "ober_printf_elements");
 			break;
 		case 'd':
 			/* String always shrinks */
@@ -1133,32 +1133,32 @@ snmpc_varbindparse(int argc, char *argv[
 			if (errstr != NULL)
 				errx(1, "%s: Bad value notation (%s)", argv[i],
 				    argv[i + 2]);
-			if ((varbind = ber_printf_elements(varbind, "{Oi}",
+			if ((varbind = ober_printf_elements(varbind, "{Oi}",
 			    &oid, lval)) == NULL)
-				err(1, "ber_printf_elements");
+				err(1, "ober_printf_elements");
 			break;
 		case 'n':
-			if ((varbind = ber_printf_elements(varbind, "{O0}",
+			if ((varbind = ober_printf_elements(varbind, "{O0}",
 			    &oid)) == NULL)
-				err(1, "ber_printf_elements");
+				err(1, "ober_printf_elements");
 			break;
 		case 'o':
 			if (smi_string2oid(argv[i + 2], &oidval) == -1)
 				errx(1, "%s: Unknown Object Identifier (Sub-id "
 				    "not found: (top) -> %s)", argv[i],
 				    argv[i + 2]);
-			if ((varbind = ber_printf_elements(varbind, "{OO}",
+			if ((varbind = ober_printf_elements(varbind, "{OO}",
 			    &oid, &oidval)) == NULL)
-				err(1, "ber_printf_elements");
+				err(1, "ober_printf_elements");
 			break;
 		case 's':
 			if ((str = strdup(argv[i + 2])) == NULL)
 				err(1, NULL);
 			strl = strlen(argv[i + 2]);
 pastestring:
-			if ((varbind = ber_printf_elements(varbind, "{Ox}",
+			if ((varbind = ober_printf_elements(varbind, "{Ox}",
 			    &oid, str, strl)) == NULL)
-				err(1, "ber_printf_elements");
+				err(1, "ober_printf_elements");
 			free(str);
 			break;
 		case 't':
@@ -1167,10 +1167,10 @@ pastestring:
 			if (errstr != NULL)
 				errx(1, "%s: Bad value notation (%s)", argv[i],
 				    argv[i + 2]);
-			if ((varbind = ber_printf_elements(varbind, "{Oit}",
+			if ((varbind = ober_printf_elements(varbind, "{Oit}",
 			    &oid, lval, BER_CLASS_APPLICATION,
 			    SNMP_T_TIMETICKS)) == NULL)
-				err(1, "ber_printf_elements");
+				err(1, "ober_printf_elements");
 			break;
 		case 'x':
 			/* String always shrinks */
Index: usr.bin/snmp/usm.c
===================================================================
RCS file: /cvs/src/usr.bin/snmp/usm.c,v
retrieving revision 1.4
diff -u -p -r1.4 usm.c
--- usr.bin/snmp/usm.c	18 Sep 2019 09:59:05 -0000	1.4
+++ usr.bin/snmp/usm.c	24 Oct 2019 13:58:18 -0000
@@ -137,7 +137,7 @@ usm_doinit(struct snmp_agent *agent)
 		usm->userlen = userlen;
 		return -1;
 	}
-	ber_free_element(ber);
+	ober_free_element(ber);
 
 	agent->v3->level = level;
 	usm->userlen = userlen;
@@ -150,7 +150,7 @@ usm_doinit(struct snmp_agent *agent)
 	if (!usm->engineidset || !usm->bootsset || !usm->timeset) {
 		if ((ber = snmp_get(agent, NULL, 0)) == NULL)
 			return -1;
-		ber_free_element(ber);
+		ober_free_element(ber);
 	}
 	return 0;
 }
@@ -191,7 +191,7 @@ usm_genparams(struct snmp_agent *agent, 
 	if (agent->v3->level & SNMP_MSGFLAG_PRIV)
 	    saltlen = sizeof(usmcookie->salt);
 
-	if ((params = ber_printf_elements(NULL, "{xddxxx}", usm->engineid,
+	if ((params = ober_printf_elements(NULL, "{xddxxx}", usm->engineid,
 	    usm->engineidlen, usmcookie->boots, usmcookie->time, usm->user,
 	    usm->userlen, digest, digestlen, &(usmcookie->salt),
 	    saltlen)) == NULL) {
@@ -199,22 +199,22 @@ usm_genparams(struct snmp_agent *agent, 
 		return NULL;
 	}
 
-	if (ber_scanf_elements(params, "{SSSSe",  &digestelm) == -1) {
-		ber_free_element(params);
+	if (ober_scanf_elements(params, "{SSSSe",  &digestelm) == -1) {
+		ober_free_element(params);
 		free(usmcookie);
 		return NULL;
 	}
 
-	ber_set_writecallback(digestelm, usm_digest_pos, usmcookie);
+	ober_set_writecallback(digestelm, usm_digest_pos, usmcookie);
 
 	bzero(&ber, sizeof(ber));
-	ber_set_application(&ber, smi_application);
-	if (ber_write_elements(&ber, params) != -1)
+	ober_set_application(&ber, smi_application);
+	if (ober_write_elements(&ber, params) != -1)
 	    berlen = ber_copy_writebuf(&ber, (void **)&secparams);
 
 	*len = berlen;
-	ber_free_element(params);
-	ber_free(&ber);
+	ober_free_element(params);
+	ober_free(&ber);
 	return secparams;
 }
 
@@ -230,20 +230,20 @@ usm_encpdu(struct snmp_agent *agent, str
 	size_t encpdulen;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_application(&ber, smi_application);
-	pdulen = ber_write_elements(&ber, pdu);
+	ober_set_application(&ber, smi_application);
+	pdulen = ober_write_elements(&ber, pdu);
 	if (pdulen == -1)
 		return NULL;
 
-	ber_get_writebuf(&ber, (void **)&serialpdu);
+	ober_get_writebuf(&ber, (void **)&serialpdu);
 
 	encpdu = usm_crypt(usm->cipher, 1, usm->privkey, usmcookie, serialpdu,
 	    pdulen, &encpdulen);
-	ber_free(&ber);
+	ober_free(&ber);
 	if (encpdu == NULL)
 		return NULL;
 
-	retpdu = ber_add_nstring(NULL, encpdu, encpdulen);
+	retpdu = ober_add_nstring(NULL, encpdu, encpdulen);
 	free(encpdu);
 	return retpdu;
 }
@@ -346,17 +346,17 @@ usm_parseparams(struct snmp_agent *agent
 	bzero(&ber, sizeof(ber));
 	bzero(exp_digest, sizeof(exp_digest));
 
-	ber_set_application(&ber, smi_application);
-	ber_set_readbuf(&ber, buf, buflen);
-	if ((secparams = ber_read_elements(&ber, NULL)) == NULL)
+	ober_set_application(&ber, smi_application);
+	ober_set_readbuf(&ber, buf, buflen);
+	if ((secparams = ober_read_elements(&ber, NULL)) == NULL)
 		return -1;
-	ber_free(&ber);
+	ober_free(&ber);
 
 	if ((usmcookie = malloc(sizeof(*usmcookie))) == NULL)
 		goto fail;
 	*cookie = usmcookie;
 
-	if (ber_scanf_elements(secparams, "{xddxpxx}", &engineid, &engineidlen,
+	if (ober_scanf_elements(secparams, "{xddxpxx}", &engineid, &engineidlen,
 	    &(usmcookie->boots), &(usmcookie->time), &user, &userlen,
 	    &digestoffset, &digest, &digestlen, &salt, &saltlen) == -1)
 		goto fail;
@@ -437,12 +437,12 @@ usm_parseparams(struct snmp_agent *agent
 		if (digestlen != 0)
 			goto fail;
 
-	ber_free_element(secparams);
+	ober_free_element(secparams);
 	return 0;
 
 fail:
 	free(usmcookie);
-	ber_free_element(secparams);
+	ober_free_element(secparams);
 	return -1;
 }
 
@@ -461,10 +461,10 @@ usm_decpdu(struct snmp_agent *agent, cha
 		return NULL;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_application(&ber, smi_application);
-	ber_set_readbuf(&ber, rawpdu, rawpdulen);
-	scopedpdu = ber_read_elements(&ber, NULL);
-	ber_free(&ber);
+	ober_set_application(&ber, smi_application);
+	ober_set_readbuf(&ber, rawpdu, rawpdulen);
+	scopedpdu = ober_read_elements(&ber, NULL);
+	ober_free(&ber);
 	free(rawpdu);
 
 	return scopedpdu;
Index: usr.sbin/ldapctl/ldapctl.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapctl/ldapctl.c,v
retrieving revision 1.12
diff -u -p -r1.12 ldapctl.c
--- usr.sbin/ldapctl/ldapctl.c	27 Jun 2019 18:03:37 -0000	1.12
+++ usr.sbin/ldapctl/ldapctl.c	24 Oct 2019 13:58:18 -0000
@@ -196,7 +196,7 @@ index_namespace(struct namespace *ns, co
 			if ((elm = db2ber(&val, ns->compression_level)) == NULL)
 				continue;
 			rc = index_entry(ns, &key, elm);
-			ber_free_elements(elm);
+			ober_free_elements(elm);
 			btval_reset(&key);
 			btval_reset(&val);
 			if (rc != 0)
Index: usr.sbin/ldapd/attributes.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/attributes.c,v
retrieving revision 1.5
diff -u -p -r1.5 attributes.c
--- usr.sbin/ldapd/attributes.c	11 Feb 2017 20:40:03 -0000	1.5
+++ usr.sbin/ldapd/attributes.c	24 Oct 2019 13:58:18 -0000
@@ -39,7 +39,7 @@ ldap_get_attribute(struct ber_element *e
 
 	for (elm = entry->be_sub; elm != NULL; elm = elm->be_next) {
 		a = elm->be_sub;
-		if (a && ber_get_string(a, &s) == 0 && strcasecmp(s, attr) == 0)
+		if (a && ober_get_string(a, &s) == 0 && strcasecmp(s, attr) == 0)
 			return a;
 	}
 
@@ -72,7 +72,7 @@ ldap_find_value(struct ber_element *elm,
 		return NULL;
 
 	for (a = elm->be_sub; a != NULL; a = a->be_next) {
-		if (ber_get_string(a, &s) == 0 && strcasecmp(s, value) == 0)
+		if (ober_get_string(a, &s) == 0 && strcasecmp(s, value) == 0)
 			return a;
 	}
 
@@ -105,13 +105,13 @@ ldap_add_attribute(struct ber_element *e
 	else while (last != NULL && last->be_next != NULL)
 		last = last->be_next;
 
-	if ((elm = ber_add_sequence(last)) == NULL)
+	if ((elm = ober_add_sequence(last)) == NULL)
 		return NULL;
-	if ((a = ber_add_string(elm, attr)) == NULL) {
-		ber_free_elements(elm);
+	if ((a = ober_add_string(elm, attr)) == NULL) {
+		ober_free_elements(elm);
 		return NULL;
 	}
-	ber_link_elements(a, value_set);
+	ober_link_elements(a, value_set);
 
 	return elm;
 }
@@ -126,17 +126,17 @@ ldap_set_values(struct ber_element *elm,
 	assert(vals);
 	assert(vals->be_sub);
 
-	if (ber_scanf_elements(elm, "se(", &attr, &old_vals) != 0) {
+	if (ober_scanf_elements(elm, "se(", &attr, &old_vals) != 0) {
 		log_warnx("failed to parse element");
 		return -1;
 	}
 
-	ber_free_elements(old_vals->be_sub);
+	ober_free_elements(old_vals->be_sub);
 	old_vals->be_sub = NULL;
-	ber_link_elements(old_vals, vals->be_sub);
+	ober_link_elements(old_vals, vals->be_sub);
 
 	vals->be_sub = NULL;
-	ber_free_elements(vals);
+	ober_free_elements(vals);
 
 	return 0;
 }
@@ -152,7 +152,7 @@ ldap_merge_values(struct ber_element *el
 	assert(vals->be_type == BER_TYPE_SET);
 	assert(vals->be_sub);
 
-	if (ber_scanf_elements(elm, "se(", &attr, &old_vals) != 0) {
+	if (ober_scanf_elements(elm, "se(", &attr, &old_vals) != 0) {
 		log_warnx("failed to parse element");
 		return -1;
 	}
@@ -161,10 +161,10 @@ ldap_merge_values(struct ber_element *el
 	while (last && last->be_next)
 		last = last->be_next;
 
-	ber_link_elements(last, vals->be_sub);
+	ober_link_elements(last, vals->be_sub);
 
 	vals->be_sub = NULL;
-	ber_free_elements(vals);
+	ober_free_elements(vals);
 
 	return 0;
 }
@@ -181,7 +181,7 @@ ldap_del_attribute(struct ber_element *e
 
 	attr = entry->be_sub;
 	while (attr) {
-		if (ber_scanf_elements(attr, "{s(", &s) != 0) {
+		if (ober_scanf_elements(attr, "{s(", &s) != 0) {
 			log_warnx("failed to parse attribute");
 			return -1;
 		}
@@ -192,7 +192,7 @@ ldap_del_attribute(struct ber_element *e
 			else
 				prev->be_next = attr->be_next;
 			attr->be_next = NULL;
-			ber_free_elements(attr);
+			ober_free_elements(attr);
 			break;
 		}
 
@@ -214,7 +214,7 @@ ldap_del_values(struct ber_element *elm,
 	assert(vals);
 	assert(vals->be_sub);
 
-	if (ber_scanf_elements(elm, "se(", &attr, &old_vals) != 0) {
+	if (ober_scanf_elements(elm, "se(", &attr, &old_vals) != 0) {
 		log_warnx("failed to parse element");
 		return -1;
 	}
@@ -227,9 +227,9 @@ ldap_del_values(struct ber_element *elm,
 		for (x = vals->be_sub; x; x = x->be_next) {
 			if (x && v->be_len == x->be_len &&
 			    memcmp(v->be_val, x->be_val, x->be_len) == 0) {
-				removed = ber_unlink_elements(prev);
-				ber_link_elements(prev, removed->be_next);
-				ber_free_element(removed);
+				removed = ober_unlink_elements(prev);
+				ober_link_elements(prev, removed->be_next);
+				ober_free_element(removed);
 				removed_p = 1;
 				break;
 			}
Index: usr.sbin/ldapd/auth.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/auth.c,v
retrieving revision 1.13
diff -u -p -r1.13 auth.c
--- usr.sbin/ldapd/auth.c	14 May 2018 07:53:47 -0000	1.13
+++ usr.sbin/ldapd/auth.c	24 Oct 2019 13:58:18 -0000
@@ -259,7 +259,7 @@ ldap_auth_sasl(struct request *req, char
 	char			*creds;
 	size_t			 len;
 
-	if (ber_scanf_elements(params, "{sx", &method, &creds, &len) != 0)
+	if (ober_scanf_elements(params, "{sx", &method, &creds, &len) != 0)
 		return LDAP_PROTOCOL_ERROR;
 
 	if (strcmp(method, "PLAIN") != 0)
@@ -315,7 +315,7 @@ ldap_auth_simple(struct request *req, ch
 		return LDAP_CONFIDENTIALITY_REQUIRED;
 	}
 
-	if (ber_scanf_elements(auth, "s", &password) != 0)
+	if (ober_scanf_elements(auth, "s", &password) != 0)
 		return LDAP_PROTOCOL_ERROR;
 
 	if (*password == '\0') {
@@ -349,7 +349,7 @@ ldap_auth_simple(struct request *req, ch
 		if (pw != NULL) {
 			for (elm = pw->be_next->be_sub; elm;
 			    elm = elm->be_next) {
-				if (ber_get_string(elm, &user_password) != 0)
+				if (ober_get_string(elm, &user_password) != 0)
 					continue;
 				pwret = check_password(req, user_password, password);
 				if (pwret >= 1)
@@ -406,7 +406,7 @@ ldap_bind(struct request *req)
 
 	++stats.req_bind;
 
-	if (ber_scanf_elements(req->op, "{ise", &ver, &binddn, &auth) != 0) {
+	if (ober_scanf_elements(req->op, "{ise", &ver, &binddn, &auth) != 0) {
 		rc = LDAP_PROTOCOL_ERROR;
 		goto done;
 	}
Index: usr.sbin/ldapd/conn.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/conn.c,v
retrieving revision 1.17
diff -u -p -r1.17 conn.c
--- usr.sbin/ldapd/conn.c	31 Jul 2018 11:01:00 -0000	1.17
+++ usr.sbin/ldapd/conn.c	24 Oct 2019 13:58:18 -0000
@@ -42,7 +42,7 @@ void
 request_free(struct request *req)
 {
 	if (req->root != NULL)
-		ber_free_elements(req->root);
+		ober_free_elements(req->root);
 	free(req);
 }
 
@@ -66,7 +66,7 @@ conn_close(struct conn *conn)
 	tls_free(conn->tls);
 
 	TAILQ_REMOVE(&conn_list, conn, next);
-	ber_free(&conn->ber);
+	ober_free(&conn->ber);
 	if (conn->bev != NULL)
 		bufferevent_free(conn->bev);
 	close(conn->fd);
@@ -155,7 +155,7 @@ conn_dispatch(struct conn *conn)
 	req->conn = conn;
 	rptr = conn->ber.br_rptr;	/* save where we start reading */
 
-	if ((req->root = ber_read_elements(&conn->ber, NULL)) == NULL) {
+	if ((req->root = ober_read_elements(&conn->ber, NULL)) == NULL) {
 		if (errno != ECANCELED) {
 			log_warnx("protocol error");
 			hexdump(rptr, conn->ber.br_rend - rptr,
@@ -170,7 +170,7 @@ conn_dispatch(struct conn *conn)
 
 	/* Read message id and request type.
 	 */
-	if (ber_scanf_elements(req->root, "{ite",
+	if (ober_scanf_elements(req->root, "{ite",
 	    &req->msgid, &class, &req->type, &req->op) != 0) {
 		log_warnx("protocol error");
 		ldap_debug_elements(req->root, -1,
@@ -196,7 +196,7 @@ conn_read(struct bufferevent *bev, void 
 	struct evbuffer		*input;
 
 	input = EVBUFFER_INPUT(bev);
-	ber_set_readbuf(&conn->ber,
+	ober_set_readbuf(&conn->ber,
 	    EVBUFFER_DATA(input), EVBUFFER_LENGTH(input));
 
 	while (conn->ber.br_rend - conn->ber.br_rptr > 0) {
@@ -296,7 +296,7 @@ conn_accept(int fd, short event, void *d
 		log_warn("malloc");
 		goto giveup;
 	}
-	ber_set_application(&conn->ber, ldap_application);
+	ober_set_application(&conn->ber, ldap_application);
 	conn->fd = afd;
 	conn->listener = l;
 
Index: usr.sbin/ldapd/filter.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/filter.c,v
retrieving revision 1.8
diff -u -p -r1.8 filter.c
--- usr.sbin/ldapd/filter.c	27 Aug 2018 12:15:20 -0000	1.8
+++ usr.sbin/ldapd/filter.c	24 Oct 2019 13:58:18 -0000
@@ -54,7 +54,7 @@ ldap_filt_eq(struct ber_element *root, s
 		return -1;
 
 	for (v = vals->be_sub; v; v = v->be_next) {
-		if (ber_get_string(v, &vs) != 0)
+		if (ober_get_string(v, &vs) != 0)
 			continue;
 		if (strcasecmp(plan->assert.value, vs) == 0)
 			return 0;
@@ -71,11 +71,11 @@ ldap_filt_subs_value(struct ber_element 
 	const char	*cmpval;
 	char		*vs, *p, *end;
 
-	if (ber_get_string(v, &vs) != 0)
+	if (ober_get_string(v, &vs) != 0)
 		return -1;
 
 	for (; sub; sub = sub->be_next) {
-		if (ber_scanf_elements(sub, "ts", &class, &type, &cmpval) != 0)
+		if (ober_scanf_elements(sub, "ts", &class, &type, &cmpval) != 0)
 			return -1;
 
 		if (class != BER_CLASS_CONTEXT)
@@ -130,7 +130,7 @@ ldap_filt_subs(struct ber_element *root,
 		return -1;
 	}
 
-	if (ber_scanf_elements(a, "s(e", &attr, &v) != 0)
+	if (ober_scanf_elements(a, "s(e", &attr, &v) != 0)
 		return -1; /* internal failure, false or undefined? */
 
 	/* Loop through all values, stop if any matches.
Index: usr.sbin/ldapd/index.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/index.c,v
retrieving revision 1.12
diff -u -p -r1.12 index.c
--- usr.sbin/ldapd/index.c	28 Jun 2018 02:41:49 -0000	1.12
+++ usr.sbin/ldapd/index.c	24 Oct 2019 13:58:18 -0000
@@ -103,7 +103,7 @@ index_attribute(struct namespace *ns, ch
 	dnsz = dn->size - strlen(ns->suffix);
 
 	for (v = a->be_next->be_sub; v; v = v->be_next) {
-		if (ber_get_string(v, &s) != 0)
+		if (ober_get_string(v, &s) != 0)
 			continue;
 		memset(&key, 0, sizeof(key));
 		key.size = asprintf(&t, "%s=%s,%.*s", attr, s, dnsz,
@@ -202,7 +202,7 @@ unindex_attribute(struct namespace *ns, 
 	dnsz = dn->size - strlen(ns->suffix);
 
 	for (v = a->be_next->be_sub; v; v = v->be_next) {
-		if (ber_get_string(v, &s) != 0)
+		if (ober_get_string(v, &s) != 0)
 			continue;
 		memset(&key, 0, sizeof(key));
 		key.size = asprintf(&t, "%s=%s,%.*s", attr, s, dnsz,
Index: usr.sbin/ldapd/ldape.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/ldape.c,v
retrieving revision 1.31
diff -u -p -r1.31 ldape.c
--- usr.sbin/ldapd/ldape.c	28 Jun 2019 13:32:48 -0000	1.31
+++ usr.sbin/ldapd/ldape.c	24 Oct 2019 13:58:18 -0000
@@ -78,27 +78,27 @@ send_ldap_extended_response(struct conn 
 
 	log_debug("sending response %u with result %lld", type, result_code);
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	elm = ber_printf_elements(root, "d{tEss",
+	elm = ober_printf_elements(root, "d{tEss",
 	    msgid, BER_CLASS_APP, type, result_code, "", "");
 	if (elm == NULL)
 		goto fail;
 
 	if (extended_oid)
-		if (ber_add_string(elm, extended_oid) == NULL)
+		if (ober_add_string(elm, extended_oid) == NULL)
 			goto fail;
 
 	ldap_debug_elements(root, type, "sending response on fd %d", conn->fd);
 
-	rc = ber_write_elements(&conn->ber, root);
-	ber_free_elements(root);
+	rc = ober_write_elements(&conn->ber, root);
+	ober_free_elements(root);
 
 	if (rc < 0)
 		log_warn("failed to create ldap result");
 	else {
-		ber_get_writebuf(&conn->ber, &buf);
+		ober_get_writebuf(&conn->ber, &buf);
 		if (bufferevent_write(conn->bev, buf, rc) != 0)
 			log_warn("failed to send ldap result");
 	}
@@ -106,7 +106,7 @@ send_ldap_extended_response(struct conn 
 	return;
 fail:
 	if (root)
-		ber_free_elements(root);
+		ober_free_elements(root);
 }
 
 int
@@ -136,12 +136,12 @@ ldap_refer(struct request *req, const ch
 	log_debug("sending referral in response %u on msgid %lld",
 	    type, req->msgid);
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	if ((elm = ref_root = ber_add_sequence(NULL)) == NULL)
+	if ((elm = ref_root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
-	ber_set_header(ref_root, BER_CLASS_CONTEXT, LDAP_REQ_SEARCH);
+	ober_set_header(ref_root, BER_CLASS_CONTEXT, LDAP_REQ_SEARCH);
 	SLIST_FOREACH(ref, refs, next) {
 		if (search != NULL)
 			rc = asprintf(&url, "%s/%s??%s", ref->url, basedn,
@@ -153,25 +153,25 @@ ldap_refer(struct request *req, const ch
 			goto fail;
 		}
 		log_debug("adding referral '%s'", url);
-		elm = ber_add_string(elm, url);
+		elm = ober_add_string(elm, url);
 		free(url);
 		if (elm == NULL)
 			goto fail;
 	}
 
-	elm = ber_printf_elements(root, "d{tEsse",
+	elm = ober_printf_elements(root, "d{tEsse",
 	    req->msgid, BER_CLASS_APP, type, result_code, "", "", ref_root);
 	if (elm == NULL)
 		goto fail;
 	ref_root = NULL;
 
-	rc = ber_write_elements(&req->conn->ber, root);
-	ber_free_elements(root);
+	rc = ober_write_elements(&req->conn->ber, root);
+	ober_free_elements(root);
 
 	if (rc < 0)
 		log_warn("failed to create ldap result");
 	else {
-		ber_get_writebuf(&req->conn->ber, &buf);
+		ober_get_writebuf(&req->conn->ber, &buf);
 		if (bufferevent_write(req->conn->bev, buf, rc) != 0)
 			log_warn("failed to send ldap result");
 	}
@@ -181,9 +181,9 @@ ldap_refer(struct request *req, const ch
 
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 	if (ref_root != NULL)
-		ber_free_elements(ref_root);
+		ober_free_elements(ref_root);
 	request_free(req);
 	return LDAP_REFERRAL;
 }
@@ -210,7 +210,7 @@ ldap_abandon(struct request *req)
 	long long	 msgid;
 	struct search	*search;
 
-	if (ber_scanf_elements(req->op, "i", &msgid) != 0) {
+	if (ober_scanf_elements(req->op, "i", &msgid) != 0) {
 		request_free(req);
 		return -1;	/* protocol error, but don't respond */
 	}
@@ -245,7 +245,7 @@ ldap_compare(struct request *req)
 	struct attr_type	*at;
 	char			*dn, *aname, *value, *s;
 
-	if (ber_scanf_elements(req->op, "{s{ss", &dn, &aname, &value) != 0) {
+	if (ober_scanf_elements(req->op, "{s{ss", &dn, &aname, &value) != 0) {
 		log_debug("%s: protocol error", __func__);
 		request_free(req);
 		return -1;
@@ -272,7 +272,7 @@ ldap_compare(struct request *req)
 		return ldap_respond(req, LDAP_OTHER);
 
 	for (elm = attr->be_sub; elm != NULL; elm = elm->be_next) {
-		if (ber_get_string(elm, &s) != 0)
+		if (ober_get_string(elm, &s) != 0)
 			return ldap_respond(req, LDAP_OTHER);
 		if (strcasecmp(value, s) == 0)
 			return ldap_respond(req, LDAP_COMPARE_TRUE);
@@ -307,7 +307,7 @@ ldap_extended(struct request *req)
 		{ NULL }
 	};
 
-	if (ber_scanf_elements(req->op, "{se", &oid, &ext_val) != 0)
+	if (ober_scanf_elements(req->op, "{se", &oid, &ext_val) != 0)
 		goto done;
 
 	log_debug("got extended operation %s", oid);
Index: usr.sbin/ldapd/logmsg.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/logmsg.c,v
retrieving revision 1.3
diff -u -p -r1.3 logmsg.c
--- usr.sbin/ldapd/logmsg.c	31 Jul 2018 11:01:00 -0000	1.3
+++ usr.sbin/ldapd/logmsg.c	24 Oct 2019 13:58:18 -0000
@@ -108,7 +108,7 @@ ldap_debug_elements(struct ber_element *
 	}
 
 	/* calculate lengths */
-	ber_calc_len(root);
+	ober_calc_len(root);
 
 	switch (root->be_encoding) {
 	case BER_TYPE_SEQUENCE:
@@ -265,28 +265,28 @@ ldap_debug_elements(struct ber_element *
 
 	switch (root->be_encoding) {
 	case BER_TYPE_BOOLEAN:
-		if (ber_get_boolean(root, &d) == -1) {
+		if (ober_get_boolean(root, &d) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "%s(%d)\n", d ? "true" : "false", d);
 		break;
 	case BER_TYPE_INTEGER:
-		if (ber_get_integer(root, &v) == -1) {
+		if (ober_get_integer(root, &v) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "value %lld\n", v);
 		break;
 	case BER_TYPE_ENUMERATED:
-		if (ber_get_enumerated(root, &v) == -1) {
+		if (ober_get_enumerated(root, &v) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "value %lld\n", v);
 		break;
 	case BER_TYPE_BITSTRING:
-		if (ber_get_bitstring(root, (void *)&buf, &len) == -1) {
+		if (ober_get_bitstring(root, (void *)&buf, &len) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
@@ -296,14 +296,14 @@ ldap_debug_elements(struct ber_element *
 		fprintf(stderr, "\n");
 		break;
 	case BER_TYPE_OBJECT:
-		if (ber_get_oid(root, &o) == -1) {
+		if (ober_get_oid(root, &o) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "\n");
 		break;
 	case BER_TYPE_OCTETSTRING:
-		if (ber_get_nstring(root, (void *)&buf, &len) == -1) {
+		if (ober_get_nstring(root, (void *)&buf, &len) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
Index: usr.sbin/ldapd/modify.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/modify.c,v
retrieving revision 1.22
diff -u -p -r1.22 modify.c
--- usr.sbin/ldapd/modify.c	18 May 2019 18:45:53 -0000	1.22
+++ usr.sbin/ldapd/modify.c	24 Oct 2019 13:58:18 -0000
@@ -41,7 +41,7 @@ ldap_delete(struct request *req)
 
 	++stats.req_mod;
 
-	if (ber_scanf_elements(req->op, "s", &dn) != 0)
+	if (ober_scanf_elements(req->op, "s", &dn) != 0)
 		return ldap_respond(req, LDAP_PROTOCOL_ERROR);
 
 	normalize_dn(dn);
@@ -102,7 +102,7 @@ ldap_delete(struct request *req)
 		goto done;
 	for (elm = entry->be_sub; elm != NULL; elm = elm->be_next) {
 		a = elm->be_sub;
-		if (a && ber_get_string(a, &s) == 0 &&
+		if (a && ober_get_string(a, &s) == 0 &&
 		    !authorized(req->conn, ns, ACI_WRITE, dn, s,
 		    LDAP_SCOPE_BASE)) {
 			rc = LDAP_INSUFFICIENT_ACCESS;
@@ -134,7 +134,7 @@ ldap_add(struct request *req)
 
 	++stats.req_mod;
 
-	if (ber_scanf_elements(req->op, "{se", &dn, &attrs) != 0)
+	if (ober_scanf_elements(req->op, "{se", &dn, &attrs) != 0)
 		return ldap_respond(req, LDAP_PROTOCOL_ERROR);
 
 	normalize_dn(dn);
@@ -158,7 +158,7 @@ ldap_add(struct request *req)
 	 */
 	for (elm = attrs->be_sub; elm != NULL; elm = elm->be_next) {
 		attr = elm->be_sub;
-		if (attr == NULL || ber_get_string(attr, &s) != 0)
+		if (attr == NULL || ober_get_string(attr, &s) != 0)
 			return ldap_respond(req, LDAP_PROTOCOL_ERROR);
 		if (!authorized(req->conn, ns, ACI_WRITE, dn, s,
 		    LDAP_SCOPE_BASE))
@@ -190,25 +190,25 @@ ldap_add(struct request *req)
 
 	/* add operational attributes
 	 */
-	if ((set = ber_add_set(NULL)) == NULL)
+	if ((set = ober_add_set(NULL)) == NULL)
 		goto fail;
-	if (ber_add_string(set, req->conn->binddn ? req->conn->binddn : "") == NULL)
+	if (ober_add_string(set, req->conn->binddn ? req->conn->binddn : "") == NULL)
 		goto fail;
 	if (ldap_add_attribute(attrs, "creatorsName", set) == NULL)
 		goto fail;
 
-	if ((set = ber_add_set(NULL)) == NULL)
+	if ((set = ober_add_set(NULL)) == NULL)
 		goto fail;
-	if (ber_add_string(set, ldap_now()) == NULL)
+	if (ober_add_string(set, ldap_now()) == NULL)
 		goto fail;
 	if (ldap_add_attribute(attrs, "createTimestamp", set) == NULL)
 		goto fail;
 
 	uuid_create(&uuid);
 	uuid_to_string(&uuid, uuid_str, sizeof(uuid_str));
-	if ((set = ber_add_set(NULL)) == NULL)
+	if ((set = ober_add_set(NULL)) == NULL)
 		goto fail;
-	if (ber_add_string(set, uuid_str) == NULL)
+	if (ober_add_string(set, uuid_str) == NULL)
 		goto fail;
 	if (ldap_add_attribute(attrs, "entryUUID", set) == NULL)
 		goto fail;
@@ -227,7 +227,7 @@ ldap_add(struct request *req)
 
 fail:
 	if (set != NULL)
-		ber_free_elements(set);
+		ober_free_elements(set);
 	namespace_abort(ns);
 	return ldap_respond(req, LDAP_OTHER);
 }
@@ -247,7 +247,7 @@ ldap_modify(struct request *req)
 
 	++stats.req_mod;
 
-	if (ber_scanf_elements(req->op, "{se", &dn, &mods) != 0)
+	if (ober_scanf_elements(req->op, "{se", &dn, &mods) != 0)
 		return ldap_respond(req, LDAP_PROTOCOL_ERROR);
 
 	normalize_dn(dn);
@@ -266,7 +266,7 @@ ldap_modify(struct request *req)
 
 	/* Check authorization for each mod to consider attributes */
 	for (mod = mods->be_sub; mod; mod = mod->be_next) {
-		if (ber_scanf_elements(mod, "{E{es", &op, &prev, &attr) != 0)
+		if (ober_scanf_elements(mod, "{E{es", &op, &prev, &attr) != 0)
 			return ldap_respond(req, LDAP_PROTOCOL_ERROR);
 		if (!authorized(req->conn, ns, ACI_WRITE, dn, attr,
 		    LDAP_SCOPE_BASE))
@@ -288,7 +288,7 @@ ldap_modify(struct request *req)
 	}
 
 	for (mod = mods->be_sub; mod; mod = mod->be_next) {
-		if (ber_scanf_elements(mod, "{E{ese(", &op, &prev, &attr, &vals) != 0) {
+		if (ober_scanf_elements(mod, "{E{ese(", &op, &prev, &attr, &vals) != 0) {
 			rc = LDAP_PROTOCOL_ERROR;
 			vals = NULL;
 			goto done;
@@ -355,7 +355,7 @@ ldap_modify(struct request *req)
 		}
 
 		if (vals != NULL) {
-			ber_free_elements(vals);
+			ober_free_elements(vals);
 			vals = NULL;
 		}
 	}
@@ -363,15 +363,15 @@ ldap_modify(struct request *req)
 	if ((rc = validate_entry(dn, entry, ns->relax)) != LDAP_SUCCESS)
 		goto done;
 
-	set = ber_add_set(NULL);
-	ber_add_string(set, req->conn->binddn ? req->conn->binddn : "");
+	set = ober_add_set(NULL);
+	ober_add_string(set, req->conn->binddn ? req->conn->binddn : "");
 	if ((a = ldap_get_attribute(entry, "modifiersName")) != NULL)
 		ldap_set_values(a, set);
 	else
 		ldap_add_attribute(entry, "modifiersName", set);
 
-	set = ber_add_set(NULL);
-	ber_add_string(set, ldap_now());
+	set = ober_add_set(NULL);
+	ober_add_string(set, ldap_now());
 	if ((a = ldap_get_attribute(entry, "modifyTimestamp")) != NULL)
 		ldap_set_values(a, set);
 	else
@@ -384,7 +384,7 @@ ldap_modify(struct request *req)
 
 done:
 	if (vals != NULL)
-		ber_free_elements(vals);
+		ober_free_elements(vals);
 	namespace_abort(ns);
 	return ldap_respond(req, rc);
 }
Index: usr.sbin/ldapd/schema.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/schema.c,v
retrieving revision 1.18
diff -u -p -r1.18 schema.c
--- usr.sbin/ldapd/schema.c	13 Feb 2019 22:57:08 -0000	1.18
+++ usr.sbin/ldapd/schema.c	24 Oct 2019 13:58:18 -0000
@@ -251,7 +251,7 @@ int
 is_oidstr(const char *oidstr)
 {
 	struct ber_oid	 oid;
-	return (ber_string2oid(oidstr, &oid) == 0);
+	return (ober_string2oid(oidstr, &oid) == 0);
 }
 
 static struct name_list *
Index: usr.sbin/ldapd/search.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/search.c,v
retrieving revision 1.24
diff -u -p -r1.24 search.c
--- usr.sbin/ldapd/search.c	5 Dec 2018 06:44:09 -0000	1.24
+++ usr.sbin/ldapd/search.c	24 Oct 2019 13:58:18 -0000
@@ -79,7 +79,7 @@ should_include_attribute(char *adesc, st
 	}
 
 	for (elm = search->attrlist->be_sub; elm; elm = elm->be_next) {
-		if (ber_get_string(elm, &fdesc) != 0)
+		if (ober_get_string(elm, &fdesc) != 0)
 			continue;
 		if (strcasecmp(fdesc, adesc) == 0)
 			return 1;
@@ -104,10 +104,10 @@ search_result(const char *dn, size_t dnl
 	char			*adesc;
 	void			*buf, *searchdn = NULL;
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	if ((filtered_attrs = ber_add_sequence(NULL)) == NULL)
+	if ((filtered_attrs = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 	link = filtered_attrs;
 
@@ -115,7 +115,7 @@ search_result(const char *dn, size_t dnl
 		goto fail;
 
 	for (prev = NULL, a = attrs->be_sub; a; a = next) {
-		if (ber_get_string(a->be_sub, &adesc) != 0)
+		if (ober_get_string(a->be_sub, &adesc) != 0)
 			goto fail;
 		/*
 		 * Check if read access to the attribute is allowed and if it
@@ -131,7 +131,7 @@ search_result(const char *dn, size_t dnl
 			else
 				attrs->be_sub = a->be_next;
 			a->be_next = NULL;			/* break chain*/
-			ber_link_elements(link, a);
+			ober_link_elements(link, a);
 			link = a;
 		} else {
 			prev = a;
@@ -139,7 +139,7 @@ search_result(const char *dn, size_t dnl
 		}
 	}
 
-	elm = ber_printf_elements(root, "i{txe", search->req->msgid,
+	elm = ober_printf_elements(root, "i{txe", search->req->msgid,
 		BER_CLASS_APP, LDAP_RES_SEARCH_ENTRY,
 		dn, dnlen, filtered_attrs);
 	if (elm == NULL)
@@ -148,15 +148,15 @@ search_result(const char *dn, size_t dnl
 	ldap_debug_elements(root, LDAP_RES_SEARCH_ENTRY,
 	    "sending search entry on fd %d", conn->fd);
 
-	rc = ber_write_elements(&conn->ber, root);
-	ber_free_elements(root);
+	rc = ober_write_elements(&conn->ber, root);
+	ober_free_elements(root);
 
 	if (rc < 0) {
 		log_warn("failed to create search-entry response");
 		return -1;
 	}
 
-	ber_get_writebuf(&conn->ber, &buf);
+	ober_get_writebuf(&conn->ber, &buf);
 	if (bufferevent_write(conn->bev, buf, rc) != 0) {
 		log_warn("failed to send ldap result");
 		return -1;
@@ -167,7 +167,7 @@ search_result(const char *dn, size_t dnl
 fail:
 	log_warn("search result");
 	if (root)
-		ber_free_elements(root);
+		ober_free_elements(root);
 	free(searchdn);
 	return -1;
 }
@@ -248,12 +248,12 @@ check_search_entry(struct btval *key, st
 	}
 
 	if (ldap_matches_filter(elm, search->plan) != 0) {
-		ber_free_elements(elm);
+		ober_free_elements(elm);
 		return 0;
 	}
 
 	rc = search_result(key->data, key->size, elm, search);
-	ber_free_elements(elm);
+	ober_free_elements(elm);
 
 	if (rc == 0)
 		search->nmatched++;
@@ -492,51 +492,51 @@ ldap_search_root_dse(struct search *sear
 	struct namespace	*ns;
 	struct ber_element	*root, *elm, *key, *val;
 
-	if ((root = ber_add_sequence(NULL)) == NULL) {
+	if ((root = ober_add_sequence(NULL)) == NULL) {
 		return;
 	}
 
-	elm = ber_add_sequence(root);
-	key = ber_add_string(elm, "objectClass");
-	val = ber_add_set(key);
-	ber_add_string(val, "top");
-
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "supportedLDAPVersion");
-	val = ber_add_set(key);
-	ber_add_string(val, "3");
-
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "namingContexts");
-	val = ber_add_set(key);
+	elm = ober_add_sequence(root);
+	key = ober_add_string(elm, "objectClass");
+	val = ober_add_set(key);
+	ober_add_string(val, "top");
+
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "supportedLDAPVersion");
+	val = ober_add_set(key);
+	ober_add_string(val, "3");
+
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "namingContexts");
+	val = ober_add_set(key);
 	TAILQ_FOREACH(ns, &conf->namespaces, next)
-		val = ber_add_string(val, ns->suffix);
+		val = ober_add_string(val, ns->suffix);
 
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "supportedExtension");
-	val = ber_add_set(key);
-	ber_add_string(val, "1.3.6.1.4.1.1466.20037");	/* StartTLS */
-
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "supportedFeatures");
-	val = ber_add_set(key);
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "supportedExtension");
+	val = ober_add_set(key);
+	ober_add_string(val, "1.3.6.1.4.1.1466.20037");	/* StartTLS */
+
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "supportedFeatures");
+	val = ober_add_set(key);
 	/* All Operational Attributes (RFC 3673) */
-	ber_add_string(val, "1.3.6.1.4.1.4203.1.5.1");
+	ober_add_string(val, "1.3.6.1.4.1.4203.1.5.1");
 
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "subschemaSubentry");
-	val = ber_add_set(key);
-	ber_add_string(val, "cn=schema");
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "subschemaSubentry");
+	val = ober_add_set(key);
+	ober_add_string(val, "cn=schema");
 
 	if ((search->conn->s_flags & F_SECURE) == F_SECURE) {
-		elm = ber_add_sequence(elm);
-		key = ber_add_string(elm, "supportedSASLMechanisms");
-		val = ber_add_set(key);
-		ber_add_string(val, "PLAIN");
+		elm = ober_add_sequence(elm);
+		key = ober_add_string(elm, "supportedSASLMechanisms");
+		val = ober_add_set(key);
+		ober_add_string(val, "PLAIN");
 	}
 
 	search_result("", 0, root, search);
-	ber_free_elements(root);
+	ober_free_elements(root);
 	send_ldap_result(search->conn, search->req->msgid,
 	    LDAP_RES_SEARCH_RESULT, LDAP_SUCCESS);
 	search_close(search);
@@ -551,63 +551,63 @@ ldap_search_subschema(struct search *sea
 	struct attr_type	*at;
 	int			 rc, i;
 
-	if ((root = ber_add_sequence(NULL)) == NULL) {
+	if ((root = ober_add_sequence(NULL)) == NULL) {
 		return;
 	}
 
-	elm = ber_add_sequence(root);
-	key = ber_add_string(elm, "objectClass");
-	val = ber_add_set(key);
-	val = ber_add_string(val, "top");
-	ber_add_string(val, "subschema");
-
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "createTimestamp");
-	val = ber_add_set(key);
-	ber_add_string(val, ldap_strftime(stats.started_at));
-
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "modifyTimestamp");
-	val = ber_add_set(key);
-	ber_add_string(val, ldap_strftime(stats.started_at));
-
-	elm = ber_add_sequence(elm);
-	key = ber_add_string(elm, "subschemaSubentry");
-	val = ber_add_set(key);
-	ber_add_string(val, "cn=schema");
+	elm = ober_add_sequence(root);
+	key = ober_add_string(elm, "objectClass");
+	val = ober_add_set(key);
+	val = ober_add_string(val, "top");
+	ober_add_string(val, "subschema");
+
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "createTimestamp");
+	val = ober_add_set(key);
+	ober_add_string(val, ldap_strftime(stats.started_at));
+
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "modifyTimestamp");
+	val = ober_add_set(key);
+	ober_add_string(val, ldap_strftime(stats.started_at));
+
+	elm = ober_add_sequence(elm);
+	key = ober_add_string(elm, "subschemaSubentry");
+	val = ober_add_set(key);
+	ober_add_string(val, "cn=schema");
 
 	if (should_include_attribute("objectClasses", search, 1)) {
-		elm = ber_add_sequence(elm);
-		key = ber_add_string(elm, "objectClasses");
-		val = ber_add_set(key);
+		elm = ober_add_sequence(elm);
+		key = ober_add_string(elm, "objectClasses");
+		val = ober_add_set(key);
 
 		RB_FOREACH(obj, object_tree, &conf->schema->objects) {
 			if (schema_dump_object(obj, buf, sizeof(buf)) != 0) {
 				rc = LDAP_OTHER;
 				goto done;
 			}
-			val = ber_add_string(val, buf);
+			val = ober_add_string(val, buf);
 		}
 	}
 
 	if (should_include_attribute("attributeTypes", search, 1)) {
-		elm = ber_add_sequence(elm);
-		key = ber_add_string(elm, "attributeTypes");
-		val = ber_add_set(key);
+		elm = ober_add_sequence(elm);
+		key = ober_add_string(elm, "attributeTypes");
+		val = ober_add_set(key);
 
 		RB_FOREACH(at, attr_type_tree, &conf->schema->attr_types) {
 			if (schema_dump_attribute(at, buf, sizeof(buf)) != 0) {
 				rc = LDAP_OTHER;
 				goto done;
 			}
-			val = ber_add_string(val, buf);
+			val = ober_add_string(val, buf);
 		}
 	}
 
 	if (should_include_attribute("matchingRules", search, 1)) {
-		elm = ber_add_sequence(elm);
-		key = ber_add_string(elm, "matchingRules");
-		val = ber_add_set(key);
+		elm = ober_add_sequence(elm);
+		key = ober_add_string(elm, "matchingRules");
+		val = ober_add_set(key);
 
 		for (i = 0; i < num_match_rules; i++) {
 			if (schema_dump_match_rule(&match_rules[i], buf,
@@ -615,7 +615,7 @@ ldap_search_subschema(struct search *sea
 				rc = LDAP_OTHER;
 				goto done;
 			}
-			val = ber_add_string(val, buf);
+			val = ober_add_string(val, buf);
 		}
 	}
 
@@ -623,7 +623,7 @@ ldap_search_subschema(struct search *sea
 	rc = LDAP_SUCCESS;
 
 done:
-	ber_free_elements(root);
+	ober_free_elements(root);
 	send_ldap_result(search->conn, search->req->msgid,
 	    LDAP_RES_SEARCH_RESULT, rc);
 	search_close(search);
@@ -703,7 +703,7 @@ search_planner(struct namespace *ns, str
 	switch (filter->be_type) {
 	case LDAP_FILT_EQ:
 	case LDAP_FILT_APPR:
-		if (ber_scanf_elements(filter, "{ss", &attr, &s) != 0)
+		if (ober_scanf_elements(filter, "{ss", &attr, &s) != 0)
 			goto fail;
 		if (plan_get_attr(plan, ns, attr) == -1)
 			plan->undefined = 1;
@@ -718,7 +718,7 @@ search_planner(struct namespace *ns, str
 		}
 		break;
 	case LDAP_FILT_SUBS:
-		if (ber_scanf_elements(filter, "{s{ets",
+		if (ober_scanf_elements(filter, "{s{ets",
 		    &attr, &plan->assert.substring, &class, &type, &s) != 0)
 			goto fail;
 		if (plan_get_attr(plan, ns, attr) == -1)
@@ -735,7 +735,7 @@ search_planner(struct namespace *ns, str
 		}
 		break;
 	case LDAP_FILT_PRES:
-		if (ber_scanf_elements(filter, "s", &attr) != 0)
+		if (ober_scanf_elements(filter, "s", &attr) != 0)
 			goto fail;
 		if (plan_get_attr(plan, ns, attr) == -1)
 			plan->undefined = 1;
@@ -745,7 +745,7 @@ search_planner(struct namespace *ns, str
 		}
 		break;
 	case LDAP_FILT_AND:
-		if (ber_scanf_elements(filter, "(e", &elm) != 0)
+		if (ober_scanf_elements(filter, "(e", &elm) != 0)
 			goto fail;
 		for (; elm; elm = elm->be_next) {
 			if ((arg = search_planner(ns, elm)) == NULL)
@@ -775,7 +775,7 @@ search_planner(struct namespace *ns, str
 		}
 		break;
 	case LDAP_FILT_OR:
-		if (ber_scanf_elements(filter, "(e", &elm) != 0)
+		if (ober_scanf_elements(filter, "(e", &elm) != 0)
 			goto fail;
 		for (; elm; elm = elm->be_next) {
 			if ((arg = search_planner(ns, elm)) == NULL)
@@ -804,7 +804,7 @@ search_planner(struct namespace *ns, str
 		}
 		break;
 	case LDAP_FILT_NOT:
-		if (ber_scanf_elements(filter, "{e", &elm) != 0)
+		if (ober_scanf_elements(filter, "{e", &elm) != 0)
 			goto fail;
 		if ((arg = search_planner(ns, elm)) == NULL)
 			goto fail;
@@ -875,7 +875,7 @@ ldap_search(struct request *req)
 	TAILQ_INSERT_HEAD(&req->conn->searches, search, next);
 	RB_INIT(&search->uniqdns);
 
-	if (ber_scanf_elements(req->op, "{sEEiibeSeS",
+	if (ober_scanf_elements(req->op, "{sEEiibeSeS",
 	    &search->basedn,
 	    &search->scope,
 	    &search->deref,
Index: usr.sbin/ldapd/util.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/util.c,v
retrieving revision 1.11
diff -u -p -r1.11 util.c
--- usr.sbin/ldapd/util.c	3 Jul 2019 03:24:03 -0000	1.11
+++ usr.sbin/ldapd/util.c	24 Oct 2019 13:58:18 -0000
@@ -113,9 +113,9 @@ ber2db(struct ber_element *root, struct 
 	memset(val, 0, sizeof(*val));
 
 	memset(&ber, 0, sizeof(ber));
-	ber_write_elements(&ber, root);
+	ober_write_elements(&ber, root);
 
-	if ((len = ber_get_writebuf(&ber, &buf)) == -1)
+	if ((len = ober_get_writebuf(&ber, &buf)) == -1)
 		return -1;
 
 	if (compression_level > 0) {
@@ -123,7 +123,7 @@ ber2db(struct ber_element *root, struct 
 		val->data = malloc(val->size + sizeof(uint32_t));
 		if (val->data == NULL) {
 			log_warn("malloc(%zu)", val->size + sizeof(uint32_t));
-			ber_free(&ber);
+			ober_free(&ber);
 			return -1;
 		}
 		dest = (char *)val->data + sizeof(uint32_t);
@@ -132,7 +132,7 @@ ber2db(struct ber_element *root, struct 
 		    compression_level)) != Z_OK) {
 			log_warn("compress returned %d", rc);
 			free(val->data);
-			ber_free(&ber);
+			ober_free(&ber);
 			return -1;
 		}
 		log_debug("compressed entry from %zd -> %lu byte",
@@ -148,7 +148,7 @@ ber2db(struct ber_element *root, struct 
 		ber.br_wbuf = NULL;
 	}
 
-	ber_free(&ber);
+	ober_free(&ber);
 
 	return 0;
 }
@@ -190,13 +190,13 @@ db2ber(struct btval *val, int compressio
 		log_debug("uncompressed entry from %zu -> %lu byte",
 		    val->size, len);
 
-		ber_set_readbuf(&ber, buf, len);
-		elm = ber_read_elements(&ber, NULL);
+		ober_set_readbuf(&ber, buf, len);
+		elm = ober_read_elements(&ber, NULL);
 		free(buf);
 		return elm;
 	} else {
-		ber_set_readbuf(&ber, val->data, val->size);
-		return ber_read_elements(&ber, NULL);
+		ober_set_readbuf(&ber, val->data, val->size);
+		return ober_read_elements(&ber, NULL);
 	}
 }
 
Index: usr.sbin/ldapd/validate.c
===================================================================
RCS file: /cvs/src/usr.sbin/ldapd/validate.c,v
retrieving revision 1.11
diff -u -p -r1.11 validate.c
--- usr.sbin/ldapd/validate.c	15 May 2018 11:19:21 -0000	1.11
+++ usr.sbin/ldapd/validate.c	24 Oct 2019 13:58:18 -0000
@@ -65,7 +65,7 @@ validate_attribute(struct attr_type *at,
 	}
 
 	for (elm = vals->be_sub; elm != NULL; elm = elm->be_next) {
-		if (ber_get_string(elm, &val) == -1) {
+		if (ober_get_string(elm, &val) == -1) {
 			log_debug("attribute value not an octet-string");
 			return LDAP_PROTOCOL_ERROR;
 		}
@@ -312,7 +312,7 @@ validate_entry(const char *dn, struct be
 	 */
 	objclass = objclass->be_next;		/* skip attribute description */
 	for (a = objclass->be_sub; a != NULL; a = a->be_next) {
-		if (ber_get_string(a, &s) != 0) {
+		if (ober_get_string(a, &s) != 0) {
 			rc = LDAP_INVALID_SYNTAX;
 			goto done;
 		}
@@ -395,7 +395,7 @@ validate_entry(const char *dn, struct be
 	/* Check all attributes against schema.
 	 */
 	for (a = entry->be_sub; a != NULL; a = a->be_next) {
-		if (ber_scanf_elements(a, "{se{", &s, &vals) != 0) {
+		if (ober_scanf_elements(a, "{se{", &s, &vals) != 0) {
 			rc = LDAP_INVALID_SYNTAX;
 			goto done;
 		}
Index: usr.sbin/snmpd/mib.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/mib.c,v
retrieving revision 1.96
diff -u -p -r1.96 mib.c
--- usr.sbin/snmpd/mib.c	13 Aug 2019 12:52:41 -0000	1.96
+++ usr.sbin/snmpd/mib.c	24 Oct 2019 13:58:18 -0000
@@ -144,18 +144,18 @@ mib_getsys(struct oid *oid, struct ber_o
 			oid->o_data = s;
 			oid->o_val = strlen(s);
 		}
-		*elm = ber_add_string(*elm, s);
+		*elm = ober_add_string(*elm, s);
 		break;
 	case 2:
 		if (so == NULL)
 			so = &sysoid;
 		smi_oidlen(so);
-		*elm = ber_add_oid(*elm, so);
+		*elm = ober_add_oid(*elm, so);
 		break;
 	case 3:
 		ticks = smi_getticks();
-		*elm = ber_add_integer(*elm, ticks);
-		ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+		*elm = ober_add_integer(*elm, ticks);
+		ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 		break;
 	case 4:
 		if (s == NULL) {
@@ -164,7 +164,7 @@ mib_getsys(struct oid *oid, struct ber_o
 			oid->o_data = s;
 			oid->o_val = strlen(s);
 		}
-		*elm = ber_add_string(*elm, s);
+		*elm = ober_add_string(*elm, s);
 		break;
 	case 5:
 		if (s == NULL) {
@@ -173,15 +173,15 @@ mib_getsys(struct oid *oid, struct ber_o
 			oid->o_data = s;
 			oid->o_val = strlen(s);
 		}
-		*elm = ber_add_string(*elm, s);
+		*elm = ober_add_string(*elm, s);
 		break;
 	case 6:
 		if (s == NULL)
 			s = "";
-		*elm = ber_add_string(*elm, s);
+		*elm = ober_add_string(*elm, s);
 		break;
 	case 7:
-		*elm = ber_add_integer(*elm, oid->o_val);
+		*elm = ober_add_integer(*elm, oid->o_val);
 		break;
 	default:
 		return (-1);
@@ -216,14 +216,14 @@ mib_sysor(struct oid *oid, struct ber_oi
 		return (-1);
 
 	/* Tables need to prepend the OID on their own */
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_sysOR]) {
 	case 1:
-		ber = ber_add_integer(ber, idx);
+		ber = ober_add_integer(ber, idx);
 		break;
 	case 2:
-		ber = ber_add_oid(ber, &miboid->o_id);
+		ber = ober_add_oid(ber, &miboid->o_id);
 		break;
 	case 3:
 		/*
@@ -232,7 +232,7 @@ mib_sysor(struct oid *oid, struct ber_oi
 		 * help to display names of internal OIDs.
 		 */
 		smi_oid2string(&miboid->o_id, buf, sizeof(buf), 0);
-		ber = ber_add_string(ber, buf);
+		ber = ober_add_string(ber, buf);
 		break;
 	case 4:
 		/*
@@ -240,8 +240,8 @@ mib_sysor(struct oid *oid, struct ber_oi
 		 * the sysORUpTime value of 0 will indicate "loaded at
 		 * startup".
 		 */
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber,
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber,
 		    BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 		break;
 	default:
@@ -294,14 +294,14 @@ mib_getsnmp(struct oid *oid, struct ber_
 	switch (oid->o_oid[OIDIDX_snmp]) {
 	case 30:
 		i = stats->snmp_enableauthentraps == 1 ? 1 : 2;
-		*elm = ber_add_integer(*elm, i);
+		*elm = ober_add_integer(*elm, i);
 		break;
 	default:
 		for (i = 0;
 		    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 			if (oid->o_oid[OIDIDX_snmp] == mapping[i].m_id) {
-				*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-				ber_set_header(*elm,
+				*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+				ober_set_header(*elm,
 				    BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 				return (0);
 			}
@@ -318,7 +318,7 @@ mib_setsnmp(struct oid *oid, struct ber_
 	struct snmp_stats	*stats = &snmpd_env->sc_stats;
 	long long		 i;
 
-	if (ber_get_integer(*elm, &i) == -1)
+	if (ober_get_integer(*elm, &i) == -1)
 		return (-1);
 
 	stats->snmp_enableauthentraps = i == 1 ? 1 : 0;
@@ -353,17 +353,17 @@ mib_engine(struct oid *oid, struct ber_o
 {
 	switch (oid->o_oid[OIDIDX_snmpEngine]) {
 	case 1:
-		*elm = ber_add_nstring(*elm, snmpd_env->sc_engineid,
+		*elm = ober_add_nstring(*elm, snmpd_env->sc_engineid,
 		    snmpd_env->sc_engineid_len);
 		break;
 	case 2:
-		*elm = ber_add_integer(*elm, snmpd_env->sc_engine_boots);
+		*elm = ober_add_integer(*elm, snmpd_env->sc_engine_boots);
 		break;
 	case 3:
-		*elm = ber_add_integer(*elm, snmpd_engine_time());
+		*elm = ober_add_integer(*elm, snmpd_engine_time());
 		break;
 	case 4:
-		*elm = ber_add_integer(*elm, READ_BUF_SIZE);
+		*elm = ober_add_integer(*elm, READ_BUF_SIZE);
 		break;
 	default:
 		return -1;
@@ -390,8 +390,8 @@ mib_usmstats(struct oid *oid, struct ber
 
 	for (i = 0; (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 		if (oid->o_oid[OIDIDX_usmStats] == mapping[i].m_id) {
-			*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-			ber_set_header(*elm, BER_CLASS_APPLICATION,
+			*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+			ober_set_header(*elm, BER_CLASS_APPLICATION,
 			    SNMP_T_COUNTER32);
 			return (0);
 		}
@@ -459,8 +459,8 @@ mib_hrsystemuptime(struct oid *oid, stru
 	if (clock_gettime(CLOCK_BOOTTIME, &uptime) == -1)
 		return (-1);
 	ticks = uptime.tv_sec * 100 + uptime.tv_nsec / 10000000;
-	*elm = ber_add_integer(*elm, ticks);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+	*elm = ober_add_integer(*elm, ticks);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 
 	return (0);
 }
@@ -495,7 +495,7 @@ mib_hrsystemdate(struct oid *oid, struct
 	s[9] = abs(tzoffset) / 3600;
 	s[10] = (abs(tzoffset) - (s[9] * 3600)) / 60;
 
-	*elm = ber_add_nstring(*elm, s, sizeof(s));
+	*elm = ober_add_nstring(*elm, s, sizeof(s));
 
 	return (0);
 }
@@ -521,8 +521,8 @@ mib_hrsystemprocs(struct oid *oid, struc
 			return (-1);
 		}
 
-		*elm = ber_add_integer(*elm, val);
-		ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
+		*elm = ober_add_integer(*elm, val);
+		ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
 
 		kvm_close(kd);
 		break;
@@ -531,7 +531,7 @@ mib_hrsystemprocs(struct oid *oid, struc
 		if (sysctl(mib, 2, &val, &len, NULL, 0) == -1)
 			return (-1);
 
-		*elm = ber_add_integer(*elm, val);
+		*elm = ober_add_integer(*elm, val);
 		break;
 	default:
 		return (-1);
@@ -551,7 +551,7 @@ mib_hrmemory(struct oid *oid, struct ber
 	if (sysctl(mib, sizeofa(mib), &physmem, &len, NULL, 0) == -1)
 		return (-1);
 
-	ber = ber_add_integer(ber, physmem / 1024);
+	ber = ober_add_integer(ber, physmem / 1024);
 
 	return (0);
 }
@@ -649,31 +649,31 @@ mib_hrstorage(struct oid *oid, struct be
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_hrStorageEntry] = idx;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_hrStorage]) {
 	case 1: /* hrStorageIndex */
-		ber = ber_add_integer(ber, idx);
+		ber = ober_add_integer(ber, idx);
 		break;
 	case 2: /* hrStorageType */
 		smi_oidlen(sop);
-		ber = ber_add_oid(ber, sop);
+		ber = ober_add_oid(ber, sop);
 		break;
 	case 3: /* hrStorageDescr */
-		ber = ber_add_string(ber, descr);
+		ber = ober_add_string(ber, descr);
 		break;
 	case 4: /* hrStorageAllocationUnits */
-		ber = ber_add_integer(ber, units);
+		ber = ober_add_integer(ber, units);
 		break;
 	case 5: /* hrStorageSize */
-		ber = ber_add_integer(ber, size);
+		ber = ober_add_integer(ber, size);
 		break;
 	case 6: /* hrStorageUsed */
-		ber = ber_add_integer(ber, used);
+		ber = ober_add_integer(ber, used);
 		break;
 	case 7: /* hrStorageAllocationFailures */
-		ber = ber_add_integer(ber, fail);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, fail);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	default:
 		return (-1);
@@ -702,7 +702,7 @@ mib_hrdevice(struct oid *oid, struct ber
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_hrDeviceEntry] = idx;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	len = sizeof(descr);
 	if (sysctl(mib, sizeofa(mib), &descr, &len, NULL, 0) == -1)
@@ -713,24 +713,24 @@ mib_hrdevice(struct oid *oid, struct ber
 
 	switch (o->bo_id[OIDIDX_hrDevice]) {
 	case 1: /* hrDeviceIndex */
-		ber = ber_add_integer(ber, idx);
+		ber = ober_add_integer(ber, idx);
 		break;
 	case 2: /* hrDeviceType */
 		smi_oidlen(sop);
-		ber = ber_add_oid(ber, sop);
+		ber = ober_add_oid(ber, sop);
 		break;
 	case 3: /* hrDeviceDescr */
-		ber = ber_add_string(ber, descr);
+		ber = ober_add_string(ber, descr);
 		break;
 	case 4: /* hrDeviceID */
-		ber = ber_add_oid(ber, &zerodotzero);
+		ber = ober_add_oid(ber, &zerodotzero);
 		break;
 	case 5: /* hrDeviceStatus */
-		ber = ber_add_integer(ber, status);
+		ber = ober_add_integer(ber, status);
 		break;
 	case 6: /* hrDeviceErrors */
-		ber = ber_add_integer(ber, fail);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, fail);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	default:
 		return (-1);
@@ -755,11 +755,11 @@ mib_hrprocessor(struct oid *oid, struct 
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_hrDeviceEntry] = idx;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_hrDevice]) {
 	case 1: /* hrProcessorFrwID */
-		ber = ber_add_oid(ber, &zerodotzero);
+		ber = ober_add_oid(ber, &zerodotzero);
 		break;
 	case 2: /* hrProcessorLoad */
 		/*
@@ -771,7 +771,7 @@ mib_hrprocessor(struct oid *oid, struct 
 		cptime2 = snmpd_env->sc_cpustates + (CPUSTATES * (idx - 1));
 		val = 100 -
 		    (cptime2[CP_IDLE] > 1000 ? 1000 : (cptime2[CP_IDLE] / 10));
-		ber = ber_add_integer(ber, val);
+		ber = ober_add_integer(ber, val);
 		break;
 	default:
 		return (-1);
@@ -796,54 +796,54 @@ mib_hrswrun(struct oid *oid, struct ber_
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_hrSWRunEntry] = kinfo->p_pid;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_hrSWRun]) {
 	case 1: /* hrSWRunIndex */
-		ber = ber_add_integer(ber, kinfo->p_pid);
+		ber = ober_add_integer(ber, kinfo->p_pid);
 		break;
 	case 2: /* hrSWRunName */
 	case 4: /* hrSWRunPath */
-		ber = ber_add_string(ber, kinfo->p_comm);
+		ber = ober_add_string(ber, kinfo->p_comm);
 		break;
 	case 3: /* hrSWRunID */
-		ber = ber_add_oid(ber, &zerodotzero);
+		ber = ober_add_oid(ber, &zerodotzero);
 		break;
 	case 5: /* hrSWRunParameters */
 		if (kinfo_args(kinfo, &s) == -1)
 			return (-1);
 
-		ber = ber_add_string(ber, s);
+		ber = ober_add_string(ber, s);
 		break;
 	case 6: /* hrSWRunType */
 		if (kinfo->p_flag & P_SYSTEM) {
 			/* operatingSystem(2) */
-			ber = ber_add_integer(ber, 2);
+			ber = ober_add_integer(ber, 2);
 		} else {
 			/* application(4) */
-			ber = ber_add_integer(ber, 4);
+			ber = ober_add_integer(ber, 4);
 		}
 		break;
 	case 7: /* hrSWRunStatus */
 		switch (kinfo->p_stat) {
 		case SONPROC:
 			/* running(1) */
-			ber = ber_add_integer(ber, 1);
+			ber = ober_add_integer(ber, 1);
 			break;
 		case SIDL:
 		case SRUN:
 		case SSLEEP:
 			/* runnable(2) */
-			ber = ber_add_integer(ber, 2);
+			ber = ober_add_integer(ber, 2);
 			break;
 		case SSTOP:
 			/* notRunnable(3) */
-			ber = ber_add_integer(ber, 3);
+			ber = ober_add_integer(ber, 3);
 			break;
 		case SDEAD:
 		default:
 			/* invalid(4) */
-			ber = ber_add_integer(ber, 4);
+			ber = ober_add_integer(ber, 4);
 			break;
 		}
 		break;
@@ -1065,7 +1065,7 @@ static struct oid if_mib[] = {
 int
 mib_ifnumber(struct oid *oid, struct ber_oid *o, struct ber_element **elm)
 {
-	*elm = ber_add_integer(*elm, kr_ifnumber());
+	*elm = ober_add_integer(*elm, kr_ifnumber());
 	return (0);
 }
 
@@ -1114,11 +1114,11 @@ mib_iftable(struct oid *oid, struct ber_
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_ifEntry] = kif->if_index;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_if]) {
 	case 1:
-		ber = ber_add_integer(ber, kif->if_index);
+		ber = ober_add_integer(ber, kif->if_index);
 		break;
 	case 2:
 		/*
@@ -1126,7 +1126,7 @@ mib_iftable(struct oid *oid, struct ber_
 		 * but we just use the interface name (like ifName).
 		 * The interface name includes the driver name on OpenBSD.
 		 */
-		ber = ber_add_string(ber, kif->if_name);
+		ber = ober_add_string(ber, kif->if_name);
 		break;
 	case 3:
 		if (kif->if_type >= 0xf0) {
@@ -1134,34 +1134,34 @@ mib_iftable(struct oid *oid, struct ber_
 			 * It does not make sense to announce the private
 			 * interface types for CARP, ENC, PFSYNC, etc.
 			 */
-			ber = ber_add_integer(ber, IFT_OTHER);
+			ber = ober_add_integer(ber, IFT_OTHER);
 		} else
-			ber = ber_add_integer(ber, kif->if_type);
+			ber = ober_add_integer(ber, kif->if_type);
 		break;
 	case 4:
-		ber = ber_add_integer(ber, kif->if_mtu);
+		ber = ober_add_integer(ber, kif->if_mtu);
 		break;
 	case 5:
 		if (kif->if_baudrate > UINT32_MAX) {
 			/* speed should be obtained from ifHighSpeed instead */
-			ber = ber_add_integer(ber, UINT32_MAX);
+			ber = ober_add_integer(ber, UINT32_MAX);
 		} else
-			ber = ber_add_integer(ber, kif->if_baudrate);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
+			ber = ober_add_integer(ber, kif->if_baudrate);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
 		break;
 	case 6:
 		if (bcmp(kif->if_lladdr, ether_zeroaddr,
 		    sizeof(kif->if_lladdr)) == 0) {
-			ber = ber_add_string(ber, "");
+			ber = ober_add_string(ber, "");
 		} else {
-			ber = ber_add_nstring(ber, kif->if_lladdr,
+			ber = ober_add_nstring(ber, kif->if_lladdr,
 			    sizeof(kif->if_lladdr));
 		}
 		break;
 	case 7:
 		/* ifAdminStatus up(1), down(2), testing(3) */
 		i = (kif->if_flags & IFF_UP) ? 1 : 2;
-		ber = ber_add_integer(ber, i);
+		ber = ober_add_integer(ber, i);
 		break;
 	case 8:
 		/* ifOperStatus */
@@ -1173,62 +1173,62 @@ mib_iftable(struct oid *oid, struct ber_
 			i = 1;	/* up(1) */
 		else
 			i = 7;	/* lowerLayerDown(7) or dormant(5)? */
-		ber = ber_add_integer(ber, i);
+		ber = ober_add_integer(ber, i);
 		break;
 	case 9:
-		ber = ber_add_integer(ber, kif->if_ticks);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+		ber = ober_add_integer(ber, kif->if_ticks);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 		break;
 	case 10:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_ibytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_ibytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 11:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_ipackets);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_ipackets);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 12:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_imcasts);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_imcasts);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 13:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_iqdrops);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_iqdrops);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 14:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_ierrors);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_ierrors);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 15:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_noproto);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_noproto);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 16:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_obytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_obytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 17:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_opackets);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_opackets);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 18:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_omcasts);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_omcasts);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 19:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_oqdrops);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_oqdrops);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 20:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_oerrors);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_oerrors);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 21:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
 		break;
 	case 22:
-		ber = ber_add_oid(ber, &zerodotzero);
+		ber = ober_add_oid(ber, &zerodotzero);
 		break;
 	default:
 		return (-1);
@@ -1252,85 +1252,85 @@ mib_ifxtable(struct oid *oid, struct ber
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_ifXEntry] = kif->if_index;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_ifX]) {
 	case 1:
-		ber = ber_add_string(ber, kif->if_name);
+		ber = ober_add_string(ber, kif->if_name);
 		break;
 	case 2:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_imcasts);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_imcasts);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 3:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 4:
-		ber = ber_add_integer(ber, (u_int32_t)kif->if_omcasts);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)kif->if_omcasts);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 5:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 6:
-		ber = ber_add_integer(ber, (u_int64_t)kif->if_ibytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, (u_int64_t)kif->if_ibytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 7:
-		ber = ber_add_integer(ber, (u_int64_t)kif->if_ipackets);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, (u_int64_t)kif->if_ipackets);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 8:
-		ber = ber_add_integer(ber, (u_int64_t)kif->if_imcasts);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, (u_int64_t)kif->if_imcasts);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 9:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 10:
-		ber = ber_add_integer(ber, (u_int64_t)kif->if_obytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, (u_int64_t)kif->if_obytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 11:
-		ber = ber_add_integer(ber, (u_int64_t)kif->if_opackets);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, (u_int64_t)kif->if_opackets);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 12:
-		ber = ber_add_integer(ber, (u_int64_t)kif->if_omcasts);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, (u_int64_t)kif->if_omcasts);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 13:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 14:
-		ber = ber_add_integer(ber, 0);	/* enabled(1), disabled(2) */
+		ber = ober_add_integer(ber, 0);	/* enabled(1), disabled(2) */
 		break;
 	case 15:
 		i = kif->if_baudrate >= 1000000 ?
 		    kif->if_baudrate / 1000000 : 0;
-		ber = ber_add_integer(ber, i);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
+		ber = ober_add_integer(ber, i);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
 		break;
 	case 16:
 		/* ifPromiscuousMode: true(1), false(2) */
 		i = kif->if_flags & IFF_PROMISC ? 1 : 2;
-		ber = ber_add_integer(ber, i);
+		ber = ober_add_integer(ber, i);
 		break;
 	case 17:
 		/* ifConnectorPresent: false(2), true(1) */
 		i = kif->if_type == IFT_ETHER ? 1 : 2;
-		ber = ber_add_integer(ber, i);
+		ber = ober_add_integer(ber, i);
 		break;
 	case 18:
-		ber = ber_add_string(ber, kif->if_descr);
+		ber = ober_add_string(ber, kif->if_descr);
 		break;
 	case 19:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 		break;
 	default:
 		return (-1);
@@ -1343,8 +1343,8 @@ int
 mib_ifstacklast(struct oid *oid, struct ber_oid *o, struct ber_element **elm)
 {
 	struct ber_element	*ber = *elm;
-	ber = ber_add_integer(ber, kr_iflastchange());
-	ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+	ber = ober_add_integer(ber, kr_iflastchange());
+	ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 	return (0);
 }
 
@@ -1381,17 +1381,17 @@ mib_ifrcvtable(struct oid *oid, struct b
 		o->bo_id[OIDIDX_ifRcvAddressEntry + idx++] = kif->if_lladdr[i];
 
 	/* write OID */
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_ifRcvAddress]) {
 	case 2:
 		/* ifRcvAddressStatus: RowStatus active(1), notInService(2) */
 		i = kif->if_flags & IFF_UP ? 1 : 2;
-		ber = ber_add_integer(ber, i);
+		ber = ober_add_integer(ber, i);
 		break;
 	case 3:
 		/* ifRcvAddressType: other(1), volatile(2), nonVolatile(3) */
-		ber = ber_add_integer(ber, 1);
+		ber = ober_add_integer(ber, 1);
 		break;
 	default:
 		return (-1);
@@ -1678,21 +1678,21 @@ mib_pfinfo(struct oid *oid, struct ber_o
 
 	switch (oid->o_oid[OIDIDX_pfstatus]) {
 	case 1:
-		*elm = ber_add_integer(*elm, s.running);
+		*elm = ober_add_integer(*elm, s.running);
 		break;
 	case 2:
 		if (!clock_gettime(CLOCK_UPTIME, &uptime))
 			runtime = uptime.tv_sec - s.since;
 		runtime *= 100;
-		*elm = ber_add_integer(*elm, runtime);
-		ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+		*elm = ober_add_integer(*elm, runtime);
+		ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 		break;
 	case 3:
-		*elm = ber_add_integer(*elm, s.debug);
+		*elm = ober_add_integer(*elm, s.debug);
 		break;
 	case 4:
 		snprintf(str, sizeof(str), "0x%08x", ntohl(s.hostid));
-		*elm = ber_add_string(*elm, str);
+		*elm = ober_add_string(*elm, str);
 		break;
 	default:
 		return (-1);
@@ -1735,8 +1735,8 @@ mib_pfcounters(struct oid *oid, struct b
 	for (i = 0;
 	    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 		if (oid->o_oid[OIDIDX_pfstatus] == mapping[i].m_id) {
-			*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-			ber_set_header(*elm, BER_CLASS_APPLICATION,
+			*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+			ober_set_header(*elm, BER_CLASS_APPLICATION,
 			    SNMP_T_COUNTER64);
 			return (0);
 		}
@@ -1763,15 +1763,15 @@ mib_pfscounters(struct oid *oid, struct 
 
 	switch (oid->o_oid[OIDIDX_pfstatus]) {
 	case 1:
-		*elm = ber_add_integer(*elm, s.states);
-		ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
+		*elm = ober_add_integer(*elm, s.states);
+		ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
 		break;
 	default:
 		for (i = 0;
 		    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 			if (oid->o_oid[OIDIDX_pfstatus] == mapping[i].m_id) {
-				*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-				ber_set_header(*elm, BER_CLASS_APPLICATION,
+				*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+				ober_set_header(*elm, BER_CLASS_APPLICATION,
 				    SNMP_T_COUNTER64);
 				return (0);
 			}
@@ -1810,14 +1810,14 @@ mib_pflogif(struct oid *oid, struct ber_
 
 	switch (oid->o_oid[OIDIDX_pfstatus]) {
 	case 1:
-		*elm = ber_add_string(*elm, s.ifname);
+		*elm = ober_add_string(*elm, s.ifname);
 		break;
 	default:
 		for (i = 0;
 		    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 			if (oid->o_oid[OIDIDX_pfstatus] == mapping[i].m_id) {
-				*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-				ber_set_header(*elm, BER_CLASS_APPLICATION,
+				*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+				ober_set_header(*elm, BER_CLASS_APPLICATION,
 				    SNMP_T_COUNTER64);
 				return (0);
 			}
@@ -1847,15 +1847,15 @@ mib_pfsrctrack(struct oid *oid, struct b
 
 	switch (oid->o_oid[OIDIDX_pfstatus]) {
 	case 1:
-		*elm = ber_add_integer(*elm, s.src_nodes);
-		ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
+		*elm = ober_add_integer(*elm, s.src_nodes);
+		ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
 		break;
 	default:
 		for (i = 0;
 		    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 			if (oid->o_oid[OIDIDX_pfstatus] == mapping[i].m_id) {
-				*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-				ber_set_header(*elm, BER_CLASS_APPLICATION,
+				*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+				ober_set_header(*elm, BER_CLASS_APPLICATION,
 				    SNMP_T_COUNTER64);
 				return (0);
 			}
@@ -1902,8 +1902,8 @@ mib_pflimits(struct oid *oid, struct ber
 		return (-1);
 	}
 
-	*elm = ber_add_integer(*elm, pl.limit);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
+	*elm = ober_add_integer(*elm, pl.limit);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
 
 	return (0);
 }
@@ -1958,7 +1958,7 @@ mib_pftimeouts(struct oid *oid, struct b
 		return (-1);
 	}
 
-	*elm = ber_add_integer(*elm, pt.seconds);
+	*elm = ober_add_integer(*elm, pt.seconds);
 
 	return (0);
 }
@@ -1971,7 +1971,7 @@ mib_pfifnum(struct oid *oid, struct ber_
 	if ((c = pfi_count()) == -1)
 		return (-1);
 
-	*elm = ber_add_integer(*elm, c);
+	*elm = ober_add_integer(*elm, c);
 
 	return (0);
 }
@@ -1989,91 +1989,91 @@ mib_pfiftable(struct oid *oid, struct be
 	if (pfi_get_if(&pif, idx))
 		return (1);
 
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_pfInterface]) {
 	case 1:
-		ber = ber_add_integer(ber, idx);
+		ber = ober_add_integer(ber, idx);
 		break;
 	case 2:
-		ber = ber_add_string(ber, pif.pfik_name);
+		ber = ober_add_string(ber, pif.pfik_name);
 		break;
 	case 3:
 		iftype = (pif.pfik_ifp == NULL ? PFI_IFTYPE_GROUP
 		    : PFI_IFTYPE_INSTANCE);
-		ber = ber_add_integer(ber, iftype);
+		ber = ober_add_integer(ber, iftype);
 		break;
 	case 4:
-		ber = ber_add_integer(ber, pif.pfik_states);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
+		ber = ober_add_integer(ber, pif.pfik_states);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
 		break;
 	case 5:
-		ber = ber_add_integer(ber, pif.pfik_rules);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
+		ber = ober_add_integer(ber, pif.pfik_rules);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_UNSIGNED32);
 		break;
 	case 6:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV4][IN][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV4][IN][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 7:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV4][IN][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV4][IN][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 8:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV4][IN][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV4][IN][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 9:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV4][IN][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV4][IN][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 10:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV4][OUT][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV4][OUT][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 11:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV4][OUT][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV4][OUT][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 12:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV4][OUT][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV4][OUT][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 13:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV4][OUT][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV4][OUT][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 14:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV6][IN][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV6][IN][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 15:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV6][IN][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV6][IN][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 16:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV6][IN][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV6][IN][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 17:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV6][IN][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV6][IN][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 18:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV6][OUT][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV6][OUT][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 19:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV6][OUT][PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV6][OUT][PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 20:
-		ber = ber_add_integer(ber, pif.pfik_packets[IPV6][OUT][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_packets[IPV6][OUT][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 21:
-		ber = ber_add_integer(ber, pif.pfik_bytes[IPV6][OUT][BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, pif.pfik_bytes[IPV6][OUT][BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	default:
 		return (1);
@@ -2090,7 +2090,7 @@ mib_pftablenum(struct oid *oid, struct b
 	if ((c = pft_count()) == -1)
 		return (-1);
 
-	*elm = ber_add_integer(*elm, c);
+	*elm = ober_add_integer(*elm, c);
 
 	return (0);
 }
@@ -2109,100 +2109,100 @@ mib_pftables(struct oid *oid, struct ber
 	if (pft_get_table(&ts, idx))
 		return (1);
 
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_pfTable]) {
 	case 1:
-		ber = ber_add_integer(ber, idx);
+		ber = ober_add_integer(ber, idx);
 		break;
 	case 2:
-		ber = ber_add_string(ber, ts.pfrts_name);
+		ber = ober_add_string(ber, ts.pfrts_name);
 		break;
 	case 3:
-		ber = ber_add_integer(ber, ts.pfrts_cnt);
+		ber = ober_add_integer(ber, ts.pfrts_cnt);
 		break;
 	case 4:
-		ber = ber_add_integer(ber, ts.pfrts_refcnt[PFR_REFCNT_ANCHOR]);
+		ber = ober_add_integer(ber, ts.pfrts_refcnt[PFR_REFCNT_ANCHOR]);
 		break;
 	case 5:
-		ber = ber_add_integer(ber, ts.pfrts_refcnt[PFR_REFCNT_RULE]);
+		ber = ober_add_integer(ber, ts.pfrts_refcnt[PFR_REFCNT_RULE]);
 		break;
 	case 6:
-		ber = ber_add_integer(ber, ts.pfrts_match);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_match);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 7:
-		ber = ber_add_integer(ber, ts.pfrts_nomatch);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_nomatch);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 8:
-		ber = ber_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 9:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 10:
-		ber = ber_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 11:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 12:
-		ber = ber_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_XPASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_XPASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 13:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_XPASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_XPASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 14:
-		ber = ber_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 15:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 16:
-		ber = ber_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 17:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 18:
-		ber = ber_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_XPASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_XPASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 19:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_XPASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_XPASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 20:
 		tzero = (time(NULL) - ts.pfrts_tzero) * 100;
-		ber = ber_add_integer(ber, tzero);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+		ber = ober_add_integer(ber, tzero);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 		break;
 	case 21:
-		ber = ber_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[IN][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 22:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[IN][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 23:
-		ber = ber_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_packets[OUT][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 24:
-		ber = ber_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, ts.pfrts_bytes[OUT][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	default:
 		return (1);
@@ -2226,71 +2226,71 @@ mib_pftableaddrs(struct oid *oid, struct
 		return (-1);
 
 	/* write OID */
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_pfTblAddr]) {
 	case 1:
-		ber = ber_add_integer(ber, tblidx);
+		ber = ober_add_integer(ber, tblidx);
 		break;
 	case 2:
-		ber = ber_add_nstring(ber, (char *)&as.pfras_a.pfra_ip4addr,
+		ber = ober_add_nstring(ber, (char *)&as.pfras_a.pfra_ip4addr,
 		    sizeof(u_int32_t));
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
 		break;
 	case 3:
-		ber = ber_add_integer(ber, as.pfras_a.pfra_net);
+		ber = ober_add_integer(ber, as.pfras_a.pfra_net);
 		break;
 	case 4:
-		ber = ber_add_integer(ber, (time(NULL) - as.pfras_tzero) * 100);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+		ber = ober_add_integer(ber, (time(NULL) - as.pfras_tzero) * 100);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 		break;
 	case 5:
-		ber = ber_add_integer(ber, as.pfras_packets[IN][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_packets[IN][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 6:
-		ber = ber_add_integer(ber, as.pfras_bytes[IN][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_bytes[IN][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 7:
-		ber = ber_add_integer(ber, as.pfras_packets[IN][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_packets[IN][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 8:
-		ber = ber_add_integer(ber, as.pfras_bytes[IN][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_bytes[IN][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 9:
-		ber = ber_add_integer(ber, as.pfras_packets[OUT][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_packets[OUT][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 10:
-		ber = ber_add_integer(ber, as.pfras_bytes[OUT][PFR_OP_BLOCK]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_bytes[OUT][PFR_OP_BLOCK]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 11:
-		ber = ber_add_integer(ber, as.pfras_packets[OUT][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_packets[OUT][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 12:
-		ber = ber_add_integer(ber, as.pfras_bytes[OUT][PFR_OP_PASS]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_bytes[OUT][PFR_OP_PASS]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 13:
-		ber = ber_add_integer(ber, as.pfras_packets[IN][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_packets[IN][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 14:
-		ber = ber_add_integer(ber, as.pfras_bytes[IN][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_bytes[IN][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 15:
-		ber = ber_add_integer(ber, as.pfras_packets[OUT][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_packets[OUT][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 16:
-		ber = ber_add_integer(ber, as.pfras_bytes[OUT][PFR_OP_MATCH]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, as.pfras_bytes[OUT][PFR_OP_MATCH]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	default:
 		return (-1);
@@ -2382,7 +2382,7 @@ mib_pflabelnum(struct oid *oid, struct b
 			lnr++;
 	}
 
-	*elm = ber_add_integer(*elm, lnr);
+	*elm = ober_add_integer(*elm, lnr);
 
 	return (0);
 }
@@ -2424,46 +2424,46 @@ mib_pflabels(struct oid *oid, struct ber
 	if (r == NULL)
 		return (1);
 
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_pfLabel]) {
 	case 1:
-		ber = ber_add_integer(ber, lnr);
+		ber = ober_add_integer(ber, lnr);
 		break;
 	case 2:
-		ber = ber_add_string(ber, r->label);
+		ber = ober_add_string(ber, r->label);
 		break;
 	case 3:
-		ber = ber_add_integer(ber, r->evaluations);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, r->evaluations);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 4:
-		ber = ber_add_integer(ber, r->packets[IN] + r->packets[OUT]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, r->packets[IN] + r->packets[OUT]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 5:
-		ber = ber_add_integer(ber, r->bytes[IN] + r->bytes[OUT]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, r->bytes[IN] + r->bytes[OUT]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 6:
-		ber = ber_add_integer(ber, r->packets[IN]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, r->packets[IN]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 7:
-		ber = ber_add_integer(ber, r->bytes[IN]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, r->bytes[IN]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 8:
-		ber = ber_add_integer(ber, r->packets[OUT]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, r->packets[OUT]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 9:
-		ber = ber_add_integer(ber, r->bytes[OUT]);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, r->bytes[OUT]);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 10:
-		ber = ber_add_integer(ber, r->states_tot);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, r->states_tot);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	default:
 		return (1);
@@ -2510,8 +2510,8 @@ mib_pfsyncstats(struct oid *oid, struct 
 	for (i = 0;
 	    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 		if (oid->o_oid[OIDIDX_pfstatus] == mapping[i].m_id) {
-			*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-			ber_set_header(*elm, BER_CLASS_APPLICATION,
+			*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+			ober_set_header(*elm, BER_CLASS_APPLICATION,
 			    SNMP_T_COUNTER64);
 			return (0);
 		}
@@ -2541,7 +2541,7 @@ mib_sensornum(struct oid *oid, struct be
 		c += sensordev.sensors_count;
 	}
 
-	*elm = ber_add_integer(*elm, c);
+	*elm = ober_add_integer(*elm, c);
 	return (0);
 }
 
@@ -2594,38 +2594,38 @@ mib_sensors(struct oid *oid, struct ber_
 	return (1);
 
  found:
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_sensor]) {
 	case 1:
-		ber = ber_add_integer(ber, (int32_t)n);
+		ber = ober_add_integer(ber, (int32_t)n);
 		break;
 	case 2:
 		if (sensor.desc[0] == '\0') {
 			snprintf(desc, sizeof(desc), "%s%d",
 			    sensor_type_s[sensor.type],
 			    sensor.numt);
-			ber = ber_add_string(ber, desc);
+			ber = ober_add_string(ber, desc);
 		} else
-			ber = ber_add_string(ber, sensor.desc);
+			ber = ober_add_string(ber, sensor.desc);
 		break;
 	case 3:
-		ber = ber_add_integer(ber, sensor.type);
+		ber = ober_add_integer(ber, sensor.type);
 		break;
 	case 4:
-		ber = ber_add_string(ber, sensordev.xname);
+		ber = ober_add_string(ber, sensordev.xname);
 		break;
 	case 5:
 		if ((s = mib_sensorvalue(&sensor)) == NULL)
 			return (-1);
-		ber = ber_add_string(ber, s);
+		ber = ober_add_string(ber, s);
 		free(s);
 		break;
 	case 6:
-		ber = ber_add_string(ber, mib_sensorunit(&sensor));
+		ber = ober_add_string(ber, mib_sensorunit(&sensor));
 		break;
 	case 7:
-		ber = ber_add_integer(ber, sensor.status);
+		ber = ober_add_integer(ber, sensor.status);
 		break;
 	}
 
@@ -2722,7 +2722,7 @@ mib_carpsysctl(struct oid *oid, struct b
 	if (sysctl(mib, 4, &v, &len, NULL, 0) == -1)
 		return (1);
 
-	*elm = ber_add_integer(*elm, v);
+	*elm = ober_add_integer(*elm, v);
 	return (0);
 }
 
@@ -2763,8 +2763,8 @@ mib_carpstats(struct oid *oid, struct be
 	for (i = 0;
 	    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 		if (oid->o_oid[OIDIDX_carpstats] == mapping[i].m_id) {
-			*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-			ber_set_header(*elm, BER_CLASS_APPLICATION,
+			*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+			ober_set_header(*elm, BER_CLASS_APPLICATION,
 			    SNMP_T_COUNTER64);
 			return (0);
 		}
@@ -2784,7 +2784,7 @@ mib_carpifnum(struct oid *oid, struct be
 		if (kif->if_type == IFT_CARP)
 			c++;
 
-	*elm = ber_add_integer(*elm, c);
+	*elm = ober_add_integer(*elm, c);
 	return (0);
 }
 
@@ -2862,29 +2862,29 @@ mib_carpiftable(struct oid *oid, struct 
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_carpIfEntry] = cif->kif.if_index;
-	*elm = ber_add_oid(*elm, o);
+	*elm = ober_add_oid(*elm, o);
 
 	switch (o->bo_id[OIDIDX_carpIf]) {
 	case 1:
-		*elm = ber_add_integer(*elm, cif->kif.if_index);
+		*elm = ober_add_integer(*elm, cif->kif.if_index);
 		break;
 	case 2:
-		*elm = ber_add_string(*elm, cif->kif.if_name);
+		*elm = ober_add_string(*elm, cif->kif.if_name);
 		break;
 	case 3:
-		*elm = ber_add_integer(*elm, cif->carpr.carpr_vhids[0]);
+		*elm = ober_add_integer(*elm, cif->carpr.carpr_vhids[0]);
 		break;
 	case 4:
-		*elm = ber_add_string(*elm, cif->carpr.carpr_carpdev);
+		*elm = ober_add_string(*elm, cif->carpr.carpr_carpdev);
 		break;
 	case 5:
-		*elm = ber_add_integer(*elm, cif->carpr.carpr_advbase);
+		*elm = ober_add_integer(*elm, cif->carpr.carpr_advbase);
 		break;
 	case 6:
-		*elm = ber_add_integer(*elm, cif->carpr.carpr_advskews[0]);
+		*elm = ober_add_integer(*elm, cif->carpr.carpr_advskews[0]);
 		break;
 	case 7:
-		*elm = ber_add_integer(*elm, cif->carpr.carpr_states[0]);
+		*elm = ober_add_integer(*elm, cif->carpr.carpr_states[0]);
 		break;
 	default:
 		free(cif);
@@ -2959,11 +2959,11 @@ mib_carpgrouptable(struct oid *oid, stru
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_carpGroupIndex] = idx;
-	*elm = ber_add_oid(*elm, o);
+	*elm = ober_add_oid(*elm, o);
 
 	switch (o->bo_id[OIDIDX_carpGroupEntry]) {
 	case 2:
-		*elm = ber_add_string(*elm, ifg->ifgrq_group);
+		*elm = ober_add_string(*elm, ifg->ifgrq_group);
 		break;
 	case 3:
 		if ((s = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
@@ -2982,7 +2982,7 @@ mib_carpgrouptable(struct oid *oid, stru
 		}
 
 		close(s);
-		*elm = ber_add_integer(*elm, ifgr.ifgr_attrib.ifg_carp_demoted);
+		*elm = ober_add_integer(*elm, ifgr.ifgr_attrib.ifg_carp_demoted);
 		break;
 	default:
 		free(ifg);
@@ -3005,15 +3005,15 @@ mib_memiftable(struct oid *oid, struct b
 		return (1);
 
 	o->bo_id[OIDIDX_memIfEntry] = kif->if_index;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_memIf]) {
 	case 1:
-		ber = ber_add_string(ber, kif->if_name);
+		ber = ober_add_string(ber, kif->if_name);
 		break;
 	case 2:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	default:
 		return (-1);
@@ -3104,7 +3104,7 @@ mib_ipforwarding(struct oid *oid, struct
 		return (-1);
 
 	/* ipForwarding: forwarding(1), notForwarding(2) */
-	*elm = ber_add_integer(*elm, (v == 0) ? 2 : 1);
+	*elm = ober_add_integer(*elm, (v == 0) ? 2 : 1);
 
 	return (0);
 }
@@ -3119,7 +3119,7 @@ mib_ipdefaultttl(struct oid *oid, struct
 	if (sysctl(mib, sizeofa(mib), &v, &len, NULL, 0) == -1)
 		return (-1);
 
-	*elm = ber_add_integer(*elm, v);
+	*elm = ober_add_integer(*elm, v);
 
 	return (0);
 }
@@ -3160,8 +3160,8 @@ mib_ipstat(struct oid *oid, struct ber_o
 	for (i = 0;
 	    (u_int)i < (sizeof(mapping) / sizeof(mapping[0])); i++) {
 		if (oid->o_oid[OIDIDX_ip] == mapping[i].m_id) {
-			*elm = ber_add_integer(*elm, *mapping[i].m_ptr);
-			ber_set_header(*elm,
+			*elm = ober_add_integer(*elm, *mapping[i].m_ptr);
+			ober_set_header(*elm,
 			    BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 			return (0);
 		}
@@ -3185,8 +3185,8 @@ mib_ipinhdrerrs(struct oid *oid, struct 
 	    ipstat.ips_badoptions + ipstat.ips_toolong +
 	    ipstat.ips_badaddr;
 
-	*elm = ber_add_integer(*elm, errors);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+	*elm = ober_add_integer(*elm, errors);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 
 	return (0);
 }
@@ -3202,8 +3202,8 @@ mib_ipinaddrerrs(struct oid *oid, struct
 
 	errors = ipstat.ips_cantforward + ipstat.ips_badaddr;
 
-	*elm = ber_add_integer(*elm, errors);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+	*elm = ober_add_integer(*elm, errors);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 
 	return (0);
 }
@@ -3219,8 +3219,8 @@ mib_ipforwdgrams(struct oid *oid, struct
 
 	counter = ipstat.ips_forward + ipstat.ips_redirectsent;
 
-	*elm = ber_add_integer(*elm, counter);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+	*elm = ober_add_integer(*elm, counter);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 
 	return (0);
 }
@@ -3242,8 +3242,8 @@ mib_ipreasmfails(struct oid *oid, struct
 
 	counter = ipstat.ips_fragdropped + ipstat.ips_fragtimeout;
 
-	*elm = ber_add_integer(*elm, counter);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+	*elm = ober_add_integer(*elm, counter);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 
 	return (0);
 }
@@ -3258,8 +3258,8 @@ mib_ipfragfails(struct oid *oid, struct 
 		return (-1);
 
 	counter = ipstat.ips_badfrags + ipstat.ips_cantfrag;
-	*elm = ber_add_integer(*elm, counter);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+	*elm = ober_add_integer(*elm, counter);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 
 	return (0);
 }
@@ -3348,27 +3348,27 @@ mib_ipaddr(struct oid *oid, struct ber_o
 		return (1);
 
 	/* write OID */
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_ipAddr]) {
 	case 1:
 		val = addr.sin_addr.s_addr;
-		ber = ber_add_nstring(ber, (char *)&val, sizeof(u_int32_t));
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
+		ber = ober_add_nstring(ber, (char *)&val, sizeof(u_int32_t));
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
 		break;
 	case 2:
-		ber = ber_add_integer(ber, ka->if_index);
+		ber = ober_add_integer(ber, ka->if_index);
 		break;
 	case 3:
 		val = ka->mask.sin.sin_addr.s_addr;
-		ber = ber_add_nstring(ber, (char *)&val, sizeof(u_int32_t));
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
+		ber = ober_add_nstring(ber, (char *)&val, sizeof(u_int32_t));
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
 		break;
 	case 4:
-		ber = ber_add_integer(ber, ka->dstbrd.sa.sa_len ? 1 : 0);
+		ber = ober_add_integer(ber, ka->dstbrd.sa.sa_len ? 1 : 0);
 		break;
 	case 5:
-		ber = ber_add_integer(ber, IP_MAXPACKET);
+		ber = ober_add_integer(ber, IP_MAXPACKET);
 		break;
 	default:
 		return (-1);
@@ -3488,31 +3488,31 @@ mib_physaddr(struct oid *oid, struct ber
 		return (1);
 
 	/* write OID */
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_ipNetToMedia]) {
 	case 1: /* ipNetToMediaIfIndex */
-		ber = ber_add_integer(ber, ka->if_index);
+		ber = ober_add_integer(ber, ka->if_index);
 		break;
 	case 2: /* ipNetToMediaPhysAddress */
 		if (bcmp(LLADDR(&ka->target.sdl), ether_zeroaddr,
 		    sizeof(ether_zeroaddr)) == 0)
-			ber = ber_add_nstring(ber, ether_zeroaddr,
+			ber = ober_add_nstring(ber, ether_zeroaddr,
 			    sizeof(ether_zeroaddr));
 		else
-			ber = ber_add_nstring(ber, LLADDR(&ka->target.sdl),
+			ber = ober_add_nstring(ber, LLADDR(&ka->target.sdl),
 			    ka->target.sdl.sdl_alen);
 		break;
 	case 3:	/* ipNetToMediaNetAddress */
 		val = addr.sin_addr.s_addr;
-		ber = ber_add_nstring(ber, (char *)&val, sizeof(u_int32_t));
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
+		ber = ober_add_nstring(ber, (char *)&val, sizeof(u_int32_t));
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_IPADDR);
 		break;
 	case 4: /* ipNetToMediaType */
 		if (ka->flags & F_STATIC)
-			ber = ber_add_integer(ber, 4); /* static */
+			ber = ober_add_integer(ber, 4); /* static */
 		else
-			ber = ber_add_integer(ber, 3); /* dynamic */
+			ber = ober_add_integer(ber, 3); /* dynamic */
 		break;
 	default:
 		return (-1);
@@ -3561,8 +3561,8 @@ static struct oid ipf_mib[] = {
 int
 mib_ipfnroutes(struct oid *oid, struct ber_oid *o, struct ber_element **elm)
 {
-	*elm = ber_add_integer(*elm, kr_routenumber());
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
+	*elm = ober_add_integer(*elm, kr_routenumber());
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
 
 	return (0);
 }
@@ -3684,11 +3684,11 @@ mib_ipfroute(struct oid *oid, struct ber
 	}
 
 	/* write OID */
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (idx) {
 	case 7: /* IfIndex */
-		ber = ber_add_integer(ber, kr->if_index);
+		ber = ober_add_integer(ber, kr->if_index);
 		break;
 	case 8: /* Type */
 		if (kr->flags & F_REJECT)
@@ -3699,7 +3699,7 @@ mib_ipfroute(struct oid *oid, struct ber
 			type = 3;
 		else
 			type = 4;
-		ber = ber_add_integer(ber, type);
+		ber = ober_add_integer(ber, type);
 		break;
 	case 9: /* Proto */
 		switch (kr->priority) {
@@ -3728,33 +3728,33 @@ mib_ipfroute(struct oid *oid, struct ber
 				proto = 1; /* not specified */
 			break;
 		}
-		ber = ber_add_integer(ber, proto);
+		ber = ober_add_integer(ber, proto);
 		break;
 	case 10: /* Age */
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
 		break;
 	case 11: /* NextHopAS */
-		ber = ber_add_integer(ber, 0);	/* unknown */
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
+		ber = ober_add_integer(ber, 0);	/* unknown */
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_GAUGE32);
 		break;
 	case 12: /* Metric1 */
-		ber = ber_add_integer(ber, -1);	/* XXX */
+		ber = ober_add_integer(ber, -1);	/* XXX */
 		break;
 	case 13: /* Metric2 */
-		ber = ber_add_integer(ber, -1);	/* XXX */
+		ber = ober_add_integer(ber, -1);	/* XXX */
 		break;
 	case 14: /* Metric3 */
-		ber = ber_add_integer(ber, -1);	/* XXX */
+		ber = ober_add_integer(ber, -1);	/* XXX */
 		break;
 	case 15: /* Metric4 */
-		ber = ber_add_integer(ber, -1);	/* XXX */
+		ber = ober_add_integer(ber, -1);	/* XXX */
 		break;
 	case 16: /* Metric5 */
-		ber = ber_add_integer(ber, -1);	/* XXX */
+		ber = ober_add_integer(ber, -1);	/* XXX */
 		break;
 	case 17: /* Status */
-		ber = ber_add_integer(ber, 1);	/* XXX */
+		ber = ober_add_integer(ber, 1);	/* XXX */
 		break;
 	default:
 		return (-1);
@@ -3804,7 +3804,7 @@ mib_diskio(struct oid *oid, struct ber_o
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_diskIOEntry] = idx;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	stats = calloc(diskcount, sizeof(*stats));
 	if (stats == NULL)
@@ -3819,34 +3819,34 @@ mib_diskio(struct oid *oid, struct ber_o
 
 	switch (o->bo_id[OIDIDX_diskIO]) {
 	case 1: /* diskIOIndex */
-		ber = ber_add_integer(ber, idx);
+		ber = ober_add_integer(ber, idx);
 		break;
 	case 2: /* diskIODevice */
-		ber = ber_add_string(ber, stats[idx - 1].ds_name);
+		ber = ober_add_string(ber, stats[idx - 1].ds_name);
 		break;
 	case 3: /* diskIONRead */
-		ber = ber_add_integer(ber, (u_int32_t)stats[idx - 1].ds_rbytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)stats[idx - 1].ds_rbytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 4: /* diskIONWritten */
-		ber = ber_add_integer(ber, (u_int32_t)stats[idx - 1].ds_wbytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)stats[idx - 1].ds_wbytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 5: /* diskIOReads */
-		ber = ber_add_integer(ber, (u_int32_t)stats[idx - 1].ds_rxfer);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)stats[idx - 1].ds_rxfer);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 6: /* diskIOWrites */
-		ber = ber_add_integer(ber, (u_int32_t)stats[idx - 1].ds_wxfer);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, (u_int32_t)stats[idx - 1].ds_wxfer);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	case 12: /* diskIONReadX */
-		ber = ber_add_integer(ber, stats[idx - 1].ds_rbytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, stats[idx - 1].ds_rbytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	case 13: /* diskIONWrittenX */
-		ber = ber_add_integer(ber, stats[idx - 1].ds_wbytes);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
+		ber = ober_add_integer(ber, stats[idx - 1].ds_wbytes);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER64);
 		break;
 	default:
 		free(stats);
@@ -3894,20 +3894,20 @@ mib_dot1dtable(struct oid *oid, struct b
 
 	/* Tables need to prepend the OID on their own */
 	o->bo_id[OIDIDX_dot1dEntry] = kif->if_index;
-	ber = ber_add_oid(ber, o);
+	ber = ober_add_oid(ber, o);
 
 	switch (o->bo_id[OIDIDX_dot1d]) {
 	case 1:
 	case 2:
-		ber = ber_add_integer(ber, kif->if_index);
+		ber = ober_add_integer(ber, kif->if_index);
 		break;
 	case 3:
-		ber = ber_add_oid(ber, &zerodotzero);
+		ber = ober_add_oid(ber, &zerodotzero);
 		break;
 	case 4:
 	case 5:
-		ber = ber_add_integer(ber, 0);
-		ber_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
+		ber = ober_add_integer(ber, 0);
+		ober_set_header(ber, BER_CLASS_APPLICATION, SNMP_T_COUNTER32);
 		break;
 	}
 
Index: usr.sbin/snmpd/mps.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/mps.c,v
retrieving revision 1.27
diff -u -p -r1.27 mps.c
--- usr.sbin/snmpd/mps.c	9 Oct 2019 06:37:53 -0000	1.27
+++ usr.sbin/snmpd/mps.c	24 Oct 2019 13:58:18 -0000
@@ -57,7 +57,7 @@ mps_getstr(struct oid *oid, struct ber_o
 
 	if (s == NULL)
 		return (-1);
-	*elm = ber_add_string(*elm, s);
+	*elm = ober_add_string(*elm, s);
 	return (0);
 }
 
@@ -73,7 +73,7 @@ mps_setstr(struct oid *oid, struct ber_o
 	if (ber->be_class != BER_CLASS_UNIVERSAL ||
 	    ber->be_type != BER_TYPE_OCTETSTRING)
 		return (-1);
-	if (ber_get_string(ber, &s) == -1)
+	if (ober_get_string(ber, &s) == -1)
 		return (-1);
 	if ((v = (void *)strdup(s)) == NULL)
 		return (-1);
@@ -87,7 +87,7 @@ mps_setstr(struct oid *oid, struct ber_o
 int
 mps_getint(struct oid *oid, struct ber_oid *o, struct ber_element **elm)
 {
-	*elm = ber_add_integer(*elm, oid->o_val);
+	*elm = ober_add_integer(*elm, oid->o_val);
 	return (0);
 }
 
@@ -96,7 +96,7 @@ mps_setint(struct oid *oid, struct ber_o
 {
 	long long	 i;
 
-	if (ber_get_integer(*elm, &i) == -1)
+	if (ober_get_integer(*elm, &i) == -1)
 		return (-1);
 	oid->o_val = i;
 
@@ -106,8 +106,8 @@ mps_setint(struct oid *oid, struct ber_o
 int
 mps_getts(struct oid *oid, struct ber_oid *o, struct ber_element **elm)
 {
-	*elm = ber_add_integer(*elm, oid->o_val);
-	ber_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
+	*elm = ober_add_integer(*elm, oid->o_val);
+	ober_set_header(*elm, BER_CLASS_APPLICATION, SNMP_T_TIMETICKS);
 	return (0);
 }
 
@@ -155,7 +155,7 @@ mps_getreq(struct snmp_message *msg, str
 	}
 
 	if ((value->o_flags & OID_TABLE) == 0)
-		elm = ber_add_oid(elm, o);
+		elm = ober_add_oid(elm, o);
 	if (value->o_get(value, o, &elm) != 0)
 		goto fail;
 
@@ -166,9 +166,9 @@ fail:
 		return (-1);
 
 	/* Set SNMPv2 extended error response. */
-	elm = ber_add_oid(elm, o);
-	elm = ber_add_null(elm);
-	ber_set_header(elm, BER_CLASS_CONTEXT, error_type);
+	elm = ober_add_oid(elm, o);
+	elm = ober_add_null(elm);
+	ober_set_header(elm, BER_CLASS_CONTEXT, error_type);
 	return (0);
 }
 
@@ -277,7 +277,7 @@ mps_getnextreq(struct snmp_message *msg,
 		/* No instance identifier specified. Append .0. */
 		if (o->bo_n + 1 > BER_MAX_OID_LEN)
 			goto fail;
-		ber = ber_add_noid(ber, o, ++o->bo_n);
+		ber = ober_add_noid(ber, o, ++o->bo_n);
 		if ((ret = next->o_get(next, o, &ber)) != 0)
 			goto fail;
 	}
@@ -289,9 +289,9 @@ fail:
 		return (-1);
 
 	/* Set SNMPv2 extended error response. */
-	ber = ber_add_oid(ber, o);
-	ber = ber_add_null(ber);
-	ber_set_header(ber, BER_CLASS_CONTEXT, error_type);
+	ber = ober_add_oid(ber, o);
+	ber = ober_add_null(ber);
+	ober_set_header(ber, BER_CLASS_CONTEXT, error_type);
 	return (0);
 }
 
@@ -308,7 +308,7 @@ mps_getbulkreq(struct snmp_message *msg,
 	*end = NULL;
 
 	for (d = NULL, len = 0; j > 0; j--) {
-		e = ber_add_sequence(NULL);
+		e = ober_add_sequence(NULL);
 		if (c == NULL)
 			c = e;
 		ret = mps_getnextreq(msg, e, o);
@@ -317,18 +317,18 @@ mps_getbulkreq(struct snmp_message *msg,
 			return (1);
 		}
 		if (ret == -1) {
-			ber_free_elements(e);
+			ober_free_elements(e);
 			if (d == NULL)
 				return (-1);
 			break;
 		}
-		len += ber_calc_len(e);
+		len += ober_calc_len(e);
 		if (len > SNMPD_MAXVARBINDLEN) {
-			ber_free_elements(e);
+			ober_free_elements(e);
 			break;
 		}
 		if (d != NULL)
-			ber_link_elements(d, e);
+			ober_link_elements(d, e);
 		d = e;
 		*end = d;
 	}
Index: usr.sbin/snmpd/parse.y
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/parse.y,v
retrieving revision 1.55
diff -u -p -r1.55 parse.y
--- usr.sbin/snmpd/parse.y	11 Jun 2019 05:36:32 -0000	1.55
+++ usr.sbin/snmpd/parse.y	24 Oct 2019 13:58:18 -0000
@@ -411,7 +411,7 @@ oid		: STRING				{
 				free($1);
 				YYERROR;
 			}
-			if (ber_string2oid($1, sysoid) == -1) {
+			if (ober_string2oid($1, sysoid) == -1) {
 				yyerror("invalid OID: %s", $1);
 				free(sysoid);
 				free($1);
@@ -430,7 +430,7 @@ trapoid		: oid					{ $$ = $1; }
 				yyerror("calloc");
 				YYERROR;
 			}
-			ber_string2oid("1.3", sysoid);
+			ober_string2oid("1.3", sysoid);
 			$$ = sysoid;
 		}
 		;
Index: usr.sbin/snmpd/smi.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/smi.c,v
retrieving revision 1.26
diff -u -p -r1.26 smi.c
--- usr.sbin/snmpd/smi.c	9 Oct 2019 06:37:53 -0000	1.26
+++ usr.sbin/snmpd/smi.c	24 Oct 2019 13:58:18 -0000
@@ -140,14 +140,14 @@ smi_string2oid(const char *oidstr, struc
 
 	/*
 	 * Parse OID strings in the common form n.n.n or n-n-n.
-	 * Based on ber_string2oid with additional support for symbolic names.
+	 * Based on ober_string2oid with additional support for symbolic names.
 	 */
 	for (p = sp = str; p != NULL; sp = p) {
 		if ((p = strpbrk(p, ".-")) != NULL)
 			*p++ = '\0';
 		if ((oid = smi_findkey(sp)) != NULL) {
 			bcopy(&oid->o_id, &ko, sizeof(ko));
-			if (o->bo_n && ber_oid_cmp(o, &ko) != 2)
+			if (o->bo_n && ober_oid_cmp(o, &ko) != 2)
 				return (-1);
 			bcopy(&ko, o, sizeof(*o));
 			errstr = NULL;
@@ -297,7 +297,7 @@ smi_debug_elements(struct ber_element *r
 	int		 constructed;
 
 	/* calculate lengths */
-	ber_calc_len(root);
+	ober_calc_len(root);
 
 	switch (root->be_encoding) {
 	case BER_TYPE_SEQUENCE:
@@ -479,20 +479,20 @@ smi_print_element(struct ber_element *ro
 
 	switch (root->be_encoding) {
 	case BER_TYPE_BOOLEAN:
-		if (ber_get_boolean(root, &d) == -1)
+		if (ober_get_boolean(root, &d) == -1)
 			goto fail;
 		if (asprintf(&str, "%s(%d)", d ? "true" : "false", d) == -1)
 			goto fail;
 		break;
 	case BER_TYPE_INTEGER:
 	case BER_TYPE_ENUMERATED:
-		if (ber_get_integer(root, &v) == -1)
+		if (ober_get_integer(root, &v) == -1)
 			goto fail;
 		if (asprintf(&str, "%lld", v) == -1)
 			goto fail;
 		break;
 	case BER_TYPE_BITSTRING:
-		if (ber_get_bitstring(root, (void *)&buf, &len) == -1)
+		if (ober_get_bitstring(root, (void *)&buf, &len) == -1)
 			goto fail;
 		if ((str = calloc(1, len * 2 + 1)) == NULL)
 			goto fail;
@@ -502,14 +502,14 @@ smi_print_element(struct ber_element *ro
 		}
 		break;
 	case BER_TYPE_OBJECT:
-		if (ber_get_oid(root, &o) == -1)
+		if (ober_get_oid(root, &o) == -1)
 			goto fail;
 		if (asprintf(&str, "%s",
 		    smi_oid2string(&o, strbuf, sizeof(strbuf), 0)) == -1)
 			goto fail;
 		break;
 	case BER_TYPE_OCTETSTRING:
-		if (ber_get_string(root, &buf) == -1)
+		if (ober_get_string(root, &buf) == -1)
 			goto fail;
 		if (root->be_class == BER_CLASS_APPLICATION &&
 		    root->be_type == SNMP_T_IPADDR) {
Index: usr.sbin/snmpd/snmpe.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/snmpe.c,v
retrieving revision 1.59
diff -u -p -r1.59 snmpe.c
--- usr.sbin/snmpd/snmpe.c	8 Aug 2019 16:50:52 -0000	1.59
+++ usr.sbin/snmpd/snmpe.c	24 Oct 2019 13:58:18 -0000
@@ -229,7 +229,7 @@ snmpe_parse(struct snmp_message *msg)
 
 	msg->sm_errstr = "invalid message";
 
-	if (ber_scanf_elements(root, "{ie", &ver, &a) != 0)
+	if (ober_scanf_elements(root, "{ie", &ver, &a) != 0)
 		goto parsefail;
 
 	/* SNMP version and community */
@@ -239,7 +239,7 @@ snmpe_parse(struct snmp_message *msg)
 	case SNMP_V2:
 		if (env->sc_min_seclevel != 0)
 			goto badversion;
-		if (ber_scanf_elements(a, "se", &comn, &msg->sm_pdu) != 0)
+		if (ober_scanf_elements(a, "se", &comn, &msg->sm_pdu) != 0)
 			goto parsefail;
 		if (strlcpy(msg->sm_community, comn,
 		    sizeof(msg->sm_community)) >= sizeof(msg->sm_community)) {
@@ -249,7 +249,7 @@ snmpe_parse(struct snmp_message *msg)
 		}
 		break;
 	case SNMP_V3:
-		if (ber_scanf_elements(a, "{iisi}e",
+		if (ober_scanf_elements(a, "{iisi}e",
 		    &msg->sm_msgid, &msg->sm_max_msg_size, &flagstr,
 		    &msg->sm_secmodel, &a) != 0)
 			goto parsefail;
@@ -267,7 +267,7 @@ snmpe_parse(struct snmp_message *msg)
 			goto parsefail;
 		}
 
-		if (ber_scanf_elements(a, "{xxe",
+		if (ober_scanf_elements(a, "{xxe",
 		    &msg->sm_ctxengineid, &msg->sm_ctxengineid_len,
 		    &ctxname, &len, &msg->sm_pdu) != 0)
 			goto parsefail;
@@ -283,7 +283,7 @@ snmpe_parse(struct snmp_message *msg)
 		goto fail;
 	}
 
-	if (ber_scanf_elements(msg->sm_pdu, "t{e", &class, &type, &a) != 0)
+	if (ober_scanf_elements(msg->sm_pdu, "t{e", &class, &type, &a) != 0)
 		goto parsefail;
 
 	/* SNMP PDU context */
@@ -354,7 +354,7 @@ snmpe_parse(struct snmp_message *msg)
 	}
 
 	/* SNMP PDU */
-	if (ber_scanf_elements(a, "iiie{et",
+	if (ober_scanf_elements(a, "iiie{et",
 	    &req, &errval, &erridx, &msg->sm_pduend,
 	    &msg->sm_varbind, &class, &type) != 0) {
 		stats->snmp_silentdrops++;
@@ -424,7 +424,7 @@ snmpe_parsevarbinds(struct snmp_message 
 		    msg->sm_b = msg->sm_b->be_next) {
 			switch (msg->sm_state++) {
 			case 0:
-				if (ber_get_oid(msg->sm_b, &o) != 0)
+				if (ober_get_oid(msg->sm_b, &o) != 0)
 					goto varfail;
 				if (o.bo_n < BER_MIN_OID_LEN ||
 				    o.bo_n > BER_MAX_OID_LEN)
@@ -444,23 +444,23 @@ snmpe_parsevarbinds(struct snmp_message 
 				switch (msg->sm_context) {
 
 				case SNMP_C_GETNEXTREQ:
-					msg->sm_c = ber_add_sequence(NULL);
+					msg->sm_c = ober_add_sequence(NULL);
 					ret = mps_getnextreq(msg, msg->sm_c,
 					    &o);
 					if (ret == 0 || ret == 1)
 						break;
-					ber_free_elements(msg->sm_c);
+					ober_free_elements(msg->sm_c);
 					msg->sm_error = SNMP_ERROR_NOSUCHNAME;
 					goto varfail;
 
 				case SNMP_C_GETREQ:
-					msg->sm_c = ber_add_sequence(NULL);
+					msg->sm_c = ober_add_sequence(NULL);
 					ret = mps_getreq(msg, msg->sm_c, &o,
 					    msg->sm_version);
 					if (ret == 0 || ret == 1)
 						break;
 					msg->sm_error = SNMP_ERROR_NOSUCHNAME;
-					ber_free_elements(msg->sm_c);
+					ober_free_elements(msg->sm_c);
 					goto varfail;
 
 				case SNMP_C_SETREQ:
@@ -493,7 +493,7 @@ snmpe_parsevarbinds(struct snmp_message 
 				if (msg->sm_last == NULL)
 					msg->sm_varbindresp = msg->sm_c;
 				else
-					ber_link_elements(msg->sm_last, msg->sm_c);
+					ober_link_elements(msg->sm_last, msg->sm_c);
 				msg->sm_last = msg->sm_end;
 				break;
 			}
@@ -570,9 +570,9 @@ snmpe_tryparse(int fd, struct snmp_messa
 {
 	struct snmp_stats	*stats = &snmpd_env->sc_stats;
 
-	ber_set_application(&msg->sm_ber, smi_application);
-	ber_set_readbuf(&msg->sm_ber, msg->sm_data, msg->sm_datalen);
-	msg->sm_req = ber_read_elements(&msg->sm_ber, NULL);
+	ober_set_application(&msg->sm_ber, smi_application);
+	ober_set_readbuf(&msg->sm_ber, msg->sm_data, msg->sm_datalen);
+	msg->sm_req = ober_read_elements(&msg->sm_ber, NULL);
 	if (msg->sm_req == NULL) {
 		if (errno == ECANCELED) {
 			/* short read; try again */
@@ -671,7 +671,7 @@ snmpe_writecb(int fd, short type, void *
 	 * Reuse the connection.
 	 * In case we already read data of the next message, copy it over.
 	 */
-	reqlen = ber_calc_len(msg->sm_req);
+	reqlen = ober_calc_len(msg->sm_req);
 	if (msg->sm_datalen > reqlen) {
 		memcpy(nmsg->sm_data, msg->sm_data + reqlen,
 		    msg->sm_datalen - reqlen);
@@ -714,10 +714,10 @@ snmpe_recvmsg(int fd, short sig, void *a
 	msg->sm_datalen = (size_t)len;
 
 	bzero(&msg->sm_ber, sizeof(msg->sm_ber));
-	ber_set_application(&msg->sm_ber, smi_application);
-	ber_set_readbuf(&msg->sm_ber, msg->sm_data, msg->sm_datalen);
+	ober_set_application(&msg->sm_ber, smi_application);
+	ober_set_readbuf(&msg->sm_ber, msg->sm_data, msg->sm_datalen);
 
-	msg->sm_req = ber_read_elements(&msg->sm_ber, NULL);
+	msg->sm_req = ober_read_elements(&msg->sm_ber, NULL);
 	if (msg->sm_req == NULL) {
 		stats->snmp_inasnparseerrs++;
 		snmp_msgfree(msg);
@@ -763,7 +763,7 @@ snmpe_response(struct snmp_message *msg)
 	ssize_t			 len;
 
 	if (msg->sm_varbindresp == NULL && msg->sm_pduend != NULL)
-		msg->sm_varbindresp = ber_unlink_elements(msg->sm_pduend);
+		msg->sm_varbindresp = ober_unlink_elements(msg->sm_pduend);
 
 	switch (msg->sm_error) {
 	case SNMP_ERROR_TOOBIG:
@@ -788,8 +788,8 @@ snmpe_response(struct snmp_message *msg)
 	if (snmpe_encode(msg) < 0)
 		goto done;
 
-	len = ber_write_elements(&msg->sm_ber, msg->sm_resp);
-	if (ber_get_writebuf(&msg->sm_ber, (void *)&ptr) == -1)
+	len = ober_write_elements(&msg->sm_ber, msg->sm_resp);
+	if (ober_get_writebuf(&msg->sm_ber, (void *)&ptr) == -1)
 		goto done;
 
 	usm_finalize_digest(msg, ptr, len);
@@ -815,11 +815,11 @@ void
 snmp_msgfree(struct snmp_message *msg)
 {
 	event_del(&msg->sm_sockev);
-	ber_free(&msg->sm_ber);
+	ober_free(&msg->sm_ber);
 	if (msg->sm_req != NULL)
-		ber_free_elements(msg->sm_req);
+		ober_free_elements(msg->sm_req);
 	if (msg->sm_resp != NULL)
-		ber_free_elements(msg->sm_resp);
+		ober_free_elements(msg->sm_resp);
 	free(msg);
 }
 
@@ -829,13 +829,13 @@ snmpe_encode(struct snmp_message *msg)
 	struct ber_element	*ehdr;
 	struct ber_element	*pdu, *epdu;
 
-	msg->sm_resp = ber_add_sequence(NULL);
-	if ((ehdr = ber_add_integer(msg->sm_resp, msg->sm_version)) == NULL)
+	msg->sm_resp = ober_add_sequence(NULL);
+	if ((ehdr = ober_add_integer(msg->sm_resp, msg->sm_version)) == NULL)
 		return -1;
 	if (msg->sm_version == SNMP_V3) {
 		char	f = MSG_SECLEVEL(msg);
 
-		if ((ehdr = ber_printf_elements(ehdr, "{iixi}", msg->sm_msgid,
+		if ((ehdr = ober_printf_elements(ehdr, "{iixi}", msg->sm_msgid,
 		    msg->sm_max_msg_size, &f, sizeof(f),
 		    msg->sm_secmodel)) == NULL)
 			return -1;
@@ -844,31 +844,31 @@ snmpe_encode(struct snmp_message *msg)
 		if ((ehdr = usm_encode(msg, ehdr)) == NULL)
 			return -1;
 	} else {
-		if ((ehdr = ber_add_string(ehdr, msg->sm_community)) == NULL)
+		if ((ehdr = ober_add_string(ehdr, msg->sm_community)) == NULL)
 			return -1;
 	}
 
-	pdu = epdu = ber_add_sequence(NULL);
+	pdu = epdu = ober_add_sequence(NULL);
 	if (msg->sm_version == SNMP_V3) {
-		if ((epdu = ber_printf_elements(epdu, "xs{",
+		if ((epdu = ober_printf_elements(epdu, "xs{",
 		    snmpd_env->sc_engineid, snmpd_env->sc_engineid_len,
 		    msg->sm_ctxname)) == NULL) {
-			ber_free_elements(pdu);
+			ober_free_elements(pdu);
 			return -1;
 		}
 	}
 
-	if (!ber_printf_elements(epdu, "tiii{e}", BER_CLASS_CONTEXT,
+	if (!ober_printf_elements(epdu, "tiii{e}", BER_CLASS_CONTEXT,
 	    msg->sm_context, msg->sm_request,
 	    msg->sm_error, msg->sm_errorindex,
 	    msg->sm_varbindresp)) {
-		ber_free_elements(pdu);
+		ober_free_elements(pdu);
 		return -1;
 	}
 
 	if (MSG_HAS_PRIV(msg))
 		pdu = usm_encrypt(msg, pdu);
-	ber_link_elements(ehdr, pdu);
+	ober_link_elements(ehdr, pdu);
 
 #ifdef DEBUG
 	fprintf(stderr, "resp msg:\n");
Index: usr.sbin/snmpd/trap.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/trap.c,v
retrieving revision 1.32
diff -u -p -r1.32 trap.c
--- usr.sbin/snmpd/trap.c	15 Apr 2018 11:57:29 -0000	1.32
+++ usr.sbin/snmpd/trap.c	24 Oct 2019 13:58:18 -0000
@@ -96,14 +96,14 @@ trap_agentx(struct agentx_handle *h, str
 				ret = AGENTX_ERR_PARSE_ERROR;
 				goto done;
 			}
-			if (state == 0 && ber_oid_cmp(&oid, &uptime) == 0) {
+			if (state == 0 && ober_oid_cmp(&oid, &uptime) == 0) {
 				if (snmp_agentx_read_int(pdu, &d) == -1) {
 					ret = AGENTX_ERR_PARSE_ERROR;
 					goto done;
 				}
 				state = 1;
 				continue;
-			} else if (ber_oid_cmp(&oid, &trapoid) == 0) {
+			} else if (ober_oid_cmp(&oid, &trapoid) == 0) {
 				if (snmp_agentx_read_oid(pdu,
 				    (struct snmp_oid *)&o) == -1) {
 					ret = AGENTX_ERR_PARSE_ERROR;
@@ -123,7 +123,7 @@ trap_agentx(struct agentx_handle *h, str
 	}
 
 	if (varbind != NULL)
-		len = ber_calc_len(varbind);
+		len = ober_calc_len(varbind);
 	log_debug("trap_agentx: from packetid %d len %zu elements %d",
 	    pdu->hdr->packetid, len, x);
 
@@ -135,7 +135,7 @@ trap_agentx(struct agentx_handle *h, str
 	return (AGENTX_ERR_NONE);
  done:
 	if (varbind != NULL)
-		ber_free_elements(varbind);
+		ober_free_elements(varbind);
 	free(v);
 	*idx = x;
 	return (ret);
@@ -174,13 +174,13 @@ trap_send(struct ber_oid *oid, struct be
 	ob.o_flags = OID_TABLE;
 
 	/* Add mandatory varbind elements */
-	trap = ber_add_sequence(NULL);
-	c = ber_printf_elements(trap, "{Odt}{OO}",
+	trap = ober_add_sequence(NULL);
+	c = ober_printf_elements(trap, "{Odt}{OO}",
 	    &uptime, smi_getticks(),
 	    BER_CLASS_APPLICATION, SNMP_T_TIMETICKS,
 	    &trapoid, oid);
 	if (elm != NULL)
-		ber_link_elements(c, elm);
+		ober_link_elements(c, elm);
 
 	bzero(&ber, sizeof(ber));
 
@@ -211,17 +211,17 @@ trap_send(struct ber_oid *oid, struct be
 		    tr->sa_community : snmpd_env->sc_trcommunity;
 
 		/* SNMP header */
-		root = ber_add_sequence(NULL);
-		b = ber_printf_elements(root, "ds{tddd",
+		root = ober_add_sequence(NULL);
+		b = ober_printf_elements(root, "ds{tddd",
 		    SNMP_V2, cmn, BER_CLASS_CONTEXT, SNMP_C_TRAPV2,
 		    arc4random(), 0, 0);
-		ber_link_elements(b, trap);
+		ober_link_elements(b, trap);
 
 #ifdef DEBUG
 		smi_debug_elements(root);
 #endif
-		len = ber_write_elements(&ber, root);
-		if (ber_get_writebuf(&ber, (void *)&ptr) > 0 &&
+		len = ober_write_elements(&ber, root);
+		if (ober_get_writebuf(&ber, (void *)&ptr) > 0 &&
 		    sendto(s, ptr, len, 0, (struct sockaddr *)&tr->ss,
 		    tr->ss.ss_len) != -1) {
 			snmpd_env->sc_stats.snmp_outpkts++;
@@ -229,13 +229,13 @@ trap_send(struct ber_oid *oid, struct be
 		}
 
 		close(s);
-		ber_unlink_elements(b);
-		ber_free_elements(root);
+		ober_unlink_elements(b);
+		ober_free_elements(root);
 	}
 
  done:
-	ber_free_elements(trap);
-	ber_free(&ber);
+	ober_free_elements(trap);
+	ober_free(&ber);
 
 	return (ret);
 }
Index: usr.sbin/snmpd/traphandler.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/traphandler.c,v
retrieving revision 1.14
diff -u -p -r1.14 traphandler.c
--- usr.sbin/snmpd/traphandler.c	14 Aug 2019 04:43:32 -0000	1.14
+++ usr.sbin/snmpd/traphandler.c	24 Oct 2019 13:58:18 -0000
@@ -205,7 +205,7 @@ traphandler_recvmsg(int fd, short events
 
  done:
 	if (req != NULL)
-		ber_free_elements(req);
+		ober_free_elements(req);
 	return;
 }
 
@@ -221,26 +221,26 @@ traphandler_parse(char *buf, size_t n, s
 	u_int			 vers, gtype, etype;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_application(&ber, smi_application);
-	ber_set_readbuf(&ber, buf, n);
+	ober_set_application(&ber, smi_application);
+	ober_set_readbuf(&ber, buf, n);
 
-	if ((*req = ber_read_elements(&ber, NULL)) == NULL)
+	if ((*req = ober_read_elements(&ber, NULL)) == NULL)
 		goto done;
 
-	if (ber_scanf_elements(*req, "{dSe", &vers, &elm) == -1)
+	if (ober_scanf_elements(*req, "{dSe", &vers, &elm) == -1)
 		goto done;
 
 	switch (vers) {
 	case SNMP_V1:
-		if (ber_scanf_elements(elm, "{oSddd",
+		if (ober_scanf_elements(elm, "{oSddd",
 		    trapoid, &gtype, &etype, uptime) == -1)
 			goto done;
 		traphandler_v1translate(trapoid, gtype, etype);
 		break;
 
 	case SNMP_V2:
-		if (ber_scanf_elements(elm, "{SSS{e}}", &elm) == -1 ||
-		    ber_scanf_elements(elm, "{Sd}{So}",
+		if (ober_scanf_elements(elm, "{SSS{e}}", &elm) == -1 ||
+		    ober_scanf_elements(elm, "{Sd}{So}",
 		    uptime, trapoid) == -1)
 			goto done;
 		*vbinds = elm->be_next->be_next;
@@ -251,13 +251,13 @@ traphandler_parse(char *buf, size_t n, s
 		goto done;
 	}
 
-	ber_free(&ber);
+	ober_free(&ber);
 	return (0);
 
  done:
-	ber_free(&ber);
+	ober_free(&ber);
 	if (*req)
-		ber_free_elements(*req);
+		ober_free_elements(*req);
 	*req = NULL;
 	return (-1);
 }
@@ -340,7 +340,7 @@ traphandler_fork_handler(struct privsep_
 		trapcmd_exec(cmd, sa, iter, oidbuf, uptime);
 
 	if (req != NULL)
-		ber_free_elements(req);
+		ober_free_elements(req);
 
 	exit(0);
 }
@@ -409,7 +409,7 @@ trapcmd_exec(struct trapcmd *cmd, struct
 		goto out;
 
 	for (; iter != NULL; iter = iter->be_next) {
-		if (ber_scanf_elements(iter, "{oe}", &oid, &elm) == -1)
+		if (ober_scanf_elements(iter, "{oe}", &oid, &elm) == -1)
 			goto out;
 		if ((value = smi_print_element(elm)) == NULL)
 			goto out;
@@ -471,7 +471,7 @@ trapcmd_cmp(struct trapcmd *cmd1, struct
 {
 	int ret;
 
-	ret = ber_oid_cmp(cmd2->cmd_oid, cmd1->cmd_oid);
+	ret = ober_oid_cmp(cmd2->cmd_oid, cmd1->cmd_oid);
 	switch (ret) {
 	case 2:
 		/* cmd1 is a child of cmd2 */
Index: usr.sbin/snmpd/usm.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/usm.c,v
retrieving revision 1.16
diff -u -p -r1.16 usm.c
--- usr.sbin/snmpd/usm.c	11 Jun 2019 05:36:32 -0000	1.16
+++ usr.sbin/snmpd/usm.c	24 Oct 2019 13:58:18 -0000
@@ -281,16 +281,16 @@ usm_decode(struct snmp_message *msg, str
 	long long		 engine_boots, engine_time;
 
 	bzero(&ber, sizeof(ber));
-	offs = ber_getpos(elm);
+	offs = ober_getpos(elm);
 
-	if (ber_get_nstring(elm, (void *)&usmparams, &len) < 0) {
+	if (ober_get_nstring(elm, (void *)&usmparams, &len) < 0) {
 		*errp = "cannot decode security params";
 		msg->sm_flags &= SNMP_MSGFLAG_REPORT;
 		goto done;
 	}
 
-	ber_set_readbuf(&ber, usmparams, len);
-	usm = ber_read_elements(&ber, NULL);
+	ober_set_readbuf(&ber, usmparams, len);
+	usm = ober_read_elements(&ber, NULL);
 	if (usm == NULL) {
 		*errp = "cannot decode security params";
 		msg->sm_flags &= SNMP_MSGFLAG_REPORT;
@@ -302,7 +302,7 @@ usm_decode(struct snmp_message *msg, str
 	smi_debug_elements(usm);
 #endif
 
-	if (ber_scanf_elements(usm, "{xiixpxx", &engineid, &enginelen,
+	if (ober_scanf_elements(usm, "{xiixpxx", &engineid, &enginelen,
 	    &engine_boots, &engine_time, &user, &userlen, &offs2,
 	    &digest, &digestlen, &salt, &saltlen) != 0) {
 		*errp = "cannot decode USM params";
@@ -374,7 +374,7 @@ usm_decode(struct snmp_message *msg, str
 			msg->sm_flags &= SNMP_MSGFLAG_REPORT;
 			goto done;
 		}
-		ber_replace_elements(elm, decr);
+		ober_replace_elements(elm, decr);
 	}
 
 	now = snmpd_engine_time();
@@ -390,9 +390,9 @@ usm_decode(struct snmp_message *msg, str
 	next = elm->be_next;
 
 done:
-	ber_free(&ber);
+	ober_free(&ber);
 	if (usm != NULL)
-		ber_free_elements(usm);
+		ober_free_elements(usm);
 	return next;
 }
 
@@ -409,7 +409,7 @@ usm_encode(struct snmp_message *msg, str
 	msg->sm_digest_offs = 0;
 	bzero(&ber, sizeof(ber));
 
-	usm = ber_add_sequence(NULL);
+	usm = ober_add_sequence(NULL);
 
 	if (MSG_HAS_AUTH(msg)) {
 		/*
@@ -438,34 +438,34 @@ usm_encode(struct snmp_message *msg, str
 
 	msg->sm_engine_boots = (u_int32_t)snmpd_env->sc_engine_boots;
 	msg->sm_engine_time = (u_int32_t)snmpd_engine_time();
-	if ((a = ber_printf_elements(usm, "xdds",
+	if ((a = ober_printf_elements(usm, "xdds",
 	    snmpd_env->sc_engineid, snmpd_env->sc_engineid_len,
 	    msg->sm_engine_boots, msg->sm_engine_time,
 	    msg->sm_username)) == NULL)
 		goto done;
 
-	if ((a = ber_add_nstring(a, digest, digestlen)) == NULL)
+	if ((a = ober_add_nstring(a, digest, digestlen)) == NULL)
 		goto done;
 	if (digestlen > 0)
-		ber_set_writecallback(a, usm_cb_digest, msg);
+		ober_set_writecallback(a, usm_cb_digest, msg);
 
-	if ((a = ber_add_nstring(a, msg->sm_salt, saltlen)) == NULL)
+	if ((a = ober_add_nstring(a, msg->sm_salt, saltlen)) == NULL)
 		goto done;
 
 #ifdef DEBUG
 	fprintf(stderr, "encode USM parameters:\n");
 	smi_debug_elements(usm);
 #endif
-	len = ber_write_elements(&ber, usm);
-	if (ber_get_writebuf(&ber, &ptr) > 0) {
-		res = ber_add_nstring(e, (char *)ptr, len);
+	len = ober_write_elements(&ber, usm);
+	if (ober_get_writebuf(&ber, &ptr) > 0) {
+		res = ober_add_nstring(e, (char *)ptr, len);
 		if (digestlen > 0)
-			ber_set_writecallback(res, usm_cb_digest, msg);
+			ober_set_writecallback(res, usm_cb_digest, msg);
 	}
 
 done:
-	ber_free(&ber);
-	ber_free_elements(usm);
+	ober_free(&ber);
+	ober_free_elements(usm);
 	return res;
 }
 
@@ -495,15 +495,15 @@ usm_encrypt(struct snmp_message *msg, st
 	smi_debug_elements(pdu);
 #endif
 
-	len = ber_write_elements(&ber, pdu);
-	if (ber_get_writebuf(&ber, &ptr) > 0) {
+	len = ober_write_elements(&ber, pdu);
+	if (ober_get_writebuf(&ber, &ptr) > 0) {
 		elen = usm_crypt(msg, ptr, len, encbuf, 1);
 		if (elen > 0)
-			encrpdu = ber_add_nstring(NULL, (char *)encbuf, elen);
+			encrpdu = ober_add_nstring(NULL, (char *)encbuf, elen);
 	}
 
-	ber_free(&ber);
-	ber_free_elements(pdu);
+	ober_free(&ber);
+	ober_free_elements(pdu);
 	return encrpdu;
 }
 
@@ -552,8 +552,8 @@ usm_make_report(struct snmp_message *msg
 	usmstat.bo_id[OIDIDX_usmStats] = msg->sm_usmerr;
 	usmstat.bo_n = OIDIDX_usmStats + 2;
 	if (msg->sm_varbindresp != NULL)
-		ber_free_elements(msg->sm_varbindresp);
-	msg->sm_varbindresp = ber_add_sequence(NULL);
+		ober_free_elements(msg->sm_varbindresp);
+	msg->sm_varbindresp = ober_add_sequence(NULL);
 	mps_getreq(NULL, msg->sm_varbindresp, &usmstat, msg->sm_version);
 	return;
 }
@@ -601,7 +601,7 @@ usm_decrypt(struct snmp_message *msg, st
 	struct ber_element	*scoped_pdu = NULL;
 	ssize_t			 scoped_pdu_len;
 
-	if (ber_get_nstring(encr, (void *)&privstr, &privlen) < 0)
+	if (ober_get_nstring(encr, (void *)&privstr, &privlen) < 0)
 		return NULL;
 
 	scoped_pdu_len = usm_crypt(msg, privstr, (int)privlen, buf, 0);
@@ -609,8 +609,8 @@ usm_decrypt(struct snmp_message *msg, st
 		return NULL;
 
 	bzero(&ber, sizeof(ber));
-	ber_set_readbuf(&ber, buf, scoped_pdu_len);
-	scoped_pdu = ber_read_elements(&ber, NULL);
+	ober_set_readbuf(&ber, buf, scoped_pdu_len);
+	scoped_pdu = ober_read_elements(&ber, NULL);
 
 #ifdef DEBUG
 	if (scoped_pdu != NULL) {
@@ -619,7 +619,7 @@ usm_decrypt(struct snmp_message *msg, st
 	}
 #endif
 
-	ber_free(&ber);
+	ober_free(&ber);
 	return scoped_pdu;
 }
 
Index: usr.sbin/snmpd/util.c
===================================================================
RCS file: /cvs/src/usr.sbin/snmpd/util.c,v
retrieving revision 1.8
diff -u -p -r1.8 util.c
--- usr.sbin/snmpd/util.c	11 May 2019 17:46:02 -0000	1.8
+++ usr.sbin/snmpd/util.c	24 Oct 2019 13:58:18 -0000
@@ -50,18 +50,18 @@ varbind_convert(struct agentx_pdu *pdu, 
 		goto done;
 	}
 
-	*iter = ber_add_sequence(*iter);
+	*iter = ober_add_sequence(*iter);
 	if (*varbind == NULL)
 		*varbind = *iter;
 
-	a = ber_add_oid(*iter, &oid);
+	a = ober_add_oid(*iter, &oid);
 
 	switch (vbhdr->type) {
 	case AGENTX_NO_SUCH_OBJECT:
 	case AGENTX_NO_SUCH_INSTANCE:
 	case AGENTX_END_OF_MIB_VIEW:
 	case AGENTX_NULL:
-		a = ber_add_null(a);
+		a = ober_add_null(a);
 		break;
 
 	case AGENTX_IP_ADDRESS:
@@ -72,7 +72,7 @@ varbind_convert(struct agentx_pdu *pdu, 
 			ret = AGENTX_ERR_PARSE_ERROR;
 			goto done;
 		}
-		a = ber_add_nstring(a, str, slen);
+		a = ober_add_nstring(a, str, slen);
 		break;
 
 	case AGENTX_OBJECT_IDENTIFIER:
@@ -81,7 +81,7 @@ varbind_convert(struct agentx_pdu *pdu, 
 			ret = AGENTX_ERR_PARSE_ERROR;
 			goto done;
 		}
-		a = ber_add_oid(a, &oid);
+		a = ober_add_oid(a, &oid);
 		break;
 
 	case AGENTX_INTEGER:
@@ -92,7 +92,7 @@ varbind_convert(struct agentx_pdu *pdu, 
 			ret = AGENTX_ERR_PARSE_ERROR;
 			goto done;
 		}
-		a = ber_add_integer(a, d);
+		a = ober_add_integer(a, d);
 		break;
 
 	case AGENTX_COUNTER64:
@@ -100,7 +100,7 @@ varbind_convert(struct agentx_pdu *pdu, 
 			ret = AGENTX_ERR_PARSE_ERROR;
 			goto done;
 		}
-		a = ber_add_integer(a, l);
+		a = ober_add_integer(a, l);
 		break;
 
 	default:
@@ -121,22 +121,22 @@ varbind_convert(struct agentx_pdu *pdu, 
 
 	/* Convert AgentX error types to SNMP error types */
 	case AGENTX_NO_SUCH_OBJECT:
-		ber_set_header(a, BER_CLASS_CONTEXT, 0);
+		ober_set_header(a, BER_CLASS_CONTEXT, 0);
 		break;
 	case AGENTX_NO_SUCH_INSTANCE:
-		ber_set_header(a, BER_CLASS_CONTEXT, 1);
+		ober_set_header(a, BER_CLASS_CONTEXT, 1);
 		break;
 
 	case AGENTX_COUNTER32:
-		ber_set_header(a, BER_CLASS_APPLICATION, SNMP_COUNTER32);
+		ober_set_header(a, BER_CLASS_APPLICATION, SNMP_COUNTER32);
 		break;
 
 	case AGENTX_GAUGE32:
-		ber_set_header(a, BER_CLASS_APPLICATION, SNMP_GAUGE32);
+		ober_set_header(a, BER_CLASS_APPLICATION, SNMP_GAUGE32);
 		break;
 
 	case AGENTX_COUNTER64:
-		ber_set_header(a, BER_CLASS_APPLICATION, SNMP_COUNTER64);
+		ober_set_header(a, BER_CLASS_APPLICATION, SNMP_COUNTER64);
 		break;
 
 	case AGENTX_IP_ADDRESS:
@@ -145,7 +145,7 @@ varbind_convert(struct agentx_pdu *pdu, 
 
 	default:
 		/* application-specific types */
-		ber_set_header(a, BER_CLASS_APPLICATION, vbhdr->type);
+		ober_set_header(a, BER_CLASS_APPLICATION, vbhdr->type);
 		break;
 	}
  done:
Index: usr.sbin/ypldap/aldap.c
===================================================================
RCS file: /cvs/src/usr.sbin/ypldap/aldap.c,v
retrieving revision 1.46
diff -u -p -r1.46 aldap.c
--- usr.sbin/ypldap/aldap.c	10 Sep 2019 14:35:32 -0000	1.46
+++ usr.sbin/ypldap/aldap.c	24 Oct 2019 13:58:18 -0000
@@ -74,7 +74,7 @@ aldap_close(struct aldap *al)
 		tls_free(al->tls);
 	}
 	close(al->fd);
-	ber_free(&al->ber);
+	ober_free(&al->ber);
 	evbuffer_free(al->buf);
 	free(al);
 
@@ -90,7 +90,7 @@ aldap_init(int fd)
 		return NULL;
 	a->buf = evbuffer_new();
 	a->fd = fd;
-	ber_set_application(&a->ber, aldap_application);
+	ober_set_application(&a->ber, aldap_application);
 
 	return a;
 }
@@ -130,13 +130,13 @@ aldap_send(struct aldap *ldap, struct be
 	size_t len, done;
 	ssize_t	error, wrote;
 
-	len = ber_calc_len(root);
-	error = ber_write_elements(&ldap->ber, root);
-	ber_free_elements(root);
+	len = ober_calc_len(root);
+	error = ober_write_elements(&ldap->ber, root);
+	ober_free_elements(root);
 	if (error == -1)
 		return -1;
 
-	ber_get_writebuf(&ldap->ber, &ptr);
+	ober_get_writebuf(&ldap->ber, &ptr);
 	done = 0;
 	data = ptr;
 	while (len > 0) {
@@ -163,10 +163,10 @@ aldap_req_starttls(struct aldap *ldap)
 {
 	struct ber_element *root = NULL, *ber;
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	ber = ber_printf_elements(root, "d{tst", ++ldap->msgid, BER_CLASS_APP,
+	ber = ober_printf_elements(root, "d{tst", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_EXTENDED, LDAP_STARTTLS_OID, BER_CLASS_CONTEXT, 0);
 	if (ber == NULL) {
 		ldap->err = ALDAP_ERR_OPERATION_FAILED;
@@ -179,7 +179,7 @@ aldap_req_starttls(struct aldap *ldap)
 	return (ldap->msgid);
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	ldap->err = ALDAP_ERR_OPERATION_FAILED;
 	return (-1);
@@ -195,10 +195,10 @@ aldap_bind(struct aldap *ldap, char *bin
 	if (bindcred == NULL)
 		bindcred = "";
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	elm = ber_printf_elements(root, "d{tdsst", ++ldap->msgid, BER_CLASS_APP,
+	elm = ober_printf_elements(root, "d{tdsst", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_BIND, VERSION, binddn, bindcred,
 	    BER_CLASS_CONTEXT, LDAP_AUTH_SIMPLE);
 	if (elm == NULL)
@@ -213,7 +213,7 @@ aldap_bind(struct aldap *ldap, char *bin
 	return (ldap->msgid);
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	ldap->err = ALDAP_ERR_OPERATION_FAILED;
 	return (-1);
@@ -224,9 +224,9 @@ aldap_unbind(struct aldap *ldap)
 {
 	struct ber_element *root = NULL, *elm;
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
-	elm = ber_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
+	elm = ober_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_UNBIND_30);
 	if (elm == NULL)
 		goto fail;
@@ -240,7 +240,7 @@ aldap_unbind(struct aldap *ldap)
 	return (ldap->msgid);
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	ldap->err = ALDAP_ERR_OPERATION_FAILED;
 
@@ -255,10 +255,10 @@ aldap_search(struct aldap *ldap, char *b
 	struct ber_element *root = NULL, *ber, *c;
 	int i;
 
-	if ((root = ber_add_sequence(NULL)) == NULL)
+	if ((root = ober_add_sequence(NULL)) == NULL)
 		goto fail;
 
-	ber = ber_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
+	ber = ober_printf_elements(root, "d{t", ++ldap->msgid, BER_CLASS_APP,
 	    LDAP_REQ_SEARCH);
 	if (ber == NULL) {
 		ldap->err = ALDAP_ERR_OPERATION_FAILED;
@@ -266,7 +266,7 @@ aldap_search(struct aldap *ldap, char *b
 	}
 
 	c = ber;	
-	ber = ber_printf_elements(ber, "sEEddb", basedn, (long long)scope,
+	ber = ober_printf_elements(ber, "sEEddb", basedn, (long long)scope,
 	                         (long long)LDAP_DEREF_NEVER, sizelimit, 
 				 timelimit, typesonly);
 	if (ber == NULL) {
@@ -279,11 +279,11 @@ aldap_search(struct aldap *ldap, char *b
 		goto fail;
 	}
 
-	if ((ber = ber_add_sequence(ber)) == NULL)
+	if ((ber = ober_add_sequence(ber)) == NULL)
 		goto fail;
 	if (attrs != NULL)
 		for (i = 0; attrs[i] != NULL; i++) {
-			if ((ber = ber_add_string(ber, attrs[i])) == NULL)
+			if ((ber = ober_add_string(ber, attrs[i])) == NULL)
 				goto fail;
 		}
 
@@ -301,7 +301,7 @@ aldap_search(struct aldap *ldap, char *b
 
 fail:
 	if (root != NULL)
-		ber_free_elements(root);
+		ober_free_elements(root);
 
 	return (-1);
 }
@@ -316,30 +316,30 @@ aldap_create_page_control(struct ber_ele
 
 	c.br_wbuf = NULL;
 
-	ber = ber_add_sequence(NULL);
+	ber = ober_add_sequence(NULL);
 
 	if (page == NULL) {
-		if (ber_printf_elements(ber, "ds", 50, "") == NULL)
+		if (ober_printf_elements(ber, "ds", 50, "") == NULL)
 			goto fail;
 	} else {
-		if (ber_printf_elements(ber, "dx", 50, page->cookie,
+		if (ober_printf_elements(ber, "dx", 50, page->cookie,
 			    page->cookie_len) == NULL)
 			goto fail;
 	}
 
-	if ((len = ber_write_elements(&c, ber)) < 1)
+	if ((len = ober_write_elements(&c, ber)) < 1)
 		goto fail;
-	if (ber_printf_elements(elm, "{t{sx", 2, 0, LDAP_PAGED_OID,
+	if (ober_printf_elements(elm, "{t{sx", 2, 0, LDAP_PAGED_OID,
 		                c.br_wbuf, (size_t)len) == NULL)
 		goto fail;
 
-	ber_free_elements(ber);
-	ber_free(&c);
+	ober_free_elements(ber);
+	ober_free(&c);
 	return len;
 fail:
 	if (ber != NULL)
-		ber_free_elements(ber);
-	ber_free(&c);	
+		ober_free_elements(ber);
+	ober_free(&c);	
 
 	return (-1);
 }
@@ -377,10 +377,10 @@ aldap_parse(struct aldap *ldap)
 		}
 
 		if (EVBUFFER_LENGTH(ldap->buf) > 0) {
-			ber_set_readbuf(&ldap->ber, EVBUFFER_DATA(ldap->buf),
+			ober_set_readbuf(&ldap->ber, EVBUFFER_DATA(ldap->buf),
 			    EVBUFFER_LENGTH(ldap->buf));
 			errno = 0;
-			m->msg = ber_read_elements(&ldap->ber, NULL);
+			m->msg = ober_read_elements(&ldap->ber, NULL);
 			if (errno != 0 && errno != ECANCELED) {
 				goto parsefail;
 			}
@@ -393,7 +393,7 @@ aldap_parse(struct aldap *ldap)
 
 	LDAP_DEBUG("message", m->msg);
 
-	if (ber_scanf_elements(m->msg, "{ite", &msgid, &class, &type, &a) != 0)
+	if (ober_scanf_elements(m->msg, "{ite", &msgid, &class, &type, &a) != 0)
 		goto parsefail;
 	m->msgid = msgid;
 	m->message_type = type;
@@ -407,17 +407,17 @@ aldap_parse(struct aldap *ldap)
 	case LDAP_RES_MODRDN:
 	case LDAP_RES_COMPARE:
 	case LDAP_RES_SEARCH_RESULT:
-		if (ber_scanf_elements(m->protocol_op, "{EeSe",
+		if (ober_scanf_elements(m->protocol_op, "{EeSe",
 		    &m->body.res.rescode, &m->dn, &m->body.res.diagmsg) != 0)
 			goto parsefail;
 		if (m->body.res.rescode == LDAP_REFERRAL) {
 			a = m->body.res.diagmsg->be_next;
-			if (ber_scanf_elements(a, "{e", &m->references) != 0)
+			if (ober_scanf_elements(a, "{e", &m->references) != 0)
 				goto parsefail;
 		}
 		if (m->msg->be_sub) {
 			for (ep = m->msg->be_sub; ep != NULL; ep = ep->be_next) {
-				ber_scanf_elements(ep, "t", &class, &type);
+				ober_scanf_elements(ep, "t", &class, &type);
 				if (class == 2 && type == 0)
 					m->page = aldap_parse_page_control(ep->be_sub->be_sub,
 					    ep->be_sub->be_sub->be_len);
@@ -426,16 +426,16 @@ aldap_parse(struct aldap *ldap)
 			m->page = NULL;
 		break;
 	case LDAP_RES_SEARCH_ENTRY:
-		if (ber_scanf_elements(m->protocol_op, "{eS{e", &m->dn,
+		if (ober_scanf_elements(m->protocol_op, "{eS{e", &m->dn,
 		    &m->body.search.attrs) != 0)
 			goto parsefail;
 		break;
 	case LDAP_RES_SEARCH_REFERENCE:
-		if (ber_scanf_elements(m->protocol_op, "{e", &m->references) != 0)
+		if (ober_scanf_elements(m->protocol_op, "{e", &m->references) != 0)
 			goto parsefail;
 		break;
 	case LDAP_RES_EXTENDED:
-		if (ber_scanf_elements(m->protocol_op, "{E",
+		if (ober_scanf_elements(m->protocol_op, "{E",
 		    &m->body.res.rescode) != 0) {
 			goto parsefail;
 		}
@@ -460,31 +460,31 @@ aldap_parse_page_control(struct ber_elem
 	struct aldap_page_control *page;
 
 	b.br_wbuf = NULL;
-	ber_scanf_elements(control, "ss", &oid, &encoded);
-	ber_set_readbuf(&b, encoded, control->be_next->be_len);
-	elm = ber_read_elements(&b, NULL);
+	ober_scanf_elements(control, "ss", &oid, &encoded);
+	ober_set_readbuf(&b, encoded, control->be_next->be_len);
+	elm = ober_read_elements(&b, NULL);
 
 	if ((page = malloc(sizeof(struct aldap_page_control))) == NULL) {
 		if (elm != NULL)
-			ber_free_elements(elm);
-		ber_free(&b);
+			ober_free_elements(elm);
+		ober_free(&b);
 		return NULL;
 	}
 
-	ber_scanf_elements(elm->be_sub, "is", &page->size, &s);
+	ober_scanf_elements(elm->be_sub, "is", &page->size, &s);
 	page->cookie_len = elm->be_sub->be_next->be_len;
 
 	if ((page->cookie = malloc(page->cookie_len)) == NULL) {
 		if (elm != NULL)
-			ber_free_elements(elm);
-		ber_free(&b);
+			ober_free_elements(elm);
+		ober_free(&b);
 		free(page);
 		return NULL;
 	}
 	memcpy(page->cookie, s, page->cookie_len);
 
-	ber_free_elements(elm);
-	ber_free(&b);
+	ober_free_elements(elm);
+	ober_free(&b);
 	return page;
 }
 
@@ -499,7 +499,7 @@ void
 aldap_freemsg(struct aldap_message *msg)
 {
 	if (msg->msg)
-		ber_free_elements(msg->msg);
+		ober_free_elements(msg->msg);
 	free(msg);
 }
 
@@ -517,7 +517,7 @@ aldap_get_dn(struct aldap_message *msg)
 	if (msg->dn == NULL)
 		return NULL;
 
-	if (ber_get_string(msg->dn, &dn) == -1)
+	if (ober_get_string(msg->dn, &dn) == -1)
 		return NULL;
 
 	return utoa(dn);
@@ -553,7 +553,7 @@ aldap_get_diagmsg(struct aldap_message *
 	if (msg->body.res.diagmsg == NULL)
 		return NULL;
 
-	if (ber_get_string(msg->body.res.diagmsg, &s) == -1)
+	if (ober_get_string(msg->body.res.diagmsg, &s) == -1)
 		return NULL;
 
 	return utoa(s);
@@ -569,7 +569,7 @@ aldap_count_attrs(struct aldap_message *
 		return (-1);
 
 	for (i = 0, a = msg->body.search.attrs;
-	    a != NULL && ber_get_eoc(a) != 0;
+	    a != NULL && ober_get_eoc(a) != 0;
 	    i++, a = a->be_next)
 		;
 
@@ -587,7 +587,7 @@ aldap_first_attr(struct aldap_message *m
 	if (msg->body.search.attrs == NULL)
 		goto fail;
 
-	if (ber_scanf_elements(msg->body.search.attrs, "{s(e)}e",
+	if (ober_scanf_elements(msg->body.search.attrs, "{s(e)}e",
 	    &key, &b, &c) != 0)
 		goto fail;
 
@@ -619,10 +619,10 @@ aldap_next_attr(struct aldap_message *ms
 
 	LDAP_DEBUG("attr", msg->body.search.iter);
 
-	if (ber_get_eoc(msg->body.search.iter) == 0)
+	if (ober_get_eoc(msg->body.search.iter) == 0)
 		goto notfound;
 
-	if (ber_scanf_elements(msg->body.search.iter, "{s(e)}e", &key, &a, &b)
+	if (ober_scanf_elements(msg->body.search.iter, "{s(e)}e", &key, &a, &b)
 	    != 0)
 		goto fail;
 
@@ -658,9 +658,9 @@ aldap_match_attr(struct aldap_message *m
 	for (a = msg->body.search.attrs;;) {
 		if (a == NULL)
 			goto notfound;
-		if (ber_get_eoc(a) == 0)
+		if (ober_get_eoc(a) == 0)
 			goto notfound;
-		if (ber_scanf_elements(a, "{s(e", &descr, &b) != 0)
+		if (ober_scanf_elements(a, "{s(e", &descr, &b) != 0)
 			goto fail;
 		if (strcasecmp(descr, inkey) == 0)
 			goto attrfound;
@@ -864,7 +864,7 @@ aldap_get_stringset(struct ber_element *
 
 	for (a = elm, i = 0; a != NULL && a->be_type == BER_TYPE_OCTETSTRING;
 	    a = a->be_next, i++)
-		(void) ber_get_ostring(a, &(ret->str[i]));
+		(void) ober_get_ostring(a, &(ret->str[i]));
 
 	return ret;
 }
@@ -893,8 +893,8 @@ ldap_parse_search_filter(struct ber_elem
 		return (NULL);
 
 	if (*cp != '\0') {
-		ber_free_elements(elm);
-		ber_link_elements(ber, NULL);
+		ober_free_elements(elm);
+		ober_link_elements(ber, NULL);
 		errno = EINVAL;
 		return (NULL);
 	}
@@ -941,10 +941,10 @@ ldap_do_parse_search_filter(struct ber_e
 		else
 			type = LDAP_FILT_OR;
 
-		if ((elm = ber_add_set(prev)) == NULL)
+		if ((elm = ober_add_set(prev)) == NULL)
 			goto callfail;
 		root = elm;
-		ber_set_header(elm, BER_CLASS_CONTEXT, type);
+		ober_set_header(elm, BER_CLASS_CONTEXT, type);
 
 		if (*++cp != '(')		/* opening `(` of filter */
 			goto syntaxfail;
@@ -960,9 +960,9 @@ ldap_do_parse_search_filter(struct ber_e
 		break;
 
 	case '!':		/* NOT */
-		if ((root = ber_add_sequence(prev)) == NULL)
+		if ((root = ober_add_sequence(prev)) == NULL)
 			goto callfail;
-		ber_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_NOT);
+		ober_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_NOT);
 
 		cp++;				/* now points to sub-filter */
 		if ((elm = ldap_do_parse_search_filter(root, &cp)) == NULL)
@@ -1004,18 +1004,18 @@ ldap_do_parse_search_filter(struct ber_e
 		if (strncmp(attr_val, "*)", 2) == 0) {
 			cp++;			/* point to trailing `)` */
 			if ((root =
-			    ber_add_nstring(prev, attr_desc, len)) == NULL)
+			    ober_add_nstring(prev, attr_desc, len)) == NULL)
 				goto bad;
 
-			ber_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_PRES);
+			ober_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_PRES);
 			break;
 		}
 
-		if ((root = ber_add_sequence(prev)) == NULL)
+		if ((root = ober_add_sequence(prev)) == NULL)
 			goto callfail;
-		ber_set_header(root, BER_CLASS_CONTEXT, type);
+		ober_set_header(root, BER_CLASS_CONTEXT, type);
 
-		if ((elm = ber_add_nstring(root, attr_desc, len)) == NULL)
+		if ((elm = ober_add_nstring(root, attr_desc, len)) == NULL)
 			goto callfail;
 
 		len = strcspn(attr_val, "*)");
@@ -1030,9 +1030,9 @@ ldap_do_parse_search_filter(struct ber_e
 
 			cp = attr_val;
 
-			ber_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_SUBS);
+			ober_set_header(root, BER_CLASS_CONTEXT, LDAP_FILT_SUBS);
 
-			if ((elm = ber_add_sequence(elm)) == NULL)
+			if ((elm = ober_add_sequence(elm)) == NULL)
 				goto callfail;
 
 			for (initial = 1;; cp++, initial = 0) {
@@ -1059,12 +1059,12 @@ ldap_do_parse_search_filter(struct ber_e
 				if ((parsed_val = parseval(attr_val, len)) ==
 				    NULL)
 					goto callfail;
-				elm = ber_add_nstring(elm, parsed_val,
+				elm = ober_add_nstring(elm, parsed_val,
 				    strlen(parsed_val));
 				free(parsed_val);
 				if (elm == NULL)
 					goto callfail;
-				ber_set_header(elm, BER_CLASS_CONTEXT, type);
+				ober_set_header(elm, BER_CLASS_CONTEXT, type);
 				if (type == LDAP_FILT_SUBS_FIN)
 					break;
 			}
@@ -1073,7 +1073,7 @@ ldap_do_parse_search_filter(struct ber_e
 
 		if ((parsed_val = parseval(attr_val, len)) == NULL)
 			goto callfail;
-		elm = ber_add_nstring(elm, parsed_val, strlen(parsed_val));
+		elm = ober_add_nstring(elm, parsed_val, strlen(parsed_val));
 		free(parsed_val);
 		if (elm == NULL)
 			goto callfail;
@@ -1089,8 +1089,8 @@ syntaxfail:		/* XXX -- error reporting *
 callfail:
 bad:
 	if (root != NULL)
-		ber_free_elements(root);
-	ber_link_elements(prev, NULL);
+		ober_free_elements(root);
+	ober_link_elements(prev, NULL);
 	return (NULL);
 }
 
@@ -1112,7 +1112,7 @@ ldap_debug_elements(struct ber_element *
 	struct ber_oid	 o;
 
 	/* calculate lengths */
-	ber_calc_len(root);
+	ober_calc_len(root);
 
 	switch (root->be_encoding) {
 	case BER_TYPE_SEQUENCE:
@@ -1242,28 +1242,28 @@ ldap_debug_elements(struct ber_element *
 
 	switch (root->be_encoding) {
 	case BER_TYPE_BOOLEAN:
-		if (ber_get_boolean(root, &d) == -1) {
+		if (ober_get_boolean(root, &d) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "%s(%d)\n", d ? "true" : "false", d);
 		break;
 	case BER_TYPE_INTEGER:
-		if (ber_get_integer(root, &v) == -1) {
+		if (ober_get_integer(root, &v) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "value %lld\n", v);
 		break;
 	case BER_TYPE_ENUMERATED:
-		if (ber_get_enumerated(root, &v) == -1) {
+		if (ober_get_enumerated(root, &v) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "value %lld\n", v);
 		break;
 	case BER_TYPE_BITSTRING:
-		if (ber_get_bitstring(root, (void *)&buf, &len) == -1) {
+		if (ober_get_bitstring(root, (void *)&buf, &len) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
@@ -1273,14 +1273,14 @@ ldap_debug_elements(struct ber_element *
 		fprintf(stderr, "\n");
 		break;
 	case BER_TYPE_OBJECT:
-		if (ber_get_oid(root, &o) == -1) {
+		if (ober_get_oid(root, &o) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
 		fprintf(stderr, "\n");
 		break;
 	case BER_TYPE_OCTETSTRING:
-		if (ber_get_nstring(root, (void *)&buf, &len) == -1) {
+		if (ober_get_nstring(root, (void *)&buf, &len) == -1) {
 			fprintf(stderr, "<INVALID>\n");
 			break;
 		}
