untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24HLAb7mhgq4kd5H8cqhnZPcDTvUzAiMHeo/W5pWspO3Dpoy5uceedKZz37BTkIgUDIqpLHjyyAZErZYl/tuhHgk=

OpenBSD 6.6 errata 014, December 18, 2019:

arm64 cpu speculatively execute instructions after ERET.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 014_eret.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/arm64/arm64/exception.S
===================================================================
RCS file: /cvs/src/sys/arch/arm64/arm64/exception.S,v
diff -u -p -u -r1.9 exception.S
--- sys/arch/arm64/arm64/exception.S	15 Mar 2019 05:42:38 -0000	1.9
+++ sys/arch/arm64/arm64/exception.S	17 Dec 2019 07:33:47 -0000
@@ -161,6 +161,8 @@ handle_el1h_sync:
 	bl	do_el1h_sync
 	restore_registers 1
 	eret
+	dsb nsh
+	isb
 
 handle_el1h_irq:
 	save_registers 1
@@ -168,6 +170,8 @@ handle_el1h_irq:
 	bl	arm_cpu_intr
 	restore_registers 1
 	eret
+	dsb nsh
+	isb
 
 handle_el1h_error:
 	brk	0xf13
Index: sys/arch/arm64/arm64/trampoline.S
===================================================================
RCS file: /cvs/src/sys/arch/arm64/arm64/trampoline.S,v
diff -u -p -u -r1.1 trampoline.S
--- sys/arch/arm64/arm64/trampoline.S	10 Jan 2018 23:27:18 -0000	1.1
+++ sys/arch/arm64/arm64/trampoline.S	17 Dec 2019 07:34:02 -0000
@@ -82,6 +82,8 @@ tramp_return:
 	mrs	x18, tpidrro_el0
 	msr	tpidrro_el0, xzr
 	eret
+	dsb nsh
+	isb
 
 /*
  * The next page contains the start of the EL0 exception handlers.
