untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3lrSrkaPJlG6oI0CwTfy6QxlfrSSgHs7GE0IEsDmsPifiw+TK0hOepCj/qLeUUn0WZzj9tzefVVhX+eqZmQokAk=

OpenBSD 6.7 errata 037, March 9, 2021:

npppd PPTP protocol handler can cause heap over-read leading to a crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 037_npppd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install npppd:
    cd /usr/src/usr.sbin/npppd
    make obj
    make
    make install

Index: usr.sbin/npppd/pptp/pptp_call.c
===================================================================
RCS file: /cvs/src/usr.sbin/npppd/pptp/pptp_call.c,v
diff -u -p -r1.9 pptp_call.c
--- usr.sbin/npppd/pptp/pptp_call.c	5 Dec 2015 16:10:31 -0000	1.9
+++ usr.sbin/npppd/pptp/pptp_call.c	7 Mar 2021 01:32:15 -0000
@@ -802,12 +802,13 @@ pptp_call_OCRQ_string(struct pptp_ocrq *
 	snprintf(buf, lbuf,
 	    "call_id=%u call_serial_number=%u max_bps=%u min_bps=%u bearer=%s "
 	    "framing=%s recv_winsz=%u packet_proccessing_delay=%u "
-	    "phone_nunmber=%s subaddress=%s",
+	    "phone_nunmber=%.*s subaddress=%.*s",
 	    ocrq->call_id, ocrq->call_serial_number, ocrq->maximum_bps,
 	    ocrq->minimum_bps, pptp_bearer_string(ocrq->bearer_type),
 	    pptp_framing_string(ocrq->framing_type), ocrq->recv_winsz,
-	    ocrq->packet_proccessing_delay, ocrq->phone_number,
-	    ocrq->subaddress);
+	    ocrq->packet_proccessing_delay,
+	    (u_int)sizeof(ocrq->phone_number), ocrq->phone_number,
+	    (u_int)sizeof(ocrq->subaddress), ocrq->subaddress);
 }
 
 /* convert Outgoing-Call-Reply packet to strings */
Index: usr.sbin/npppd/pptp/pptp_ctrl.c
===================================================================
RCS file: /cvs/src/usr.sbin/npppd/pptp/pptp_ctrl.c,v
diff -u -p -r1.11 pptp_ctrl.c
--- usr.sbin/npppd/pptp/pptp_ctrl.c	16 Apr 2016 18:32:29 -0000	1.11
+++ usr.sbin/npppd/pptp/pptp_ctrl.c	7 Mar 2021 01:32:15 -0000
@@ -556,26 +556,24 @@ pptp_ctrl_output_flush(pptp_ctrl *_this)
 static void
 pptp_ctrl_SCCRx_string(struct pptp_scc *scc, u_char *buf, int lbuf)
 {
-	char buf1[128], buf2[128], buf3[128];
-
-	/* sanity check */
-	strlcpy(buf1, scc->host_name, sizeof(buf1));
-	strlcpy(buf2, scc->vendor_string, sizeof(buf2));
+	char results[128];
 
 	if (scc->result_code != 0)
-		snprintf(buf3, sizeof(buf3), "result=%d error=%d ",
+		snprintf(results, sizeof(results), "result=%d error=%d ",
 		    scc->result_code, scc->error_code);
 	else
-		buf3[0] = '\0';
+		results[0] = '\0';
 
 	snprintf(buf, lbuf,
 	    "protocol_version=%d.%d %sframing=%s bearer=%s max_channels=%d "
-	    "firmware_revision=%d(0x%04x) host_name=\"%s\" "
-	    "vendor_string=\"%s\"",
-	    scc->protocol_version >> 8, scc->protocol_version & 0xff, buf3,
+	    "firmware_revision=%d(0x%04x) host_name=\"%.*s\" "
+	    "vendor_string=\"%.*s\"",
+	    scc->protocol_version >> 8, scc->protocol_version & 0xff, results,
 	    pptp_framing_string(scc->framing_caps),
 	    pptp_bearer_string(scc->bearer_caps), scc->max_channels,
-	    scc->firmware_revision, scc->firmware_revision, buf1, buf2);
+	    scc->firmware_revision, scc->firmware_revision,
+	    (u_int)sizeof(scc->host_name), scc->host_name,
+	    (u_int)sizeof(scc->vendor_string), scc->vendor_string);
 }
 
 /* receive Start-Control-Connection-Request */
