untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZ7yJXjzjz8/fHNJfcKJeIiWUxTqh5BSwJ47fTYS8kzst66SVlGi+hXcB82vi1BJzvd7QrNqioOkgg4lroQzo1Ac=

OpenBSD 7.0 errata 002, October 31, 2021:

Opening /dev/bpf too quickly too often could lead to a kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 002_bpf.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/bpf.c
===================================================================
RCS file: /cvs/src/sys/net/bpf.c,v
retrieving revision 1.205
diff -u -p -r1.205 bpf.c
--- sys/net/bpf.c	15 Jun 2021 05:24:47 -0000	1.205
+++ sys/net/bpf.c	23 Oct 2021 15:59:12 -0000
@@ -1553,6 +1553,7 @@ bpf_allocbufs(struct bpf_d *d)
 	d->bd_sbuf = malloc(d->bd_bufsize, M_DEVBUF, M_NOWAIT);
 	if (d->bd_sbuf == NULL) {
 		free(d->bd_fbuf, M_DEVBUF, d->bd_bufsize);
+		d->bd_fbuf = NULL;
 		return (ENOMEM);
 	}
 
