untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAfgjccdgI7iLM9HLWsNAFHNMLuxR0Q4Wp5lJUp0NVmND8YxOI1NlbdZfH3mjtx7ZH58kryVLoynsi3GN9W5YqEwU=

OpenBSD 7.5 errata 013, October 31, 2024:

Updating Apple Silicon system firmware to the latest version cripples
OpenBSD.  This disabled the onboard WiFi.

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 013_aplsmc.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/arm64/dev/aplsmc.c
===================================================================
RCS file: /cvs/src/sys/arch/arm64/dev/aplsmc.c,v
diff -u -p -r1.25 aplsmc.c
--- sys/arch/arm64/dev/aplsmc.c	16 Jul 2023 16:11:11 -0000	1.25
+++ sys/arch/arm64/dev/aplsmc.c	29 Oct 2024 23:04:16 -0000
@@ -250,6 +250,12 @@ aplsmc_attach(struct device *parent, str
 		return;
 	}
 
+	error = rtkit_set_ap_pwrstate(sc->sc_rs, RTKIT_MGMT_PWR_STATE_ON);
+	if (error) {
+		printf(": can't set AP power state\n");
+		return;
+	}
+
 	error = rtkit_start_endpoint(sc->sc_rs, SMC_EP, aplsmc_callback, sc);
 	if (error) {
 		printf(": can't start SMC endpoint\n");
