/*-
 * Copyright (c) 1996-1997 John D. Polstra.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	_MACHINE_ELF_H_
#define	_MACHINE_ELF_H_

/*
 * ELF definitions for the AArch64 architecture.
 */

#ifdef _KERNEL
# define __HAVE_CPU_HWCAP
# define __HAVE_CPU_HWCAP2
extern unsigned long	hwcap, hwcap2;
#endif /* _KERNEL */

/* HWCAP */
#define	HWCAP_FP		0x00000001
#define	HWCAP_ASIMD		0x00000002
#define	HWCAP_EVTSTRM		0x00000004
#define	HWCAP_AES		0x00000008
#define	HWCAP_PMULL		0x00000010
#define	HWCAP_SHA1		0x00000020
#define	HWCAP_SHA2		0x00000040
#define	HWCAP_CRC32		0x00000080
#define	HWCAP_ATOMICS		0x00000100
#define	HWCAP_FPHP		0x00000200
#define	HWCAP_ASIMDHP		0x00000400
#define	HWCAP_CPUID		0x00000800
#define	HWCAP_ASIMDRDM		0x00001000
#define	HWCAP_JSCVT		0x00002000
#define	HWCAP_FCMA		0x00004000
#define	HWCAP_LRCPC		0x00008000
#define	HWCAP_DCPOP		0x00010000
#define	HWCAP_SHA3		0x00020000
#define	HWCAP_SM3		0x00040000
#define	HWCAP_SM4		0x00080000
#define	HWCAP_ASIMDDP		0x00100000
#define	HWCAP_SHA512		0x00200000
#define	HWCAP_SVE		0x00400000
#define	HWCAP_ASIMDFHM		0x00800000
#define	HWCAP_DIT		0x01000000
#define	HWCAP_USCAT		0x02000000
#define	HWCAP_ILRCPC		0x04000000
#define	HWCAP_FLAGM		0x08000000
#define	HWCAP_SSBS		0x10000000
#define	HWCAP_SB		0x20000000
#define	HWCAP_PACA		0x40000000
#define	HWCAP_PACG		0x80000000

/* HWCAP2 */
#define	HWCAP2_DCPODP		0x0000000000000001ul
#define	HWCAP2_SVE2		0x0000000000000002ul
#define	HWCAP2_SVEAES		0x0000000000000004ul
#define	HWCAP2_SVEPMULL		0x0000000000000008ul
#define	HWCAP2_SVEBITPERM	0x0000000000000010ul
#define	HWCAP2_SVESHA3		0x0000000000000020ul
#define	HWCAP2_SVESM4		0x0000000000000040ul
#define	HWCAP2_FLAGM2		0x0000000000000080ul
#define	HWCAP2_FRINT		0x0000000000000100ul
#define	HWCAP2_SVEI8MM		0x0000000000000200ul
#define	HWCAP2_SVEF32MM		0x0000000000000400ul
#define	HWCAP2_SVEF64MM		0x0000000000000800ul
#define	HWCAP2_SVEBF16		0x0000000000001000ul
#define	HWCAP2_I8MM		0x0000000000002000ul
#define	HWCAP2_BF16		0x0000000000004000ul
#define	HWCAP2_DGH		0x0000000000008000ul
#define	HWCAP2_RNG		0x0000000000010000ul
#define	HWCAP2_BTI		0x0000000000020000ul
#define	HWCAP2_MTE		0x0000000000040000ul
#define	HWCAP2_ECV		0x0000000000080000ul
#define	HWCAP2_AFP		0x0000000000100000ul
#define	HWCAP2_RPRES		0x0000000000200000ul
#define	HWCAP2_MTE3		0x0000000000400000ul
#define	HWCAP2_SME		0x0000000000800000ul
#define	HWCAP2_SME_I16I64	0x0000000001000000ul
#define	HWCAP2_SME_F64F64	0x0000000002000000ul
#define	HWCAP2_SME_I8I32	0x0000000004000000ul
#define	HWCAP2_SME_F16F32	0x0000000008000000ul
#define	HWCAP2_SME_B16F32	0x0000000010000000ul
#define	HWCAP2_SME_F32F32	0x0000000020000000ul
#define	HWCAP2_SME_FA64		0x0000000040000000ul
#define	HWCAP2_WFXT		0x0000000080000000ul
#define	HWCAP2_EBF16		0x0000000100000000ul
#define	HWCAP2_SVE_EBF16	0x0000000200000000ul
#define	HWCAP2_CSSC		0x0000000400000000ul
#define	HWCAP2_RPRFM		0x0000000800000000ul
#define	HWCAP2_SVE2P1		0x0000001000000000ul
#define	HWCAP2_SME2		0x0000002000000000ul
#define	HWCAP2_SME2P1		0x0000004000000000ul
#define	HWCAP2_SME_I16I32	0x0000008000000000ul
#define	HWCAP2_SME_BI32I32	0x0000010000000000ul
#define	HWCAP2_SME_B16B16	0x0000020000000000ul
#define	HWCAP2_SME_F16F16	0x0000040000000000ul
#define	HWCAP2_MOPS		0x0000080000000000ul
#define	HWCAP2_HBC		0x0000100000000000ul

#endif /* !_MACHINE_ELF_H_ */
