/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.HashTable;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.ParseError;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class LogicalPathname
extends Pathname {
    public static final String LOGICAL_PATHNAME_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-;*.";
    private static final HashMap map = new HashMap();
    public static HashTable TRANSLATIONS = HashTable.newEqualHashTable("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-;*.".length(), Lisp.NIL, Lisp.NIL);
    private static final Symbol _TRANSLATIONS_ = Lisp.exportSpecial("*LOGICAL-PATHNAME-TRANSLATIONS*", Lisp.PACKAGE_SYS, TRANSLATIONS);
    private static final Primitive CANONICALIZE_LOGICAL_HOST = new canonicalize_logical_host();
    private static final Primitive _MAKE_LOGICAL_PATHNAME = new _make_logical_pathname();

    public static boolean isValidLogicalPathname(String namestring) {
        String host;
        return !LogicalPathname.isValidURL(namestring) && (host = LogicalPathname.getHostString(namestring)) != null && TRANSLATIONS.get(new SimpleString(host)) != null;
    }

    protected LogicalPathname() {
    }

    public static LogicalPathname create() {
        return new LogicalPathname();
    }

    public static LogicalPathname create(LogicalPathname p) {
        Pathname pathname = new Pathname();
        pathname.copyFrom(p);
        LogicalPathname result = new LogicalPathname();
        Pathname.ncoerce(pathname, result);
        return result;
    }

    public static LogicalPathname create(String namestring) {
        LogicalPathname result = null;
        if (LogicalPathname.isValidLogicalPathname(namestring)) {
            String h = LogicalPathname.getHostString(namestring);
            result = LogicalPathname.create(h, namestring.substring(namestring.indexOf(58) + 1));
            return result;
        }
        Lisp.error(new FileError("Failed to find a valid logical Pathname host in '" + namestring + "'", Lisp.NIL));
        return (LogicalPathname)Lisp.UNREACHED;
    }

    public static LogicalPathname create(String host, String rest) {
        SimpleString h = new SimpleString(host);
        if (TRANSLATIONS.get(h) == null) {
            String message = MessageFormat.format("'{0}' is not a defined logical host", host);
            Lisp.error(new SimpleError(message));
        }
        LogicalPathname result = new LogicalPathname();
        int limit = rest.length();
        for (int i = 0; i < limit; ++i) {
            char c = rest.charAt(i);
            if (LOGICAL_PATHNAME_CHARS.indexOf(c) >= 0) continue;
            Lisp.error(new ParseError("The character #\\" + c + " is not valid in a logical pathname."));
        }
        result.setHost(h);
        result.setDevice(Keyword.UNSPECIFIC);
        int semi = rest.lastIndexOf(59);
        if (semi >= 0) {
            String d = rest.substring(0, semi + 1);
            result.setDirectory(LogicalPathname.parseDirectory(d));
            rest = rest.substring(semi + 1);
        } else {
            result.setDirectory(new Cons(Keyword.ABSOLUTE));
        }
        int dot = rest.indexOf(46);
        if (dot >= 0) {
            String n = rest.substring(0, dot);
            if (n.equals("*")) {
                result.setName(Keyword.WILD);
            } else {
                result.setName(new SimpleString(n.toUpperCase()));
            }
            rest = rest.substring(dot + 1);
            dot = rest.indexOf(46);
            if (dot >= 0) {
                String t = rest.substring(0, dot);
                if (t.equals("*")) {
                    result.setType(Keyword.WILD);
                } else {
                    result.setType(new SimpleString(t.toUpperCase()));
                }
                String v = rest.substring(dot + 1);
                if (v.equals("*")) {
                    result.setVersion(Keyword.WILD);
                } else if (v.equals("NEWEST") || v.equals("newest")) {
                    result.setVersion(Keyword.NEWEST);
                } else {
                    result.setVersion(Lisp.PACKAGE_CL.intern("PARSE-INTEGER").execute(new SimpleString(v)));
                }
            } else {
                String t = rest;
                if (t.equals("*")) {
                    result.setType(Keyword.WILD);
                } else {
                    result.setType(new SimpleString(t.toUpperCase()));
                }
            }
        } else {
            String n = rest;
            if (n.equals("*")) {
                result.setName(Keyword.WILD);
            } else if (n.length() > 0) {
                result.setName(new SimpleString(n.toUpperCase()));
            }
        }
        return result;
    }

    public static final SimpleString canonicalizeStringComponent(AbstractString s) {
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (LOGICAL_PATHNAME_CHARS.indexOf(c) >= 0) continue;
            Lisp.error(new ParseError("Invalid character #\\" + c + " in logical pathname component \"" + String.valueOf(s) + "\""));
            return null;
        }
        return new SimpleString(s.getStringValue().toUpperCase());
    }

    public static Pathname translateLogicalPathname(LogicalPathname pathname) {
        return (Pathname)Symbol.TRANSLATE_LOGICAL_PATHNAME.execute(pathname);
    }

    private static final LispObject parseDirectory(String s) {
        LispObject result;
        if (s.charAt(0) == ';') {
            result = new Cons(Keyword.RELATIVE);
            s = s.substring(1);
        } else {
            result = new Cons(Keyword.ABSOLUTE);
        }
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreTokens()) {
            LispObject obj;
            String token = st.nextToken();
            if (token.equals("*")) {
                obj = Keyword.WILD;
            } else if (token.equals("**")) {
                obj = Keyword.WILD_INFERIORS;
            } else if (token.equals("..")) {
                if (result.car() instanceof AbstractString) {
                    result = result.cdr();
                    continue;
                }
                obj = Keyword.UP;
            } else {
                obj = new SimpleString(token.toUpperCase());
            }
            result = new Cons(obj, result);
        }
        return ((LispObject)result).nreverse();
    }

    @Override
    public LispObject typeOf() {
        return Symbol.LOGICAL_PATHNAME;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.LOGICAL_PATHNAME;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.LOGICAL_PATHNAME) {
            return Lisp.T;
        }
        if (type == BuiltInClass.LOGICAL_PATHNAME) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    @Override
    protected String getDirectoryNamestring() {
        StringBuilder sb = new StringBuilder();
        if (this.getDirectory() != Lisp.NIL) {
            LispObject temp = this.getDirectory();
            LispObject part = temp.car();
            if (part != Keyword.ABSOLUTE) {
                if (part == Keyword.RELATIVE) {
                    sb.append(';');
                } else {
                    Lisp.error(new FileError("Unsupported directory component " + part.princToString() + ".", this));
                }
            }
            for (temp = temp.cdr(); temp != Lisp.NIL; temp = temp.cdr()) {
                part = temp.car();
                if (part instanceof AbstractString) {
                    sb.append(part.getStringValue());
                } else if (part == Keyword.WILD) {
                    sb.append('*');
                } else if (part == Keyword.WILD_INFERIORS) {
                    sb.append("**");
                } else if (part == Keyword.UP) {
                    sb.append("..");
                } else {
                    Lisp.error(new FileError("Unsupported directory component " + part.princToString() + ".", this));
                }
                sb.append(';');
            }
        }
        return sb.toString();
    }

    @Override
    public String printObject() {
        LispThread thread = LispThread.currentThread();
        boolean printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        boolean printEscape = Symbol.PRINT_ESCAPE.symbolValue(thread) != Lisp.NIL;
        StringBuilder sb = new StringBuilder();
        if (printReadably || printEscape) {
            sb.append("#P\"");
        }
        sb.append(this.getHost().getStringValue());
        sb.append(':');
        if (this.getDirectory() != Lisp.NIL) {
            sb.append(this.getDirectoryNamestring());
        }
        if (this.getName() != Lisp.NIL) {
            if (this.getName() == Keyword.WILD) {
                sb.append('*');
            } else {
                sb.append(this.getName().getStringValue());
            }
        }
        if (this.getType() != Lisp.NIL) {
            sb.append('.');
            if (this.getType() == Keyword.WILD) {
                sb.append('*');
            } else {
                sb.append(this.getType().getStringValue());
            }
        }
        if (this.getVersion().integerp()) {
            sb.append('.');
            int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue(thread));
            if (this.getVersion() instanceof Fixnum) {
                sb.append(Integer.toString(((Fixnum)this.getVersion()).value, base).toUpperCase());
            } else if (this.getVersion() instanceof Bignum) {
                sb.append(((Bignum)this.getVersion()).value.toString(base).toUpperCase());
            }
        } else if (this.getVersion() == Keyword.WILD) {
            sb.append(".*");
        } else if (this.getVersion() == Keyword.NEWEST) {
            sb.append(".NEWEST");
        }
        if (printReadably || printEscape) {
            sb.append('\"');
        }
        return sb.toString();
    }

    protected static String getHostString(String s) {
        int colon = s.indexOf(58);
        if (colon >= 0) {
            return s.substring(0, colon).toUpperCase();
        }
        return null;
    }

    @Override
    public long getLastModified() {
        Pathname p = LogicalPathname.translateLogicalPathname(this);
        return p.getLastModified();
    }

    private static class _make_logical_pathname
    extends Primitive {
        _make_logical_pathname() {
            super("%make-logical-pathname", Lisp.PACKAGE_SYS, true, "namestring");
        }

        @Override
        public LispObject execute(LispObject arg) {
            String s = arg.getStringValue();
            String h = LogicalPathname.getHostString(s);
            if (h != null) {
                if (h.length() == 0) {
                    return Lisp.error(new LispError("Invalid logical host name: \"" + h + "\""));
                }
                if (TRANSLATIONS.get(new SimpleString(h)) != null) {
                    return LogicalPathname.create(h, s.substring(s.indexOf(58) + 1));
                }
            }
            return Lisp.error(new TypeError("Logical namestring does not specify a host: \"" + s + "\""));
        }
    }

    private static class canonicalize_logical_host
    extends Primitive {
        canonicalize_logical_host() {
            super("canonicalize-logical-host", Lisp.PACKAGE_SYS, true, "host");
        }

        @Override
        public LispObject execute(LispObject arg) {
            AbstractString s = Lisp.checkString(arg);
            if (s.length() == 0) {
                return Lisp.error(new LispError("Invalid logical host name: \"" + s.getStringValue() + "\""));
            }
            return LogicalPathname.canonicalizeStringComponent(s);
        }
    }
}

