#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for vyos_firewall_rules
"""

from __future__ import absolute_import, division, print_function


__metaclass__ = type

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "network",
}

DOCUMENTATION = """
---
module: vyos_firewall_rules
version_added: '1.0.0'
short_description: Firewall rules resource module
description: This module manages firewall rule-set attributes on VyOS devices
author:
- Rohit Thakur (@rohitthakur2590)
- Gaige B. Paulsen (@gaige)
notes:
- Tested against VyOS 1.3.8, 1.4.2, the upcoming 1.5, and the rolling release of spring 2025.
- The provided examples of commands are valid for VyOS 1.4+
- This module works with connection C(ansible.netcommon.network_cli).
  See L(the VyOS OS Platform Options,../network/user_guide/platform_vyos.html).

options:
  config:
    description: A dictionary of Firewall rule-set options.
    type: list
    elements: dict
    suboptions:
      afi:
        description:
        - Specifies the type of rule-set.
        type: str
        choices:
        - ipv4
        - ipv6
        required: true
      rule_sets:
        description:
        - The Firewall rule-set list.
        type: list
        elements: dict
        suboptions:
          filter:
            description:
            - Filter type (exclusive to "name").
            - Supported in 1.4 and later.
            type: str
            choices: ['input', 'output', 'forward']
          name:
            description:
            - Firewall rule set name.
            - Required for 1.3- and optional for 1.4+.
            type: str
          default_action:
            description:
            - Default action for rule-set.
            - drop (Drop if no prior rules are hit (default))
            - reject (Drop and notify source if no prior rules are hit)
            - accept (Accept if no prior rules are hit)
            - jump (Jump to another rule-set, 1.4+)
            type: str
            choices: ['drop', 'reject', 'accept', 'jump']
          default_jump_target:
            description:
            - Default jump target if the default action is jump.
            - Only valid in 1.4 and later.
            - Only valid when default_action = jump.
            type: str
          description:
            description:
            - Rule set description.
            type: str
          enable_default_log:
            description:
            - Option to log packets hitting default-action.
            type: bool
          rules:
            description:
            - A dictionary that specifies the rule-set configurations.
            type: list
            elements: dict
            suboptions:
              number:
                description:
                - Rule number.
                type: int
                required: true
              description:
                description:
                - Description of this rule.
                type: str
              action:
                description:
                - Specifying the action.
                - inspect is available  < 1.4
                - continue, return, jump, queue, synproxy are available >= 1.4
                type: str
                choices:
                - drop
                - reject
                - accept
                - inspect
                - continue
                - return
                - jump
                - queue
                - synproxy
              destination:
                description:
                - Specifying the destination parameters.
                type: dict
                suboptions:
                  address:
                    description:
                    - Destination ip address subnet or range.
                    - IPv4/6 address, subnet or range to match.
                    - Match everything except the specified address, subnet or range.
                    - Destination ip address subnet or range.
                    type: str
                  group:
                    description:
                    - Destination group.
                    type: dict
                    suboptions:
                      address_group:
                        description:
                        - Group of addresses.
                        type: str
                      network_group:
                        description:
                        - Group of networks.
                        type: str
                      port_group:
                        description:
                        - Group of ports.
                        type: str
                  port:
                    description:
                    - Multiple destination ports can be specified as a comma-separated
                      list.
                    - The whole list can also be "negated" using '!'.
                    - For example:'!22,telnet,http,123,1001-1005'.
                    type: str
              disable:
                description:
                - Option to disable firewall rule.
                - aliased to disabled
                type: bool
                aliases: ["disabled"]
              fragment:
                description:
                - IP fragment match.
                type: str
                choices:
                - match-frag
                - match-non-frag
              icmp:
                description:
                - ICMP type and code information.
                type: dict
                suboptions:
                  type_name:
                    description:
                    - ICMP type-name.
                    type: str
                    choices:
                    - any
                    - echo-reply
                    - destination-unreachable
                    - network-unreachable
                    - host-unreachable
                    - protocol-unreachable
                    - port-unreachable
                    - fragmentation-needed
                    - source-route-failed
                    - network-unknown
                    - host-unknown
                    - network-prohibited
                    - host-prohibited
                    - TOS-network-unreachable
                    - TOS-host-unreachable
                    - communication-prohibited
                    - host-precedence-violation
                    - precedence-cutoff
                    - source-quench
                    - redirect
                    - network-redirect
                    - host-redirect
                    - TOS-network-redirect
                    - TOS-host-redirect
                    - echo-request
                    - router-advertisement
                    - router-solicitation
                    - time-exceeded
                    - ttl-zero-during-transit
                    - ttl-zero-during-reassembly
                    - parameter-problem
                    - ip-header-bad
                    - required-option-missing
                    - timestamp-request
                    - timestamp-reply
                    - address-mask-request
                    - address-mask-reply
                    - ping
                    - pong
                    - ttl-exceeded
                  code:
                    description:
                    - ICMP code.
                    type: int
                  type:
                    description:
                    - ICMP type.
                    type: int
              inbound_interface:
                description:
                  - Inbound interface.
                  - Only valid in 1.4 and later.
                type: dict
                suboptions:
                  name:
                    description:
                      - Interface name.
                      - Can have wildcards
                    type: str
                  group:
                    description:
                      - Interface group.
                    type: str
              ipsec:
                description:
                - Inbound ip sec packets.
                - VyOS 1.4 and older match-ipsec/match-none
                - VyOS 1.5 and later require -in/-out suffixes
                type: str
                choices:
                - match-ipsec
                - match-none
                - match-ipsec-in
                - match-ipsec-out
                - match-none-in
                - match-none-out
              jump_target:
                description:
                  - Jump target if the action is jump.
                  - Only valid in 1.4 and later.
                  - Only valid when action = jump.
                type: str
              limit:
                description:
                - Rate limit using a token bucket filter.
                type: dict
                suboptions:
                  burst:
                    description:
                    - Maximum number of packets to allow in excess of rate.
                    type: int
                  rate:
                    description:
                    - format for rate (integer/time unit).
                    - any one of second, minute, hour or day may be used to specify
                      time unit.
                    - eg. 1/second implies rule to be matched at an average of once
                      per second.
                    type: dict
                    suboptions:
                      number:
                        description:
                        - This is the integer value.
                        type: int
                      unit:
                        description:
                        - This is the time unit.
                        type: str
              log:
                description:
                  - Option to log packets matching rule.
                type: str
                choices: ['disable', 'enable']
              outbound_interface:
                description:
                  - Match outbound interface.
                  - Only valid in 1.4 and later.
                type: dict
                suboptions:
                  name:
                    description:
                      - Interface name.
                      - Can have wildcards
                    type: str
                  group:
                    description:
                      - Interface group.
                    type: str
              packet_length:
                description:
                  - Packet length match.
                  - Only valid in 1.4 and later.
                  - Multiple values from 1 to 65535 and ranges are supported
                type: list
                elements: dict
                suboptions:
                  length:
                    description:
                      - Packet length or range.
                    type: str
              packet_length_exclude:
                description:
                  - Packet length match.
                  - Only valid in 1.4 and later.
                  - Multiple values from 1 to 65535 and ranges are supported
                type: list
                elements: dict
                suboptions:
                  length:
                    description:
                      - Packet length or range.
                    type: str
              packet_type:
                description:
                  - Packet type match.
                type: str
                choices: ['broadcast', 'multicast', 'host', 'other']
              protocol:
                description:
                - Protocol to match (protocol name in /etc/protocols or protocol number
                  or all).
                - <text> IP protocol name from /etc/protocols (e.g. "tcp" or "udp").
                - <0-255> IP protocol number.
                - tcp_udp Both TCP and UDP.
                - all All IP protocols.
                - (!)All IP protocols except for the specified name or number.
                type: str
              queue:
                description:
                  - Queue options.
                  - Only valid in 1.4 and later.
                  - Only valid when action = queue.
                  - Can be a queue number or range.
                type: str
              queue_options:
                description:
                  - Queue options.
                  - Only valid in 1.4 and later.
                  - Only valid when action = queue.
                type: str
                choices: ['bypass', 'fanout']
              recent:
                description:
                - Parameters for matching recently seen sources.
                type: dict
                suboptions:
                  count:
                    description:
                    - Source addresses seen more than N times.
                    type: int
                  time:
                    description:
                    - Source addresses seen in the last N seconds.
                    - Since 1.4, this is a string of second/minute/hour
                    type: str
              source:
                description:
                - Source parameters.
                type: dict
                suboptions:
                  address:
                    description:
                    - Source ip address subnet or range.
                    - IPv4/6 address, subnet or range to match.
                    - Match everything except the specified address, subnet or range.
                    - Source ip address subnet or range.
                    type: str
                  group:
                    description:
                    - Source group.
                    type: dict
                    suboptions:
                      address_group:
                        description:
                        - Group of addresses.
                        type: str
                      network_group:
                        description:
                        - Group of networks.
                        type: str
                      port_group:
                        description:
                        - Group of ports.
                        type: str
                  port:
                    description:
                    - Multiple source ports can be specified as a comma-separated
                      list.
                    - The whole list can also be "negated" using '!'.
                    - For example:'!22,telnet,http,123,1001-1005'.
                    type: str
                  mac_address:
                    description:
                    - <MAC address> MAC address to match.
                    - <!MAC address> Match everything except the specified MAC address.
                    type: str
                  fqdn:
                    description:
                      - Fully qualified domain name.
                      - Available in 1.4 and later.
                    type: str

              state:
                description:
                - Session state.
                type: dict
                suboptions:
                  established:
                    description:
                    - Established state.
                    type: bool
                  invalid:
                    description:
                    - Invalid state.
                    type: bool
                  new:
                    description:
                    - New state.
                    type: bool
                  related:
                    description:
                    - Related state.
                    type: bool
              synproxy:
                description:
                  - SYN proxy options.
                  - Only valid in 1.4 and later.
                  - Only valid when action = synproxy.
                type: dict
                suboptions:
                  mss:
                    description:
                      - Adjust MSS (501-65535)
                    type: int
                  window_scale:
                    description:
                      - Window scale (1-14).
                    type: int
              tcp:
                description:
                - TCP flags to match.
                type: dict
                suboptions:
                  flags:
                    description:
                      - list of tcp flags to be matched
                      - 5.0 breaking change to support 1.4+ and 1.3-
                    type: list
                    elements: dict
                    suboptions:
                      flag:
                        description:
                          - TCP flag to be matched.
                          - syn, ack, fin, rst, urg, psh, all (1.3-)
                          - syn, ack, fin, rst, urg, psh, cwr, ecn (1.4+)
                        type: str
                        choices:
                        - ack
                        - cwr
                        - ecn
                        - fin
                        - psh
                        - rst
                        - syn
                        - urg
                        - all
                      invert:
                        description:
                          - Invert the match.
                        type: bool
              time:
                description:
                - Time to match rule.
                type: dict
                suboptions:
                  utc:
                    description:
                    - Interpret times for startdate, stopdate, starttime and stoptime
                      to be UTC.
                    type: bool
                  monthdays:
                    description:
                    - Monthdays to match rule on.
                    type: str
                  startdate:
                    description:
                    - Date to start matching rule.
                    type: str
                  starttime:
                    description:
                    - Time of day to start matching rule.
                    type: str
                  stopdate:
                    description:
                    - Date to stop matching rule.
                    type: str
                  stoptime:
                    description:
                    - Time of day to stop matching rule.
                    type: str
                  weekdays:
                    description:
                    - Weekdays to match rule on.
                    type: str
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the VyOS device
      by executing the command B(show configuration commands | grep firewall).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
    - The state the configuration should be left in
    type: str
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - gathered
    - rendered
    - parsed
    default: merged
"""
EXAMPLES = """
# Using deleted to delete firewall rules based on rule-set name
#
# Before state
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv4 name Downlink default-action 'accept'
# set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'
# set firewall ipv4 name Downlink rule 501 action 'accept'
# set firewall ipv4 name Downlink rule 501 description 'Rule 501 is configured by Ansible'
# set firewall ipv4 name Downlink rule 501 ipsec 'match-ipsec'
# set firewall ipv4 name Downlink rule 502 action 'reject'
# set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'
# set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'

- name: Delete attributes of given firewall rules.
  vyos.vyos.vyos_firewall_rules:
    config:
      - afi: ipv4
        rule_sets:
          - name: Downlink
    state: deleted
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
#    "before": [
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "Downlink",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 501 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 501
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 502 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 502
#                        }
#                    ]
#               }
#            ]
#        }
#    ]
#    "commands": [
#        "delete firewall ipv4 name Downlink"
#    ]
#
# "after": []
# After state
# ------------
# vyos@vyos# run show configuration commands | grep firewall
# set firewall group address-group 'inbound'


# Using deleted to delete firewall rules based on afi
#
# Before state
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv6 name UPLINK rule 1 action 'accept'
# set firewall ipv6 name UPLINK rule 1
# set firewall ipv6 name UPLINK rule 1 description 'Fwipv6-Rule 1 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 1 ipsec 'match-ipsec'
# set firewall ipv6 name UPLINK rule 2 action 'accept'
# set firewall ipv6 name UPLINK rule 2
# set firewall ipv6 name UPLINK rule 2 description 'Fwipv6-Rule 2 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 2 ipsec 'match-ipsec'
# set firewall group address-group 'inbound'
# set firewall ipv4 name Downlink default-action 'accept'
# set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'
# set firewall ipv4 name Downlink rule 501 action 'accept'
# set firewall ipv4 name Downlink rule 501 description 'Rule 501 is configured by Ansible'
# set firewall ipv4 name Downlink rule 501 ipsec 'match-ipsec'
# set firewall ipv4 name Downlink rule 502 action 'reject'
# set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'
# set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'

- name: Delete attributes of given firewall rules.
  vyos.vyos.vyos_firewall_rules:
    config:
      - afi: ipv4
    state: deleted
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
#    "before": [
#        {
#            "afi": "ipv6",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "This is ipv6 specific rule-set",
#                    "name": "UPLINK",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 1 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 1
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 2 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 2
#                        }
#                    ]
#                }
#            ]
#        },
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "Downlink",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 501 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 501
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 502 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 502
#                        }
#                    ]
#               }
#            ]
#        }
#    ]
#    "commands": [
#        "delete firewall ipv4 name"
#    ]
#
# "after": []
# After state
# ------------
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv6 name UPLINK rule 1 action 'accept'
# set firewall ipv6 name UPLINK rule 1
# set firewall ipv6 name UPLINK rule 1 description 'Fwipv6-Rule 1 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 1 ipsec 'match-ipsec'
# set firewall ipv6 name UPLINK rule 2 action 'accept'
# set firewall ipv6 name UPLINK rule 2
# set firewall ipv6 name UPLINK rule 2 description 'Fwipv6-Rule 2 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 2 ipsec 'match-ipsec'


# Using deleted to delete all the the firewall rules when provided config is empty
#
# Before state
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv4 name Downlink default-action 'accept'
# set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'
# set firewall ipv4 name Downlink rule 501 action 'accept'
# set firewall ipv4 name Downlink rule 501 description 'Rule 501 is configured by Ansible'
# set firewall ipv4 name Downlink rule 501 ipsec 'match-ipsec'
# set firewall ipv4 name Downlink rule 502 action 'reject'
# set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'
# set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'
#
- name: Delete attributes of given firewall rules.
  vyos.vyos.vyos_firewall_rules:
    state: deleted
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
#    "before": [
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "Downlink",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 501 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 501
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 502 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 502
#                        }
#                    ]
#               }
#            ]
#        }
#    ]
#    "commands": [
#        "delete firewall ipv4 name"
#    ]
#
# "after": []
# After state
# ------------
# vyos@vyos# run show configuration commands | grep firewall
# set firewall group address-group 'inbound'


# Using merged
#
# Before state:
# -------------
#
# vyos@vyos# run show  configuration commands | grep firewall
# set firewall group address-group 'inbound'
#
- name: Merge the provided configuration with the existing running configuration
  vyos.vyos.vyos_firewall_rules:
    config:
      - afi: ipv6
        rule_sets:
          - name: UPLINK
            description: This is ipv6 specific rule-set
            default_action: accept
            rules:
              - number: 1
                action: accept
                description: Fwipv6-Rule 1 is configured by Ansible
                ipsec: match-ipsec
              - number: 2
                action: accept
                description: Fwipv6-Rule 2 is configured by Ansible
                ipsec: match-ipsec
      - afi: ipv4
        rule_sets:
          - name: INBOUND
            description: IPv4 INBOUND rule set
            default_action: accept
            rules:
              - number: 101
                action: accept
                description: Rule 101 is configured by Ansible
                ipsec: match-ipsec
              - number: 102
                action: reject
                description: Rule 102 is configured by Ansible
                ipsec: match-ipsec
              - number: 103
                action: accept
                description: Rule 103 is configured by Ansible
                destination:
                  group:
                    address_group: inbound
                source:
                  address: 192.0.2.0
                state:
                  established: true
                  new: false
                  invalid: false
                  related: true
    state: merged
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
# before": []
#
#    "commands": [
#       "set firewall ipv6 name UPLINK default-action 'accept'",
#       "set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'",
#       "set firewall ipv6 name UPLINK rule 1 action 'accept'",
#       "set firewall ipv6 name UPLINK rule 1",
#       "set firewall ipv6 name UPLINK rule 1 description 'Fwipv6-Rule 1 is configured by Ansible'",
#       "set firewall ipv6 name UPLINK rule 1 ipsec 'match-ipsec'",
#       "set firewall ipv6 name UPLINK rule 2 action 'accept'",
#       "set firewall ipv6 name UPLINK rule 2",
#       "set firewall ipv6 name UPLINK rule 2 description 'Fwipv6-Rule 2 is configured by Ansible'",
#       "set firewall ipv6 name UPLINK rule 2 ipsec 'match-ipsec'",
#       "set firewall ipv4 name INBOUND default-action 'accept'",
#       "set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'",
#       "set firewall ipv4 name INBOUND rule 101 action 'accept'",
#       "set firewall ipv4 name INBOUND rule 101",
#       "set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'",
#       "set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'",
#       "set firewall ipv4 name INBOUND rule 102 action 'reject'",
#       "set firewall ipv4 name INBOUND rule 102",
#       "set firewall ipv4 name INBOUND rule 102 description 'Rule 102 is configured by Ansible'",
#       "set firewall ipv4 name INBOUND rule 102 ipsec 'match-ipsec'",
#       "set firewall ipv4 name INBOUND rule 103 description 'Rule 103 is configured by Ansible'",
#       "set firewall ipv4 name INBOUND rule 103 destination group address-group inbound",
#       "set firewall ipv4 name INBOUND rule 103",
#       "set firewall ipv4 name INBOUND rule 103 source address 192.0.2.0",
#       "set firewall ipv4 name INBOUND rule 103 state established",
#       "set firewall ipv4 name INBOUND rule 103 state related",
#       "set firewall ipv4 name INBOUND rule 103 action 'accept'"
#    ]
#
# "after": [
#        {
#            "afi": "ipv6",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "This is ipv6 specific rule-set",
#                    "name": "UPLINK",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 1 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 1
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 2 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 2
#                        }
#                    ]
#                }
#            ]
#        },
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "INBOUND",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 101 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 101
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 102 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 102
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Rule 103 is configured by Ansible",
#                            "destination": {
#                                "group": {
#                                    "address_group": "inbound"
#                                }
#                            },
#                            "number": 103,
#                            "source": {
#                                "address": "192.0.2.0"
#                            },
#                            "state": {
#                                "established": true,
#                                "invalid": false,
#                                "new": false,
#                                "related": true
#                            }
#                        }
#                    ]
#                }
#            ]
#        }
#    ]
#
# After state:
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv6 name UPLINK rule 1 action 'accept'
# set firewall ipv6 name UPLINK rule 1 description 'Fwipv6-Rule 1 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 1 ipsec 'match-ipsec'
# set firewall ipv6 name UPLINK rule 2 action 'accept'
# set firewall ipv6 name UPLINK rule 2 description 'Fwipv6-Rule 2 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 2 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND default-action 'accept'
# set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'
# set firewall ipv4 name INBOUND rule 101 action 'accept'
# set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 102 action 'reject'
# set firewall ipv4 name INBOUND rule 102 description 'Rule 102 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 102 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 103 action 'accept'
# set firewall ipv4 name INBOUND rule 103 description 'Rule 103 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 103 destination group address-group 'inbound'
# set firewall ipv4 name INBOUND rule 103 source address '192.0.2.0'
# set firewall ipv4 name INBOUND rule 103 state established
# set firewall ipv4 name INBOUND rule 103 state related


# Using replaced
#
# Before state:
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv6 name UPLINK rule 1 action 'accept'
# set firewall ipv6 name UPLINK rule 1 description 'Fwipv6-Rule 1 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 1 ipsec 'match-ipsec'
# set firewall ipv6 name UPLINK rule 2 action 'accept'
# set firewall ipv6 name UPLINK rule 2 description 'Fwipv6-Rule 2 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 2 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND default-action 'accept'
# set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'
# set firewall ipv4 name INBOUND rule 101 action 'accept'
# set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 102 action 'reject'
# set firewall ipv4 name INBOUND rule 102 description 'Rule 102 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 102 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 103 action 'accept'
# set firewall ipv4 name INBOUND rule 103 description 'Rule 103 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 103 destination group address-group 'inbound'
# set firewall ipv4 name INBOUND rule 103 source address '192.0.2.0'
# set firewall ipv4 name INBOUND rule 103 state established
# set firewall ipv4 name INBOUND rule 103 state related
#
- name: >-
    Replace device configurations of listed firewall rules with provided
    configurations
  vyos.vyos.vyos_firewall_rules:
    config:
      - afi: ipv6
        rule_sets:
          - name: UPLINK
            description: This is ipv6 specific rule-set
            default_action: accept
      - afi: ipv4
        rule_sets:
          - name: INBOUND
            description: IPv4 INBOUND rule set
            default_action: accept
            rules:
              - number: 101
                action: accept
                description: Rule 101 is configured by Ansible
                ipsec: match-ipsec
              - number: 104
                action: reject
                description: Rule 104 is configured by Ansible
                ipsec: match-none
    state: replaced
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "before": [
#        {
#            "afi": "ipv6",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "This is ipv6 specific rule-set",
#                    "name": "UPLINK",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 1 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 1
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 2 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 2
#                        }
#                    ]
#                }
#            ]
#        },
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "INBOUND",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 101 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 101
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 102 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 102
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Rule 103 is configured by Ansible",
#                            "destination": {
#                                "group": {
#                                    "address_group": "inbound"
#                                }
#                            },
#                            "number": 103,
#                            "source": {
#                                "address": "192.0.2.0"
#                            },
#                            "state": {
#                                "established": true,
#                                "invalid": false,
#                                "new": false,
#                                "related": true
#                            }
#                        }
#                    ]
#                }
#            ]
#        }
#    ]
#
# "commands": [
#        "delete firewall ipv6 name UPLINK rule 1",
#        "delete firewall ipv6 name UPLINK rule 2",
#        "delete firewall ipv4 name INBOUND rule 102",
#        "delete firewall ipv4 name INBOUND rule 103",
#        "set firewall ipv4 name INBOUND rule 104 action 'reject'",
#        "set firewall ipv4 name INBOUND rule 104 description 'Rule 104 is configured by Ansible'",
#        "set firewall ipv4 name INBOUND rule 104",
#        "set firewall ipv4 name INBOUND rule 104 ipsec 'match-none'"
#    ]
#
#    "after": [
#        {
#            "afi": "ipv6",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "This is ipv6 specific rule-set",
#                    "name": "UPLINK"
#                }
#            ]
#        },
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "INBOUND",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 101 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 101
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 104 is configured by Ansible",
#                            "ipsec": "match-none",
#                            "number": 104
#                        }
#                    ]
#                }
#            ]
#        }
#    ]
#
# After state:
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv4 name INBOUND default-action 'accept'
# set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'
# set firewall ipv4 name INBOUND rule 101 action 'accept'
# set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 104 action 'reject'
# set firewall ipv4 name INBOUND rule 104 description 'Rule 104 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 104 ipsec 'match-none'


# Using overridden
#
# Before state
# --------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv4 name INBOUND default-action 'accept'
# set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'
# set firewall ipv4 name INBOUND rule 101 action 'accept'
# set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 104 action 'reject'
# set firewall ipv4 name INBOUND rule 104 description 'Rule 104 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 104 ipsec 'match-none'
#
- name: Overrides all device configuration with provided configuration
  vyos.vyos.vyos_firewall_rules:
    config:
      - afi: ipv4
        rule_sets:
          - name: Downlink
            description: IPv4 INBOUND rule set
            default_action: accept
            rules:
              - number: 501
                action: accept
                description: Rule 501 is configured by Ansible
                ipsec: match-ipsec
              - number: 502
                action: reject
                description: Rule 502 is configured by Ansible
                ipsec: match-ipsec
    state: overridden
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
# "before": [
#        {
#            "afi": "ipv6",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "This is ipv6 specific rule-set",
#                    "name": "UPLINK"
#                }
#            ]
#        },
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "INBOUND",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 101 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 101
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 104 is configured by Ansible",
#                            "ipsec": "match-none",
#                            "number": 104
#                        }
#                    ]
#                }
#            ]
#        }
#    ]
#
#    "commands": [
#        "delete firewall ipv6 name UPLINK",
#        "delete firewall ipv4 name INBOUND",
#        "set firewall ipv4 name Downlink default-action 'accept'",
#        "set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'",
#        "set firewall ipv4 name Downlink rule 501 action 'accept'",
#        "set firewall ipv4 name Downlink rule 501",
#        "set firewall ipv4 name Downlink rule 501 description 'Rule 501 is configured by Ansible'",
#        "set firewall ipv4 name Downlink rule 501 ipsec 'match-ipsec'",
#        "set firewall ipv4 name Downlink rule 502 action 'reject'",
#        "set firewall ipv4 name Downlink rule 502",
#        "set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'",
#        "set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'"
#
#
#    "after": [
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "Downlink",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 501 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 501
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 502 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 502
#                        }
#                    ]
#               }
#            ]
#        }
#    ]
#
#
# After state
# ------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv4 name Downlink default-action 'accept'
# set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'
# set firewall ipv4 name Downlink rule 501 action 'accept'
# set firewall ipv4 name Downlink rule 501 description 'Rule 501 is configured by Ansible'
# set firewall ipv4 name Downlink rule 501 ipsec 'match-ipsec'
# set firewall ipv4 name Downlink rule 502 action 'reject'
# set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'
# set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'


# Using gathered
#
# Before state:
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv6 name UPLINK rule 1 action 'accept'
# set firewall ipv6 name UPLINK rule 1 description 'Fwipv6-Rule 1 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 1 ipsec 'match-ipsec'
# set firewall ipv6 name UPLINK rule 2 action 'accept'
# set firewall ipv6 name UPLINK rule 2 description 'Fwipv6-Rule 2 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 2 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND default-action 'accept'
# set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'
# set firewall ipv4 name INBOUND rule 101 action 'accept'
# set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 102 action 'reject'
# set firewall ipv4 name INBOUND rule 102 description 'Rule 102 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 102 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 103 action 'accept'
# set firewall ipv4 name INBOUND rule 103 description 'Rule 103 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 103 destination group address-group 'inbound'
# set firewall ipv4 name INBOUND rule 103 source address '192.0.2.0'
# set firewall ipv4 name INBOUND rule 103 state established
# set firewall ipv4 name INBOUND rule 103 state related
#
- name: Gather listed firewall rules with provided configurations
  vyos.vyos.vyos_firewall_rules:
    config:
    state: gathered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "gathered": [
#        {
#            "afi": "ipv6",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "This is ipv6 specific rule-set",
#                    "name": "UPLINK",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 1 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 1
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Fwipv6-Rule 2 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 2
#                        }
#                    ]
#                }
#            ]
#        },
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "INBOUND",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 101 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 101
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 102 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 102
#                        },
#                        {
#                            "action": "accept",
#                            "description": "Rule 103 is configured by Ansible",
#                            "destination": {
#                                "group": {
#                                    "address_group": "inbound"
#                                }
#                            },
#                            "number": 103,
#                            "source": {
#                                "address": "192.0.2.0"
#                            },
#                            "state": {
#                                "established": true,
#                                "invalid": false,
#                                "new": false,
#                                "related": true
#                            }
#                        }
#                    ]
#                }
#            ]
#        }
#    ]
#
#
# After state:
# -------------
#
# vyos@vyos:~$ show configuration commands| grep firewall
# set firewall group address-group 'inbound'
# set firewall ipv6 name UPLINK default-action 'accept'
# set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'
# set firewall ipv6 name UPLINK rule 1 action 'accept'
# set firewall ipv6 name UPLINK rule 1 description 'Fwipv6-Rule 1 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 1 ipsec 'match-ipsec'
# set firewall ipv6 name UPLINK rule 2 action 'accept'
# set firewall ipv6 name UPLINK rule 2 description 'Fwipv6-Rule 2 is configured by Ansible'
# set firewall ipv6 name UPLINK rule 2 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND default-action 'accept'
# set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'
# set firewall ipv4 name INBOUND rule 101 action 'accept'
# set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 102 action 'reject'
# set firewall ipv4 name INBOUND rule 102 description 'Rule 102 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 102 ipsec 'match-ipsec'
# set firewall ipv4 name INBOUND rule 103 action 'accept'
# set firewall ipv4 name INBOUND rule 103 description 'Rule 103 is configured by Ansible'
# set firewall ipv4 name INBOUND rule 103 destination group address-group 'inbound'
# set firewall ipv4 name INBOUND rule 103 source address '192.0.2.0'
# set firewall ipv4 name INBOUND rule 103 state established
# set firewall ipv4 name INBOUND rule 103 state related


# Using rendered
#
#
- name: Render the commands for provided  configuration
  vyos.vyos.vyos_firewall_rules:
    config:
      - afi: ipv6
        rule_sets:
          - name: UPLINK
            description: This is ipv6 specific rule-set
            default_action: accept
      - afi: ipv4
        rule_sets:
          - name: INBOUND
            description: IPv4 INBOUND rule set
            default_action: accept
            rules:
              - number: 101
                action: accept
                description: Rule 101 is configured by Ansible
                ipsec: match-ipsec
              - number: 102
                action: reject
                description: Rule 102 is configured by Ansible
                ipsec: match-ipsec
              - number: 103
                action: accept
                description: Rule 103 is configured by Ansible
                destination:
                  group:
                    address_group: inbound
                source:
                  address: 192.0.2.0
                state:
                  established: true
                  new: false
                  invalid: false
                  related: true
    state: rendered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "rendered": [
#        "set firewall ipv6 name UPLINK default-action 'accept'",
#        "set firewall ipv6 name UPLINK description 'This is ipv6 specific rule-set'",
#        "set firewall ipv4 name INBOUND default-action 'accept'",
#        "set firewall ipv4 name INBOUND description 'IPv4 INBOUND rule set'",
#        "set firewall ipv4 name INBOUND rule 101 action 'accept'",
#        "set firewall ipv4 name INBOUND rule 101",
#        "set firewall ipv4 name INBOUND rule 101 description 'Rule 101 is configured by Ansible'",
#        "set firewall ipv4 name INBOUND rule 101 ipsec 'match-ipsec'",
#        "set firewall ipv4 name INBOUND rule 102 action 'reject'",
#        "set firewall ipv4 name INBOUND rule 102",
#        "set firewall ipv4 name INBOUND rule 102 description 'Rule 102 is configured by Ansible'",
#        "set firewall ipv4 name INBOUND rule 102 ipsec 'match-ipsec'",
#        "set firewall ipv4 name INBOUND rule 103 description 'Rule 103 is configured by Ansible'",
#        "set firewall ipv4 name INBOUND rule 103 destination group address-group inbound",
#        "set firewall ipv4 name INBOUND rule 103",
#        "set firewall ipv4 name INBOUND rule 103 source address 192.0.2.0",
#        "set firewall ipv4 name INBOUND rule 103 state established",
#        "set firewall ipv4 name INBOUND rule 103 state related",
#        "set firewall ipv4 name INBOUND rule 103 action 'accept'"
#    ]


# Using parsed
#
#
- name: Parse the commands for provided configuration
  vyos.vyos.vyos_firewall_rules:
    running_config:
      "set firewall group address-group 'inbound'
       set firewall ipv4 name Downlink default-action 'accept'
       set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'
       set firewall ipv4 name Downlink rule 501 action 'accept'
       set firewall ipv4 name Downlink rule 501 description 'Rule 501 is configured by Ansible'
       set firewall ipv4 name Downlink rule 501 ipsec 'match-ipsec'
       set firewall ipv4 name Downlink rule 502 action 'reject'
       set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'
       set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed": [
#        {
#            "afi": "ipv4",
#            "rule_sets": [
#                {
#                    "default_action": "accept",
#                    "description": "IPv4 INBOUND rule set",
#                    "name": "Downlink",
#                    "rules": [
#                        {
#                            "action": "accept",
#                            "description": "Rule 501 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 501
#                        },
#                        {
#                            "action": "reject",
#                            "description": "Rule 502 is configured by Ansible",
#                            "ipsec": "match-ipsec",
#                            "number": 502
#                        }
#                    ]
#                }
#            ]
#        }
#    ]
"""
RETURN = """
before:
  description: The configuration prior to the module execution.
  returned: when I(state) is C(merged), C(replaced), C(overridden), C(deleted) or C(purged)
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
after:
  description: The resulting configuration after module execution.
  returned: when changed
  type: dict
  sample: >
    This output will always be in the same format as the
    module argspec.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample:
    - "set firewall ipv4 name Downlink default-action 'accept'"
    - "set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'"
    - "set firewall ipv4 name Downlink rule 501 action 'accept'"
    - "set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'"
    - "set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'"
rendered:
  description: The provided configuration in the task rendered in device-native format (offline).
  returned: when I(state) is C(rendered)
  type: list
  sample:
    - "set firewall ipv4 name Downlink default-action 'accept'"
    - "set firewall ipv4 name Downlink description 'IPv4 INBOUND rule set'"
    - "set firewall ipv4 name Downlink rule 501 action 'accept'"
    - "set firewall ipv4 name Downlink rule 502 description 'Rule 502 is configured by Ansible'"
    - "set firewall ipv4 name Downlink rule 502 ipsec 'match-ipsec'"
gathered:
  description: Facts about the network resource gathered from the remote device as structured data.
  returned: when I(state) is C(gathered)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.
parsed:
  description: The device native config provided in I(running_config) option parsed into structured data as per module argspec.
  returned: when I(state) is C(parsed)
  type: list
  sample: >
    This output will always be in the same format as the
    module argspec.

"""


from ansible.module_utils.basic import AnsibleModule

from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.argspec.firewall_rules.firewall_rules import (
    Firewall_rulesArgs,
)
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.config.firewall_rules.firewall_rules import (
    Firewall_rules,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=Firewall_rulesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Firewall_rules(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
