/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rssinput;

import it.sauronsoftware.feed4j.FeedParser;
import it.sauronsoftware.feed4j.bean.FeedItem;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rssinput.RssInputData;
import org.pentaho.di.trans.steps.rssinput.RssInputField;
import org.pentaho.di.trans.steps.rssinput.RssInputMeta;
import org.pentaho.ui.database.Messages;

public class RssInput
extends BaseStep
implements StepInterface {
    private RssInputMeta meta;
    private RssInputData data;

    public RssInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private boolean readNextUrl() {
        try {
            if (this.meta.urlInField()) {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString((String)"RssInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                if (this.first) {
                    int i;
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    if (Const.isEmpty((String)this.meta.getUrlFieldname())) {
                        this.logError(Messages.getString((String)"RssInput.Log.UrlFieldNameMissing"));
                        throw new KettleException(Messages.getString((String)"RssInput.Log.UrlFieldNameMissing"));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(this.meta.getUrlFieldname());
                        if (this.data.indexOfUrlField < 0) {
                            this.logError(Messages.getString((String)"RssInput.Log.ErrorFindingField") + "[" + this.meta.getUrlFieldname() + "]");
                            throw new KettleException(Messages.getString((String)"RssInput.Exception.ErrorFindingField", (String)this.meta.getUrlFieldname()));
                        }
                    }
                }
                this.data.currenturl = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfUrlField);
            } else {
                if (this.data.last_url) {
                    return false;
                }
                if (this.data.urlnr >= this.data.urlsize) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString((String)"RssInput.Log.FinishedProcessing"));
                    }
                    return false;
                }
                this.data.last_url = this.data.urlnr == this.data.urlsize - 1;
                this.data.currenturl = this.environmentSubstitute(this.meta.getUrl()[this.data.urlnr]);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString((String)"RssInput.Log.ReadingUrl", (String)this.data.currenturl), new Object[0]);
            }
            URL rss = new URL(this.data.currenturl);
            this.data.feed = FeedParser.parse((URL)rss);
            this.data.itemssize = this.data.feed.getItemCount();
            ++this.data.urlnr;
            this.data.itemsnr = 0;
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString((String)"RssInput.Log.UrlReaded", (String)this.data.currenturl, (String)("" + this.data.itemssize)));
            }
        }
        catch (Exception e) {
            this.logError(Messages.getString((String)"RssInput.Log.UnableToReadUrl", (String)("" + this.data.urlnr), (String)this.data.currenturl, (String)e.toString()));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        if (this.meta.urlInField()) {
            while (this.data.itemsnr >= this.data.itemssize) {
                if (this.readNextUrl()) continue;
                return null;
            }
        } else {
            while (this.data.itemsnr >= this.data.itemssize || this.data.feed == null) {
                if (this.readNextUrl()) continue;
                return null;
            }
        }
        Object[] outputRowData = this.buildEmptyRow();
        if (this.data.readrow != null) {
            System.arraycopy(this.data.readrow, 0, outputRowData, 0, this.data.readrow.length);
        }
        try {
            FeedItem item = this.data.feed.getItem(this.data.itemsnr);
            if (Const.isEmpty((String)this.meta.getRealReadFrom()) || !Const.isEmpty((String)this.meta.getRealReadFrom()) && item.getPubDate().compareTo(this.data.readfromdatevalide) > 0) {
                RowMetaInterface irow;
                for (int j = 0; j < this.meta.getInputFields().length; ++j) {
                    RssInputField RSSInputField = this.meta.getInputFields()[j];
                    String valueString = null;
                    if (RSSInputField.getColumn() == 0) {
                        valueString = item.getTitle();
                    } else if (RSSInputField.getColumn() == 1) {
                        valueString = item.getLink() == null ? "" : item.getLink().toString();
                    } else if (RSSInputField.getColumn() == 2) {
                        valueString = item.getDescriptionAsText();
                    } else if (RSSInputField.getColumn() == 3) {
                        valueString = item.getDescriptionAsHTML();
                    } else if (RSSInputField.getColumn() == 4) {
                        valueString = item.getComments() == null ? "" : item.getComments().toString();
                    } else if (RSSInputField.getColumn() == 5) {
                        valueString = item.getGUID();
                    } else if (RSSInputField.getColumn() == 6) {
                        valueString = item.getPubDate() == null ? "" : DateFormat.getInstance().format(item.getPubDate());
                    }
                    switch (RSSInputField.getTrimType()) {
                        case 1: {
                            valueString = Const.ltrim((String)valueString);
                            break;
                        }
                        case 2: {
                            valueString = Const.rtrim((String)valueString);
                            break;
                        }
                        case 3: {
                            valueString = Const.trim((String)valueString);
                            break;
                        }
                    }
                    ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + j);
                    ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + j);
                    outputRowData[this.data.totalpreviousfields + j] = targetValueMeta.convertData(sourceValueMeta, (Object)valueString);
                    if (!this.meta.getInputFields()[j].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)valueString)) continue;
                    outputRowData[this.data.totalpreviousfields + j] = this.data.previousRow[this.data.totalpreviousfields + j];
                }
                int rowIndex = this.data.nrInputFields;
                if (this.meta.includeUrl()) {
                    outputRowData[this.data.totalpreviousfields + rowIndex++] = this.data.currenturl;
                }
                if (this.meta.includeRowNumber()) {
                    outputRowData[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.rownr);
                }
                this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
                ++this.data.rownr;
                ++this.data.itemsnr;
            }
        }
        catch (Exception e) {
            throw new KettleException(e.toString());
        }
        return outputRowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block5: {
            Object[] outputRowData = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString((String)"RssInput.Exception.Run", (String)e.toString()));
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setErrors(1L);
                    throw new KettleException((Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "RssInput001");
            }
        }
        return true;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RssInputMeta)smi;
        this.data = (RssInputData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.includeRowNumber() && Const.isEmpty((String)this.meta.getRowNumberField())) {
                this.logError(Messages.getString((String)"RssInput.Error.RowNumberFieldMissing"));
                return false;
            }
            if (this.meta.includeUrl() && Const.isEmpty((String)this.meta.geturlField())) {
                this.logError(Messages.getString((String)"RssInput.Error.UrlFieldMissing"));
                return false;
            }
            if (!Const.isEmpty((String)this.meta.getReadFrom())) {
                try {
                    SimpleDateFormat fdrss = new SimpleDateFormat("yyyy-MM-dd");
                    fdrss.setLenient(false);
                    this.data.readfromdatevalide = fdrss.parse(this.meta.getRealReadFrom());
                }
                catch (Exception e) {
                    this.logError("can not validate ''Read From date'' : " + this.environmentSubstitute(this.meta.getReadFrom()));
                    return false;
                }
            }
            if (this.meta.urlInField()) {
                if (this.meta.getUrl() == null && this.meta.getUrl().length == 0) {
                    this.logError(Messages.getString((String)"RssInput.Log.UrlMissing"));
                    return false;
                }
            } else {
                this.data.urlsize = this.meta.getUrl().length;
                try {
                    int i;
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                }
                catch (Exception e) {
                    this.logError("Error initializing step: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.rownr = 1L;
            this.data.urlnr = 0;
            this.data.nrInputFields = this.meta.getInputFields().length;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RssInputMeta)smi;
        this.data = (RssInputData)sdi;
        if (this.data.feed != null) {
            this.data.feed = null;
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

