// Copyright 2020 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include "soc/soc_caps.h"
#include "soc/periph_defs.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    struct {
        const periph_module_t module;
        struct {
            const int rx_irq_id;
            const int tx_irq_id;
        } pairs[SOC_GDMA_PAIRS_PER_GROUP];
    } groups[SOC_GDMA_GROUPS];
} gdma_signal_conn_t;

extern const gdma_signal_conn_t gdma_periph_signals;

#ifdef __cplusplus
}
#endif
