/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class InjectPayloadCallother
extends InjectPayloadSleigh {
    protected InjectPayloadCallother(ConstructTpl pcode, InjectPayloadCallother failedPayload) {
        super(pcode, failedPayload);
    }

    protected InjectPayloadCallother(ConstructTpl pcode, String nm) {
        super(pcode, 2, nm);
    }

    public InjectPayloadCallother(String sourceName) {
        super(sourceName);
        this.type = 2;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_CALLOTHERFIXUP);
        encoder.writeString(AttributeId.ATTRIB_TARGETOP, this.name);
        super.encode(encoder);
        encoder.closeElement(ElementId.ELEM_CALLOTHERFIXUP);
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage language) throws XmlParseException {
        XmlElement fixupEl = parser.start(new String[]{"callotherfixup"});
        this.name = fixupEl.getAttribute("targetop");
        if (!parser.peek().isStart() || !parser.peek().getName().equals("pcode")) {
            throw new XmlParseException("<callotherfixup> does not contain a <pcode> tag");
        }
        super.restoreXml(parser, language);
        parser.end(fixupEl);
    }
}

