/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.util;

import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.AssertException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class PluginUtils {
    public static <T extends Plugin> T instantiatePlugin(Class<T> pluginClass, PluginTool tool) throws PluginException {
        String className = pluginClass.getName();
        try {
            Constructor<T> ctor = pluginClass.getConstructor(PluginTool.class);
            ctor.setAccessible(true);
            return (T)((Plugin)ctor.newInstance(new Object[]{tool}));
        }
        catch (NoSuchMethodException e) {
            throw new PluginException(className, "Possibly missing plugin constructor");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            String message = t == null ? "" : t.getMessage();
            Msg.error(PluginUtils.class, (Object)("Unexpected Exception: " + message), (Throwable)t);
            throw new PluginException("Error constructing plugin: " + String.valueOf(pluginClass), e);
        }
        catch (InstantiationException e) {
            throw new PluginException(className, "Could not instantiate plugin class " + String.valueOf(e));
        }
        catch (IllegalAccessException e) {
            throw new PluginException(className, "Illegal Access exception, make sure plugin class and constructor is public");
        }
    }

    public static Class<? extends Plugin> forName(String pluginClassName) throws PluginException {
        try {
            List classes = ClassSearcher.getClasses(Plugin.class);
            for (Class plug : classes) {
                if (!plug.getName().equals(pluginClassName)) continue;
                return plug;
            }
            Class<?> tmpClass = Class.forName(pluginClassName);
            if (!Plugin.class.isAssignableFrom(tmpClass)) {
                throw new PluginException("Class " + pluginClassName + " is not derived from Plugin");
            }
            return tmpClass.asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Plugin class not found: " + pluginClassName);
        }
    }

    private static String getStaticStringFieldValue(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException ex) {
            throw new AssertException("default provider class for " + clazz.getName() + " is not declared to be public!");
        }
        return null;
    }

    public static Class<? extends Plugin> getDefaultProviderForServiceClass(Class<?> serviceClass) {
        String defaultProviderClassName = null;
        ServiceInfo sia = serviceClass.getAnnotation(ServiceInfo.class);
        if (sia != null) {
            if (sia.defaultProvider().length > 0) {
                return sia.defaultProvider()[0];
            }
            defaultProviderClassName = sia.defaultProviderName().trim();
        }
        if (defaultProviderClassName == null || defaultProviderClassName.isEmpty()) {
            defaultProviderClassName = PluginUtils.getStaticStringFieldValue(serviceClass, "defaultProvider");
        }
        if (defaultProviderClassName != null) {
            try {
                Class<?> tmpClass = Class.forName(defaultProviderClassName);
                return tmpClass.asSubclass(Plugin.class);
            }
            catch (ClassCastException cce) {
                Msg.error(PluginUtils.class, (Object)("The default provider specified for service " + serviceClass.getName() + " (" + defaultProviderClassName + ") is not a Plugin!"));
            }
            catch (ClassNotFoundException e) {
                throw new AssertException("default provider class for " + serviceClass.getName() + " not found!");
            }
        }
        return null;
    }

    public static String getPluginNameFromClass(Class<? extends Plugin> pluginClass) {
        return pluginClass.getSimpleName();
    }

    public static void assertUniquePluginName(Class<? extends Plugin> pluginClass) throws PluginException {
        String pluginName = PluginUtils.getPluginNameFromClass(pluginClass);
        for (Class otherPluginClass : ClassSearcher.getClasses(Plugin.class)) {
            if (otherPluginClass == pluginClass || !PluginUtils.getPluginNameFromClass(otherPluginClass).equals(pluginName)) continue;
            throw new PluginException("Duplicate Plugin name: " + pluginClass.getName() + " and " + otherPluginClass.getName());
        }
    }
}

