/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.plugin.core.equate.AbstractConvertAction;
import ghidra.app.plugin.core.equate.EquatePlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringUtilities;

public class ConvertToBinaryAction
extends AbstractConvertAction {
    public ConvertToBinaryAction(EquatePlugin plugin) {
        super(plugin, "Convert To Unsigned Binary", false);
    }

    @Override
    protected String getMenuName(Program program, Scalar scalar, boolean isData) {
        return this.getStandardLengthString("Unsigned Binary:") + this.convertToString(program, scalar, isData);
    }

    @Override
    protected String convertToString(Program program, Scalar scalar, boolean isData) {
        String valueStr = Long.toBinaryString(scalar.getUnsignedValue());
        valueStr = StringUtilities.pad((String)valueStr, (char)'0', (int)scalar.bitLength());
        return valueStr + "b";
    }

    @Override
    protected int getFormatChoice() {
        return 2;
    }
}

