/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import ghidra.features.bsim.query.LSHException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class CategoryRecord
implements Comparable<CategoryRecord> {
    private String type;
    private String category;

    public CategoryRecord(String t, String c) {
        this.type = t;
        this.category = c;
    }

    public String getType() {
        return this.type;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean equals(Object obj) {
        CategoryRecord op2 = (CategoryRecord)obj;
        if (!this.type.equals(op2.type)) {
            return false;
        }
        return this.category.equals(op2.category);
    }

    @Override
    public int compareTo(CategoryRecord arg0) {
        int cmp = this.type.compareTo(arg0.type);
        if (cmp != 0) {
            return cmp;
        }
        if (this.category == null) {
            if (arg0.category == null) {
                return 0;
            }
            return -1;
        }
        if (arg0.category == null) {
            return 1;
        }
        return this.category.compareTo(arg0.category);
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("  <category type=\"");
        fwrite.append(this.type);
        fwrite.append("\">");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.category);
        fwrite.append("</category>\n");
    }

    public static CategoryRecord restoreXml(XmlPullParser parser) throws LSHException {
        XmlElement el = parser.start(new String[]{"category"});
        String type = el.getAttribute("type");
        String category = parser.end().getText();
        if (type == null || category == null) {
            throw new LSHException("Bad category tag");
        }
        return new CategoryRecord(type, category);
    }

    public static boolean enforceTypeCharacters(String val) {
        if (val == null) {
            return false;
        }
        if (val.length() == 0) {
            return false;
        }
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == '_' || c == ':' || c == '/' || c == '(' || c == ')') continue;
            return false;
        }
        return true;
    }
}

