/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph;

import datagraph.data.graph.DataExplorationGraph;
import datagraph.data.graph.DegEdge;
import datagraph.data.graph.DegVertex;
import datagraph.graph.explore.EgEdgeTransformer;
import datagraph.graph.explore.EgGraphLayout;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import java.util.Comparator;

public class DegLayout
extends EgGraphLayout<DegVertex, DegEdge> {
    protected DegLayout(DataExplorationGraph g, int verticalGap, int horizontalGap) {
        super(g, "Data Graph Layout", verticalGap, horizontalGap);
    }

    public DataExplorationGraph getVisualGraph() {
        return (DataExplorationGraph)this.getGraph();
    }

    public AbstractVisualGraphLayout<DegVertex, DegEdge> createClonedLayout(VisualGraph<DegVertex, DegEdge> newGraph) {
        if (!(newGraph instanceof DataExplorationGraph)) {
            throw new IllegalArgumentException("Must pass a " + DataExplorationGraph.class.getSimpleName() + "to clone the " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        DataExplorationGraph dataGraph = (DataExplorationGraph)newGraph;
        DegLayout newLayout = new DegLayout(dataGraph, this.verticalGap, this.horizontalGap);
        return newLayout;
    }

    @Override
    protected Comparator<DegVertex> getIncommingVertexComparator() {
        return (v1, v2) -> v1.getAddress().compareTo((Object)v2.getAddress());
    }

    @Override
    protected Comparator<DegVertex> getOutgoingVertexComparator() {
        return (v1, v2) -> {
            DegVertex parent = (DegVertex)v1.getSourceVertex();
            return parent.compare(v1, v2);
        };
    }

    @Override
    protected EgEdgeTransformer<DegVertex, DegEdge> createEdgeTransformer() {
        return new EgEdgeTransformer<DegVertex, DegEdge>();
    }
}

