/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceSection
implements TraceSection,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final SectionTranslator translator;

    public DBTraceSection(DBTraceObject object) {
        this.object = object;
        this.translator = new SectionTranslator(this, object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public TraceModule getModule() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceModule traceModule = this.object.queryCanonicalAncestorsInterface(TraceModule.class).findAny().orElseThrow();
            return traceModule;
        }
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(long snap, String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(Lifespan.nowOn(snap), name);
        }
    }

    @Override
    public String getName(long snap) {
        String key = this.object.getCanonicalPath().key();
        String index = KeyPath.parseIfIndex(key);
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_display", String.class, index);
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", range);
        }
    }

    @Override
    public AddressRange getRange(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            AddressRange addressRange = TraceObjectInterfaceUtils.getValue(this.object, snap, "_range", AddressRange.class, null);
            return addressRange;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class SectionTranslator
    extends DBTraceObjectInterface.Translator<TraceSection> {
        private static final Map<TraceObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Set<String>>();
        private final Set<String> keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SectionTranslator(DBTraceSection this$0, DBTraceObject object, TraceSection iface) {
            super("_range", object, iface);
            TraceObjectSchema schema = object.getSchema();
            Map<TraceObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(s.checkAliasedAttribute("_range"), s.checkAliasedAttribute("_display")));
            }
        }

        @Override
        protected TraceEvent<TraceSection, Void> getAddedType() {
            return TraceEvents.SECTION_ADDED;
        }

        @Override
        protected TraceEvent<TraceSection, Lifespan> getLifespanChangedType() {
            return null;
        }

        @Override
        protected TraceEvent<TraceSection, Void> getChangedType() {
            return TraceEvents.SECTION_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.contains(key);
        }

        @Override
        protected TraceEvent<TraceSection, Void> getDeletedType() {
            return TraceEvents.SECTION_DELETED;
        }
    }
}

