/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sourceToSink;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.sourceToSink.DeepTaintAnalyzerException;
import com.intellij.codeInspection.sourceToSink.NonMarkedElement;
import com.intellij.codeInspection.sourceToSink.TaintAnalyzer;
import com.intellij.codeInspection.sourceToSink.TaintValue;
import com.intellij.codeInspection.sourceToSink.TaintValueFactory;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.PsiClassRenderingInfo;
import com.intellij.ide.util.PsiElementRenderingInfo;
import com.intellij.ide.util.PsiMethodRenderingInfo;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public class TaintNode
extends PresentableNodeDescriptor<TaintNode> {
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myPsiElement;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myRef;
    List<TaintNode> myCachedChildren;
    TaintValue myTaintValue = TaintValue.UNKNOWN;
    boolean isTaintFlowRoot;
    private boolean isExcluded;
    @Nullable
    private final Icon myIcon;
    @Nullable
    private final TaintValueFactory myTaintValueFactory;
    private final boolean myNext;
    @NotNull
    private final PresentationData data = new PresentationData();

    TaintNode(@Nullable TaintNode parent, @Nullable PsiElement psiElement, @Nullable PsiElement ref, @Nullable TaintValueFactory taintValueFactory, boolean next) {
        super(parent == null ? null : parent.myProject, (NodeDescriptor)parent);
        this.myPsiElement = psiElement == null ? null : SmartPointerManager.createPointer((PsiElement)psiElement);
        this.myRef = ref == null ? null : SmartPointerManager.createPointer((PsiElement)ref);
        this.myTaintValueFactory = taintValueFactory;
        int flags = 3;
        this.myIcon = psiElement == null ? null : psiElement.getIcon(flags);
        this.myNext = next;
        this.appendPsiElement(psiElement);
    }

    public TaintNode getElement() {
        return this;
    }

    public PsiElement getRef() {
        return this.myRef == null ? null : this.myRef.getElement();
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myPsiElement == null ? null : this.myPsiElement.getElement();
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            TaintNode.$$$reportNull$$$0(0);
        }
    }

    public List<TaintNode> calcChildren() {
        PsiElement elementRef;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        if (this.myCachedChildren != null) {
            return this.myCachedChildren;
        }
        PsiElement psiElement2 = elementRef = this.myRef == null ? null : this.myRef.getElement();
        if (elementRef == null) {
            return null;
        }
        this.myCachedChildren = this.propagate(psiElement, elementRef);
        if (this.isExcluded) {
            this.myCachedChildren.forEach(c -> c.setExcluded(this.isExcluded));
        }
        return this.myCachedChildren;
    }

    @NotNull
    private List<TaintNode> propagate(@NotNull PsiElement psiElement, @NotNull PsiElement elementRef) {
        TaintValue taintValue;
        if (psiElement == null) {
            TaintNode.$$$reportNull$$$0(1);
        }
        if (elementRef == null) {
            TaintNode.$$$reportNull$$$0(2);
        }
        if (this.myTaintValueFactory == null) {
            List<TaintNode> list = List.of();
            if (list == null) {
                TaintNode.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (!this.myNext) {
            List<TaintNode> list = List.of();
            if (list == null) {
                TaintNode.$$$reportNull$$$0(4);
            }
            return list;
        }
        TaintAnalyzer taintAnalyzer = new TaintAnalyzer(this.myTaintValueFactory);
        UExpression uExpression = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)elementRef, (Class[])new Class[]{UExpression.class});
        if (uExpression == null) {
            List<TaintNode> list = Collections.emptyList();
            if (list == null) {
                TaintNode.$$$reportNull$$$0(5);
            }
            return list;
        }
        try {
            taintValue = taintAnalyzer.analyzeExpression(uExpression, true, TaintValue.TAINTED);
        }
        catch (DeepTaintAnalyzerException e) {
            List<TaintNode> list = Collections.emptyList();
            if (list == null) {
                TaintNode.$$$reportNull$$$0(6);
            }
            return list;
        }
        this.myTaintValue = taintValue;
        if (taintValue == TaintValue.UNTAINTED) {
            List<TaintNode> list = Collections.emptyList();
            if (list == null) {
                TaintNode.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (taintValue == TaintValue.TAINTED) {
            this.markTainted();
            List<TaintNode> list = Collections.emptyList();
            if (list == null) {
                TaintNode.$$$reportNull$$$0(8);
            }
            return list;
        }
        Set<PsiElement> parents = this.collectParents();
        parents.add(psiElement);
        ArrayList<TaintNode> children = new ArrayList<TaintNode>();
        for (NonMarkedElement nonMarkedElement : taintAnalyzer.getNonMarkedElements()) {
            if (parents.contains(nonMarkedElement.myNonMarked)) continue;
            TaintNode child = new TaintNode(this, (PsiElement)nonMarkedElement.myNonMarked, nonMarkedElement.myRef, this.myTaintValueFactory, nonMarkedElement.myNext);
            children.add(child);
        }
        ArrayList<TaintNode> arrayList = children;
        if (arrayList == null) {
            TaintNode.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    protected PresentationData createPresentation() {
        PresentationData data = new PresentationData();
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            TaintNode.append(data, UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            PresentationData presentationData = data;
            if (presentationData == null) {
                TaintNode.$$$reportNull$$$0(10);
            }
            return presentationData;
        }
        data.setIcon(this.myIcon);
        data.applyFrom(this.data);
        if (!this.isTaintFlowRoot) {
            PresentationData presentationData = data;
            if (presentationData == null) {
                TaintNode.$$$reportNull$$$0(11);
            }
            return presentationData;
        }
        String unsafeFlow = JvmAnalysisBundle.message("jvm.inspections.source.unsafe.to.sink.flow.propagate.safe.toolwindow.unsafe.flow", new Object[0]);
        SimpleTextAttributes attributes = new SimpleTextAttributes(2, UIUtil.getLabelInfoForeground());
        TaintNode.append(data, unsafeFlow, attributes);
        PresentationData presentationData = data;
        if (presentationData == null) {
            TaintNode.$$$reportNull$$$0(12);
        }
        return presentationData;
    }

    private static void append(@NotNull PresentationData data, @NlsContexts.Label @NotNull String message, @NotNull SimpleTextAttributes attributes) {
        if (data == null) {
            TaintNode.$$$reportNull$$$0(13);
        }
        if (message == null) {
            TaintNode.$$$reportNull$$$0(14);
        }
        if (attributes == null) {
            TaintNode.$$$reportNull$$$0(15);
        }
        data.addText(message, attributes);
    }

    private void appendPsiElement(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return;
        }
        TaintNode taintNode = this;
        int style = taintNode.isExcluded() ? 4 : 0;
        Color color = taintNode.myTaintValue == TaintValue.TAINTED ? NamedColorUtil.getErrorForeground() : null;
        SimpleTextAttributes attributes = new SimpleTextAttributes(style, color);
        PsiMethod psiMethod = (PsiMethod)ObjectUtils.tryCast((Object)psiElement, PsiMethod.class);
        if (psiMethod != null) {
            PsiMethodRenderingInfo renderingInfo = new PsiMethodRenderingInfo(true);
            String text = renderingInfo.getPresentableText(psiMethod);
            TaintNode.append(this.data, text, attributes);
            return;
        }
        PsiVariable psiVariable = (PsiVariable)ObjectUtils.tryCast((Object)psiElement, PsiVariable.class);
        if (psiVariable != null) {
            String varText = PsiFormatUtil.formatVariable((PsiVariable)psiVariable, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            TaintNode.append(this.data, varText, attributes);
            PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
            Color placeColor = attributes.getFgColor();
            if (placeColor == null) {
                placeColor = UIUtil.getLabelInfoForeground();
            }
            SimpleTextAttributes placeAttribute = new SimpleTextAttributes(2, placeColor);
            if (parent instanceof PsiMethod) {
                PsiMethodRenderingInfo renderingInfo = new PsiMethodRenderingInfo(true);
                TaintNode.append(this.data, ": " + renderingInfo.getPresentableText((PsiMethod)parent), placeAttribute);
            } else if (parent instanceof PsiClass) {
                PsiElementRenderingInfo renderingInfo = PsiClassRenderingInfo.INSTANCE;
                TaintNode.append(this.data, ": " + renderingInfo.getPresentableText((PsiElement)((PsiClass)parent)), placeAttribute);
            }
            return;
        }
        PsiNamedElement namedElement = (PsiNamedElement)ObjectUtils.tryCast((Object)psiElement, PsiNamedElement.class);
        if (namedElement == null) {
            return;
        }
        String name = namedElement.getName();
        if (name == null) {
            return;
        }
        TaintNode.append(this.data, name, attributes);
    }

    private void markTainted() {
        List<TaintNode> siblings;
        this.myTaintValue = TaintValue.TAINTED;
        TaintNode parent = (TaintNode)((Object)ObjectUtils.tryCast((Object)this.getParentDescriptor(), TaintNode.class));
        if (parent != null && (siblings = parent.myCachedChildren) != null && siblings.size() == 1) {
            parent.markTainted();
            return;
        }
        this.isTaintFlowRoot = true;
    }

    @NotNull
    private Set<PsiElement> collectParents() {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        TaintNode parent = (TaintNode)((Object)ObjectUtils.tryCast((Object)this.getParentDescriptor(), TaintNode.class));
        while (parent != null) {
            PsiElement parentPsiElement = parent.getPsiElement();
            if (parentPsiElement == null || parent.getParentDescriptor() == null) {
                HashSet<PsiElement> hashSet = parents;
                if (hashSet == null) {
                    TaintNode.$$$reportNull$$$0(16);
                }
                return hashSet;
            }
            parents.add(parentPsiElement);
            parent = (TaintNode)((Object)ObjectUtils.tryCast((Object)parent.getParentDescriptor(), TaintNode.class));
        }
        HashSet<PsiElement> hashSet = parents;
        if (hashSet == null) {
            TaintNode.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    boolean isExcluded() {
        return this.isExcluded;
    }

    void setExcluded(boolean excluded) {
        this.isExcluded = excluded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRef";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/sourceToSink/TaintNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/sourceToSink/TaintNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "propagate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "propagate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 16, 17 -> new IllegalStateException(string);
        };
    }
}

