/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.common.Value;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.otlp.ArrayAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BytesAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;
import java.nio.ByteBuffer;
import java.util.List;

public final class AnyValueMarshaler {
    private AnyValueMarshaler() {
    }

    public static MarshalerWithSize create(Value<?> value) {
        switch (value.getType()) {
            case STRING: {
                return StringAnyValueMarshaler.create((String)value.getValue());
            }
            case BOOLEAN: {
                return BoolAnyValueMarshaler.create((Boolean)value.getValue());
            }
            case LONG: {
                return IntAnyValueMarshaler.create((Long)value.getValue());
            }
            case DOUBLE: {
                return DoubleAnyValueMarshaler.create((Double)value.getValue());
            }
            case ARRAY: {
                return ArrayAnyValueMarshaler.createAnyValue((List)value.getValue());
            }
            case KEY_VALUE_LIST: {
                return KeyValueListAnyValueMarshaler.create((List)value.getValue());
            }
            case BYTES: {
                return BytesAnyValueMarshaler.create((ByteBuffer)value.getValue());
            }
        }
        throw new IllegalArgumentException("Unsupported Value type: " + (Object)((Object)value.getType()));
    }
}

