/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.stringprep;

import java.net.IDN;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import rocks.xmpp.precis.PrecisProfile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\n\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/xmpp/stringprep/IDNWithUnderscoreProfile;", "Lrocks/xmpp/precis/PrecisProfile;", "()V", "applyAdditionalMappingRule", "", "kotlin.jvm.PlatformType", "charSequence", "", "applyCaseMappingRule", "applyDirectionalityRule", "applyNormalizationRule", "applyWidthMappingRule", "prepare", "input", "verifyLDHUP", "s", "Companion", "jitsi-xmpp-extensions"})
@SourceDebugExtension(value={"SMAP\nJitsiXmppStringprep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JitsiXmppStringprep.kt\norg/jitsi/xmpp/stringprep/IDNWithUnderscoreProfile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class IDNWithUnderscoreProfile
extends PrecisProfile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final char[] dots;
    private static final Pattern LABEL_SEPARATOR;

    public IDNWithUnderscoreProfile() {
        super(false);
    }

    @Override
    @NotNull
    public String prepare(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter(input, "input");
        String string = IDN.toASCII(((Object)input).toString());
        Intrinsics.checkNotNullExpressionValue(string, "toASCII(...)");
        String ascii = this.verifyLDHUP(string);
        String string2 = IDN.toUnicode(ascii);
        Intrinsics.checkNotNullExpressionValue(string2, "toUnicode(...)");
        return this.verifyLDHUP(string2);
    }

    private final String verifyLDHUP(String s2) {
        String string;
        String it = string = s2;
        boolean bl = false;
        StringBuffer dest = new StringBuffer(s2);
        if (!(((CharSequence)dest).length() > 0)) {
            boolean $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$92 = false;
            String $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$92 = "Empty label is not a legal name";
            throw new IllegalArgumentException($i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$92.toString());
        }
        int $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$92 = s2.length();
        for (int i = 0; i < $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$92; ++i) {
            if (!(!IDNWithUnderscoreProfile.Companion.isNonLDHUPAsciiCodePoint(dest.charAt(i)))) {
                boolean $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$102 = false;
                String $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$102 = "Contains non-LDHUP ASCII characters: " + dest.charAt(i);
                throw new IllegalArgumentException($i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$102.toString());
            }
            if (!IDNWithUnderscoreProfile.Companion.isLabelSeparator(dest.charAt(i))) continue;
            if (!(i != 0)) {
                boolean $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$112 = false;
                String $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$112 = "Empty label is not a legal name";
                throw new IllegalArgumentException($i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$112.toString());
            }
            if (!(dest.charAt(i - 1) != '-')) {
                boolean $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$122 = false;
                String $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$122 = "Label has trailing hyphen";
                throw new IllegalArgumentException($i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$122.toString());
            }
            if (!(!IDNWithUnderscoreProfile.Companion.isLabelSeparator(dest.charAt(i - 1)))) {
                boolean $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$132 = false;
                String $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$132 = "Empty label is not a legal name";
                throw new IllegalArgumentException($i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$132.toString());
            }
            if (!(i == dest.length() - 1 || dest.charAt(i + 1) != '-')) {
                boolean $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$142 = false;
                String $i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$142 = "Label has leading hyphen";
                throw new IllegalArgumentException($i$a$-require-IDNWithUnderscoreProfile$verifyLDHUP$1$142.toString());
            }
            if (i == dest.length() - 1 || !IDNWithUnderscoreProfile.Companion.isLabelSeparator(dest.charAt(i + 1))) continue;
            boolean bl2 = false;
            String string2 = "Empty label";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(dest.charAt(0) != '-' && dest.charAt(dest.length() - 1) != '-')) {
            boolean bl3 = false;
            String string3 = "Has leading or trailing hyphen";
            throw new IllegalArgumentException(string3.toString());
        }
        return string;
    }

    @Override
    protected CharSequence applyWidthMappingRule(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "charSequence");
        return PrecisProfile.widthMap(charSequence);
    }

    @Override
    protected String applyAdditionalMappingRule(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "charSequence");
        return LABEL_SEPARATOR.matcher(charSequence).replaceAll(".");
    }

    @Override
    @NotNull
    protected String applyCaseMappingRule(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "charSequence");
        String string = ((Object)charSequence).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    @Override
    protected String applyNormalizationRule(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "charSequence");
        return Normalizer.normalize(charSequence, Normalizer.Form.NFC);
    }

    @Override
    @NotNull
    protected CharSequence applyDirectionalityRule(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter(charSequence, "charSequence");
        return charSequence;
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('.'), Character.valueOf('\u3002'), Character.valueOf('\uff0e'), Character.valueOf('\uff61')};
        dots = CollectionsKt.toCharArray((Collection<Character>)CollectionsKt.listOf(characterArray));
        LABEL_SEPARATOR = Pattern.compile("[" + ArraysKt.joinToString$default(dots, (CharSequence)"", null, null, 0, null, null, 62, null) + "]");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\t*\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jitsi/xmpp/stringprep/IDNWithUnderscoreProfile$Companion;", "", "()V", "LABEL_SEPARATOR", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "dots", "", "isLabelSeparator", "", "", "isNonLDHUPAsciiCodePoint", "", "jitsi-xmpp-extensions"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isLabelSeparator(char $this$isLabelSeparator) {
            return ArraysKt.contains(dots, $this$isLabelSeparator);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNonLDHUPAsciiCodePoint(int $this$isNonLDHUPAsciiCodePoint) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            if (0 <= $this$isNonLDHUPAsciiCodePoint) {
                if ($this$isNonLDHUPAsciiCodePoint < 37) {
                    return true;
                }
                bl4 = false;
            } else {
                bl4 = false;
            }
            if (bl4) return true;
            if (38 <= $this$isNonLDHUPAsciiCodePoint) {
                if ($this$isNonLDHUPAsciiCodePoint < 45) {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ($this$isNonLDHUPAsciiCodePoint == 47) return true;
            if (58 <= $this$isNonLDHUPAsciiCodePoint) {
                if ($this$isNonLDHUPAsciiCodePoint < 65) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if (91 <= $this$isNonLDHUPAsciiCodePoint) {
                if ($this$isNonLDHUPAsciiCodePoint < 95) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if ($this$isNonLDHUPAsciiCodePoint == 96) return true;
            if (123 > $this$isNonLDHUPAsciiCodePoint) return false;
            if ($this$isNonLDHUPAsciiCodePoint >= 128) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

