/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBArray;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.broker.StopMonitor;
import com.ca.directory.jxplorer.search.SearchExecute;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class SearchBar
extends JToolBar {
    JXplorer jxplorer;
    StopMonitor stopMonitor;
    int lastQuickSearchSelection = 0;
    private static Logger log = Logger.getLogger(SearchBar.class.getName());

    public SearchBar(JXplorer jxplorer) {
        this.jxplorer = jxplorer;
        this.setFloatable(false);
        String attFile = "quicksearch.txt";
        this.setSize(750, 10);
        CBButton search = new CBButton(CBIntText.get("Quick Search"), CBIntText.get("Click here to perform the search."));
        search.setPreferredSize(new Dimension(115, 20));
        ButtonRegister br = JXplorer.getButtonRegister();
        br.registerItem(br.SEARCH, search);
        jxplorer.getRootPane().setDefaultButton(search);
        Object[] selections = null;
        try {
            selections = CBUtility.readStringArrayFile("quicksearch.txt");
        }
        catch (Exception e) {
            selections = null;
        }
        if (selections == null || selections.length == 0) {
            selections = new String[]{"cn", "sn", "description", "telephoneNumber", "postalCode", "address"};
        }
        final CBJComboBox searchAttribute = new CBJComboBox(selections);
        searchAttribute.setEditable(true);
        searchAttribute.setPreferredSize(new Dimension(150, 20));
        searchAttribute.setToolTipText(CBIntText.get("Select a search attribute, or type in a new one (and press enter)."));
        this.add(searchAttribute);
        Object[] ftns = new String[]{"=", "~=", ">=", "<=", "!(=)"};
        final CBJComboBox searchFtn = new CBJComboBox(ftns);
        searchFtn.setEditable(false);
        searchFtn.setToolTipText(CBIntText.get("Specify the matching relationship for your search."));
        this.add(searchFtn);
        final JTextField searchFilter = new JTextField();
        searchFilter.setToolTipText(CBIntText.get("Place the value to match here (you can use wildcards such as '*')."));
        this.add(searchFilter);
        search.setToolTipText(CBIntText.get("Search from your currently selected node using the searchBar fields."));
        this.add(search);
        final JXplorer jx = jxplorer;
        search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String ftn = searchFtn.getSelectedItem().toString();
                String filter = "(" + searchAttribute.getSelectedItem();
                filter = "!(=)".equals(ftn) ? "(!" + filter + "=" + searchFilter.getText() + "))" : ("rfc2254".equals(searchAttribute.getSelectedItem()) ? searchFilter.getText() : filter + ftn + searchFilter.getText() + ")");
                DN base = jx.getTree().getCurrentDN();
                if (base == null) {
                    base = jx.getTree().getRootDN();
                }
                String aliasOption = "always";
                log.info("Setting search alias option to: [" + aliasOption + "]");
                JXplorer.setProperty("option.ldap.searchAliasBehaviour", aliasOption);
                SearchExecute.run(jx.getSearchTree(), base, filter, new String[]{"objectClass"}, 2, jx.getSearchBroker());
                jx.getTreeTabPane().setSelectedComponent(jx.getResultsPanel());
            }
        });
        searchAttribute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i;
                boolean newItem = true;
                boolean itemDeleted = false;
                String selection = searchAttribute.getSelectedItem().toString();
                if (selection.length() == 0) {
                    int removePos;
                    int n = removePos = SearchBar.this.lastQuickSearchSelection < searchAttribute.getItemCount() ? SearchBar.this.lastQuickSearchSelection : -1;
                    if (removePos < 0) {
                        return;
                    }
                    searchAttribute.removeItemAt(removePos);
                }
                SearchBar.this.lastQuickSearchSelection = searchAttribute.getSelectedIndex();
                Object[] values = new String[searchAttribute.getItemCount() + 1];
                int j = 0;
                for (i = 0; i < searchAttribute.getItemCount(); ++i) {
                    String searchAtt = searchAttribute.getItemAt(i).toString();
                    if (selection.equals(searchAtt)) {
                        newItem = false;
                    }
                    if (searchAtt != null && searchAtt.length() > 0) {
                        if (!SearchBar.this.isAttributeValid(searchAtt)) continue;
                        values[j++] = searchAtt;
                        continue;
                    }
                    itemDeleted = true;
                }
                if (newItem && SearchBar.this.isAttributeValid(selection)) {
                    values[j++] = selection;
                }
                if (itemDeleted || newItem) {
                    int i2;
                    for (i = 0; i < values.length; ++i) {
                        if (values[i] == null || ((String)values[i]).toString().length() != 0) continue;
                        values[i] = null;
                    }
                    Object[] trimmedArray = CBArray.trimNulls(values);
                    Object[] trimmedStrings = new String[trimmedArray.length];
                    searchAttribute.removeAllItems();
                    for (i2 = 0; i2 < trimmedArray.length; ++i2) {
                        trimmedStrings[i2] = trimmedArray[i2].toString();
                    }
                    Arrays.sort(trimmedStrings);
                    for (i2 = 0; i2 < trimmedArray.length; ++i2) {
                        searchAttribute.addItem(trimmedStrings[i2]);
                    }
                    CBUtility.writeStringArrayFile("quicksearch.txt", (String[])trimmedStrings);
                    searchAttribute.setSelectedItem(selection);
                }
            }
        });
    }

    public boolean isAttributeValid(String attr) {
        if (attr.indexOf(" ") > -1) {
            log.warning("The value '" + attr + "' in the Search Bar is not a valid attribute." + "  An attribute cannot contain a space in it's name, therefore this value will not be saved in the 'quicksearch.txt' property file.");
            return false;
        }
        return true;
    }
}

