/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractScriptEngineFactory
implements ScriptEngineFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<String> getScriptTypes() {
        ArrayList<String> scriptTypes = new ArrayList<String>();
        for (javax.script.ScriptEngineFactory f : ENGINE_MANAGER.getEngineFactories()) {
            scriptTypes.addAll(f.getExtensions());
            scriptTypes.addAll(f.getMimeTypes());
        }
        return Collections.unmodifiableList(scriptTypes);
    }

    @Override
    public void scopeValues(ScriptEngine scriptEngine, Map<String, Object> scopeValues) {
        for (Map.Entry<String, Object> entry : scopeValues.entrySet()) {
            scriptEngine.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public @Nullable ScriptEngine createScriptEngine(String scriptType) {
        ScriptEngine scriptEngine = ENGINE_MANAGER.getEngineByExtension(scriptType);
        if (scriptEngine == null) {
            scriptEngine = ENGINE_MANAGER.getEngineByMimeType(scriptType);
        }
        if (scriptEngine == null) {
            scriptEngine = ENGINE_MANAGER.getEngineByName(scriptType);
        }
        return scriptEngine;
    }
}

