/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.calendar;

import com.projectlibre1.configuration.Settings;
import com.projectlibre1.document.Document;
import com.projectlibre1.pm.calendar.DayDescriptor;
import com.projectlibre1.pm.calendar.HasCalendar;
import com.projectlibre1.pm.calendar.InvalidCalendarException;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.calendar.WorkRangeException;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.calendar.WorkingHours;
import com.projectlibre1.pm.time.HasStartAndEnd;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.timescale.CalendarUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CalendarService {
    private static CalendarService instance = null;
    ArrayList baseCalendars = new ArrayList();
    ArrayList derivedCalendars = new ArrayList();
    ArrayList assignmentCalendars = new ArrayList();
    private static final String PLACE_HOLDER_NAME = "____~";

    public static CalendarService getInstance() {
        if (instance == null) {
            instance = new CalendarService();
        }
        return instance;
    }

    public String getCalendarName(WorkingCalendar workingCalendar) {
        if (workingCalendar == null) {
            return "";
        }
        return workingCalendar.getName();
    }

    public WorkingCalendar getBaseCalendar(WorkingCalendar workingCalendar) {
        return (WorkingCalendar)workingCalendar.getBaseCalendar();
    }

    public DayDescriptor getDay(WorkingCalendar workingCalendar, long l) {
        return workingCalendar.getMonthDayDescriptor(l);
    }

    public DayDescriptor getDay(WorkingCalendar workingCalendar, Set set, boolean[] blArray) {
        DayDescriptor dayDescriptor;
        CalendarUtil.DayIterator dayIterator = new CalendarUtil.DayIterator();
        DayDescriptor dayDescriptor2 = null;
        for (int i = 0; i < 7; ++i) {
            if (!blArray[i] || (dayDescriptor2 = this.mergeWithCommon(dayDescriptor = workingCalendar.getWeekDayDescriptor(i + 1), dayDescriptor2)) != null) continue;
            return null;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            dayIterator.setInterval((HasStartAndEnd)iterator.next());
            while (dayIterator.hasMoreDays()) {
                dayDescriptor = workingCalendar.getMonthDayDescriptor(dayIterator.nextDay());
                dayDescriptor2 = this.mergeWithCommon(dayDescriptor, dayDescriptor2);
                if (dayDescriptor2 != null) continue;
                return null;
            }
        }
        return dayDescriptor2;
    }

    private DayDescriptor mergeWithCommon(DayDescriptor dayDescriptor, DayDescriptor dayDescriptor2) {
        if (dayDescriptor2 == null) {
            dayDescriptor2 = dayDescriptor;
            return dayDescriptor2;
        }
        if (dayDescriptor.isModified() != dayDescriptor2.isModified() || dayDescriptor.isWorking() != dayDescriptor2.isWorking()) {
            return null;
        }
        if (dayDescriptor.isModified() && dayDescriptor.isWorking()) {
            if (dayDescriptor.getWorkingHours() == null && dayDescriptor2.getWorkingHours() == null) {
                return null;
            }
            if (dayDescriptor.getWorkingHours() == null && dayDescriptor2.getWorkingHours() != null || dayDescriptor.getWorkingHours() != null && dayDescriptor2.getWorkingHours() == null) {
                return null;
            }
            List list = dayDescriptor.getWorkingHours().getIntervals();
            List list2 = dayDescriptor2.getWorkingHours().getIntervals();
            if (list2.size() != list.size()) {
                return null;
            }
            Iterator iterator = list2.iterator();
            Iterator iterator2 = list.iterator();
            while (iterator.hasNext()) {
                HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)iterator.next();
                HasStartAndEnd hasStartAndEnd2 = (HasStartAndEnd)iterator2.next();
                if (hasStartAndEnd2 == null && hasStartAndEnd == null) continue;
                if (hasStartAndEnd2 == null && hasStartAndEnd != null) {
                    return null;
                }
                if (hasStartAndEnd2 != null && hasStartAndEnd == null) {
                    return null;
                }
                if (hasStartAndEnd.getStart() == hasStartAndEnd2.getStart() && hasStartAndEnd.getEnd() == hasStartAndEnd2.getEnd()) continue;
                return null;
            }
        }
        return dayDescriptor2;
    }

    public DayDescriptor getWeekDay(WorkingCalendar workingCalendar, int n) {
        return workingCalendar.getWeekDayDescriptor(n);
    }

    public void makeDefaultDay(WorkingCalendar workingCalendar, long l) {
        workingCalendar.makeDefaultDay(l);
    }

    public void makeDefaultDays(WorkingCalendar workingCalendar, Set set, boolean[] blArray) {
        for (int i = 0; i < 7; ++i) {
            if (!blArray[i]) continue;
            this.makeDefaultWeekDay(workingCalendar, i + 1);
        }
        CalendarUtil.DayIterator dayIterator = new CalendarUtil.DayIterator();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            dayIterator.setInterval((HasStartAndEnd)iterator.next());
            while (dayIterator.hasMoreDays()) {
                workingCalendar.makeDefaultDay(dayIterator.nextDay());
            }
        }
    }

    public void makeDefaultWeekDay(WorkingCalendar workingCalendar, int n) {
        workingCalendar.makeDefaultWeekDay(n);
    }

    public void setDayWorkingHours(WorkingCalendar workingCalendar, long l, WorkingHours workingHours) throws WorkRangeException {
        if (workingHours.getDuration() == 0L) {
            this.setDayNonWorking(workingCalendar, l);
        } else {
            workingCalendar.setDayWorkingHours(l, workingHours);
        }
    }

    public void setDaysWorkingHours(WorkingCalendar workingCalendar, Set set, boolean[] blArray, WorkingHours workingHours) throws WorkRangeException, InvalidCalendarException {
        for (int i = 0; i < 7; ++i) {
            if (!blArray[i]) continue;
            this.setWeekDayWorkingHours(workingCalendar, i + 1, workingHours);
        }
        CalendarUtil.DayIterator dayIterator = new CalendarUtil.DayIterator();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            dayIterator.setInterval((HasStartAndEnd)iterator.next());
            while (dayIterator.hasMoreDays()) {
                workingCalendar.setDayWorkingHours(dayIterator.nextDay(), workingHours);
            }
        }
    }

    public void setWeekDayWorkingHours(WorkingCalendar workingCalendar, int n, WorkingHours workingHours) throws WorkRangeException, InvalidCalendarException {
        if (workingHours.getDuration() == 0L) {
            this.setWeekDayNonWorking(workingCalendar, n);
        } else {
            workingCalendar.setWeekDayWorkingHours(n, workingHours);
        }
    }

    public void setDayNonWorking(WorkingCalendar workingCalendar, long l) {
        workingCalendar.setDayNonWorking(l);
    }

    public void setDaysNonWorking(WorkingCalendar workingCalendar, Set set, boolean[] blArray) throws InvalidCalendarException {
        for (int i = 0; i < 7; ++i) {
            if (!blArray[i]) continue;
            this.setWeekDayNonWorking(workingCalendar, i + 1);
        }
        CalendarUtil.DayIterator dayIterator = new CalendarUtil.DayIterator();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            dayIterator.setInterval((HasStartAndEnd)iterator.next());
            while (dayIterator.hasMoreDays()) {
                workingCalendar.setDayNonWorking(dayIterator.nextDay());
            }
        }
    }

    public void setWeekDayNonWorking(WorkingCalendar workingCalendar, int n) throws InvalidCalendarException {
        int n2 = 0;
        for (int i = 0; i < 7; ++i) {
            if (this.getWeekDay(workingCalendar, i + 1).isWorking()) continue;
            ++n2;
        }
        if (n2 >= 6) {
            throw new InvalidCalendarException(Messages.getString("Message.errorCalendarMustHaveWorkingDay"));
        }
        workingCalendar.setWeekDayNonWorking(n);
    }

    public void assignCalendar(WorkingCalendar workingCalendar, WorkingCalendar workingCalendar2) {
        workingCalendar.assignFrom(workingCalendar2);
    }

    public WorkingCalendar makeScratchCopy(WorkingCalendar workingCalendar) {
        return workingCalendar.makeScratchCopy();
    }

    public String dump(WorkingCalendar workingCalendar) {
        return workingCalendar.dump();
    }

    public WorkingCalendar getStandardBasedInstance() {
        WorkingCalendar workingCalendar = WorkingCalendar.getStandardBasedInstance();
        this.add(workingCalendar);
        return workingCalendar;
    }

    public WorkingCalendar getStandardInstance() {
        WorkingCalendar workingCalendar = WorkingCalendar.getStandardInstance();
        return workingCalendar;
    }

    public WorkingCalendar getDefaultInstance() {
        WorkingCalendar workingCalendar = WorkingCalendar.getDefaultInstance();
        return workingCalendar;
    }

    public void saveAndUpdate(WorkingCalendar workingCalendar) {
        this.invalidate(workingCalendar);
    }

    public void invalidate(WorkingCalendar workingCalendar) {
        Iterator iterator = workingCalendar.getObjectsUsing().iterator();
        HashSet<Document> hashSet = new HashSet<Document>();
        while (iterator.hasNext()) {
            HasCalendar hasCalendar = (HasCalendar)iterator.next();
            hashSet.add(hasCalendar.invalidateCalendar());
        }
        for (Document document : hashSet) {
            document.fireUpdateEvent(this, document);
        }
    }

    public void add(WorkingCalendar workingCalendar) {
        if (workingCalendar.isBaseCalendar()) {
            if (!this.baseCalendars.contains(workingCalendar)) {
                boolean bl;
                boolean bl2 = bl = CalendarService.findBaseCalendar(workingCalendar.getName()) != null;
                if (bl) {
                    return;
                }
                this.baseCalendars.add(workingCalendar);
            }
        } else if (!this.baseCalendars.contains(workingCalendar)) {
            this.derivedCalendars.add(workingCalendar);
        }
    }

    public final ArrayList getBaseCalendars() {
        return this.baseCalendars;
    }

    public final ArrayList getDerivedCalendars() {
        return this.derivedCalendars;
    }

    public static final Object[] allBaseCalendars() {
        return CalendarService.getInstance().getBaseCalendars().toArray();
    }

    public static final WorkCalendar findBaseCalendar(String string) {
        return CalendarService.getInstance().findBaseCalendar(string, false);
    }

    public WorkCalendar findBaseCalendar(String object, boolean bl) {
        if (object == null) {
            return null;
        }
        bl = false;
        if (bl) {
            object = (String)object + PLACE_HOLDER_NAME;
        }
        for (WorkingCalendar workingCalendar : CalendarService.getInstance().getBaseCalendars()) {
            if (workingCalendar == null || workingCalendar.getName() == null || !workingCalendar.getName().equals(object)) continue;
            return workingCalendar;
        }
        return null;
    }

    public WorkCalendar findBaseCalendar(long l) {
        for (WorkingCalendar workingCalendar : CalendarService.getInstance().getBaseCalendars()) {
            if (workingCalendar.getUniqueId() != l) continue;
            return workingCalendar;
        }
        return null;
    }

    public void renameImportedBaseCalendars(String string) {
        for (WorkingCalendar workingCalendar : CalendarService.getInstance().getBaseCalendars()) {
            String string2 = workingCalendar.getName();
            int n = string2.indexOf(PLACE_HOLDER_NAME);
            if (n == -1) continue;
            string2 = CalendarService.toImportedName(string2.substring(0, n), string);
            workingCalendar.setName(string2);
        }
    }

    private static String toImportedName(String string, String string2) {
        return string + Settings.LEFT_BRACKET + string2 + Settings.RIGHT_BRACKET;
    }

    public void reassignCalendar(HasCalendar hasCalendar, WorkCalendar workCalendar, WorkCalendar workCalendar2) {
        if (workCalendar == workCalendar2) {
            return;
        }
        if (workCalendar != null && workCalendar instanceof WorkingCalendar) {
            ((WorkingCalendar)workCalendar).removeObjectUsing(hasCalendar);
        }
        if (workCalendar2 != null && workCalendar2 instanceof WorkingCalendar) {
            ((WorkingCalendar)workCalendar2).addObjectUsing(hasCalendar);
        }
    }
}

