/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.Node$;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.SetNode$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class HashCollisionSetNode<A>
extends SetNode<A> {
    private final int originalHash;
    private final int hash;
    private Vector<A> content;

    public HashCollisionSetNode(int originalHash, int hash, Vector<A> content) {
        this.originalHash = originalHash;
        this.hash = hash;
        this.content = content;
        Predef$.MODULE$.require(this.content().length() >= 2);
    }

    public int originalHash() {
        return this.originalHash;
    }

    public int hash() {
        return this.hash;
    }

    public Vector<A> content() {
        return this.content;
    }

    public void content_$eq(Vector<A> x$1) {
        this.content = x$1;
    }

    @Override
    public boolean contains(A element, int originalHash, int hash, int shift) {
        return this.hash() == hash && this.content().contains(element);
    }

    @Override
    public SetNode<A> updated(A element, int originalHash, int hash, int shift) {
        if (this.contains(element, originalHash, hash, shift)) {
            return this;
        }
        return new HashCollisionSetNode<A>(originalHash, hash, this.content().appended(element));
    }

    @Override
    public SetNode<A> removed(A element, int originalHash, int hash, int shift) {
        if (!this.contains(element, originalHash, hash, shift)) {
            return this;
        }
        Vector updatedContent = (Vector)this.content().filterNot((Function1<Object, Boolean> & Serializable)element0 -> BoxesRunTime.equals(element0, element));
        int n = updatedContent.size();
        if (1 == n) {
            return new BitmapIndexedSetNode(Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(hash, 0)), 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{updatedContent.apply(false)}), ClassTag$.MODULE$.Any()), new int[]{originalHash}, 1, hash);
        }
        return new HashCollisionSetNode<A>(originalHash, hash, updatedContent);
    }

    @Override
    public boolean hasNodes() {
        return false;
    }

    @Override
    public int nodeArity() {
        return 0;
    }

    @Override
    public SetNode<A> getNode(int index) {
        throw new IndexOutOfBoundsException("No sub-nodes present in hash-collision leaf node.");
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    @Override
    public int payloadArity() {
        return this.content().length();
    }

    @Override
    public A getPayload(int index) {
        return (A)this.content().apply(index);
    }

    @Override
    public int getHash(int index) {
        return this.originalHash();
    }

    @Override
    public int size() {
        return this.content().length();
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        Iterator<A> iter = this.content().iterator();
        while (iter.hasNext()) {
            f.apply(iter.next());
        }
    }

    @Override
    public int cachedJavaKeySetHashCode() {
        return this.size() * this.hash();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean subsetOf(SetNode<A> that, int shift) {
        HashCollisionSetNode hashCollisionSetNode;
        if (this == that) {
            return true;
        }
        SetNode<A> setNode = that;
        if (!(setNode instanceof HashCollisionSetNode)) return false;
        HashCollisionSetNode node = hashCollisionSetNode = (HashCollisionSetNode)setNode;
        if (this.payloadArity() > node.payloadArity()) return false;
        Vector vector = node.content();
        if (!this.content().forall((Function1<Object, Boolean> & Serializable)elem -> vector.contains(elem))) return false;
        return true;
    }

    @Override
    public SetNode<A> filterImpl(Function1<A, Object> pred, boolean flipped) {
        Object newContent = this.content().filterImpl((Function1)pred, flipped);
        int newContentLength = ((Vector)newContent).length();
        if (newContentLength == 0) {
            return SetNode$.MODULE$.empty();
        }
        if (newContentLength == 1) {
            return new BitmapIndexedSetNode(Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(this.hash(), 0)), 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{((Vector)newContent).head()}), ClassTag$.MODULE$.Any()), new int[]{this.originalHash()}, 1, this.hash());
        }
        if (((Vector)newContent).length() == this.content().length()) {
            return this;
        }
        return new HashCollisionSetNode<A>(this.originalHash(), this.hash(), newContent);
    }

    @Override
    public SetNode<A> diff(SetNode<A> that, int shift) {
        return this.filterImpl((Function1<Object, Boolean> & Serializable)_$1 -> that.contains(_$1, this.originalHash(), this.hash(), shift), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof HashCollisionSetNode)) return false;
        HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)object;
        HashCollisionSetNode node = hashCollisionSetNode;
        if (this == node) return true;
        if (this.hash() != node.hash()) return false;
        if (this.content().size() != node.content().size()) return false;
        Vector vector = node.content();
        if (!this.content().forall((Function1<Object, Boolean> & Serializable)elem -> vector.contains(elem))) return false;
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    @Override
    public HashCollisionSetNode<A> copy() {
        return new HashCollisionSetNode<A>(this.originalHash(), this.hash(), this.content());
    }

    @Override
    public SetNode<A> concat(SetNode<A> that, int shift) {
        SetNode<A> setNode = that;
        if (setNode instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)setNode;
            HashCollisionSetNode hc = hashCollisionSetNode;
            if (hc == this) {
                return this;
            }
            VectorBuilder newContent = null;
            Iterator<A> iter = hc.content().iterator();
            while (iter.hasNext()) {
                A nextPayload = iter.next();
                if (this.content().contains(nextPayload)) continue;
                if (newContent == null) {
                    newContent = new VectorBuilder();
                    newContent.addAll((IterableOnce)this.content());
                }
                newContent.addOne((Object)nextPayload);
            }
            if (newContent == null) {
                return this;
            }
            return new HashCollisionSetNode<A>(this.originalHash(), this.hash(), newContent.result());
        }
        if (setNode instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode;
            throw new UnsupportedOperationException("Cannot concatenate a HashCollisionSetNode with a BitmapIndexedSetNode");
        }
        throw new MatchError(setNode);
    }

    @Override
    public void foreachWithHash(Function2<A, Object, BoxedUnit> f) {
        Iterator<A> iter = this.content().iterator();
        while (iter.hasNext()) {
            A next = iter.next();
            f.apply(next, BoxesRunTime.boxToInteger(this.originalHash()));
        }
    }

    @Override
    public boolean foreachWithHashWhile(Function2<A, Object, Object> f) {
        boolean stillGoing = true;
        Iterator<A> iter = this.content().iterator();
        while (iter.hasNext() && stillGoing) {
            A next = iter.next();
            stillGoing = stillGoing && BoxesRunTime.unboxToBoolean(f.apply(next, BoxesRunTime.boxToInteger(this.originalHash())));
        }
        return stillGoing;
    }
}

