/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinderClassLoader
extends ClassLoader {
    private static final Map<String, Class<?>> PRIMITIVE_TYPES;
    private final ClassLoader adaptedClassLoader;

    public static BinderClassLoader createBinderClassLoader(final ClassLoader adaptedClassLoader) {
        PrivilegedAction<BinderClassLoader> action = new PrivilegedAction<BinderClassLoader>(){

            @Override
            public BinderClassLoader run() {
                return new BinderClassLoader(adaptedClassLoader);
            }
        };
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (BinderClassLoader)action.run();
    }

    private BinderClassLoader(ClassLoader adaptedClassLoader) {
        this.adaptedClassLoader = adaptedClassLoader;
    }

    public ClassLoader getAdaptedClassLoader() {
        return this.adaptedClassLoader;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (PRIMITIVE_TYPES.containsKey(name)) {
            return PRIMITIVE_TYPES.get(name);
        }
        return this.adaptedClassLoader.loadClass(name);
    }

    static {
        HashMap<String, Class<Comparable<Boolean>>> primitiveTypes = new HashMap<String, Class<Comparable<Boolean>>>();
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        PRIMITIVE_TYPES = Collections.unmodifiableMap(primitiveTypes);
    }
}

