/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;

@Deprecated(forRemoval=true, since="2.16.0")
public class RegexAutoTagScanner
extends PluginPassiveScanner {
    public static final String TAG_STATS_PREFIX = "stats.tag.";
    protected static final int PATTERN_SCAN = 2;
    private String name = null;
    private String requestUrlRegex = null;
    private String requestHeaderRegex = null;
    private String responseHeaderRegex = null;
    private String responseBodyRegex = null;
    private Pattern requestUrlPattern = null;
    private Pattern requestHeaderPattern = null;
    private Pattern responseHeaderPattern = null;
    private Pattern responseBodyPattern = null;
    private TYPE type = null;
    private String config = null;

    public RegexAutoTagScanner() {
    }

    public RegexAutoTagScanner(String name, TYPE type, String config) {
        this.name = name;
        this.type = type;
        this.config = config;
    }

    public RegexAutoTagScanner(String name, TYPE type, String config, String requestUrlregex, String requestHeaderRegex, String responseHeaderRegex, String responseBodyRegex, boolean enabled) {
        this.name = name;
        this.setRequestUrlRegex(requestUrlregex);
        this.setRequestHeaderRegex(requestHeaderRegex);
        this.setResponseHeaderRegex(responseHeaderRegex);
        this.setResponseBodyRegex(responseBodyRegex);
        this.type = type;
        this.config = config;
        this.setEnabled(enabled);
    }

    public RegexAutoTagScanner(RegexAutoTagScanner scanner) {
        this(scanner.name, scanner.type, scanner.config, scanner.requestUrlRegex, scanner.requestHeaderRegex, scanner.responseHeaderRegex, scanner.responseBodyRegex, scanner.isEnabled());
    }

    @Override
    public RegexAutoTagScanner copy() {
        return new RegexAutoTagScanner(this);
    }

    public Pattern getRequestUrlPattern() {
        return this.requestUrlPattern;
    }

    public Pattern getRequestHeaderPattern() {
        return this.requestHeaderPattern;
    }

    public Pattern getResponseHeaderPattern() {
        return this.responseHeaderPattern;
    }

    public Pattern getResponseBodyPattern() {
        return this.responseBodyPattern;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public String getConf() {
        return this.config;
    }

    public void setConf(String config) {
        this.config = config;
    }

    public String getRequestUrlRegex() {
        return this.requestUrlRegex;
    }

    public void setRequestUrlRegex(String requestUrlregex) {
        this.requestUrlRegex = requestUrlregex;
        this.requestUrlPattern = requestUrlregex == null || requestUrlregex.length() == 0 ? null : Pattern.compile(requestUrlregex, 2);
    }

    public String getRequestHeaderRegex() {
        return this.requestHeaderRegex;
    }

    public void setRequestHeaderRegex(String requestHeaderRegex) {
        this.requestHeaderRegex = requestHeaderRegex;
        this.requestHeaderPattern = requestHeaderRegex == null || requestHeaderRegex.length() == 0 ? null : Pattern.compile(requestHeaderRegex, 2);
    }

    public String getResponseHeaderRegex() {
        return this.responseHeaderRegex;
    }

    public void setResponseHeaderRegex(String responseHeaderRegex) {
        this.responseHeaderRegex = responseHeaderRegex;
        this.responseHeaderPattern = responseHeaderRegex == null || responseHeaderRegex.length() == 0 ? null : Pattern.compile(responseHeaderRegex, 2);
    }

    public String getResponseBodyRegex() {
        return this.responseBodyRegex;
    }

    public void setResponseBodyRegex(String responseBodyRegex) {
        this.responseBodyRegex = responseBodyRegex;
        this.responseBodyPattern = responseBodyRegex == null || responseBodyRegex.length() == 0 ? null : Pattern.compile(responseBodyRegex, 2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage msg, int id) {
        Matcher m;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getRequestHeaderPattern() != null && (m = this.getRequestHeaderPattern().matcher(msg.getRequestHeader().toString())).find()) {
            this.matched(m, msg, id);
            return;
        }
        if (this.getRequestUrlPattern() != null && (m = this.getRequestUrlPattern().matcher(msg.getRequestHeader().getURI().toString())).find()) {
            this.matched(m, msg, id);
            return;
        }
    }

    public Alert getAlert(HttpMessage msg) {
        return null;
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage msg, int id, Source source) {
        Matcher m;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getResponseHeaderPattern() != null && (m = this.getResponseHeaderPattern().matcher(msg.getResponseHeader().toString())).find()) {
            this.matched(m, msg, id);
            return;
        }
        if (this.getResponseBodyPattern() != null && (m = this.getResponseBodyPattern().matcher(msg.getResponseBody().toString())).find()) {
            this.matched(m, msg, id);
            return;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.requestHeaderRegex == null ? 0 : this.requestHeaderRegex.hashCode());
        result = 31 * result + (this.requestUrlRegex == null ? 0 : this.requestUrlRegex.hashCode());
        result = 31 * result + (this.responseBodyRegex == null ? 0 : this.responseBodyRegex.hashCode());
        result = 31 * result + (this.responseHeaderRegex == null ? 0 : this.responseHeaderRegex.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RegexAutoTagScanner other = (RegexAutoTagScanner)object;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.requestHeaderRegex == null ? other.requestHeaderRegex != null : !this.requestHeaderRegex.equals(other.requestHeaderRegex)) {
            return false;
        }
        if (this.requestUrlRegex == null ? other.requestUrlRegex != null : !this.requestUrlRegex.equals(other.requestUrlRegex)) {
            return false;
        }
        if (this.responseBodyRegex == null ? other.responseBodyRegex != null : !this.responseBodyRegex.equals(other.responseBodyRegex)) {
            return false;
        }
        if (this.responseHeaderRegex == null ? other.responseHeaderRegex != null : !this.responseHeaderRegex.equals(other.responseHeaderRegex)) {
            return false;
        }
        return this.type == other.type;
    }

    private void matched(Matcher matcher, HttpMessage msg, int id) {
        String tag = this.getConf();
        if (this.tagHistoryType(msg.getHistoryRef().getHistoryType())) {
            if (matcher.groupCount() > 0) {
                tag = matcher.pattern().matcher(matcher.group()).replaceFirst(tag);
            }
            this.addHistoryTag(tag);
        }
        try {
            Stats.incCounter(SessionStructure.getHostName(msg), TAG_STATS_PREFIX + this.getConf());
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    private boolean tagHistoryType(int historyType) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(historyType);
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        return true;
    }

    public static enum TYPE {
        ALERT,
        TAG,
        TECH;

    }
}

