/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
implements Parser {
    private SAXParserFactory spf;
    private RSyntaxTextArea textArea;
    private ArrayList noticeList = new ArrayList(1);

    public XMLParser(RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
    }

    public Iterator getNoticeIterator() {
        return this.noticeList.iterator();
    }

    public void parse(Reader reader) {
        this.noticeList.clear();
        if (this.spf == null) {
            return;
        }
        try {
            SAXParser sAXParser = this.spf.newSAXParser();
            Handler handler = new Handler();
            InputSource inputSource = new InputSource(reader);
            sAXParser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.noticeList.add(new ParserNotice("Error parsing XML: " + exception.getMessage(), -1, -1));
        }
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        private void doError(SAXParseException sAXParseException) {
            int n = sAXParseException.getLineNumber() - 1;
            try {
                int n2 = XMLParser.this.textArea.getLineStartOffset(n);
                int n3 = XMLParser.this.textArea.getLineEndOffset(n) - n2 + 1;
                ParserNotice parserNotice = new ParserNotice(sAXParseException.getMessage(), n2, n3, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
                XMLParser.this.noticeList.add(parserNotice);
                System.err.println(">>> " + n2 + "-" + n3 + " -> " + parserNotice);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.doError(sAXParseException);
        }
    }
}

