/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.search.SearchTerm;

public abstract class StringTerm
extends SearchTerm {
    protected String pattern;
    protected boolean ignoreCase;

    public int hashCode() {
        return this.ignoreCase ? this.pattern.hashCode() : ~this.pattern.hashCode();
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringTerm)) {
            return false;
        }
        StringTerm st = (StringTerm)obj;
        if (this.ignoreCase) {
            return st.pattern.equalsIgnoreCase(this.pattern) && st.ignoreCase == this.ignoreCase;
        }
        return st.pattern.equals(this.pattern) && st.ignoreCase == this.ignoreCase;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected StringTerm(String pattern) {
        this.pattern = pattern;
        this.ignoreCase = true;
    }

    protected boolean match(String s) {
        int len = s.length() - this.pattern.length();
        for (int i = 0; i <= len; ++i) {
            if (!s.regionMatches(this.ignoreCase, i, this.pattern, 0, this.pattern.length())) continue;
            return true;
        }
        return false;
    }

    protected StringTerm(String pattern, boolean ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }
}

