/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import javax.annotation.Nullable;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelAction;
import org.gradle.internal.buildtree.BuildTreeModelController;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.PhasedActionResult;
import org.gradle.tooling.internal.provider.runner.BuildControllerFactory;
import org.gradle.tooling.internal.provider.runner.DefaultBuildController;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public abstract class AbstractClientProvidedBuildActionRunner
implements BuildActionRunner {
    private final BuildControllerFactory buildControllerFactory;
    private final PayloadSerializer payloadSerializer;

    public AbstractClientProvidedBuildActionRunner(BuildControllerFactory buildControllerFactory, PayloadSerializer payloadSerializer) {
        this.buildControllerFactory = buildControllerFactory;
        this.payloadSerializer = payloadSerializer;
    }

    protected BuildActionRunner.Result runClientAction(ClientAction action, BuildTreeLifecycleController buildController) {
        ActionAdapter adapter = new ActionAdapter(action, this.payloadSerializer);
        try {
            SerializedPayload result = (SerializedPayload)buildController.fromBuildModel(action.isRunTasks(), (BuildTreeModelAction)adapter);
            return BuildActionRunner.Result.of((Object)result);
        }
        catch (RuntimeException e) {
            RuntimeException clientFailure = e;
            if (adapter.actionFailure != null) {
                clientFailure = new InternalBuildActionFailureException((Throwable)adapter.actionFailure);
            }
            return BuildActionRunner.Result.failed((Throwable)e, (RuntimeException)clientFailure);
        }
    }

    private class ActionAdapter
    implements BuildTreeModelAction<SerializedPayload> {
        private final ClientAction clientAction;
        private final PayloadSerializer payloadSerializer;
        RuntimeException actionFailure;

        ActionAdapter(ClientAction clientAction, PayloadSerializer payloadSerializer) {
            this.clientAction = clientAction;
            this.payloadSerializer = payloadSerializer;
        }

        public void beforeTasks(BuildTreeModelController controller) {
            this.runAction(controller, this.clientAction.getProjectsEvaluatedAction(), PhasedActionResult.Phase.PROJECTS_LOADED);
        }

        public SerializedPayload fromBuildModel(BuildTreeModelController controller) {
            this.runAction(controller, this.clientAction.getBuildFinishedAction(), PhasedActionResult.Phase.BUILD_FINISHED);
            return this.clientAction.getResult();
        }

        private void runAction(BuildTreeModelController controller, @Nullable Object action, PhasedActionResult.Phase phase) {
            if (action == null || this.actionFailure != null) {
                return;
            }
            DefaultBuildController internalBuildController = AbstractClientProvidedBuildActionRunner.this.buildControllerFactory.controllerFor(controller);
            try {
                Object result = this.executeAction(action, internalBuildController);
                SerializedPayload serializedResult = this.payloadSerializer.serialize(result);
                this.clientAction.collectActionResult(serializedResult, phase);
            }
            catch (RuntimeException e) {
                this.actionFailure = e;
                throw e;
            }
        }

        private Object executeAction(Object action, DefaultBuildController internalBuildController) {
            if (action instanceof InternalBuildActionVersion2) {
                return ((InternalBuildActionVersion2)action).execute((InternalBuildControllerVersion2)internalBuildController);
            }
            return ((InternalBuildAction)action).execute((InternalBuildController)internalBuildController);
        }
    }

    protected static interface ClientAction {
        @Nullable
        public Object getProjectsEvaluatedAction();

        @Nullable
        public Object getBuildFinishedAction();

        public void collectActionResult(SerializedPayload var1, PhasedActionResult.Phase var2);

        @Nullable
        public SerializedPayload getResult();

        public boolean isRunTasks();
    }
}

