/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtilRt {
    private static final String WINDOWS_INVALID_CHARS = "<>:\"|?*";
    private static final Set<String> WINDOWS_RESERVED_NAMES = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
    private static final Charset FS_CHARSET = PathUtilRt.fsCharset();

    private PathUtilRt() {
    }

    @NotNull
    public static String getFileName(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        int end = PathUtilRt.lastNonSeparatorIndex(path);
        int start = PathUtilRt.lastSeparatorIndex(path, end);
        if (PathUtilRt.isWindowsUNCRoot(path, start)) {
            start = -1;
        }
        String string = path.substring(start + 1, end + 1);
        if (string == null) {
            PathUtilRt.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable(value="null means no extension (e.g. 'xxx'), empty string means empty extension (e.g. 'xxx.')")
    public static @Nullable(value="null means no extension (e.g. 'xxx'), empty string means empty extension (e.g. 'xxx.')") String getFileExtension(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        int end = PathUtilRt.lastNonSeparatorIndex(path);
        if (end == -1) {
            return null;
        }
        int start = PathUtilRt.lastSeparatorIndex(path, end) + 1;
        int index = StringUtilRt.lastIndexOf(path, '.', Math.max(start, 0), end + 1);
        return index < 0 ? null : path.substring(index + 1, end + 1);
    }

    private static int lastNonSeparatorIndex(@NotNull String path) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(1);
        }
        for (int index = path.length() - 1; index >= 0; --index) {
            char c = path.charAt(index);
            if (PathUtilRt.isSeparator(c)) continue;
            return index;
        }
        return -1;
    }

    @NotNull
    public static String getParentPath(@NotNull String path) {
        int end;
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(2);
        }
        String string = (end = PathUtilRt.getParentPathEndOffset(path)) == 0 ? "" : path.substring(0, end);
        if (string == null) {
            PathUtilRt.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static CharSequence getParentPathSequence(@NotNull CharSequence path) {
        int end;
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(4);
        }
        CharSequence charSequence = (end = PathUtilRt.getParentPathEndOffset(path)) == 0 ? "" : path.subSequence(0, end);
        if (charSequence == null) {
            PathUtilRt.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    private static int getParentPathEndOffset(@NotNull CharSequence path) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(6);
        }
        if (path.length() == 0) {
            return 0;
        }
        int end = PathUtilRt.lastSeparatorIndex(path, path.length() - 1);
        if (end == path.length() - 1 && end >= 1) {
            end = PathUtilRt.lastSeparatorIndex(path, end - 1);
        }
        if (end == -1 || end == 0) {
            return 0;
        }
        if (PathUtilRt.isWindowsUNCRoot(path, end)) {
            return 0;
        }
        char prev = path.charAt(end - 1);
        if (PathUtilRt.isSeparator(prev)) {
            --end;
        }
        return end;
    }

    public static boolean isWindowsUNCRoot(@NotNull CharSequence path, int lastPathSeparatorPosition) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(7);
        }
        return Platform.CURRENT == Platform.WINDOWS && PathUtilRt.startsWithSeparatorSeparator(path) && lastPathSeparatorPosition >= 1 && !PathUtilRt.hasFileSeparatorsOrNavigatableDots(path, 2, lastPathSeparatorPosition);
    }

    private static boolean hasFileSeparatorsOrNavigatableDots(@NotNull CharSequence path, int start, int end) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(8);
        }
        for (int i = end - 1; i >= start; --i) {
            char c = path.charAt(i);
            if (PathUtilRt.isSeparator(c)) {
                return true;
            }
            if (c != '.' || i != 2 && (i != 3 || path.charAt(2) != '.')) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text) {
        if (text == null) {
            PathUtilRt.$$$reportNull$$$0(9);
        }
        return PathUtilRt.suggestFileName(text, false, false);
    }

    @NotNull
    public static String suggestFileName(@NotNull String text, boolean allowDots, boolean allowSpaces) {
        if (text == null) {
            PathUtilRt.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!PathUtilRt.isValidFileNameChar(c, Platform.CURRENT, true) || !allowDots && c == '.' || !allowSpaces && Character.isWhitespace(c)) {
                result.append('_');
                continue;
            }
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            PathUtilRt.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static boolean isValidFileName(@NotNull String fileName, boolean strict) {
        if (fileName == null) {
            PathUtilRt.$$$reportNull$$$0(12);
        }
        return PathUtilRt.isValidFileName(fileName, Platform.CURRENT, strict, FS_CHARSET);
    }

    public static boolean startsWithSeparatorSeparator(@NotNull CharSequence path) {
        if (path == null) {
            PathUtilRt.$$$reportNull$$$0(13);
        }
        return path.length() > 1 && PathUtilRt.isSeparator(path.charAt(0)) && path.charAt(1) == path.charAt(0);
    }

    public static boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    public static int lastSeparatorIndex(@NotNull CharSequence s, int endInclusive) {
        if (s == null) {
            PathUtilRt.$$$reportNull$$$0(14);
        }
        for (int i = endInclusive; i >= 0; --i) {
            if (!PathUtilRt.isSeparator(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidFileName(@NotNull String name, @NotNull Platform os, boolean strict, @Nullable Charset cs) {
        if (name == null) {
            PathUtilRt.$$$reportNull$$$0(15);
        }
        if (os == null) {
            PathUtilRt.$$$reportNull$$$0(16);
        }
        if (name.isEmpty() || name.equals(".") || name.equals("..")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (PathUtilRt.isValidFileNameChar(name.charAt(i), os, strict)) continue;
            return false;
        }
        if (os == Platform.WINDOWS && name.length() >= 3 && name.length() <= 4 && WINDOWS_RESERVED_NAMES.contains(name.toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        return cs == null || cs.canEncode() && cs.newEncoder().canEncode(name);
    }

    private static boolean isValidFileNameChar(char c, Platform os, boolean strict) {
        if (PathUtilRt.isSeparator(c)) {
            return false;
        }
        if (!(!strict && os != Platform.WINDOWS || c >= ' ' && WINDOWS_INVALID_CHARS.indexOf(c) < 0)) {
            return false;
        }
        return !strict || c != ';';
    }

    private static Charset fsCharset() {
        String property;
        if (!SystemInfoRt.isWindows && !SystemInfoRt.isMac && (property = System.getProperty("sun.jnu.encoding")) != null) {
            try {
                return Charset.forName(property);
            }
            catch (Exception e) {
                LoggerRt.getInstance(PathUtilRt.class).warn("unknown JNU charset: " + property, e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathUtilRt";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathUtilRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPathSequence";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "lastNonSeparatorIndex";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParentPathSequence";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentPathEndOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsUNCRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasFileSeparatorsOrNavigatableDots";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "startsWithSeparatorSeparator";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lastSeparatorIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Platform {
        UNIX,
        WINDOWS;

        public static final Platform CURRENT;

        static {
            CURRENT = SystemInfoRt.isWindows ? WINDOWS : UNIX;
        }
    }
}

