/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.http.simple;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.keycloak.connections.httpclient.SafeInputStream;

public class SimpleHttpResponse
implements AutoCloseable {
    private final HttpResponse response;
    private final long maxConsumedResponseSize;
    private final ObjectMapper objectMapper;
    private int statusCode = -1;
    private String responseString;
    private ContentType contentType;

    public SimpleHttpResponse(HttpResponse response, long maxConsumedResponseSize, ObjectMapper objectMapper) {
        this.response = response;
        this.maxConsumedResponseSize = maxConsumedResponseSize;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readResponse() throws IOException {
        if (this.statusCode == -1) {
            this.statusCode = this.response.getStatusLine().getStatusCode();
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                InputStream is = entity.getContent();
                this.contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = this.contentType.getCharset();
                try {
                    HeaderIterator it = this.response.headerIterator();
                    while (it.hasNext()) {
                        Header header = it.nextHeader();
                        if (!header.getName().equals("Content-Encoding") || !header.getValue().equals("gzip")) continue;
                        is = new GZIPInputStream(is);
                    }
                    is = new SafeInputStream(is, this.maxConsumedResponseSize);
                    try (InputStreamReader reader = charset == null ? new InputStreamReader(is, StandardCharsets.UTF_8) : new InputStreamReader(is, charset);){
                        StringWriter writer = new StringWriter();
                        char[] buffer = new char[4096];
                        int n = reader.read(buffer);
                        while (n != -1) {
                            writer.write(buffer, 0, n);
                            n = reader.read(buffer);
                        }
                        this.responseString = writer.toString();
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
    }

    public int getStatus() throws IOException {
        this.readResponse();
        return this.response.getStatusLine().getStatusCode();
    }

    public JsonNode asJson() throws IOException {
        return this.objectMapper.readTree(this.asString());
    }

    public <T> T asJson(Class<T> type) throws IOException {
        return (T)this.objectMapper.readValue(this.asString(), type);
    }

    public <T> T asJson(TypeReference<T> type) throws IOException {
        return (T)this.objectMapper.readValue(this.asString(), type);
    }

    public String asString() throws IOException {
        this.readResponse();
        return this.responseString;
    }

    public String getFirstHeader(String name) throws IOException {
        this.readResponse();
        Header[] headers = this.response.getHeaders(name);
        if (headers != null && headers.length > 0) {
            return headers[0].getValue();
        }
        return null;
    }

    public List<String> getHeader(String name) throws IOException {
        this.readResponse();
        Header[] headers = this.response.getHeaders(name);
        if (headers != null && headers.length > 0) {
            return Stream.of(headers).map(NameValuePair::getValue).collect(Collectors.toList());
        }
        return null;
    }

    public Header[] getAllHeaders() throws IOException {
        this.readResponse();
        return this.response.getAllHeaders();
    }

    public ContentType getContentType() throws IOException {
        this.readResponse();
        return this.contentType;
    }

    public Charset getContentTypeCharset() throws IOException {
        Charset charset;
        this.readResponse();
        if (this.contentType != null && (charset = this.contentType.getCharset()) != null) {
            return charset;
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    public void close() throws IOException {
        this.readResponse();
    }
}

