/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrApplicationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int APPLICATIONNAME;
    public static final int APPLICATIONVERSION;
    public static final int ENGINENAME;
    public static final int ENGINEVERSION;
    public static final int APIVERSION;

    public XrApplicationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrApplicationInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
    public ByteBuffer applicationName() {
        return XrApplicationInfo.napplicationName(this.address());
    }

    @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
    public String applicationNameString() {
        return XrApplicationInfo.napplicationNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int applicationVersion() {
        return XrApplicationInfo.napplicationVersion(this.address());
    }

    @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
    public ByteBuffer engineName() {
        return XrApplicationInfo.nengineName(this.address());
    }

    @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
    public String engineNameString() {
        return XrApplicationInfo.nengineNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int engineVersion() {
        return XrApplicationInfo.nengineVersion(this.address());
    }

    @NativeType(value="XrVersion")
    public long apiVersion() {
        return XrApplicationInfo.napiVersion(this.address());
    }

    public XrApplicationInfo applicationName(@NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]") ByteBuffer value) {
        XrApplicationInfo.napplicationName(this.address(), value);
        return this;
    }

    public XrApplicationInfo applicationVersion(@NativeType(value="uint32_t") int value) {
        XrApplicationInfo.napplicationVersion(this.address(), value);
        return this;
    }

    public XrApplicationInfo engineName(@NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]") ByteBuffer value) {
        XrApplicationInfo.nengineName(this.address(), value);
        return this;
    }

    public XrApplicationInfo engineVersion(@NativeType(value="uint32_t") int value) {
        XrApplicationInfo.nengineVersion(this.address(), value);
        return this;
    }

    public XrApplicationInfo apiVersion(@NativeType(value="XrVersion") long value) {
        XrApplicationInfo.napiVersion(this.address(), value);
        return this;
    }

    public XrApplicationInfo set(ByteBuffer applicationName, int applicationVersion, ByteBuffer engineName, int engineVersion, long apiVersion) {
        this.applicationName(applicationName);
        this.applicationVersion(applicationVersion);
        this.engineName(engineName);
        this.engineVersion(engineVersion);
        this.apiVersion(apiVersion);
        return this;
    }

    public XrApplicationInfo set(XrApplicationInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrApplicationInfo malloc() {
        return (XrApplicationInfo)XrApplicationInfo.wrap(XrApplicationInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrApplicationInfo calloc() {
        return (XrApplicationInfo)XrApplicationInfo.wrap(XrApplicationInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrApplicationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrApplicationInfo)XrApplicationInfo.wrap(XrApplicationInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrApplicationInfo create(long address) {
        return (XrApplicationInfo)XrApplicationInfo.wrap(XrApplicationInfo.class, (long)address);
    }

    @Nullable
    public static XrApplicationInfo createSafe(long address) {
        return address == 0L ? null : (XrApplicationInfo)XrApplicationInfo.wrap(XrApplicationInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrApplicationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrApplicationInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrApplicationInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrApplicationInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrApplicationInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrApplicationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrApplicationInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrApplicationInfo malloc(MemoryStack stack) {
        return (XrApplicationInfo)XrApplicationInfo.wrap(XrApplicationInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrApplicationInfo calloc(MemoryStack stack) {
        return (XrApplicationInfo)XrApplicationInfo.wrap(XrApplicationInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrApplicationInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrApplicationInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer napplicationName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)APPLICATIONNAME), (int)128);
    }

    public static String napplicationNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)APPLICATIONNAME));
    }

    public static int napplicationVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)APPLICATIONVERSION);
    }

    public static ByteBuffer nengineName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)ENGINENAME), (int)128);
    }

    public static String nengineNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)ENGINENAME));
    }

    public static int nengineVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENGINEVERSION);
    }

    public static long napiVersion(long struct) {
        return UNSAFE.getLong(null, struct + (long)APIVERSION);
    }

    public static void napplicationName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)128);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)APPLICATIONNAME), (long)value.remaining());
    }

    public static void napplicationVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)APPLICATIONVERSION, value);
    }

    public static void nengineName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)128);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)ENGINENAME), (long)value.remaining());
    }

    public static void nengineVersion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENGINEVERSION, value);
    }

    public static void napiVersion(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)APIVERSION, value);
    }

    static {
        Struct.Layout layout = XrApplicationInfo.__struct((Struct.Member[])new Struct.Member[]{XrApplicationInfo.__array((int)1, (int)128), XrApplicationInfo.__member((int)4), XrApplicationInfo.__array((int)1, (int)128), XrApplicationInfo.__member((int)4), XrApplicationInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        APPLICATIONNAME = layout.offsetof(0);
        APPLICATIONVERSION = layout.offsetof(1);
        ENGINENAME = layout.offsetof(2);
        ENGINEVERSION = layout.offsetof(3);
        APIVERSION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrApplicationInfo, Buffer>
    implements NativeResource {
        private static final XrApplicationInfo ELEMENT_FACTORY = XrApplicationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrApplicationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
        public ByteBuffer applicationName() {
            return XrApplicationInfo.napplicationName(this.address());
        }

        @NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]")
        public String applicationNameString() {
            return XrApplicationInfo.napplicationNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int applicationVersion() {
            return XrApplicationInfo.napplicationVersion(this.address());
        }

        @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
        public ByteBuffer engineName() {
            return XrApplicationInfo.nengineName(this.address());
        }

        @NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]")
        public String engineNameString() {
            return XrApplicationInfo.nengineNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int engineVersion() {
            return XrApplicationInfo.nengineVersion(this.address());
        }

        @NativeType(value="XrVersion")
        public long apiVersion() {
            return XrApplicationInfo.napiVersion(this.address());
        }

        public Buffer applicationName(@NativeType(value="char[XR_MAX_APPLICATION_NAME_SIZE]") ByteBuffer value) {
            XrApplicationInfo.napplicationName(this.address(), value);
            return this;
        }

        public Buffer applicationVersion(@NativeType(value="uint32_t") int value) {
            XrApplicationInfo.napplicationVersion(this.address(), value);
            return this;
        }

        public Buffer engineName(@NativeType(value="char[XR_MAX_ENGINE_NAME_SIZE]") ByteBuffer value) {
            XrApplicationInfo.nengineName(this.address(), value);
            return this;
        }

        public Buffer engineVersion(@NativeType(value="uint32_t") int value) {
            XrApplicationInfo.nengineVersion(this.address(), value);
            return this;
        }

        public Buffer apiVersion(@NativeType(value="XrVersion") long value) {
            XrApplicationInfo.napiVersion(this.address(), value);
            return this;
        }
    }
}

