/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import javax.annotation.Nullable;
import org.lwjgl.bgfx.BGFX;
import org.lwjgl.bgfx.BGFXInternalData;
import org.lwjgl.bgfx.BGFXPlatformData;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.NativeType;

public class BGFXPlatform {
    public static final int BGFX_RENDER_FRAME_NO_CONTEXT = 0;
    public static final int BGFX_RENDER_FRAME_RENDER = 1;
    public static final int BGFX_RENDER_FRAME_TIMEOUT = 2;
    public static final int BGFX_RENDER_FRAME_EXITING = 3;
    public static final int BGFX_RENDER_FRAME_COUNT = 4;

    protected BGFXPlatform() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="bgfx_renderer_frame_t")
    public static int bgfx_render_frame(@NativeType(value="int32_t") int _msecs) {
        long __functionAddress = Functions.render_frame;
        return JNI.invokeI((int)_msecs, (long)__functionAddress);
    }

    public static void nbgfx_set_platform_data(long _data) {
        long __functionAddress = Functions.set_platform_data;
        JNI.invokePV((long)_data, (long)__functionAddress);
    }

    public static void bgfx_set_platform_data(@NativeType(value="bgfx_platform_data_t const *") BGFXPlatformData _data) {
        BGFXPlatform.nbgfx_set_platform_data(_data.address());
    }

    public static long nbgfx_get_internal_data() {
        long __functionAddress = Functions.get_internal_data;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="bgfx_internal_data_t const *")
    public static BGFXInternalData bgfx_get_internal_data() {
        long __result = BGFXPlatform.nbgfx_get_internal_data();
        return BGFXInternalData.createSafe(__result);
    }

    @NativeType(value="uintptr_t")
    public static long bgfx_override_internal_texture_ptr(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uintptr_t") long _ptr) {
        long __functionAddress = Functions.override_internal_texture_ptr;
        return JNI.invokePP((short)_handle, (long)_ptr, (long)__functionAddress);
    }

    public static long nbgfx_override_internal_texture(short _handle, short _width, short _height, byte _numMips, int _format, long _flags) {
        long __functionAddress = Functions.override_internal_texture;
        return JNI.invokeJP((short)_handle, (short)_width, (short)_height, (byte)_numMips, (int)_format, (long)_flags, (long)__functionAddress);
    }

    @NativeType(value="uintptr_t")
    public static long bgfx_override_internal_texture(@NativeType(value="bgfx_texture_handle_t") short _handle, @NativeType(value="uint16_t") int _width, @NativeType(value="uint16_t") int _height, @NativeType(value="uint8_t") int _numMips, @NativeType(value="bgfx_texture_format_t") int _format, @NativeType(value="uint64_t") long _flags) {
        return BGFXPlatform.nbgfx_override_internal_texture(_handle, (short)_width, (short)_height, (byte)_numMips, _format, _flags);
    }

    public static final class Functions {
        public static final long render_frame = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"bgfx_render_frame");
        public static final long set_platform_data = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"bgfx_set_platform_data");
        public static final long get_internal_data = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"bgfx_get_internal_data");
        public static final long override_internal_texture_ptr = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"bgfx_override_internal_texture_ptr");
        public static final long override_internal_texture = APIUtil.apiGetFunctionAddress((FunctionProvider)BGFX.getLibrary(), (String)"bgfx_override_internal_texture");

        private Functions() {
        }
    }
}

