/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.item;

import com.google.gson.JsonObject;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangedRunnableListener;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.io.rest.DTOMapper;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTConstants;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.core.internal.item.MetadataSelectorMatcher;
import org.openhab.core.io.rest.core.item.EnrichedGroupItemDTO;
import org.openhab.core.io.rest.core.item.EnrichedItemDTO;
import org.openhab.core.io.rest.core.item.EnrichedItemDTOMapper;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemBuilderFactory;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ManagedItemProvider;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.items.dto.GroupItemDTO;
import org.openhab.core.items.dto.ItemDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.items.dto.MetadataDTO;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.library.items.RollershutterItem;
import org.openhab.core.library.items.SwitchItem;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.RawType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.semantics.SemanticTagRegistry;
import org.openhab.core.semantics.SemanticsPredicates;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
@Tag(name="items")
@Component
@JaxrsResource
@JaxrsName(value="items")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ItemResource
implements RESTResource {
    public static final String PATH_ITEMS = "items";
    private final Logger logger = LoggerFactory.getLogger(ItemResource.class);
    private final DTOMapper dtoMapper;
    private final EventPublisher eventPublisher;
    private final ItemBuilderFactory itemBuilderFactory;
    private final ItemRegistry itemRegistry;
    private final LocaleService localeService;
    private final ManagedItemProvider managedItemProvider;
    private final MetadataRegistry metadataRegistry;
    private final MetadataSelectorMatcher metadataSelectorMatcher;
    private final SemanticTagRegistry semanticTagRegistry;
    private final TimeZoneProvider timeZoneProvider;
    private final RegistryChangedRunnableListener<Item> resetLastModifiedItemChangeListener = new RegistryChangedRunnableListener(() -> {
        Date date = this.lastModified = null;
    });
    private final RegistryChangedRunnableListener<Metadata> resetLastModifiedMetadataChangeListener = new RegistryChangedRunnableListener(() -> {
        Date date = this.lastModified = null;
    });
    private @Nullable Date lastModified = null;

    private static void respectForwarded(UriBuilder uriBuilder, @Context HttpHeaders httpHeaders) {
        Optional.ofNullable(httpHeaders.getHeaderString("X-Forwarded-Host")).ifPresent(host -> {
            int pos1 = host.indexOf("[");
            int pos2 = host.indexOf("]");
            String hostWithIpv6 = pos1 >= 0 && pos2 > pos1 ? host.substring(pos1, pos2 + 1) : null;
            String[] parts = hostWithIpv6 == null ? host.split(":") : host.substring(pos2 + 1).split(":");
            uriBuilder.host(hostWithIpv6 != null ? hostWithIpv6 : parts[0]);
            if (parts.length > 1) {
                uriBuilder.port(Integer.parseInt(parts[1]));
            }
        });
        Optional.ofNullable(httpHeaders.getHeaderString("X-Forwarded-Proto")).ifPresent(arg_0 -> ((UriBuilder)uriBuilder).scheme(arg_0));
    }

    @Activate
    public ItemResource(@Reference DTOMapper dtoMapper, @Reference EventPublisher eventPublisher, @Reference ItemBuilderFactory itemBuilderFactory, @Reference ItemRegistry itemRegistry, @Reference LocaleService localeService, @Reference ManagedItemProvider managedItemProvider, @Reference MetadataRegistry metadataRegistry, @Reference MetadataSelectorMatcher metadataSelectorMatcher, @Reference SemanticTagRegistry semanticTagRegistry, @Reference TimeZoneProvider timeZoneProvider) {
        this.dtoMapper = dtoMapper;
        this.eventPublisher = eventPublisher;
        this.itemBuilderFactory = itemBuilderFactory;
        this.itemRegistry = itemRegistry;
        this.localeService = localeService;
        this.managedItemProvider = managedItemProvider;
        this.metadataRegistry = metadataRegistry;
        this.metadataSelectorMatcher = metadataSelectorMatcher;
        this.semanticTagRegistry = semanticTagRegistry;
        this.timeZoneProvider = timeZoneProvider;
        this.itemRegistry.addRegistryChangeListener(this.resetLastModifiedItemChangeListener);
        this.metadataRegistry.addRegistryChangeListener(this.resetLastModifiedMetadataChangeListener);
    }

    @Deactivate
    void deactivate() {
        this.itemRegistry.removeRegistryChangeListener(this.resetLastModifiedItemChangeListener);
        this.metadataRegistry.removeRegistryChangeListener(this.resetLastModifiedMetadataChangeListener);
    }

    private UriBuilder uriBuilder(UriInfo uriInfo, HttpHeaders httpHeaders) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(PATH_ITEMS).path("{itemName}");
        ItemResource.respectForwarded(uriBuilder, httpHeaders);
        return uriBuilder;
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Produces(value={"application/json"})
    @Operation(operationId="getItems", summary="Get all available items.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EnrichedItemDTO.class)))})})
    public Response getItems(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @Context Request request, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="type") @Parameter(description="item type filter") @Nullable String type, @QueryParam(value="tags") @Parameter(description="item tag filter") @Nullable String tags, @DefaultValue(value=".*") @QueryParam(value="metadata") @Parameter(description="metadata selector - a comma separated list or a regular expression (returns all if no value given)") @Nullable String namespaceSelector, @DefaultValue(value="false") @QueryParam(value="recursive") @Parameter(description="get member items recursively") boolean recursive, @QueryParam(value="fields") @Parameter(description="limit output to the given fields (comma separated)") @Nullable String fields, @DefaultValue(value="false") @QueryParam(value="staticDataOnly") @Parameter(description="provides a cacheable list of values not expected to change regularly and checks the If-Modified-Since header, all other parameters are ignored except \"metadata\"") boolean staticDataOnly) {
        Locale locale = this.localeService.getLocale(language);
        ZoneId zoneId = this.timeZoneProvider.getTimeZone();
        Set<String> namespaces = this.splitAndFilterNamespaces(namespaceSelector, locale);
        UriBuilder uriBuilder = this.uriBuilder(uriInfo, httpHeaders);
        if (staticDataOnly) {
            if (this.lastModified != null) {
                Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(this.lastModified);
                if (responseBuilder != null) {
                    return responseBuilder.build();
                }
            } else {
                this.lastModified = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
            }
            Stream itemStream = this.getItems(type, tags).stream().map(item -> EnrichedItemDTOMapper.map(item, false, null, uriBuilder, locale, zoneId)).peek(dto -> this.addMetadata((EnrichedItemDTO)((Object)dto), namespaces, null)).peek(dto -> {
                Boolean bl = dto.editable = Boolean.valueOf(this.isEditable(dto.name));
            });
            itemStream = this.dtoMapper.limitToFields(itemStream, "name,label,type,groupType,function,category,editable,groupNames,link,tags,metadata,commandDescription,stateDescription");
            return Response.ok((Object)new Stream2JSONInputStream(itemStream)).lastModified(this.lastModified).cacheControl(RESTConstants.CACHE_CONTROL).build();
        }
        Stream itemStream = this.getItems(type, tags).stream().map(item -> EnrichedItemDTOMapper.map(item, recursive, null, uriBuilder, locale, zoneId)).peek(dto -> this.addMetadata((EnrichedItemDTO)((Object)dto), namespaces, null)).peek(dto -> {
            Boolean bl = dto.editable = Boolean.valueOf(this.isEditable(dto.name));
        }).peek(dto -> {
            EnrichedItemDTO enrichedItemDTO = dto;
            if (enrichedItemDTO instanceof EnrichedGroupItemDTO) {
                void enrichedGroupItemDTO;
                EnrichedGroupItemDTO enrichedGroupItemDTO2 = (EnrichedGroupItemDTO)enrichedItemDTO;
                EnrichedGroupItemDTO cfr_ignored_0 = (EnrichedGroupItemDTO)enrichedItemDTO;
                EnrichedItemDTO[] enrichedItemDTOArray = enrichedGroupItemDTO.members;
                int n = enrichedGroupItemDTO.members.length;
                int n2 = 0;
                while (n2 < n) {
                    EnrichedItemDTO member = enrichedItemDTOArray[n2];
                    member.editable = this.isEditable(member.name);
                    ++n2;
                }
            }
        });
        itemStream = this.dtoMapper.limitToFields(itemStream, fields);
        return Response.ok((Object)new Stream2JSONInputStream(itemStream)).build();
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/metadata/namespaces")
    @Produces(value={"application/json"})
    @Operation(operationId="getItemNamespaces", summary="Gets the namespace of an item.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Item not found")})
    public Response getItemNamespaces(@PathParam(value="itemname") @Parameter(description="item name") String itemname, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Item item = this.getItem(itemname);
        if (item != null) {
            Collection namespaces = this.metadataRegistry.getAllNamespaces(itemname);
            return Response.ok((Object)new Stream2JSONInputStream(namespaces.stream())).build();
        }
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="getItemByName", summary="Gets a single item.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedItemDTO.class))}), @ApiResponse(responseCode="404", description="Item not found")})
    public Response getItemByName(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @DefaultValue(value=".*") @QueryParam(value="metadata") @Parameter(description="metadata selector - a comma separated list or a regular expression (returns all if no value given)") @Nullable String namespaceSelector, @DefaultValue(value="true") @QueryParam(value="recursive") @Parameter(description="get member items if the item is a group item") boolean recursive, @PathParam(value="itemname") @Parameter(description="item name") String itemname) {
        Locale locale = this.localeService.getLocale(language);
        ZoneId zoneId = this.timeZoneProvider.getTimeZone();
        Set<String> namespaces = this.splitAndFilterNamespaces(namespaceSelector, locale);
        Item item = this.getItem(itemname);
        if (item != null) {
            EnrichedItemDTO dto = EnrichedItemDTOMapper.map(item, recursive, null, this.uriBuilder(uriInfo, httpHeaders), locale, zoneId);
            this.addMetadata(dto, namespaces, null);
            dto.editable = this.isEditable(dto.name);
            EnrichedItemDTO enrichedItemDTO = dto;
            if (enrichedItemDTO instanceof EnrichedGroupItemDTO) {
                void enrichedGroupItemDTO;
                EnrichedGroupItemDTO enrichedGroupItemDTO2 = (EnrichedGroupItemDTO)enrichedItemDTO;
                EnrichedGroupItemDTO cfr_ignored_0 = (EnrichedGroupItemDTO)enrichedItemDTO;
                EnrichedItemDTO[] enrichedItemDTOArray = enrichedGroupItemDTO.members;
                int n = enrichedGroupItemDTO.members.length;
                int n2 = 0;
                while (n2 < n) {
                    EnrichedItemDTO member = enrichedItemDTOArray[n2];
                    member.editable = this.isEditable(member.name);
                    ++n2;
                }
            }
            return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)((Object)dto), null);
        }
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    private Set<String> splitAndFilterNamespaces(@Nullable String namespaceSelector, Locale locale) {
        return this.metadataSelectorMatcher.filterNamespaces(namespaceSelector, locale);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/state")
    @Produces(value={"text/plain"})
    @Operation(operationId="getItemState", summary="Gets the state of an item.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="404", description="Item not found")})
    public Response getPlainItemState(@PathParam(value="itemname") @Parameter(description="item name") String itemname) {
        Item item = this.getItem(itemname);
        if (item != null) {
            return Response.ok((Object)item.getState().toFullString()).build();
        }
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/state")
    @Operation(operationId="getItemState", summary="Gets the state of an item.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Item state is not RawType"), @ApiResponse(responseCode="404", description="Item not found"), @ApiResponse(responseCode="415", description="MediaType not supported by item state")})
    public Response getBinaryItemState(@HeaderParam(value="Accept") @Nullable String mediaType, @PathParam(value="itemname") @Parameter(description="item name") String itemname) {
        List<String> acceptedMediaTypes = Arrays.stream(Objects.requireNonNullElse(mediaType, "").split(",")).map(String::trim).toList();
        Item item = this.getItem(itemname);
        if (item != null) {
            State state = item.getState();
            State state2 = state;
            if (state2 instanceof RawType) {
                void type;
                RawType rawType = (RawType)state2;
                RawType cfr_ignored_0 = (RawType)state2;
                String mimeType = type.getMimeType();
                byte[] data = type.getBytes();
                if (acceptedMediaTypes.contains("image/*") && mimeType.startsWith("image/") || acceptedMediaTypes.contains(mimeType)) {
                    return Response.ok((Object)data).type(mimeType).build();
                }
                if (acceptedMediaTypes.contains("application/octet-stream")) {
                    return Response.ok((Object)data).type("application/octet-stream").build();
                }
                return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/state")
    @Consumes(value={"text/plain"})
    @Operation(operationId="updateItemState", summary="Updates the state of an item.", responses={@ApiResponse(responseCode="202", description="Accepted"), @ApiResponse(responseCode="404", description="Item not found"), @ApiResponse(responseCode="400", description="Item state null")})
    public Response putItemState(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="itemname") @Parameter(description="item name") String itemname, @Parameter(description="valid item state (e.g. ON, OFF)", required=true) String value) {
        Locale locale = this.localeService.getLocale(language);
        ZoneId zoneId = this.timeZoneProvider.getTimeZone();
        Item item = this.getItem(itemname);
        if (item != null) {
            State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)value);
            if (state != null) {
                this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)itemname, (State)state));
                return this.getItemResponse(null, Response.Status.ACCEPTED, null, locale, zoneId, null);
            }
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)("State could not be parsed: " + value));
        }
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    @POST
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}")
    @Consumes(value={"text/plain"})
    @Operation(operationId="sendItemCommand", summary="Sends a command to an item.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item not found"), @ApiResponse(responseCode="400", description="Item command null")})
    public Response postItemCommand(@PathParam(value="itemname") @Parameter(description="item name") String itemname, @Parameter(description="valid item command (e.g. ON, OFF, UP, DOWN, REFRESH)", required=true) String value) {
        Item item = this.getItem(itemname);
        Command command = null;
        if (item != null) {
            if ("toggle".equalsIgnoreCase(value) && (item instanceof SwitchItem || item instanceof RollershutterItem)) {
                if (OnOffType.ON.equals((Object)item.getStateAs(OnOffType.class))) {
                    command = OnOffType.OFF;
                }
                if (OnOffType.OFF.equals((Object)item.getStateAs(OnOffType.class))) {
                    command = OnOffType.ON;
                }
                if (UpDownType.UP.equals((Object)item.getStateAs(UpDownType.class))) {
                    command = UpDownType.DOWN;
                }
                if (UpDownType.DOWN.equals((Object)item.getStateAs(UpDownType.class))) {
                    command = UpDownType.UP;
                }
            } else {
                command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)value);
            }
            if (command != null) {
                this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemname, (Command)command));
                Response.ResponseBuilder resbuilder = Response.ok();
                resbuilder.type("text/plain");
                return resbuilder.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return ItemResource.getItemNotFoundResponse(itemname);
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemName: [a-zA-Z_0-9]+}/members/{memberItemName: [a-zA-Z_0-9]+}")
    @Operation(operationId="addMemberToGroupItem", summary="Adds a new member to a group item.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item or member item not found or item is not of type group item."), @ApiResponse(responseCode="405", description="Member item is not editable.")})
    public Response addMember(@PathParam(value="itemName") @Parameter(description="item name") String itemName, @PathParam(value="memberItemName") @Parameter(description="member item name") String memberItemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            if (!(item instanceof GroupItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            GroupItem groupItem = (GroupItem)item;
            Item memberItem = this.itemRegistry.getItem(memberItemName);
            if (!(memberItem instanceof GenericItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (this.managedItemProvider.get((Object)memberItemName) == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
            }
            GenericItem genericMemberItem = (GenericItem)memberItem;
            genericMemberItem.addGroupName(groupItem.getName());
            this.managedItemProvider.update((Identifiable)genericMemberItem);
            return Response.ok(null, (String)"text/plain").build();
        }
        catch (ItemNotFoundException e) {
            return ItemResource.getItemNotFoundResponse(itemName);
        }
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemName: [a-zA-Z_0-9]+}/members/{memberItemName: [a-zA-Z_0-9]+}")
    @Operation(operationId="removeMemberFromGroupItem", summary="Removes an existing member from a group item.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item or member item not found or item is not of type group item."), @ApiResponse(responseCode="405", description="Member item is not editable.")})
    public Response removeMember(@PathParam(value="itemName") @Parameter(description="item name") String itemName, @PathParam(value="memberItemName") @Parameter(description="member item name") String memberItemName) {
        try {
            Item item = this.itemRegistry.getItem(itemName);
            if (!(item instanceof GroupItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            GroupItem groupItem = (GroupItem)item;
            Item memberItem = this.itemRegistry.getItem(memberItemName);
            if (!(memberItem instanceof GenericItem)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (this.managedItemProvider.get((Object)memberItemName) == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
            }
            GenericItem genericMemberItem = (GenericItem)memberItem;
            genericMemberItem.removeGroupName(groupItem.getName());
            this.managedItemProvider.update((Identifiable)genericMemberItem);
            return Response.ok(null, (String)"text/plain").build();
        }
        catch (ItemNotFoundException e) {
            return ItemResource.getItemNotFoundResponse(itemName);
        }
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}")
    @Operation(operationId="removeItemFromRegistry", summary="Removes an item from the registry.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item not found or item is not editable.")})
    public Response removeItem(@PathParam(value="itemname") @Parameter(description="item name") String itemname) {
        if (this.managedItemProvider.remove(itemname) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/tags/{tag}")
    @Operation(operationId="addTagToItem", summary="Adds a tag to an item.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item not found."), @ApiResponse(responseCode="405", description="Item not editable.")})
    public Response addTag(@PathParam(value="itemname") @Parameter(description="item name") String itemname, @PathParam(value="tag") @Parameter(description="tag") String tag) {
        Item item = this.getItem(itemname);
        if (item == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.managedItemProvider.get((Object)itemname) == null) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        ((GenericItem)item).addTag(tag);
        this.managedItemProvider.update((Identifiable)item);
        return Response.ok(null, (String)"text/plain").build();
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/tags/{tag}")
    @Operation(operationId="removeTagFromItem", summary="Removes a tag from an item.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item not found."), @ApiResponse(responseCode="405", description="Item not editable.")})
    public Response removeTag(@PathParam(value="itemname") @Parameter(description="item name") String itemname, @PathParam(value="tag") @Parameter(description="tag") String tag) {
        Item item = this.getItem(itemname);
        if (item == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.managedItemProvider.get((Object)itemname) == null) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        ((GenericItem)item).removeTag(tag);
        this.managedItemProvider.update((Identifiable)item);
        return Response.ok(null, (String)"text/plain").build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/metadata/{namespace}")
    @Consumes(value={"application/json"})
    @Operation(operationId="addMetadataToItem", summary="Adds metadata to an item.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="400", description="Metadata value empty."), @ApiResponse(responseCode="404", description="Item not found."), @ApiResponse(responseCode="405", description="Metadata not editable.")})
    public Response addMetadata(@PathParam(value="itemname") @Parameter(description="item name") String itemname, @PathParam(value="namespace") @Parameter(description="namespace") String namespace, @Parameter(description="metadata", required=true) MetadataDTO metadata) {
        Item item = this.getItem(itemname);
        if (item == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String value = metadata.value;
        if (value == null || value.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        MetadataKey key = new MetadataKey(namespace, itemname);
        Metadata md = new Metadata(key, value, metadata.config);
        if (this.metadataRegistry.get((Object)key) == null) {
            this.metadataRegistry.add((Identifiable)md);
            return Response.status((Response.Status)Response.Status.CREATED).type("text/plain").build();
        }
        this.metadataRegistry.update((Identifiable)md);
        return Response.ok(null, (String)"text/plain").build();
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}/metadata/{namespace}")
    @Operation(operationId="removeMetadataFromItem", summary="Removes metadata from an item.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item not found."), @ApiResponse(responseCode="405", description="Meta data not editable.")})
    public Response removeMetadata(@PathParam(value="itemname") @Parameter(description="item name") String itemname, @PathParam(value="namespace") @Parameter(description="namespace") @Nullable String namespace) {
        Item item = this.getItem(itemname);
        if (item == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (namespace == null) {
            this.metadataRegistry.removeItemMetadata(itemname);
        } else {
            MetadataKey key = new MetadataKey(namespace, itemname);
            if (this.metadataRegistry.get((Object)key) != null) {
                if (this.metadataRegistry.remove((Object)key) == null) {
                    return Response.status((Response.Status)Response.Status.CONFLICT).build();
                }
            } else {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @RolesAllowed(value={"administrator"})
    @Path(value="/metadata/purge")
    @Operation(operationId="purgeDatabase", summary="Remove unused/orphaned metadata.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK")})
    public Response purge() {
        Collection itemNames = this.itemRegistry.stream().map(Item::getName).collect(Collectors.toCollection(HashSet::new));
        this.metadataRegistry.getAll().stream().filter(md -> !itemNames.contains(md.getUID().getItemName())).forEach(md -> {
            Identifiable identifiable = this.metadataRegistry.remove((Object)md.getUID());
        });
        return Response.ok().build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemname: [a-zA-Z_0-9]+}")
    @Consumes(value={"application/json"})
    @Operation(operationId="addOrUpdateItemInRegistry", summary="Adds a new item to the registry or updates the existing item.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedItemDTO.class))}), @ApiResponse(responseCode="201", description="Item created."), @ApiResponse(responseCode="400", description="Payload invalid."), @ApiResponse(responseCode="404", description="Item not found or name in path invalid."), @ApiResponse(responseCode="405", description="Item not editable.")})
    public Response createOrUpdateItem(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="itemname") @Parameter(description="item name") String itemname, @Parameter(description="item data", required=true) @Nullable GroupItemDTO item) {
        Locale locale = this.localeService.getLocale(language);
        ZoneId zoneId = this.timeZoneProvider.getTimeZone();
        if (item == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!itemname.equalsIgnoreCase(item.name)) {
            this.logger.warn("Received HTTP PUT request at '{}' with an item name '{}' that does not match the one in the url.", (Object)uriInfo.getPath(), (Object)item.name);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Item newItem = ItemDTOMapper.map((ItemDTO)item, (ItemBuilderFactory)this.itemBuilderFactory);
            if (newItem == null) {
                this.logger.warn("Received HTTP PUT request at '{}' with an invalid item type '{}'.", (Object)uriInfo.getPath(), (Object)item.type);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (this.getItem(itemname) == null) {
                this.managedItemProvider.add(newItem);
                return this.getItemResponse(this.uriBuilder(uriInfo, httpHeaders), Response.Status.CREATED, (Item)this.itemRegistry.get((Object)itemname), locale, zoneId, null);
            }
            if (this.managedItemProvider.get((Object)itemname) != null) {
                this.managedItemProvider.update((Identifiable)newItem);
                return this.getItemResponse(this.uriBuilder(uriInfo, httpHeaders), Response.Status.OK, (Item)this.itemRegistry.get((Object)itemname), locale, zoneId, null);
            }
            this.logger.warn("Cannot update existing item '{}', because is not managed.", (Object)itemname);
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.METHOD_NOT_ALLOWED, (String)("Cannot update non-managed Item " + itemname));
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Received HTTP PUT request at '{}' with an invalid item name '{}'.", (Object)uriInfo.getPath(), (Object)item.name);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Consumes(value={"application/json"})
    @Operation(operationId="addOrUpdateItemsInRegistry", summary="Adds a list of items to the registry or updates the existing items.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Payload is invalid.")})
    public Response createOrUpdateItems(@Parameter(description="array of item data", required=true) GroupItemDTO @Nullable [] items) {
        if (items == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList<GroupItemDTO> wrongTypes = new ArrayList<GroupItemDTO>();
        ArrayList<Item> activeItems = new ArrayList<Item>();
        HashMap<String, Set> tagMap = new HashMap<String, Set>();
        GroupItemDTO[] groupItemDTOArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            GroupItemDTO item = groupItemDTOArray[n2];
            try {
                Item item2 = ItemDTOMapper.map((ItemDTO)item, (ItemBuilderFactory)this.itemBuilderFactory);
                if (item2 == null) {
                    wrongTypes.add(item);
                    tagMap.put(item.name, item.tags);
                } else {
                    activeItems.add(item2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.warn("Received HTTP PUT request with an invalid item name '{}'.", (Object)item.name);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            ++n2;
        }
        ArrayList<Item> createdItems = new ArrayList<Item>();
        ArrayList<Item> updatedItems = new ArrayList<Item>();
        ArrayList<Item> failedItems = new ArrayList<Item>();
        for (Item activeItem : activeItems) {
            String itemName = activeItem.getName();
            if (this.getItem(itemName) == null) {
                this.managedItemProvider.add(activeItem);
                createdItems.add(activeItem);
                continue;
            }
            if (this.managedItemProvider.get((Object)itemName) != null) {
                this.managedItemProvider.update((Identifiable)activeItem);
                updatedItems.add(activeItem);
                continue;
            }
            this.logger.warn("Cannot update existing item '{}', because it is not managed.", (Object)itemName);
            failedItems.add(activeItem);
        }
        ArrayList<JsonObject> responseList = new ArrayList<JsonObject>();
        for (GroupItemDTO groupItemDTO : wrongTypes) {
            responseList.add(this.buildStatusObject(groupItemDTO.name, "error", "Received HTTP PUT request with an invalid item type '" + groupItemDTO.type + "'."));
        }
        for (Item item : failedItems) {
            responseList.add(this.buildStatusObject(item.getName(), "error", "Cannot update non-managed item"));
        }
        for (Item item : createdItems) {
            responseList.add(this.buildStatusObject(item.getName(), "created", null));
        }
        for (Item item : updatedItems) {
            responseList.add(this.buildStatusObject(item.getName(), "updated", null));
        }
        return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, responseList, null);
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Path(value="/{itemName: \\w+}/semantic/{semanticClass: \\w+}")
    @Operation(operationId="getSemanticItem", summary="Gets the item which defines the requested semantics of an item.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Item not found")})
    public Response getSemanticItem(@Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="itemName") @Parameter(description="item name") String itemName, @PathParam(value="semanticClass") @Parameter(description="semantic class") String semanticClassName) {
        Locale locale = this.localeService.getLocale(language);
        ZoneId zoneId = this.timeZoneProvider.getTimeZone();
        Class semanticClass = this.semanticTagRegistry.getTagClassById(semanticClassName);
        if (semanticClass == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Item foundItem = this.findParentByTag(this.getItem(itemName), SemanticsPredicates.isA((Class)semanticClass));
        if (foundItem == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        EnrichedItemDTO dto = EnrichedItemDTOMapper.map(foundItem, false, null, this.uriBuilder(uriInfo, httpHeaders), locale, zoneId);
        dto.editable = this.isEditable(dto.name);
        return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)((Object)dto), null);
    }

    private JsonObject buildStatusObject(String itemName, String status, @Nullable String message) {
        JsonObject jo = new JsonObject();
        jo.addProperty("name", itemName);
        jo.addProperty("status", status);
        jo.addProperty("message", message);
        return jo;
    }

    private @Nullable Item findParentByTag(@Nullable Item item, Predicate<Item> predicate) {
        if (item == null) {
            return null;
        }
        if (predicate.test(item)) {
            return item;
        }
        return item.getGroupNames().stream().map(this::getItem).map(i -> this.findParentByTag((Item)i, predicate)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private static Response getItemNotFoundResponse(String itemname) {
        String message = "Item " + itemname + " does not exist!";
        return JSONResponse.createResponse((Response.StatusType)Response.Status.NOT_FOUND, null, (String)message);
    }

    private Response getItemResponse(@Nullable UriBuilder uriBuilder, Response.Status status, @Nullable Item item, Locale locale, ZoneId zoneId, @Nullable String errormessage) {
        EnrichedItemDTO entity = item != null ? EnrichedItemDTOMapper.map(item, true, null, uriBuilder, locale, zoneId) : null;
        return JSONResponse.createResponse((Response.StatusType)status, entity, (String)errormessage);
    }

    private @Nullable Item getItem(String itemname) {
        return (Item)this.itemRegistry.get((Object)itemname);
    }

    private Collection<Item> getItems(@Nullable String type, @Nullable String tags) {
        Collection items;
        if (tags == null) {
            items = type == null ? this.itemRegistry.getItems() : this.itemRegistry.getItemsOfType(type);
        } else {
            String[] tagList = tags.split(",");
            items = type == null ? this.itemRegistry.getItemsByTag(tagList) : this.itemRegistry.getItemsByTagAndType(type, tagList);
        }
        return items;
    }

    /*
     * WARNING - void declaration
     */
    private void addMetadata(EnrichedItemDTO dto, Set<String> namespaces, @Nullable Predicate<Metadata> filter) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (Object namespace : namespaces) {
            MetadataKey key = new MetadataKey(namespace, dto.name);
            Metadata md = (Metadata)this.metadataRegistry.get((Object)key);
            if (md == null || filter != null && !filter.test(md)) continue;
            MetadataDTO mdDto = new MetadataDTO();
            mdDto.value = md.getValue();
            mdDto.config = md.getConfiguration().isEmpty() ? null : md.getConfiguration();
            metadata.put((String)namespace, mdDto);
        }
        Object object = dto;
        if (object instanceof EnrichedGroupItemDTO) {
            void tO;
            Object namespace;
            namespace = (EnrichedGroupItemDTO)((Object)object);
            EnrichedGroupItemDTO cfr_ignored_0 = (EnrichedGroupItemDTO)((Object)object);
            EnrichedItemDTO[] enrichedItemDTOArray = tO.members;
            int n = tO.members.length;
            int n2 = 0;
            while (n2 < n) {
                EnrichedItemDTO member = enrichedItemDTOArray[n2];
                this.addMetadata(member, namespaces, filter);
                ++n2;
            }
        }
        if (!metadata.isEmpty()) {
            dto.metadata = metadata;
        }
    }

    private boolean isEditable(String itemName) {
        return this.managedItemProvider.get((Object)itemName) != null;
    }
}

