/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.HeatMapChart;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.AxisTick;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Callback;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Category;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Date;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Logarithmic;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Number;
import org.knowm.xchart.internal.chartpart.AxisTitle;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.internal.series.AxesChartSeriesCategory;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.BoxStyler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.HeatMapStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class Axis<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartPart {
    private final Chart<ST, S> chart;
    private final Rectangle2D.Double bounds;
    private final ST axesChartStyler;
    private final AxisTitle<ST, S> axisTitle;
    private final AxisTick<ST, S> axisTick;
    private final Direction direction;
    private final int index;
    private Series.DataType dataType;
    private AxisTickCalculator axisTickCalculator;
    private double min;
    private double max;

    public Axis(Chart<ST, S> chart, Direction direction, int index) {
        this.chart = chart;
        this.axesChartStyler = (AxesChartStyler)chart.getStyler();
        this.direction = direction;
        this.index = index;
        this.bounds = new Rectangle2D.Double();
        this.axisTitle = new AxisTitle<ST, S>(chart, direction, direction == Direction.Y ? this : null, index);
        this.axisTick = new AxisTick<ST, S>(chart, direction, direction == Direction.Y ? this : null);
    }

    void resetMinMax() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    void addMinMax(double min, double max) {
        if (Double.isNaN(this.min) || min < this.min) {
            this.min = min;
        }
        if (Double.isNaN(this.max) || max > this.max) {
            this.max = max;
        }
    }

    public void preparePaint() {
        double legendHeightOffset = 0.0;
        if (((Styler)this.axesChartStyler).isLegendVisible() && ((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideS) {
            legendHeightOffset = this.chart.getLegend().getBounds().getHeight();
        }
        if (this.direction == Direction.Y) {
            double height;
            double xOffset = 0.0;
            double yOffset = this.chart.getChartTitle().getBounds().getHeight() + (double)((Styler)this.axesChartStyler).getChartPadding();
            int i = 1;
            double width = 60.0;
            do {
                double legendWidthOffset = 0.0;
                if (((Styler)this.axesChartStyler).isLegendVisible() && ((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideE) {
                    legendWidthOffset = ((Styler)this.axesChartStyler).getChartPadding();
                }
                double approximateXAxisWidth = (double)this.chart.getWidth() - width - (((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideE ? this.chart.getLegend().getBounds().getWidth() : 0.0) - (double)(2 * ((Styler)this.axesChartStyler).getChartPadding()) - (double)(((AxesChartStyler)this.axesChartStyler).isYAxisTicksVisible() ? ((AxesChartStyler)this.axesChartStyler).getPlotMargin() : 0) - legendWidthOffset;
                height = (double)this.chart.getHeight() - yOffset - this.chart.getXAxis().getXAxisHeightHint(approximateXAxisWidth) - (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin() - (double)((Styler)this.axesChartStyler).getChartPadding() - legendHeightOffset;
                width = this.getYAxisWidthHint(height);
            } while (i-- > 0);
            this.bounds.setRect(xOffset, yOffset, width, height);
        } else {
            Rectangle2D.Double leftYAxisBounds = this.chart.getAxisPair().getLeftYAxisBounds();
            Rectangle2D.Double rightYAxisBounds = this.chart.getAxisPair().getRightYAxisBounds();
            double maxYAxisY = Math.max(((RectangularShape)leftYAxisBounds).getY() + ((RectangularShape)leftYAxisBounds).getHeight(), ((RectangularShape)rightYAxisBounds).getY() + ((RectangularShape)rightYAxisBounds).getHeight());
            double xOffset = ((RectangularShape)leftYAxisBounds).getWidth() + ((RectangularShape)leftYAxisBounds).getX();
            double yOffset = maxYAxisY + (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin() - legendHeightOffset;
            double legendWidth = 0.0;
            if (((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideE && ((Styler)this.axesChartStyler).isLegendVisible()) {
                legendWidth = this.chart.getLegend().getBounds().getWidth() + (double)((Styler)this.axesChartStyler).getChartPadding();
            }
            double width = (double)this.chart.getWidth() - ((RectangularShape)leftYAxisBounds).getWidth() - ((RectangularShape)rightYAxisBounds).getWidth() - ((RectangularShape)leftYAxisBounds).getX() - (double)(1 * ((Styler)this.axesChartStyler).getChartPadding()) - legendWidth;
            double height = (double)this.chart.getHeight() - maxYAxisY - (double)((Styler)this.axesChartStyler).getChartPadding() - (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin();
            this.bounds.setRect(xOffset, yOffset, width, height);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.direction == Direction.Y) {
            boolean onRight;
            boolean bl = onRight = ((Styler)this.axesChartStyler).getYAxisGroupPosistion(this.index) == Styler.YAxisPosition.Right;
            if (onRight) {
                this.axisTick.paint(g);
                this.axisTitle.paint(g);
            } else {
                this.axisTitle.paint(g);
                this.axisTick.paint(g);
            }
            this.bounds.width = (((AxesChartStyler)this.axesChartStyler).isYAxisTitleVisible() ? this.axisTitle.getBounds().getWidth() : 0.0) + this.axisTick.getBounds().getWidth();
        } else {
            this.axisTickCalculator = this.getAxisTickCalculator(this.bounds.getWidth());
            this.axisTitle.paint(g);
            this.axisTick.paint(g);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    private double getXAxisHeightHint(double workingSpace) {
        double titleHeight = 0.0;
        if (this.chart.getXAxisTitle() != null && !this.chart.getXAxisTitle().trim().equalsIgnoreCase("") && ((AxesChartStyler)this.axesChartStyler).isXAxisTitleVisible()) {
            TextLayout textLayout = new TextLayout(this.chart.getXAxisTitle(), ((AxesChartStyler)this.axesChartStyler).getAxisTitleFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            titleHeight = rectangle.getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTitlePadding();
        }
        this.axisTickCalculator = this.getAxisTickCalculator(workingSpace);
        double axisTickLabelsHeight = 0.0;
        if (((AxesChartStyler)this.axesChartStyler).isXAxisTicksVisible()) {
            String sampleLabel = "";
            for (int i = 0; i < this.axisTickCalculator.getTickLabels().size(); ++i) {
                if (this.axisTickCalculator.getTickLabels().get(i) == null || this.axisTickCalculator.getTickLabels().get(i).length() <= sampleLabel.length()) continue;
                sampleLabel = this.axisTickCalculator.getTickLabels().get(i);
            }
            TextLayout textLayout = new TextLayout(sampleLabel.length() == 0 ? " " : sampleLabel, ((AxesChartStyler)this.axesChartStyler).getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
            AffineTransform rot = ((AxesChartStyler)this.axesChartStyler).getXAxisLabelRotation() == 0 ? null : AffineTransform.getRotateInstance(-1.0 * Math.toRadians(((AxesChartStyler)this.axesChartStyler).getXAxisLabelRotation()));
            Shape shape = textLayout.getOutline(rot);
            Rectangle rectangle = shape.getBounds();
            axisTickLabelsHeight = ((RectangularShape)rectangle).getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickPadding() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength();
        }
        return titleHeight + axisTickLabelsHeight;
    }

    private double getYAxisWidthHint(double workingSpace) {
        double titleHeight = 0.0;
        String yAxisTitle = this.chart.getYAxisGroupTitle(this.index);
        if (yAxisTitle != null && !yAxisTitle.trim().equalsIgnoreCase("") && ((AxesChartStyler)this.axesChartStyler).isYAxisTitleVisible()) {
            TextLayout textLayout = new TextLayout(yAxisTitle, ((AxesChartStyler)this.axesChartStyler).getAxisTitleFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            titleHeight = rectangle.getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTitlePadding();
        }
        this.axisTickCalculator = this.getAxisTickCalculator(workingSpace);
        double axisTickLabelsHeight = 0.0;
        if (((AxesChartStyler)this.axesChartStyler).isYAxisTicksVisible()) {
            String sampleLabel = "";
            for (int i = 0; i < this.axisTickCalculator.getTickLabels().size(); ++i) {
                if (this.axisTickCalculator.getTickLabels().get(i) == null || this.axisTickCalculator.getTickLabels().get(i).length() <= sampleLabel.length()) continue;
                sampleLabel = this.axisTickCalculator.getTickLabels().get(i);
            }
            TextLayout textLayout = new TextLayout(sampleLabel.length() == 0 ? " " : sampleLabel, ((AxesChartStyler)this.axesChartStyler).getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            axisTickLabelsHeight = rectangle.getWidth() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickPadding() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength();
        }
        return titleHeight + axisTickLabelsHeight;
    }

    private AxisTickCalculator getAxisTickCalculator(double workingSpace) {
        if (this.getDirection() == Direction.X) {
            return this.getAxisTickCalculatorForX(workingSpace);
        }
        return this.getAxisTickCalculatorForY(workingSpace);
    }

    private AxisTickCalculator getAxisTickCalculatorForY(double workingSpace) {
        LinkedHashSet uniqueYData;
        List<?> categories;
        List<Object> yData = new ArrayList();
        if (this.axesChartStyler instanceof HeatMapStyler) {
            categories = ((HeatMapChart)this.chart).getHeatMapSeries().getYData();
            yData = categories.stream().filter(Objects::nonNull).filter(it -> it instanceof Number).mapToDouble(it -> ((Number)it).doubleValue()).boxed().collect(Collectors.toList());
        } else if (this.axesChartStyler instanceof CategoryStyler) {
            uniqueYData = new LinkedHashSet();
            for (CategorySeries categorySeries : ((CategoryChart)this.chart).getSeriesMap().values()) {
                uniqueYData.addAll(categorySeries.getYData().stream().filter(Objects::nonNull).mapToDouble(Number::doubleValue).boxed().collect(Collectors.toList()));
            }
            yData.addAll(uniqueYData);
        } else if (this.axesChartStyler instanceof XYStyler) {
            uniqueYData = new LinkedHashSet();
            for (XYSeries xySeries : ((XYChart)this.chart).getSeriesMap().values()) {
                uniqueYData.addAll(Arrays.stream(xySeries.getYData()).boxed().collect(Collectors.toList()));
            }
            yData.addAll(uniqueYData);
        }
        if (((AxesChartStyler)this.axesChartStyler).getyAxisTickLabelsFormattingFunction() != null) {
            if (!yData.isEmpty()) {
                return new AxisTickCalculator_Callback(((AxesChartStyler)this.axesChartStyler).getyAxisTickLabelsFormattingFunction(), this.getDirection(), workingSpace, this.min, this.max, (List<Double>)yData, (AxesChartStyler)this.axesChartStyler);
            }
            return new AxisTickCalculator_Callback(((AxesChartStyler)this.axesChartStyler).getyAxisTickLabelsFormattingFunction(), this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        if (((AxesChartStyler)this.axesChartStyler).isYAxisLogarithmic() && this.getDataType() != Series.DataType.Date) {
            return new AxisTickCalculator_Logarithmic(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler, this.getYIndex());
        }
        if (this.axesChartStyler instanceof HeatMapStyler) {
            categories = ((HeatMapChart)this.chart).getHeatMapSeries().getYData();
            Series.DataType axisType = this.chart.getAxisPair().getYAxis().getDataType();
            return new AxisTickCalculator_Category(this.getDirection(), workingSpace, categories, axisType, (AxesChartStyler)this.axesChartStyler);
        }
        if (!yData.isEmpty()) {
            return new AxisTickCalculator_Number(this.getDirection(), workingSpace, this.min, this.max, (List<Double>)yData, (AxesChartStyler)this.axesChartStyler);
        }
        return new AxisTickCalculator_Number(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler, this.getYIndex());
    }

    private AxisTickCalculator_ getAxisTickCalculatorForX(double workingSpace) {
        LinkedHashSet uniqueXData;
        List<?> categories;
        List<Object> xData = new ArrayList();
        if (this.axesChartStyler instanceof HeatMapStyler) {
            categories = ((HeatMapChart)this.chart).getHeatMapSeries().getXData();
            xData = categories.stream().filter(Objects::nonNull).filter(it -> it instanceof Number).mapToDouble(it -> ((Number)it).doubleValue()).boxed().collect(Collectors.toList());
        } else if (this.axesChartStyler instanceof CategoryStyler) {
            uniqueXData = new LinkedHashSet();
            for (CategorySeries categorySeries : ((CategoryChart)this.chart).getSeriesMap().values()) {
                List numericCategoryXData = categorySeries.getXData().stream().filter(Objects::nonNull).filter(x -> x instanceof Number).mapToDouble(x -> ((Number)x).doubleValue()).boxed().collect(Collectors.toList());
                uniqueXData.addAll(numericCategoryXData);
            }
            xData.addAll(uniqueXData);
        } else if (this.axesChartStyler instanceof XYStyler) {
            uniqueXData = new LinkedHashSet();
            for (XYSeries xySeries : ((XYChart)this.chart).getSeriesMap().values()) {
                uniqueXData.addAll(Arrays.stream(xySeries.getXData()).boxed().collect(Collectors.toList()));
            }
            xData.addAll(uniqueXData);
        }
        if (((AxesChartStyler)this.axesChartStyler).getxAxisTickLabelsFormattingFunction() != null) {
            if (!xData.isEmpty()) {
                return new AxisTickCalculator_Callback(((AxesChartStyler)this.axesChartStyler).getxAxisTickLabelsFormattingFunction(), this.getDirection(), workingSpace, this.min, this.max, (List<Double>)xData, (AxesChartStyler)this.axesChartStyler);
            }
            return new AxisTickCalculator_Callback(((AxesChartStyler)this.axesChartStyler).getxAxisTickLabelsFormattingFunction(), this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        if (this.axesChartStyler instanceof CategoryStyler || this.axesChartStyler instanceof BoxStyler) {
            AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
            List categories2 = (List)axesChartSeries.getXData();
            Series.DataType axisType = this.chart.getAxisPair().getXAxis().getDataType();
            return new AxisTickCalculator_Category(this.getDirection(), workingSpace, categories2, axisType, (AxesChartStyler)this.axesChartStyler);
        }
        if (this.getDataType() == Series.DataType.Date && !(this.axesChartStyler instanceof HeatMapStyler)) {
            return new AxisTickCalculator_Date(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        if (((AxesChartStyler)this.axesChartStyler).isXAxisLogarithmic()) {
            return new AxisTickCalculator_Logarithmic(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        if (this.axesChartStyler instanceof HeatMapStyler) {
            categories = ((HeatMapChart)this.chart).getHeatMapSeries().getXData();
            Series.DataType axisType = this.chart.getAxisPair().getXAxis().getDataType();
            return new AxisTickCalculator_Category(this.getDirection(), workingSpace, categories, axisType, (AxesChartStyler)this.axesChartStyler);
        }
        if (!xData.isEmpty()) {
            return new AxisTickCalculator_Number(this.getDirection(), workingSpace, this.min, this.max, (List<Double>)xData, (AxesChartStyler)this.axesChartStyler);
        }
        return new AxisTickCalculator_Number(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
    }

    Series.DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(Series.DataType dataType) {
        if (dataType != null && this.dataType != null && this.dataType != dataType) {
            throw new IllegalArgumentException("Different Axes (e.g. Date, Number, String) cannot be mixed on the same chart!!");
        }
        this.dataType = dataType;
    }

    double getMin() {
        return this.min;
    }

    void setMin(double min) {
        this.min = min;
    }

    double getMax() {
        return this.max;
    }

    void setMax(double max) {
        this.max = max;
    }

    AxisTick<ST, S> getAxisTick() {
        return this.axisTick;
    }

    private Direction getDirection() {
        return this.direction;
    }

    AxisTitle<ST, S> getAxisTitle() {
        return this.axisTitle;
    }

    public AxisTickCalculator getAxisTickCalculator() {
        return this.axisTickCalculator;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public int getYIndex() {
        return this.index;
    }

    public double getScreenValue(double chartPoint) {
        boolean isLog;
        double workingSpace;
        double startOffset;
        double minVal = this.min;
        double maxVal = this.max;
        if (this.min > this.max && this.getDirection() == Direction.X && this.axesChartStyler instanceof CategoryStyler) {
            AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
            int count = axesChartSeries.getXData().size();
            minVal = 0.0;
            maxVal = count;
        }
        if (this.direction == Direction.X) {
            startOffset = this.bounds.getX();
            workingSpace = this.bounds.getWidth();
            isLog = ((AxesChartStyler)this.axesChartStyler).isXAxisLogarithmic();
        } else {
            startOffset = 0.0;
            workingSpace = this.bounds.getHeight();
            isLog = ((AxesChartStyler)this.axesChartStyler).isYAxisLogarithmic();
        }
        if (this.min == this.max) {
            return workingSpace / 2.0;
        }
        double tickSpace = ((Styler)this.axesChartStyler).getPlotContentSize() * workingSpace;
        if (tickSpace < (double)((AxesChartStyler)this.axesChartStyler).getXAxisTickMarkSpacingHint()) {
            return workingSpace / 2.0;
        }
        double margin = Utils.getTickStartOffset(workingSpace, tickSpace);
        minVal = isLog ? Math.log10(minVal) : minVal;
        maxVal = isLog ? Math.log10(maxVal) : maxVal;
        chartPoint = isLog ? Math.log10(chartPoint) : chartPoint;
        double tickLabelPosition = startOffset + margin + (chartPoint - minVal) / (maxVal - minVal) * tickSpace;
        if (this.direction == Direction.Y) {
            tickLabelPosition = this.bounds.getHeight() - tickLabelPosition + this.bounds.getY();
        }
        return tickLabelPosition;
    }

    public double getScreenValueForMin() {
        return this.getScreenValue(this.min);
    }

    public double getScreenValueForMax() {
        return this.getScreenValue(this.max);
    }

    public double getChartValue(double screenPoint) {
        boolean isLog;
        double workingSpace;
        double startOffset;
        if (this.min == this.max) {
            return this.min;
        }
        double minVal = this.min;
        double maxVal = this.max;
        if (this.min > this.max && this.getDirection() == Direction.X && this.axesChartStyler instanceof CategoryStyler) {
            AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
            int count = axesChartSeries.getXData().size();
            minVal = 0.0;
            maxVal = count;
        }
        if (this.direction == Direction.X) {
            startOffset = this.bounds.getX();
            workingSpace = this.bounds.getWidth();
            isLog = ((AxesChartStyler)this.axesChartStyler).isXAxisLogarithmic();
        } else {
            startOffset = 0.0;
            workingSpace = this.bounds.getHeight();
            screenPoint = this.bounds.getHeight() - screenPoint + this.bounds.getY();
            isLog = ((AxesChartStyler)this.axesChartStyler).isYAxisLogarithmic();
        }
        double tickSpace = ((Styler)this.axesChartStyler).getPlotContentSize() * workingSpace;
        if (tickSpace < (double)((AxesChartStyler)this.axesChartStyler).getXAxisTickMarkSpacingHint()) {
            return minVal;
        }
        double margin = Utils.getTickStartOffset(workingSpace, tickSpace);
        minVal = isLog ? Math.log10(minVal) : minVal;
        maxVal = isLog ? Math.log10(maxVal) : maxVal;
        double value = (screenPoint - margin - startOffset) * (maxVal - minVal) / tickSpace + minVal;
        value = isLog ? Math.pow(10.0, value) : value;
        return value;
    }

    public static enum Direction {
        X,
        Y;

    }
}

