
package Term::Size::Perl::Params; 

# created Wed Feb  4 21:56:04 2026

use vars qw($VERSION);
$VERSION = '0.031';

sub params {
    return (
        winsize => {
            sizeof => 8,
            mask => 'S!S!S!S!'
        },
        TIOCGWINSZ => {
            value => 1074295912,
            definition => qq{(0x40000000UL | ((sizeof(struct winsize) & 0x1fff) << 16) | ((('t')) << 8) | ((104)))}
        }
    );
}

1;

=pod

=head1 NAME

Term::Size::Perl::Params - Configuration for Term::Size::Perl

=head1 SYNOPSIS

    use Term::Size::Perl::Params ();

    %params = Term::Size::Perl::Params::params();

=head1 DESCRIPTION

The configuration parameters C<Term::Size::Perl> needs to
know for retrieving the terminal size with C<ioctl>.

=head1 FUNCTIONS

=head2 params

The configuration parameters C<Term::Size::Perl> needs to
know for retrieving the terminal size with C<ioctl>.

=cut
