/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.core.tasty;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.core.tasty.ScratchData;
import dotty.tools.dotc.util.IntMap;
import dotty.tools.dotc.util.IntMap$;
import dotty.tools.dotc.util.Util$;
import dotty.tools.tasty.TastyBuffer;
import dotty.tools.tasty.TastyBuffer$;
import java.util.Arrays;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.runtime.Scala3RunTime$;

public class TreeBuffer
extends TastyBuffer {
    private int[] offsets;
    private boolean[] isRelative;
    private int numOffsets;
    private final IntMap<Trees.Tree<Types.Type>> treeAddrs;

    public TreeBuffer() {
        super(50000);
        int initialOffsetSize = this.bytes().length / 8;
        this.offsets = new int[initialOffsetSize];
        this.isRelative = new boolean[initialOffsetSize];
        this.numOffsets = 0;
        this.treeAddrs = new IntMap(8192, IntMap$.MODULE$.$lessinit$greater$default$2());
    }

    public int registerTreeAddr(Trees.Tree<Types.Type> tree) {
        int idx = this.treeAddrs.apply(tree);
        if (idx < 0) {
            this.treeAddrs.update(tree, this.currentAddr());
            return this.currentAddr();
        }
        return TastyBuffer.Addr$.MODULE$.apply(idx);
    }

    public int addrOfTree(Trees.Tree<Types.Type> tree) {
        int idx = this.treeAddrs.apply(tree);
        if (idx < 0) {
            return TastyBuffer$.MODULE$.NoAddr();
        }
        return TastyBuffer.Addr$.MODULE$.apply(idx);
    }

    private int offset(int i) {
        return TastyBuffer.Addr$.MODULE$.apply(this.offsets[i]);
    }

    private void keepOffset(boolean relative) {
        if (this.numOffsets == this.offsets.length) {
            this.offsets = dotty.tools.tasty.util.Util$.MODULE$.dble(this.offsets);
            this.isRelative = (boolean[])dotty.tools.tasty.util.Util$.MODULE$.dble((Object)this.isRelative, ClassTag$.MODULE$.apply(Boolean.TYPE));
        }
        this.offsets[this.numOffsets] = this.length();
        this.isRelative[this.numOffsets] = relative;
        ++this.numOffsets;
    }

    public int reserveRef(boolean relative) {
        int addr = this.currentAddr();
        this.keepOffset(relative);
        this.reserveAddr();
        return addr;
    }

    public void writeRef(int target) {
        this.keepOffset(false);
        this.fillAddr(this.reserveAddr(), target);
    }

    public void fillRef(int at, int target, boolean relative) {
        int addr = relative ? TastyBuffer.Addr$.MODULE$.relativeTo$extension(target, at) : target;
        this.fillAddr(at, addr);
    }

    public int deltaAt(int at, ScratchData scratch) {
        int idx = Util$.MODULE$.bestFit(this.offsets, this.numOffsets, at - 1, Util$.MODULE$.bestFit$default$4());
        if (idx < 0) {
            return 0;
        }
        return scratch.delta()[idx];
    }

    public int adjusted(int x, ScratchData scratch) {
        return TastyBuffer.Addr$.MODULE$.$minus$extension(x, this.deltaAt(x, scratch));
    }

    public void compactify(ScratchData scratch) {
        int origLength = this.length();
        this.computeDeltas$1(scratch);
        int saved = 0;
        while ((saved = this.adjustDeltas$1(scratch)) > 0 && this.length() / saved < 100) {
        }
        this.adjustOffsets$1(scratch);
        this.adjustTreeAddrs$1(scratch);
        int wasted = this.compress$1(scratch);
    }

    private final int[] reserve$1(int[] arr) {
        if (arr.length < this.numOffsets) {
            return new int[this.numOffsets];
        }
        Arrays.fill(arr, 0, this.numOffsets, 0);
        return arr;
    }

    private final void computeDeltas$1(ScratchData scratch$1) {
        scratch$1.delta_$eq(this.reserve$1(scratch$1.delta()));
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int off = this.offset(i);
            int skippedOff = this.skipZeroes(off);
            int skippedCount = skippedOff - off;
            if (skippedCount >= 4) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("unset field at position " + new TastyBuffer.Addr(off)));
            }
            scratch$1.delta()[i] = lastDelta += skippedCount;
        }
    }

    private final int adjustedOffset$1(ScratchData scratch$2, int i) {
        int at = this.offset(i);
        int original = this.getAddr(at);
        if (this.isRelative[i]) {
            int len2;
            int start = this.skipNat(at);
            int len1 = TastyBuffer.Addr$.MODULE$.$minus$extension(TastyBuffer.Addr$.MODULE$.$plus$extension(original, scratch$2.delta()[i]), this.deltaAt(TastyBuffer.Addr$.MODULE$.$plus$extension(original, start), scratch$2));
            if (!TastyBuffer.Addr$.MODULE$.$eq$eq$extension(len1, len2 = TastyBuffer.Addr$.MODULE$.$minus$extension(this.adjusted(TastyBuffer.Addr$.MODULE$.$plus$extension(original, start), scratch$2), this.adjusted(start, scratch$2)))) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)("adjusting offset #" + i + ": " + new TastyBuffer.Addr(at) + ", original = " + new TastyBuffer.Addr(original) + ", len1 = " + new TastyBuffer.Addr(len1) + ", len2 = " + new TastyBuffer.Addr(len2)));
            }
            return len1;
        }
        return this.adjusted(original, scratch$2);
    }

    private final void adjustOffsets$1(ScratchData scratch$6) {
        for (int i = 0; i < this.numOffsets; ++i) {
            int corrected = this.adjustedOffset$1(scratch$6, i);
            this.fillAddr(this.offset(i), corrected);
        }
    }

    private final int adjustDeltas$1(ScratchData scratch$3) {
        scratch$3.delta1_$eq(this.reserve$1(scratch$3.delta1()));
        int lastDelta = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int corrected = this.adjustedOffset$1(scratch$3, i);
            scratch$3.delta1()[i] = lastDelta += 4 - TastyBuffer$.MODULE$.natSize(corrected);
        }
        int saved = this.numOffsets == 0 ? 0 : scratch$3.delta1()[this.numOffsets - 1] - scratch$3.delta()[this.numOffsets - 1];
        int[] tmp = scratch$3.delta();
        scratch$3.delta_$eq(scratch$3.delta1());
        scratch$3.delta1_$eq(tmp);
        return saved;
    }

    private final void shift$1(IntRef start$1, IntRef lastDelta$1, int end) {
        System.arraycopy(this.bytes(), start$1.elem, this.bytes(), start$1.elem - lastDelta$1.elem, end - start$1.elem);
    }

    private final int compress$1(ScratchData scratch$4) {
        IntRef lastDelta = IntRef.create((int)0);
        IntRef start = IntRef.create((int)0);
        int wasted = 0;
        for (int i = 0; i < this.numOffsets; ++i) {
            int next = this.offsets[i];
            this.shift$1(start, lastDelta, next);
            start.elem = next + scratch$4.delta()[i] - lastDelta.elem;
            int pastZeroes = this.skipZeroes(TastyBuffer.Addr$.MODULE$.apply(next));
            if (pastZeroes < start.elem) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"something's wrong: eliminated non-zero");
            }
            wasted += pastZeroes - start.elem;
            lastDelta.elem = scratch$4.delta()[i];
        }
        this.shift$1(start, lastDelta, this.length());
        this.length_$eq(this.length() - lastDelta.elem);
        return wasted;
    }

    private final void adjustTreeAddrs$1(ScratchData scratch$5) {
        for (int i = 0; i < this.treeAddrs.size(); ++i) {
            this.treeAddrs.setValue(i, this.adjusted(TastyBuffer.Addr$.MODULE$.apply(this.treeAddrs.value(i)), scratch$5));
        }
    }
}

