/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class EitherOrMultiPattern
extends Pattern {
    private Pattern[] patterns;
    private int patternsCount;

    public EitherOrMultiPattern(Pattern[] patterns) {
        this.patterns = patterns;
        this.patternsCount = patterns.length;
        this.sourceStart = patterns[0].sourceStart;
        this.sourceEnd = patterns[this.patternsCount - 1].sourceEnd;
        this.setIsEitherOrPattern();
    }

    @Override
    public Pattern[] getAlternatives() {
        return this.patterns;
    }

    @Override
    public void setIsEitherOrPattern() {
        int i = 0;
        while (i < this.patternsCount) {
            this.patterns[i].setIsEitherOrPattern();
            ++i;
        }
    }

    @Override
    public void setIsGuarded() {
        int i = 0;
        while (i < this.patternsCount) {
            this.patterns[i].setIsGuarded();
            ++i;
        }
    }

    @Override
    public void setOuterExpressionType(TypeBinding expressionType) {
        super.setOuterExpressionType(expressionType);
        int i = 0;
        while (i < this.patternsCount) {
            this.patterns[i].setOuterExpressionType(expressionType);
            ++i;
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        boolean hasError = false;
        int i = 0;
        while (i < this.patternsCount) {
            TypeBinding t = this.patterns[i].resolveType(scope);
            if (t == null || !t.isValidBinding()) {
                hasError = true;
            }
            int j = 0;
            while (j < i) {
                if (this.patterns[j].dominates(this.patterns[i])) {
                    scope.problemReporter().patternDominatedByAnother(this.patterns[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.resolvedType = hasError ? null : this.patterns[0].resolvedType;
        return this.resolvedType;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, BranchLabel patternMatchLabel, BranchLabel matchFailLabel) {
        BranchLabel[] checkNextLabel = new BranchLabel[this.patternsCount];
        int i = 0;
        while (i < this.patternsCount) {
            checkNextLabel[i] = new BranchLabel(codeStream);
            Pattern p = this.patterns[i];
            codeStream.dup();
            codeStream.instance_of(p.resolvedType);
            codeStream.ifeq(checkNextLabel[i]);
            codeStream.dup();
            this.patterns[i].generateCode(currentScope, codeStream, patternMatchLabel, checkNextLabel[i]);
            codeStream.pop();
            codeStream.goto_(patternMatchLabel);
            checkNextLabel[i].place();
            ++i;
        }
        codeStream.pop();
        codeStream.goto_(matchFailLabel);
    }

    @Override
    public boolean dominates(Pattern p) {
        if (!this.isUnguarded()) {
            return false;
        }
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern thiz = patternArray[n2];
            if (thiz.dominates(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean coversType(TypeBinding type, Scope scope) {
        if (!this.isUnguarded()) {
            return false;
        }
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            if (p.coversType(type, scope)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        return NO_VARIABLES;
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        int i = 0;
        while (i < this.patternsCount) {
            if (i > 0) {
                output.append(", ");
            }
            this.patterns[i].print(0, output);
            ++i;
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            Pattern[] patternArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern p = patternArray[n2];
                p.traverse(visitor, scope);
                ++n2;
            }
        }
        visitor.endVisit(this, scope);
    }
}

