/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.UUID;

final class ClientIdentifier {
    private static String CLIENT_UID;

    private ClientIdentifier() {
    }

    public static String getClientUid() {
        if (CLIENT_UID == null) {
            CLIENT_UID = ClientIdentifier.generateClientUid();
        }
        return CLIENT_UID;
    }

    private static String generateClientUid() {
        String identifier = UUID.randomUUID().toString();
        String pid = ClientIdentifier.getProcessId();
        String hostname = ClientIdentifier.getHostName();
        return String.format("%s@%s@%s", identifier, pid, hostname);
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "localhost";
        }
    }

    private static String getProcessId() {
        try {
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
            Object processHandleInstance = currentMethod.invoke(null, new Object[0]);
            Method pidMethod = processHandleClass.getMethod("pid", new Class[0]);
            long pid = (Long)pidMethod.invoke(processHandleInstance, new Object[0]);
            return Long.toString(pid);
        }
        catch (Exception e) {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            if (jvmName != null && jvmName.contains("@")) {
                return jvmName.split("@")[0];
            }
            return "unknown";
        }
    }
}

