/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml.user;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.saml.acs.AssertedIdentity;
import org.apache.guacamole.auth.saml.conf.ConfigurationService;
import org.apache.guacamole.auth.sso.user.SSOAuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.token.TokenName;

public class SAMLAuthenticatedUser
extends SSOAuthenticatedUser {
    private static final String SAML_ATTRIBUTE_TOKEN_PREFIX = "SAML_";
    @Inject
    private ConfigurationService confService;

    private Map<String, String> getTokens(AssertedIdentity identity) {
        return Collections.unmodifiableMap(identity.getAttributes().entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(entry -> TokenName.canonicalize((String)((String)entry.getKey()), (String)SAML_ATTRIBUTE_TOKEN_PREFIX), entry -> (String)((List)entry.getValue()).get(0))));
    }

    private Set<String> getGroups(AssertedIdentity identity) throws GuacamoleException {
        List<String> samlGroups = identity.getAttributes().get(this.confService.getGroupAttribute());
        if (samlGroups == null || samlGroups.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(samlGroups));
    }

    public void init(AssertedIdentity identity, Credentials credentials) throws GuacamoleException {
        super.init(identity.getUsername(), credentials, this.getGroups(identity), this.getTokens(identity));
    }
}

