/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.xsdvalidator;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.xsdvalidator.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryXSDValidator
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String xmlfilename;
    private String xsdfilename;

    public JobEntryXSDValidator(String n) {
        super(n, "");
        this.xmlfilename = null;
        this.xsdfilename = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.XSD_VALIDATOR);
    }

    public JobEntryXSDValidator() {
        this("");
    }

    public JobEntryXSDValidator(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryXSDValidator je = (JobEntryXSDValidator)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"xsdfilename", (String)this.xsdfilename));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.xmlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.xsdfilename = XMLHandler.getTagValue((Node)entrynode, (String)"xsdfilename");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'xsdvalidator' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.xmlfilename = rep.getJobEntryAttributeString(id_jobentry, "xmlfilename");
            this.xsdfilename = rep.getJobEntryAttributeString(id_jobentry, "xsdfilename");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'xsdvalidator' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "xmlfilename", this.xmlfilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "xsdfilename", this.xsdfilename);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'xsdvalidator' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getRealxmlfilename() {
        return this.environmentSubstitute(this.getxmlFilename());
    }

    public String getRealxsdfilename() {
        return this.environmentSubstitute(this.getxsdFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block24: {
            FileObject xsdfile;
            FileObject xmlfile;
            String realxsdfilename;
            String realxmlfilename;
            LogWriter log;
            block23: {
                log = LogWriter.getInstance();
                result = previousResult;
                result.setResult(false);
                realxmlfilename = this.getRealxmlfilename();
                realxsdfilename = this.getRealxsdfilename();
                xmlfile = null;
                xsdfile = null;
                if (this.xmlfilename != null && this.xsdfilename != null) {
                    xmlfile = KettleVFS.getFileObject((String)realxmlfilename);
                    xsdfile = KettleVFS.getFileObject((String)realxsdfilename);
                    if (xmlfile.exists() && xsdfile.exists()) {
                        SchemaFactory factorytXSDValidator_1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        File XSDFile = new File(KettleVFS.getFilename((FileObject)xsdfile));
                        Schema SchematXSD = factorytXSDValidator_1.newSchema(XSDFile);
                        Validator XSDValidator = SchematXSD.newValidator();
                        File xmlfiletXSDValidator_1 = new File(KettleVFS.getFilename((FileObject)xmlfile));
                        StreamSource sourcetXSDValidator_1 = new StreamSource(xmlfiletXSDValidator_1);
                        XSDValidator.validate(sourcetXSDValidator_1);
                        result.setResult(true);
                    } else {
                        if (!xmlfile.exists()) {
                            log.logError(this.toString(), Messages.getString("JobEntryXSDValidator.FileDoesNotExist1.Label") + realxmlfilename + Messages.getString("JobEntryXSDValidator.FileDoesNotExist2.Label"), new Object[0]);
                        }
                        if (!xsdfile.exists()) {
                            log.logError(this.toString(), Messages.getString("JobEntryXSDValidator.FileDoesNotExist1.Label") + realxsdfilename + Messages.getString("JobEntryXSDValidator.FileDoesNotExist2.Label"), new Object[0]);
                        }
                        result.setResult(false);
                        result.setNrErrors(1L);
                    }
                    break block23;
                }
                log.logError(this.toString(), Messages.getString("JobEntryXSDValidator.AllFilesNotNull.Label"), new Object[0]);
                result.setResult(false);
                result.setNrErrors(1L);
            }
            Object var18_19 = null;
            try {
                if (xmlfile != null) {
                    xmlfile.close();
                }
                if (xsdfile != null) {
                    xsdfile.close();
                }
                break block24;
            }
            catch (IOException e2) {}
            break block24;
            {
                catch (SAXException ex) {
                    log.logError(this.toString(), "Error :" + ex.getMessage(), new Object[0]);
                    Object var18_20 = null;
                    try {
                        if (xmlfile != null) {
                            xmlfile.close();
                        }
                        if (xsdfile != null) {
                            xsdfile.close();
                        }
                        break block24;
                    }
                    catch (IOException e2) {}
                    break block24;
                }
                catch (Exception e) {
                    log.logError(this.toString(), Messages.getString("JobEntryXSDValidator.ErrorXSDValidator.Label") + Messages.getString("JobEntryXSDValidator.ErrorXML1.Label") + realxmlfilename + Messages.getString("JobEntryXSDValidator.ErrorXML2.Label") + Messages.getString("JobEntryXSDValidator.ErrorXSD1.Label") + realxsdfilename + Messages.getString("JobEntryXSDValidator.ErrorXSD2.Label") + e.getMessage(), new Object[0]);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var18_21 = null;
                    try {
                        if (xmlfile != null) {
                            xmlfile.close();
                        }
                        if (xsdfile != null) {
                            xsdfile.close();
                        }
                        break block24;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                try {
                    if (xmlfile != null) {
                        xmlfile.close();
                    }
                    if (xsdfile != null) {
                        xsdfile.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public void setxsdFilename(String filename) {
        this.xsdfilename = filename;
    }

    public String getxsdFilename() {
        return this.xsdfilename;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.xsdfilename) && !Const.isEmpty((String)this.xmlfilename)) {
            String realXmlFileName = jobMeta.environmentSubstitute(this.xmlfilename);
            String realXsdFileName = jobMeta.environmentSubstitute(this.xsdfilename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXsdFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "xsdFilename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "xmlFilename", remarks, ctx);
    }
}

