/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.util;

import java.util.Arrays;

public class IntArrayBuilder {
    private int[] data;
    private int size;

    public IntArrayBuilder() {
        this.data = new int[1];
        this.size = 0;
    }

    public IntArrayBuilder(int size) {
        this.data = new int[size];
        this.size = 0;
    }

    public IntArrayBuilder(int[] ints) {
        this.data = new int[ints.length];
        System.arraycopy(ints, 0, this.data, 0, ints.length);
        this.size = this.data.length;
    }

    public IntArrayBuilder append(int[] str) {
        int len = str.length;
        this.ensureCapacityInternal(this.size + len);
        System.arraycopy(str, 0, this.data, this.size, len);
        this.size += len;
        return this;
    }

    public IntArrayBuilder append(int c) {
        this.ensureCapacityInternal(this.size + 1);
        this.data[this.size++] = c;
        return this;
    }

    public int[] toArray() {
        if (this.size == 0) {
            return new int[0];
        }
        return Arrays.copyOf(this.data, this.size);
    }

    public int size() {
        return this.size;
    }

    public void deleteLastEntry() {
        if (this.size > 0) {
            --this.size;
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.data.length > 0) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = this.data.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.data = Arrays.copyOf(this.data, newCapacity);
    }
}

