/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserModelDefaultMethods;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;

public abstract class AbstractUserAdapter
extends UserModelDefaultMethods {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ComponentModel storageProviderModel;
    protected StorageId storageId;
    protected long created = System.currentTimeMillis();

    public AbstractUserAdapter(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
        this.session = session;
        this.realm = realm;
        this.storageProviderModel = storageProviderModel;
    }

    public Set<String> getRequiredActions() {
        return Collections.emptySet();
    }

    public Stream<String> getRequiredActionsStream() {
        return this.getRequiredActions().stream();
    }

    public void addRequiredAction(String action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public void removeRequiredAction(String action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        throw new ReadOnlyException("user is read only for this update");
    }

    protected Set<GroupModel> getGroupsInternal() {
        return Collections.emptySet();
    }

    protected boolean appendDefaultGroups() {
        return true;
    }

    public Set<GroupModel> getGroups() {
        HashSet<GroupModel> set = new HashSet<GroupModel>();
        if (this.appendDefaultGroups()) {
            set.addAll(this.realm.getDefaultGroupsStream().collect(Collectors.toSet()));
        }
        set.addAll(this.getGroupsInternal());
        return set;
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.getGroups().stream();
    }

    public void joinGroup(GroupModel group) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public void leaveGroup(GroupModel group) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public boolean isMemberOf(GroupModel group) {
        return RoleUtils.isMember(this.getGroups().stream(), (GroupModel)group);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        return this.getRoleMappings().stream().filter(RoleUtils::isRealmRole).collect(Collectors.toSet());
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return this.getRealmRoleMappings().stream();
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        return this.getRoleMappings().stream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app)).collect(Collectors.toSet());
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        return this.getClientRoleMappings(app).stream();
    }

    public boolean hasRole(RoleModel role) {
        return RoleUtils.hasRole(this.getRoleMappings().stream(), (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroups().stream(), (RoleModel)role, (boolean)true);
    }

    public void grantRole(RoleModel role) {
        throw new ReadOnlyException("user is read only for this update");
    }

    protected boolean appendDefaultRolesToRoleMappings() {
        return true;
    }

    protected Set<RoleModel> getRoleMappingsInternal() {
        return Collections.emptySet();
    }

    public Set<RoleModel> getRoleMappings() {
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        if (this.appendDefaultRolesToRoleMappings()) {
            set.addAll(this.realm.getDefaultRole().getCompositesStream().collect(Collectors.toSet()));
        }
        set.addAll(this.getRoleMappingsInternal());
        return set;
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        return this.getRoleMappings().stream();
    }

    public void deleteRoleMapping(RoleModel role) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public String getFederationLink() {
        return StorageId.providerId((String)this.getId());
    }

    public void setFederationLink(String link) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public String getServiceAccountClientLink() {
        return null;
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public String getId() {
        if (this.storageId == null) {
            this.storageId = new StorageId(this.storageProviderModel.getId(), this.getUsername());
        }
        return this.storageId.getId();
    }

    public void setUsername(String username) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public Long getCreatedTimestamp() {
        return this.created;
    }

    public void setCreatedTimestamp(Long timestamp) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public void setSingleAttribute(String name, String value) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public void removeAttribute(String name) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public void setAttribute(String name, List<String> values) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public String getFirstAttribute(String name) {
        if (name.equals("username")) {
            return this.getUsername();
        }
        return null;
    }

    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap attributes = new MultivaluedHashMap();
        attributes.add((Object)"username", (Object)this.getUsername());
        return attributes;
    }

    public List<String> getAttribute(String name) {
        if (name.equals("username")) {
            return Collections.singletonList(this.getUsername());
        }
        return Collections.emptyList();
    }

    public Stream<String> getAttributeStream(String name) {
        return this.getAttribute(name).stream();
    }

    public String getFirstName() {
        return null;
    }

    public void setFirstName(String firstName) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public String getLastName() {
        return null;
    }

    public void setLastName(String lastName) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public String getEmail() {
        return null;
    }

    public void setEmail(String email) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public boolean isEmailVerified() {
        return false;
    }

    public void setEmailVerified(boolean verified) {
        throw new ReadOnlyException("user is read only for this update");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static abstract class Streams
    extends AbstractUserAdapter
    implements UserModel {
        public Streams(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
            super(session, realm, storageProviderModel);
        }

        @Override
        public Set<String> getRequiredActions() {
            return this.getRequiredActionsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<String> getRequiredActionsStream() {
            return Stream.empty();
        }

        @Override
        public List<String> getAttribute(String name) {
            return this.getAttributeStream(name).collect(Collectors.toList());
        }

        @Override
        public Stream<String> getAttributeStream(String name) {
            if (name.equals("username")) {
                return Stream.of(this.getUsername());
            }
            return Stream.empty();
        }

        @Override
        public Set<GroupModel> getGroups() {
            return this.getGroupsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<GroupModel> getGroupsStream() {
            Stream<GroupModel> groups = this.getGroupsInternal().stream();
            if (this.appendDefaultGroups()) {
                groups = Stream.concat(groups, this.realm.getDefaultGroupsStream());
            }
            return groups;
        }

        @Override
        public boolean isMemberOf(GroupModel group) {
            return RoleUtils.isMember(this.getGroupsStream(), (GroupModel)group);
        }

        @Override
        public Set<RoleModel> getRealmRoleMappings() {
            return this.getRealmRoleMappingsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<RoleModel> getRealmRoleMappingsStream() {
            return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
        }

        @Override
        public Set<RoleModel> getClientRoleMappings(ClientModel app) {
            return this.getClientRoleMappingsStream(app).collect(Collectors.toSet());
        }

        @Override
        public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
            return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
        }

        @Override
        public Set<RoleModel> getRoleMappings() {
            return this.getRoleMappingsStream().collect(Collectors.toSet());
        }

        @Override
        public Stream<RoleModel> getRoleMappingsStream() {
            Stream<RoleModel> roleMappings = this.getRoleMappingsInternal().stream();
            if (this.appendDefaultRolesToRoleMappings()) {
                return Stream.concat(roleMappings, this.realm.getDefaultRole().getCompositesStream());
            }
            return roleMappings;
        }

        @Override
        public boolean hasRole(RoleModel role) {
            return RoleUtils.hasRole(this.getRoleMappingsStream(), (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroupsStream(), (RoleModel)role, (boolean)true);
        }
    }
}

