/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples.spaceinvaders;

import org.lwjgl.examples.spaceinvaders.Entity;
import org.lwjgl.examples.spaceinvaders.Game;
import org.lwjgl.examples.spaceinvaders.Sprite;

public class AlienEntity
extends Entity {
    private static final int DOWNWARD_MOVEMENT = 10;
    private static final int BOTTOM_BORDER = 570;
    private static final int RIGHT_BORDER = 750;
    private static final int LEFT_BORDER = 10;
    private float moveSpeed = 75.0f;
    private Game game;
    private Sprite[] frames = new Sprite[4];
    private long lastFrameChange;
    private long frameDuration = 250L;
    private int frameNumber;

    public AlienEntity(Game game, int x, int y) {
        super(game.getSprite("alien.gif"), x, y);
        this.frames[0] = this.sprite;
        this.frames[1] = game.getSprite("alien2.gif");
        this.frames[2] = this.sprite;
        this.frames[3] = game.getSprite("alien3.gif");
        this.game = game;
        this.dx = -this.moveSpeed;
    }

    @Override
    public void move(long delta) {
        this.lastFrameChange += delta;
        if (this.lastFrameChange > this.frameDuration) {
            this.lastFrameChange = 0L;
            ++this.frameNumber;
            if (this.frameNumber >= this.frames.length) {
                this.frameNumber = 0;
            }
            this.sprite = this.frames[this.frameNumber];
        }
        if (this.dx < 0.0f && this.x < 10.0f) {
            this.game.updateLogic();
        }
        if (this.dx > 0.0f && this.x > 750.0f) {
            this.game.updateLogic();
        }
        super.move(delta);
    }

    @Override
    public void doLogic() {
        this.dx = -this.dx;
        this.y += 10.0f;
        if (this.y > 570.0f) {
            this.game.notifyDeath();
        }
    }

    @Override
    public void collidedWith(Entity other) {
    }
}

